/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.utils.sslcert.adaptor;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ParentLastClassLoader
extends ClassLoader {
    private static final Hashtable<String, Class> classes = new Hashtable();
    private File[] jarFiles;

    public ParentLastClassLoader(ClassLoader parent) {
        super(parent);
        String libDir = System.getProperty("synapse.bcprov.lib");
        if (libDir == null) {
            libDir = "lib";
        }
        File dir = new File(libDir);
        this.jarFiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().startsWith("synapse-nhttp-transport") || f.getName().equals("bcprov-jdk15on-1.49.jar");
            }
        });
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        throw new ClassNotFoundException();
    }

    @Override
    protected synchronized Class<?> loadClass(String className, boolean resolve) throws ClassNotFoundException {
        try {
            Class<?> result = classes.get(className);
            if (result != null) {
                return result;
            }
            for (File jarFile : this.jarFiles) {
                try {
                    JarFile jar = new JarFile(jarFile);
                    JarEntry entry = jar.getJarEntry(className.replace(".", "/") + ".class");
                    InputStream is = jar.getInputStream(entry);
                    ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                    int nextValue = is.read();
                    while (-1 != nextValue) {
                        byteStream.write(nextValue);
                        nextValue = is.read();
                    }
                    byte[] classByte = byteStream.toByteArray();
                    result = this.defineClass(className, classByte, 0, classByte.length, null);
                    classes.put(className, result);
                    break;
                }
                catch (Exception exception) {
                }
            }
            if (result != null) {
                return result;
            }
            throw new ClassNotFoundException("Not found " + className);
        }
        catch (ClassNotFoundException e) {
            return super.loadClass(className, resolve);
        }
    }
}

