/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorSerializer;
import org.apache.synapse.config.xml.SequenceMediatorSerializer;
import org.apache.synapse.mediators.builtin.CacheMediator;

public class CacheMediatorSerializer
extends AbstractMediatorSerializer {
    @Override
    public OMElement serializeSpecificMediator(Mediator m) {
        if (!(m instanceof CacheMediator)) {
            this.handleException("Unsupported mediator passed in for serialization : " + m.getType());
        }
        CacheMediator mediator = (CacheMediator)m;
        OMElement cache = fac.createOMElement("cache", synNS);
        CacheMediatorSerializer.saveTracingState(cache, mediator);
        if (mediator.getId() != null) {
            cache.addAttribute(fac.createOMAttribute("id", nullNS, mediator.getId()));
        }
        if (mediator.getScope() != null) {
            cache.addAttribute(fac.createOMAttribute("scope", nullNS, mediator.getScope()));
        }
        if (mediator.isCollector()) {
            cache.addAttribute(fac.createOMAttribute("collector", nullNS, "true"));
        } else {
            OMElement implElem;
            OMElement onCacheHit;
            cache.addAttribute(fac.createOMAttribute("collector", nullNS, "false"));
            if (mediator.getDigestGenerator() != null) {
                cache.addAttribute(fac.createOMAttribute("hashGenerator", nullNS, mediator.getDigestGenerator().getClass().getName()));
            }
            if (mediator.getTimeout() != 0L) {
                cache.addAttribute(fac.createOMAttribute("timeout", nullNS, Long.toString(mediator.getTimeout())));
            }
            if (mediator.getMaxMessageSize() != 0) {
                cache.addAttribute(fac.createOMAttribute("maxMessageSize", nullNS, Integer.toString(mediator.getMaxMessageSize())));
            }
            if (mediator.getOnCacheHitRef() != null) {
                onCacheHit = fac.createOMElement("onCacheHit", synNS);
                onCacheHit.addAttribute(fac.createOMAttribute("sequence", nullNS, mediator.getOnCacheHitRef()));
                cache.addChild((OMNode)onCacheHit);
            } else if (mediator.getOnCacheHitSequence() != null) {
                onCacheHit = fac.createOMElement("onCacheHit", synNS);
                new SequenceMediatorSerializer().serializeChildren(onCacheHit, mediator.getOnCacheHitSequence().getList());
                cache.addChild((OMNode)onCacheHit);
            }
            if (mediator.getInMemoryCacheSize() != 0) {
                implElem = fac.createOMElement("implementation", synNS);
                implElem.addAttribute(fac.createOMAttribute("type", nullNS, "memory"));
                implElem.addAttribute(fac.createOMAttribute("maxSize", nullNS, Integer.toString(mediator.getInMemoryCacheSize())));
                cache.addChild((OMNode)implElem);
            }
            if (mediator.getDiskCacheSize() != 0) {
                implElem = fac.createOMElement("implementation", synNS);
                implElem.addAttribute(fac.createOMAttribute("type", nullNS, "disk"));
                implElem.addAttribute(fac.createOMAttribute("maxSize", nullNS, Integer.toString(mediator.getDiskCacheSize())));
                cache.addChild((OMNode)implElem);
            }
        }
        return cache;
    }

    @Override
    public String getMediatorClassName() {
        return CacheMediator.class.getName();
    }
}

