/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference.validation;

import java.math.BigDecimal;
import org.owasp.esapi.Encoder;
import org.owasp.esapi.StringUtilities;
import org.owasp.esapi.errors.ValidationException;
import org.owasp.esapi.reference.validation.BaseValidationRule;

public class NumberValidationRule
extends BaseValidationRule {
    private double minValue = Double.NEGATIVE_INFINITY;
    private double maxValue = Double.POSITIVE_INFINITY;
    private static BigDecimal bigBad;
    private static BigDecimal smallBad;

    public NumberValidationRule(String typeName, Encoder encoder) {
        super(typeName, encoder);
    }

    public NumberValidationRule(String typeName, Encoder encoder, double minValue, double maxValue) {
        super(typeName, encoder);
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public Double getValid(String context, String input) throws ValidationException {
        return this.safelyParse(context, input);
    }

    public Double sanitize(String context, String input) {
        Double toReturn = 0.0;
        try {
            toReturn = this.safelyParse(context, input);
        }
        catch (ValidationException e) {
            // empty catch block
        }
        return toReturn;
    }

    private Double safelyParse(String context, String input) throws ValidationException {
        Double d;
        BigDecimal bd;
        if (StringUtilities.isEmpty(input)) {
            if (this.allowNull) {
                return null;
            }
            throw new ValidationException(context + ": Input number required", "Input number required: context=" + context + ", input=" + input, context);
        }
        String canonical = this.encoder.canonicalize(input);
        if (this.minValue > this.maxValue) {
            throw new ValidationException(context + ": Invalid number input: context", "Validation parameter error for number: maxValue ( " + this.maxValue + ") must be greater than minValue ( " + this.minValue + ") for " + context, context);
        }
        try {
            bd = new BigDecimal(canonical);
        }
        catch (NumberFormatException e) {
            throw new ValidationException(context + ": Invalid number input", "Invalid number input format: context=" + context + ", input=" + input, e, context);
        }
        if (bd.compareTo(smallBad) >= 0 && bd.compareTo(bigBad) <= 0) {
            return new Double("2.2250738585072014E-308");
        }
        try {
            d = Double.parseDouble(canonical);
        }
        catch (NumberFormatException e) {
            throw new ValidationException(context + ": Invalid number input", "Invalid number input format: context=" + context + ", input=" + input, e, context);
        }
        if (d.isInfinite()) {
            throw new ValidationException("Invalid number input: context=" + context, "Invalid double input is infinite: context=" + context + ", input=" + input, context);
        }
        if (d.isNaN()) {
            throw new ValidationException("Invalid number input: context=" + context, "Invalid double input is not a number: context=" + context + ", input=" + input, context);
        }
        if (d < this.minValue) {
            throw new ValidationException("Invalid number input must be between " + this.minValue + " and " + this.maxValue + ": context=" + context, "Invalid number input must be between " + this.minValue + " and " + this.maxValue + ": context=" + context + ", input=" + input, context);
        }
        if (d > this.maxValue) {
            throw new ValidationException("Invalid number input must be between " + this.minValue + " and " + this.maxValue + ": context=" + context, "Invalid number input must be between " + this.minValue + " and " + this.maxValue + ": context=" + context + ", input=" + input, context);
        }
        return d;
    }

    static {
        BigDecimal one = new BigDecimal(1);
        BigDecimal two = new BigDecimal(2);
        BigDecimal tiny = one.divide(two.pow(1022));
        bigBad = tiny.subtract(one.divide(two.pow(1076)));
        smallBad = tiny.subtract(one.divide(two.pow(1075)));
    }
}

