/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.impl.mgmt;

import java.util.HashMap;
import java.util.Map;
import org.apache.tiles.BasicAttributeContext;
import org.apache.tiles.Definition;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.TilesContainerWrapper;
import org.apache.tiles.definition.NoSuchDefinitionException;
import org.apache.tiles.mgmt.MutableTilesContainer;
import org.apache.tiles.request.Request;

public class CachingTilesContainer
extends TilesContainerWrapper
implements MutableTilesContainer {
    private static final String DEFAULT_DEFINITIONS_ATTRIBUTE_NAME = "org.apache.tiles.impl.mgmt.DefinitionManager.DEFINITIONS";
    private String definitionsAttributeName;

    public CachingTilesContainer(TilesContainer originalContainer) {
        super(originalContainer);
        this.definitionsAttributeName = DEFAULT_DEFINITIONS_ATTRIBUTE_NAME;
    }

    public CachingTilesContainer(TilesContainer originalContainer, String definitionsAttributeName) {
        super(originalContainer);
        this.definitionsAttributeName = definitionsAttributeName;
        if (this.definitionsAttributeName == null) {
            this.definitionsAttributeName = DEFAULT_DEFINITIONS_ATTRIBUTE_NAME;
        }
    }

    public Definition getDefinition(String definition, Request request) {
        Definition retValue = null;
        retValue = this.getCustomDefinition(definition, request);
        if (retValue == null) {
            retValue = super.getDefinition(definition, request);
        }
        return retValue;
    }

    public boolean isValidDefinition(String definition, Request request) {
        if (this.getCustomDefinition(definition, request) != null) {
            return true;
        }
        return super.isValidDefinition(definition, request);
    }

    public void register(Definition definition, Request request) {
        Map<String, Definition> definitions = this.getOrCreateDefinitions(request);
        if (definition.getName() == null) {
            definition.setName(this.getNextUniqueDefinitionName(definitions));
        }
        if (definition.isExtending()) {
            this.resolveInheritance(definition, request);
        }
        definitions.put(definition.getName(), definition);
    }

    public void render(String definition, Request request) {
        Definition toRender = this.getDefinition(definition, request);
        if (toRender == null) {
            throw new NoSuchDefinitionException("Cannot find definition named '" + definition + "'");
        }
        super.render(toRender, request);
    }

    private void resolveInheritance(Definition definition, Request request) {
        if (!definition.isExtending()) {
            return;
        }
        String parentDefinitionName = definition.getExtends();
        boolean recurse = true;
        Definition parent = this.getCustomDefinition(parentDefinitionName, request);
        if (parent == null) {
            parent = this.container.getDefinition(parentDefinitionName, request);
            recurse = false;
        }
        if (parent == null) {
            throw new NoSuchDefinitionException("Error while resolving definition inheritance: child '" + definition.getName() + "' can't find its ancestor '" + parentDefinitionName + "'. Please check your description file.");
        }
        if (recurse) {
            this.resolveInheritance(parent, request);
        }
        definition.inherit((BasicAttributeContext)parent);
    }

    private Map<String, Definition> getDefinitions(Request request) {
        return (Map)request.getContext("request").get(this.definitionsAttributeName);
    }

    private Map<String, Definition> getOrCreateDefinitions(Request request) {
        HashMap definitions = (HashMap)request.getContext("request").get(this.definitionsAttributeName);
        if (definitions == null) {
            definitions = new HashMap();
            request.getContext("request").put(this.definitionsAttributeName, definitions);
        }
        return definitions;
    }

    private String getNextUniqueDefinitionName(Map<String, Definition> definitions) {
        String candidate;
        int anonymousDefinitionIndex = 1;
        do {
            candidate = "$anonymousMutableDefinition" + anonymousDefinitionIndex;
            ++anonymousDefinitionIndex;
        } while (definitions.containsKey(candidate));
        return candidate;
    }

    private Definition getCustomDefinition(String definition, Request request) {
        Map<String, Definition> definitions = this.getDefinitions(request);
        if (definitions != null) {
            return definitions.get(definition);
        }
        return null;
    }
}

