/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.sling.testing.mock.osgi.config.AbstractConfigTypeReflectionProvider;
import org.apache.sling.testing.mock.osgi.config.ConfigTypeStrictnessViolation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ComponentPropertyParser {
    private static final Logger log = LoggerFactory.getLogger(ComponentPropertyParser.class);
    private static final Pattern IDENTIFIERTOPROPERTY = Pattern.compile("(__)|(_)|(\\$_\\$)|(\\$\\$)|(\\$)");
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("\\s*(?<key>[^=\\s:]+)\\s*(?::\\s*(?<type>Boolean|Byte|Character|Short|Integer|Long|Float|Double|String)\\s*)?=(?<value>.*)");
    private static final String PROPERTY_PATTERN_CAPTURE_GROUP_VALUE = "value";
    private static final Set<Class<?>> BOXES = Stream.of(Boolean.class, Byte.class, Character.class, Short.class, Integer.class, Long.class, Float.class, Double.class).collect(Collectors.toSet());

    private ComponentPropertyParser() {
    }

    static String unescape(@NotNull String escapeSequence) {
        switch (escapeSequence) {
            case "__": {
                return "_";
            }
            case "_": {
                return ".";
            }
            case "$_$": {
                return "-";
            }
            case "$$": {
                return "\\$";
            }
            case "$": {
                return "";
            }
        }
        throw new IllegalArgumentException("Unsupported escape sequence " + escapeSequence);
    }

    static String identifierToPropertyName(@NotNull String name, @Nullable String prefix) {
        Matcher m = IDENTIFIERTOPROPERTY.matcher(name);
        if (!m.find()) {
            return Optional.ofNullable(prefix).map(pfx -> pfx.concat(name)).orElse(name);
        }
        StringBuffer b = new StringBuffer();
        do {
            m.appendReplacement(b, ComponentPropertyParser.unescape(m.group()));
        } while (m.find());
        m.appendTail(b);
        String propName = b.toString();
        return Optional.ofNullable(prefix).map(pfx -> pfx.concat(propName)).orElse(propName);
    }

    static String singleElementAnnotationKey(@NotNull String simpleName, @Nullable String prefix) {
        int dollar = simpleName.lastIndexOf(36);
        StringBuilder sb = new StringBuilder(dollar <= 0 ? simpleName : simpleName.substring(dollar + 1));
        boolean lastLowerCase = false;
        for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            if (Character.isUpperCase(c)) {
                sb.setCharAt(i, Character.toLowerCase(c));
                if (lastLowerCase) {
                    sb.insert(i, '.');
                    ++i;
                }
                lastLowerCase = false;
                continue;
            }
            lastLowerCase = Character.isLowerCase(c);
        }
        if (prefix != null) {
            return prefix.concat(sb.toString());
        }
        return sb.toString();
    }

    static boolean isSupportedNonArraySimpleType(Class<?> attributeType) {
        return attributeType.isPrimitive() || BOXES.contains(attributeType) || attributeType.equals(String.class);
    }

    public static boolean isSupportedPropertyMapValueType(Class<?> attributeType) {
        if (attributeType.isArray()) {
            return ComponentPropertyParser.isSupportedNonArraySimpleType(attributeType.getComponentType());
        }
        return ComponentPropertyParser.isSupportedNonArraySimpleType(attributeType);
    }

    public static boolean isSupportedConfigTypeValueType(Class<?> attributeType) {
        if (attributeType.isArray()) {
            return ComponentPropertyParser.isSupportedConfigTypeValueType(attributeType.getComponentType());
        }
        return ComponentPropertyParser.isSupportedNonArraySimpleType(attributeType) || Class.class.equals(attributeType) || attributeType.isEnum();
    }

    static void getDefaults(@NotNull Class<?> configType, @NotNull Map<String, Object> values) {
        AbstractConfigTypeReflectionProvider defaultsProvider = AbstractConfigTypeReflectionProvider.getInstance(configType);
        Map<String, Object> defaults = defaultsProvider.getDefaults(values);
        if (!defaults.isEmpty()) {
            values.putAll(defaults);
        }
    }

    static Map<String, Object> getTypedProperties(Map<String, String> propertyType, Map<String, List<String>> map) {
        HashMap<String, Object> returnProps = new HashMap<String, Object>();
        block21: for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            String name = entry.getKey();
            List<String> values = entry.getValue();
            switch (propertyType.getOrDefault(name, "String")) {
                case "Boolean": {
                    ComponentPropertyParser.putSingleOrMany(returnProps, name, values, Boolean::parseBoolean, Boolean[]::new);
                    continue block21;
                }
                case "Byte": {
                    ComponentPropertyParser.putSingleOrMany(returnProps, name, values, Byte::parseByte, Byte[]::new);
                    continue block21;
                }
                case "Character": {
                    ComponentPropertyParser.putSingleOrMany(returnProps, name, values, str -> Character.valueOf(str.charAt(0)), Character[]::new);
                    continue block21;
                }
                case "Short": {
                    ComponentPropertyParser.putSingleOrMany(returnProps, name, values, Short::parseShort, Short[]::new);
                    continue block21;
                }
                case "Integer": {
                    ComponentPropertyParser.putSingleOrMany(returnProps, name, values, Integer::parseInt, Integer[]::new);
                    continue block21;
                }
                case "Long": {
                    ComponentPropertyParser.putSingleOrMany(returnProps, name, values, Long::parseLong, Long[]::new);
                    continue block21;
                }
                case "Float": {
                    ComponentPropertyParser.putSingleOrMany(returnProps, name, values, Float::parseFloat, Float[]::new);
                    continue block21;
                }
                case "Double": {
                    ComponentPropertyParser.putSingleOrMany(returnProps, name, values, Double::parseDouble, Double[]::new);
                    continue block21;
                }
            }
            ComponentPropertyParser.putSingleOrMany(returnProps, name, values, Function.identity(), String[]::new);
        }
        return returnProps;
    }

    static <T> void putSingleOrMany(Map<String, Object> map, String key, List<String> values, Function<? super String, ? extends T> mapper, IntFunction<T[]> generator) {
        if (values.size() == 1) {
            map.put(key, mapper.apply(values.get(0)));
        } else if (values.size() > 1) {
            map.put(key, values.stream().map(mapper).toArray(generator));
        }
    }

    public static Map<String, Object> parse(@NotNull String[] properties) {
        HashMap<String, String> propertyType = new HashMap<String, String>();
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        Function<String, List> getValues = key -> map.computeIfAbsent((String)key, ignored -> new LinkedList());
        for (String p : properties) {
            Matcher m = PROPERTY_PATTERN.matcher(p);
            if (m.matches()) {
                String key2 = m.group("key");
                String type = m.group("type");
                if (type != null) {
                    propertyType.put(key2, type);
                }
                String value = m.group(PROPERTY_PATTERN_CAPTURE_GROUP_VALUE);
                getValues.apply(key2).add(value);
                continue;
            }
            log.warn("Malformed property '{}'", (Object)p);
        }
        return ComponentPropertyParser.getTypedProperties(propertyType, map);
    }

    public static Map<String, Object> parse(@NotNull Class<?> configType, @NotNull String[] properties) {
        Map<String, Object> returnProps = ComponentPropertyParser.parse(properties);
        ComponentPropertyParser.getDefaults(configType, returnProps);
        return returnProps;
    }

    public static void assertOneToOneMapping(@NotNull Class<?> configType, @NotNull String[] properties) {
        Map<String, Object> props = ComponentPropertyParser.parse(properties);
        AbstractConfigTypeReflectionProvider defaultsProvider = AbstractConfigTypeReflectionProvider.getInstance(configType);
        HashSet<String> parsedProperties = new HashSet<String>(props.keySet());
        Set expectedProperties = Arrays.stream(defaultsProvider.getMethods()).map(defaultsProvider::getPropertyName).collect(Collectors.toSet());
        Set<String> defaults = defaultsProvider.getDefaults(props).keySet();
        ArrayList missingExpected = new ArrayList(expectedProperties);
        missingExpected.removeAll(parsedProperties);
        missingExpected.removeAll(defaults);
        ArrayList<String> unexpectedParsed = new ArrayList<String>(parsedProperties);
        unexpectedParsed.removeAll(expectedProperties);
        if (!missingExpected.isEmpty() || !unexpectedParsed.isEmpty()) {
            throw new ConfigTypeStrictnessViolation(String.format("Config type %s failed one-to-one mapping test (missing=%s unexpected=%s) with properties %s", configType, missingExpected, unexpectedParsed, parsedProperties));
        }
    }
}

