/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter.internal;

import java.util.Collection;
import org.apache.royale.compiler.clients.problems.CompilerProblemCategorizer;
import org.apache.royale.compiler.problems.CompilerProblemSeverity;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.formatter.FormatterSettings;

public abstract class BaseTokenFormatter {
    protected FormatterSettings settings;

    protected BaseTokenFormatter(FormatterSettings settings) {
        this.settings = settings;
    }

    protected boolean hasErrors(Collection<ICompilerProblem> problems) {
        CompilerProblemCategorizer categorizer = new CompilerProblemCategorizer(null);
        for (ICompilerProblem problem : problems) {
            CompilerProblemSeverity severity = categorizer.getProblemSeverity(problem);
            if (!CompilerProblemSeverity.ERROR.equals((Object)severity)) continue;
            return true;
        }
        return false;
    }

    protected int increaseIndent(int indent) {
        return indent + 1;
    }

    protected int decreaseIndent(int indent) {
        return Math.max(0, indent - 1);
    }

    protected String getIndent() {
        if (this.settings.insertSpaces) {
            String result = "";
            for (int j = 0; j < this.settings.tabSize; ++j) {
                result = result + " ";
            }
            return result;
        }
        return "\t";
    }

    protected void appendIndent(StringBuilder builder, int indent) {
        String indentString = this.getIndent();
        for (int i = 0; i < indent; ++i) {
            builder.append(indentString);
        }
    }

    protected void appendNewLines(StringBuilder builder, int numRequiredNewLines) {
        if (this.settings.maxPreserveNewLines != 0) {
            numRequiredNewLines = Math.min(this.settings.maxPreserveNewLines, numRequiredNewLines);
        }
        for (int j = 0; j < numRequiredNewLines; ++j) {
            builder.append('\n');
        }
    }
}

