/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.lang;

import flex2.compiler.mxml.lang.StandardDefs;

public abstract class TextParser {
    public static final int Ok = 0;
    public static final int ErrTypeNotEmbeddable = 1;
    public static final int ErrInvalidTextForType = 2;
    public static final int ErrInvalidPercentage = 3;
    public static final int ErrTypeNotSerializable = 4;
    public static final int ErrPercentagesNotAllowed = 5;
    public static final int ErrTypeNotContextRootable = 6;
    public static final int ErrUnrecognizedAtFunction = 7;
    public static final int ErrUndefinedContextRoot = 8;
    public static final int ErrInvalidTwoWayBind = 9;
    public static final int FlagInCDATA = 1;
    public static final int FlagCollapseWhiteSpace = 2;
    public static final int FlagConvertColorNames = 4;
    public static final int FlagAllowPercentages = 8;
    public static final int FlagIgnoreBinding = 16;
    public static final int FlagIgnoreAtFunction = 32;
    public static final int FlagIgnoreArraySyntax = 64;
    public static final int FlagIgnoreAtFunctionEscape = 128;
    public static final int FlagRichTextContent = 256;

    public static boolean isValidIdentifier(String id) {
        if (id.length() == 0 || !TextParser.isIdentifierFirstChar(id.charAt(0))) {
            return false;
        }
        for (int i = 1; i < id.length(); ++i) {
            if (TextParser.isIdentifierChar(id.charAt(i))) continue;
            return false;
        }
        return !StandardDefs.isReservedWord(id);
    }

    public static boolean isScopedName(String name) {
        return name.indexOf(46) != -1;
    }

    public static String[] analyzeScopedName(String name) {
        String[] results = name.split("\\.");
        return results.length != 2 ? null : results;
    }

    private static boolean isIdentifierFirstChar(char ch) {
        return Character.isJavaIdentifierStart(ch);
    }

    private static boolean isIdentifierChar(int ch) {
        return ch != -1 && Character.isJavaIdentifierPart((char)ch);
    }
}

