/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.eventbridge.filter;

import java.util.List;
import org.apache.rocketmq.eventbridge.exception.EventBridgeException;
import org.apache.rocketmq.eventbridge.exception.code.BaseErrorCode;
import org.apache.rocketmq.eventbridge.exception.code.DefaultErrorCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@Component
@Order(value=2)
public class LoginFilter
implements WebFilter {
    private static final Logger log = LoggerFactory.getLogger(LoginFilter.class);
    public static final String HEADER_KEY_LOGIN_ACCOUNT_ID = "loginAccountId";
    public static final String HEADER_KEY_PARENT_ACCOUNT_ID = "parentAccountId";
    public static final String HEADER_KEY_RESOURCE_OWNER_ACCOUNT_ID = "resourceOwnerAccountId";

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        ServerHttpRequest request = exchange.getRequest();
        return chain.filter(exchange).subscriberContext(ctx -> {
            List parentAccountIds = request.getHeaders().get((Object)HEADER_KEY_PARENT_ACCOUNT_ID);
            List loginAccountIds = request.getHeaders().get((Object)HEADER_KEY_LOGIN_ACCOUNT_ID);
            List resourceOwnerIds = request.getHeaders().get((Object)HEADER_KEY_RESOURCE_OWNER_ACCOUNT_ID);
            if (resourceOwnerIds == null || resourceOwnerIds.isEmpty()) {
                throw new EventBridgeException((BaseErrorCode)DefaultErrorCode.LoginFailed, new Object[0]);
            }
            return ctx.put((Object)HEADER_KEY_PARENT_ACCOUNT_ID, parentAccountIds != null && !parentAccountIds.isEmpty() ? parentAccountIds.get(0) : "").put((Object)HEADER_KEY_LOGIN_ACCOUNT_ID, loginAccountIds != null && !loginAccountIds.isEmpty() ? loginAccountIds.get(0) : "").put((Object)HEADER_KEY_RESOURCE_OWNER_ACCOUNT_ID, resourceOwnerIds != null && !resourceOwnerIds.isEmpty() ? resourceOwnerIds.get(0) : "");
        });
    }
}

