/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rpc.impl.core;

import com.alipay.remoting.Connection;
import com.alipay.remoting.ConnectionEventProcessor;
import com.alipay.sofa.jraft.ReplicatorGroup;
import com.alipay.sofa.jraft.entity.PeerId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientServiceConnectionEventProcessor
implements ConnectionEventProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ClientServiceConnectionEventProcessor.class);
    private final ReplicatorGroup rgGroup;

    public ClientServiceConnectionEventProcessor(ReplicatorGroup rgGroup) {
        this.rgGroup = rgGroup;
    }

    public void onEvent(String remoteAddr, Connection conn) {
        PeerId peer = new PeerId();
        if (peer.parse(remoteAddr)) {
            LOG.info("Peer {} is connected", (Object)peer);
            this.rgGroup.checkReplicator(peer, true);
        } else {
            LOG.error("Fail to parse peer: {}", (Object)remoteAddr);
        }
    }
}

