/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.queue;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.rocketmq.common.BoundaryType;
import org.apache.rocketmq.common.Pair;
import org.apache.rocketmq.common.attribute.CQType;
import org.apache.rocketmq.common.message.MessageExtBrokerInner;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.DispatchRequest;
import org.apache.rocketmq.store.MessageFilter;
import org.apache.rocketmq.store.MessageStore;
import org.apache.rocketmq.store.queue.ConsumeQueueInterface;
import org.apache.rocketmq.store.queue.CqUnit;
import org.apache.rocketmq.store.queue.QueueOffsetOperator;
import org.apache.rocketmq.store.queue.ReferredIterator;
import org.rocksdb.RocksDBException;

public class RocksDBConsumeQueue
implements ConsumeQueueInterface {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqStore");
    private static final Logger ERROR_LOG = LoggerFactory.getLogger((String)"RocketmqStoreError");
    private final MessageStore messageStore;
    private final String topic;
    private final int queueId;

    public RocksDBConsumeQueue(MessageStore messageStore, String topic, int queueId) {
        this.messageStore = messageStore;
        this.topic = topic;
        this.queueId = queueId;
    }

    public RocksDBConsumeQueue(String topic, int queueId) {
        this.messageStore = null;
        this.topic = topic;
        this.queueId = queueId;
    }

    @Override
    public boolean load() {
        return true;
    }

    @Override
    public void recover() {
    }

    @Override
    public void checkSelf() {
    }

    @Override
    public boolean flush(int flushLeastPages) {
        return true;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void truncateDirtyLogicFiles(long maxCommitLogPos) {
    }

    @Override
    public int deleteExpiredFile(long minCommitLogPos) {
        return 0;
    }

    @Override
    public long rollNextFile(long nextBeginOffset) {
        return 0L;
    }

    @Override
    public boolean isFirstFileAvailable() {
        return true;
    }

    @Override
    public boolean isFirstFileExist() {
        return true;
    }

    @Override
    public void swapMap(int reserveNum, long forceSwapIntervalMs, long normalSwapIntervalMs) {
    }

    @Override
    public void cleanSwappedMap(long forceCleanSwapIntervalMs) {
    }

    @Override
    public long getMaxOffsetInQueue() {
        try {
            return this.messageStore.getQueueStore().getMaxOffsetInQueue(this.topic, this.queueId);
        }
        catch (RocksDBException e) {
            ERROR_LOG.error("getMaxOffsetInQueue Failed. topic: {}, queueId: {}", new Object[]{this.topic, this.queueId, e});
            return 0L;
        }
    }

    @Override
    public long getMessageTotalInQueue() {
        try {
            long maxOffsetInQueue = this.messageStore.getQueueStore().getMaxOffsetInQueue(this.topic, this.queueId);
            long minOffsetInQueue = this.messageStore.getQueueStore().getMinOffsetInQueue(this.topic, this.queueId);
            return maxOffsetInQueue - minOffsetInQueue;
        }
        catch (RocksDBException e) {
            ERROR_LOG.error("getMessageTotalInQueue Failed. topic: {}, queueId: {}, {}", new Object[]{this.topic, this.queueId, e});
            return -1L;
        }
    }

    @Override
    public long getOffsetInQueueByTime(long timestamp) {
        return 0L;
    }

    @Override
    public long getOffsetInQueueByTime(long timestamp, BoundaryType boundaryType) {
        return 0L;
    }

    @Override
    public long getMaxPhysicOffset() {
        Long maxPhyOffset = this.messageStore.getQueueStore().getMaxPhyOffsetInConsumeQueue(this.topic, this.queueId);
        return maxPhyOffset == null ? -1L : maxPhyOffset;
    }

    @Override
    public long getMinLogicOffset() {
        return 0L;
    }

    @Override
    public CQType getCQType() {
        return CQType.RocksDBCQ;
    }

    @Override
    public long getTotalSize() {
        return 0L;
    }

    @Override
    public int getUnitSize() {
        return 20;
    }

    @Override
    public void correctMinOffset(long minCommitLogOffset) {
    }

    @Override
    public void putMessagePositionInfoWrapper(DispatchRequest request) {
    }

    @Override
    public void assignQueueOffset(QueueOffsetOperator queueOffsetOperator, MessageExtBrokerInner msg) throws RocksDBException {
        String topicQueueKey = this.getTopic() + "-" + this.getQueueId();
        Long queueOffset = queueOffsetOperator.getTopicQueueNextOffset(topicQueueKey);
        if (queueOffset == null) {
            queueOffset = this.messageStore.getQueueStore().getMaxOffsetInQueue(this.topic, this.queueId);
            queueOffsetOperator.updateQueueOffset(topicQueueKey, queueOffset);
        }
        msg.setQueueOffset(queueOffset.longValue());
    }

    @Override
    public void increaseQueueOffset(QueueOffsetOperator queueOffsetOperator, MessageExtBrokerInner msg, short messageNum) {
        String topicQueueKey = this.getTopic() + "-" + this.getQueueId();
        queueOffsetOperator.increaseQueueOffset(topicQueueKey, messageNum);
    }

    @Override
    public long estimateMessageCount(long from, long to, MessageFilter filter) {
        return 0L;
    }

    @Override
    public long getMinOffsetInQueue() {
        return this.messageStore.getMinOffsetInQueue(this.topic, this.queueId);
    }

    private int pullNum(long cqOffset, long maxCqOffset) {
        long diffLong = maxCqOffset - cqOffset;
        if (diffLong < Integer.MAX_VALUE) {
            int diffInt = (int)diffLong;
            return diffInt > 16 ? 16 : diffInt;
        }
        return 16;
    }

    @Override
    public ReferredIterator<CqUnit> iterateFrom(long startIndex) {
        try {
            long maxCqOffset = this.getMaxOffsetInQueue();
            if (startIndex < maxCqOffset) {
                int num = this.pullNum(startIndex, maxCqOffset);
                return this.iterateFrom0(startIndex, num);
            }
        }
        catch (RocksDBException e) {
            log.error("[RocksDBConsumeQueue] iterateFrom error!", (Throwable)e);
        }
        return null;
    }

    @Override
    public ReferredIterator<CqUnit> iterateFrom(long startIndex, int count) throws RocksDBException {
        long maxCqOffset = this.getMaxOffsetInQueue();
        if (startIndex < maxCqOffset) {
            int num = Math.min((int)(maxCqOffset - startIndex), count);
            return this.iterateFrom0(startIndex, num);
        }
        return null;
    }

    @Override
    public CqUnit get(long index) {
        Pair<CqUnit, Long> pair = this.getCqUnitAndStoreTime(index);
        return pair == null ? null : (CqUnit)pair.getObject1();
    }

    @Override
    public Pair<CqUnit, Long> getCqUnitAndStoreTime(long index) {
        ByteBuffer byteBuffer;
        try {
            byteBuffer = this.messageStore.getQueueStore().get(this.topic, this.queueId, index);
        }
        catch (RocksDBException e) {
            ERROR_LOG.error("getUnitAndStoreTime Failed. topic: {}, queueId: {}", new Object[]{this.topic, this.queueId, e});
            return null;
        }
        if (byteBuffer == null || byteBuffer.remaining() < 28) {
            return null;
        }
        long phyOffset = byteBuffer.getLong();
        int size = byteBuffer.getInt();
        long tagCode = byteBuffer.getLong();
        long messageStoreTime = byteBuffer.getLong();
        return new Pair((Object)new CqUnit(index, phyOffset, size, tagCode), (Object)messageStoreTime);
    }

    @Override
    public Pair<CqUnit, Long> getEarliestUnitAndStoreTime() {
        try {
            long minOffset = this.messageStore.getQueueStore().getMinOffsetInQueue(this.topic, this.queueId);
            return this.getCqUnitAndStoreTime(minOffset);
        }
        catch (RocksDBException e) {
            ERROR_LOG.error("getEarliestUnitAndStoreTime Failed. topic: {}, queueId: {}", new Object[]{this.topic, this.queueId, e});
            return null;
        }
    }

    @Override
    public CqUnit getEarliestUnit() {
        Pair<CqUnit, Long> pair = this.getEarliestUnitAndStoreTime();
        return pair == null ? null : (CqUnit)pair.getObject1();
    }

    @Override
    public CqUnit getLatestUnit() {
        try {
            long maxOffset = this.messageStore.getQueueStore().getMaxOffsetInQueue(this.topic, this.queueId);
            return this.get(maxOffset > 0L ? maxOffset - 1L : maxOffset);
        }
        catch (RocksDBException e) {
            ERROR_LOG.error("getLatestUnit Failed. topic: {}, queueId: {}, {}", new Object[]{this.topic, this.queueId, e.getMessage()});
            return null;
        }
    }

    @Override
    public long getLastOffset() {
        return this.getMaxPhysicOffset();
    }

    private ReferredIterator<CqUnit> iterateFrom0(long startIndex, int count) throws RocksDBException {
        List<ByteBuffer> byteBufferList = this.messageStore.getQueueStore().rangeQuery(this.topic, this.queueId, startIndex, count);
        if (byteBufferList == null || byteBufferList.isEmpty()) {
            if (this.messageStore.getMessageStoreConfig().isEnableRocksDBLog()) {
                log.warn("iterateFrom0 - find nothing, startIndex:{}, count:{}", (Object)startIndex, (Object)count);
            }
            return null;
        }
        return new RocksDBConsumeQueueIterator(byteBufferList, startIndex);
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public int getQueueId() {
        return this.queueId;
    }

    private class RocksDBConsumeQueueIterator
    implements ReferredIterator<CqUnit> {
        private final List<ByteBuffer> byteBufferList;
        private final long startIndex;
        private final int totalCount;
        private int currentIndex;

        public RocksDBConsumeQueueIterator(List<ByteBuffer> byteBufferList, long startIndex) {
            this.byteBufferList = byteBufferList;
            this.startIndex = startIndex;
            this.totalCount = byteBufferList.size();
            this.currentIndex = 0;
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < this.totalCount;
        }

        @Override
        public CqUnit next() {
            if (!this.hasNext()) {
                return null;
            }
            int currentIndex = this.currentIndex++;
            ByteBuffer byteBuffer = this.byteBufferList.get(currentIndex);
            CqUnit cqUnit = new CqUnit(this.startIndex + (long)currentIndex, byteBuffer.getLong(), byteBuffer.getInt(), byteBuffer.getLong());
            return cqUnit;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public void release() {
        }

        @Override
        public CqUnit nextAndRelease() {
            try {
                CqUnit cqUnit = this.next();
                return cqUnit;
            }
            finally {
                this.release();
            }
        }
    }
}

