/*
 * Decompiled with CFR 0.152.
 */
package org.archive.url;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.archive.url.CanonicalizeRules;
import org.archive.url.CanonicalizerConstants;
import org.archive.url.HandyURL;
import org.archive.url.URLCanonicalizer;
import org.archive.url.URLRegexTransformer;
import org.archive.util.StringFieldExtractor;

public class IAURLCanonicalizer
implements URLCanonicalizer,
CanonicalizerConstants {
    private CanonicalizeRules rules;
    public static final Pattern WWWN_PATTERN = Pattern.compile("^www\\d*\\.");

    public IAURLCanonicalizer(CanonicalizeRules rules) {
        this.rules = rules;
    }

    @Override
    public void canonicalize(HandyURL url) {
        int defaultPort;
        if (url.getOpaque() != null) {
            return;
        }
        if (this.rules.isSet(6, 1) && url.getScheme() != null) {
            url.setScheme(url.getScheme().toLowerCase(Locale.ROOT));
        }
        if (this.rules.isSet(0, 1)) {
            url.setHost(url.getHost().toLowerCase(Locale.ROOT));
        }
        if (this.rules.isSet(0, 2)) {
            url.setHost(IAURLCanonicalizer.massageHost(url.getHost()));
        }
        if (this.rules.isSet(5, 1)) {
            url.setAuthUser(null);
            url.setAuthPass(null);
        } else if (this.rules.isSet(5, 2)) {
            url.setAuthPass(null);
        }
        if (this.rules.isSet(1, 1) && (defaultPort = IAURLCanonicalizer.getDefaultPort(url.getScheme())) == url.getPort()) {
            url.setPort(-1);
        }
        String path = url.getPath();
        if (this.rules.isSet(2, 4) && path.equals("/")) {
            url.setPath(null);
        } else {
            if (this.rules.isSet(2, 1)) {
                path = path.toLowerCase(Locale.ROOT);
            }
            if (this.rules.isSet(2, 2)) {
                path = URLRegexTransformer.stripPathSessionID(path);
            }
            if (this.rules.isSet(2, 4) && path.equals("/")) {
                url.setPath(null);
            } else if (this.rules.isSet(2, 8) && path.endsWith("/") && path.length() > 1) {
                path = path.substring(0, path.length() - 1);
            }
            url.setPath(path);
        }
        String query = url.getQuery();
        if (query != null) {
            if (this.rules.isSet(3, 2)) {
                query = URLRegexTransformer.stripQuerySessionID(query);
            }
            if (this.rules.isSet(3, 1)) {
                query = query.toLowerCase(Locale.ROOT);
            }
            if (this.rules.isSet(3, 8)) {
                query = IAURLCanonicalizer.alphaReorderQuery(query);
            }
            if (query.equals("") && this.rules.isSet(3, 4)) {
                query = null;
            }
            url.setQuery(query);
        }
    }

    public static String alphaReorderQuery(String orig) {
        if (orig == null) {
            return null;
        }
        if (orig.length() <= 1) {
            return orig;
        }
        String[] args = orig.split("&", -1);
        StringFieldExtractor.StringTuple[] qas = new StringFieldExtractor.StringTuple[args.length];
        StringFieldExtractor sfe = new StringFieldExtractor('=', 1);
        for (int i = 0; i < args.length; ++i) {
            qas[i] = sfe.split(args[i]);
        }
        Arrays.sort(qas, new Comparator<StringFieldExtractor.StringTuple>(){

            @Override
            public int compare(StringFieldExtractor.StringTuple o1, StringFieldExtractor.StringTuple o2) {
                int cmp = o1.first.compareTo(o2.first);
                if (cmp != 0) {
                    return cmp;
                }
                if (o1.second == null) {
                    if (o2.second == null) {
                        return 0;
                    }
                    return -1;
                }
                if (o2.second == null) {
                    return 1;
                }
                return o1.second.compareTo(o2.second);
            }
        });
        StringBuilder sb = new StringBuilder(orig.length());
        int max = qas.length - 1;
        for (int i = 0; i < max; ++i) {
            if (qas[i].second == null) {
                sb.append(qas[i].first).append('&');
                continue;
            }
            sb.append(qas[i].first).append('=').append(qas[i].second).append('&');
        }
        if (qas[max].second == null) {
            sb.append(qas[max].first);
        } else {
            sb.append(qas[max].first).append('=').append(qas[max].second);
        }
        return sb.toString();
    }

    public static String massageHost(String host) {
        Matcher m;
        while ((m = WWWN_PATTERN.matcher(host)).find()) {
            host = host.substring(m.group(0).length());
        }
        return host;
    }

    public static int getDefaultPort(String scheme) {
        String lcScheme = scheme.toLowerCase(Locale.ROOT);
        if (lcScheme.equals("http")) {
            return 80;
        }
        if (lcScheme.equals("https")) {
            return 443;
        }
        return 0;
    }
}

