/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.flyway.autoconfigure;

import javax.lang.model.element.Modifier;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.generate.GeneratedMethod;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.beans.factory.aot.BeanRegistrationCode;
import org.springframework.beans.factory.aot.BeanRegistrationCodeFragments;
import org.springframework.beans.factory.aot.BeanRegistrationCodeFragmentsDecorator;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.boot.flyway.autoconfigure.NativeImageResourceProviderCustomizer;
import org.springframework.boot.flyway.autoconfigure.ResourceProviderCustomizer;
import org.springframework.javapoet.CodeBlock;

class ResourceProviderCustomizerBeanRegistrationAotProcessor
implements BeanRegistrationAotProcessor {
    ResourceProviderCustomizerBeanRegistrationAotProcessor() {
    }

    public @Nullable BeanRegistrationAotContribution processAheadOfTime(RegisteredBean registeredBean) {
        if (registeredBean.getBeanClass().equals(ResourceProviderCustomizer.class)) {
            return BeanRegistrationAotContribution.withCustomCodeFragments(codeFragments -> new AotContribution((BeanRegistrationCodeFragments)codeFragments, registeredBean));
        }
        return null;
    }

    private static class AotContribution
    extends BeanRegistrationCodeFragmentsDecorator {
        private final RegisteredBean registeredBean;

        protected AotContribution(BeanRegistrationCodeFragments delegate, RegisteredBean registeredBean) {
            super(delegate);
            this.registeredBean = registeredBean;
        }

        public CodeBlock generateInstanceSupplierCode(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode, boolean allowDirectSupplierShortcut) {
            GeneratedMethod generatedMethod = beanRegistrationCode.getMethods().add("getInstance", method -> {
                method.addJavadoc("Get the bean instance for '$L'.", new Object[]{this.registeredBean.getBeanName()});
                method.addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC});
                method.returns(NativeImageResourceProviderCustomizer.class);
                CodeBlock.Builder code = CodeBlock.builder();
                code.addStatement("return new $T()", new Object[]{NativeImageResourceProviderCustomizer.class});
                method.addCode(code.build());
            });
            return generatedMethod.toMethodReference().toCodeBlock();
        }
    }
}

