/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.params;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ParamContextClient;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.nifi.ParamContextResult;
import org.apache.nifi.web.api.entity.ParameterContextEntity;

public class GetParamContext
extends AbstractNiFiCommand<ParamContextResult> {
    public GetParamContext() {
        super("get-param-context", ParamContextResult.class);
    }

    @Override
    public String getDescription() {
        return "Retrieves a parameter context by id and lists each parameter and its value.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.PARAM_CONTEXT_ID.createOption());
        this.addOption(CommandOption.PARAM_CONTEXT_INCLUDE_INHERITED.createOption());
    }

    @Override
    public ParamContextResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String paramContextId = this.getRequiredArg(properties, CommandOption.PARAM_CONTEXT_ID);
        boolean includeInheritedParameters = this.hasArg(properties, CommandOption.PARAM_CONTEXT_INCLUDE_INHERITED);
        ParamContextClient paramContextClient = client.getParamContextClient();
        ParameterContextEntity parameterContext = paramContextClient.getParamContext(paramContextId, includeInheritedParameters);
        return new ParamContextResult(this.getResultType(properties), parameterContext, includeInheritedParameters);
    }
}

