/*
 * Decompiled with CFR 0.152.
 */
package v14.h2.command;

import java.io.ByteArrayOutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import v14.h2.api.IntervalQualifier;
import v14.h2.command.Command;
import v14.h2.command.CommandContainer;
import v14.h2.command.CommandList;
import v14.h2.command.Prepared;
import v14.h2.command.ddl.AlterIndexRename;
import v14.h2.command.ddl.AlterSchemaRename;
import v14.h2.command.ddl.AlterSequence;
import v14.h2.command.ddl.AlterTableAddConstraint;
import v14.h2.command.ddl.AlterTableAlterColumn;
import v14.h2.command.ddl.AlterTableDropConstraint;
import v14.h2.command.ddl.AlterTableRename;
import v14.h2.command.ddl.AlterTableRenameColumn;
import v14.h2.command.ddl.AlterTableRenameConstraint;
import v14.h2.command.ddl.AlterUser;
import v14.h2.command.ddl.AlterView;
import v14.h2.command.ddl.Analyze;
import v14.h2.command.ddl.CommandWithColumns;
import v14.h2.command.ddl.CreateAggregate;
import v14.h2.command.ddl.CreateConstant;
import v14.h2.command.ddl.CreateDomain;
import v14.h2.command.ddl.CreateFunctionAlias;
import v14.h2.command.ddl.CreateIndex;
import v14.h2.command.ddl.CreateLinkedTable;
import v14.h2.command.ddl.CreateRole;
import v14.h2.command.ddl.CreateSchema;
import v14.h2.command.ddl.CreateSequence;
import v14.h2.command.ddl.CreateSynonym;
import v14.h2.command.ddl.CreateTable;
import v14.h2.command.ddl.CreateTrigger;
import v14.h2.command.ddl.CreateUser;
import v14.h2.command.ddl.CreateView;
import v14.h2.command.ddl.DeallocateProcedure;
import v14.h2.command.ddl.DefineCommand;
import v14.h2.command.ddl.DropAggregate;
import v14.h2.command.ddl.DropConstant;
import v14.h2.command.ddl.DropDatabase;
import v14.h2.command.ddl.DropDomain;
import v14.h2.command.ddl.DropFunctionAlias;
import v14.h2.command.ddl.DropIndex;
import v14.h2.command.ddl.DropRole;
import v14.h2.command.ddl.DropSchema;
import v14.h2.command.ddl.DropSequence;
import v14.h2.command.ddl.DropSynonym;
import v14.h2.command.ddl.DropTable;
import v14.h2.command.ddl.DropTrigger;
import v14.h2.command.ddl.DropUser;
import v14.h2.command.ddl.DropView;
import v14.h2.command.ddl.GrantRevoke;
import v14.h2.command.ddl.PrepareProcedure;
import v14.h2.command.ddl.SchemaCommand;
import v14.h2.command.ddl.SequenceOptions;
import v14.h2.command.ddl.SetComment;
import v14.h2.command.ddl.TruncateTable;
import v14.h2.command.dml.AlterTableSet;
import v14.h2.command.dml.BackupCommand;
import v14.h2.command.dml.Call;
import v14.h2.command.dml.CommandWithValues;
import v14.h2.command.dml.DataChangeStatement;
import v14.h2.command.dml.Delete;
import v14.h2.command.dml.ExecuteImmediate;
import v14.h2.command.dml.ExecuteProcedure;
import v14.h2.command.dml.Explain;
import v14.h2.command.dml.Insert;
import v14.h2.command.dml.Merge;
import v14.h2.command.dml.MergeUsing;
import v14.h2.command.dml.NoOperation;
import v14.h2.command.dml.Query;
import v14.h2.command.dml.RunScriptCommand;
import v14.h2.command.dml.ScriptCommand;
import v14.h2.command.dml.Select;
import v14.h2.command.dml.SelectOrderBy;
import v14.h2.command.dml.SelectUnion;
import v14.h2.command.dml.Set;
import v14.h2.command.dml.SetSessionCharacteristics;
import v14.h2.command.dml.SetTypes;
import v14.h2.command.dml.TableValueConstructor;
import v14.h2.command.dml.TransactionCommand;
import v14.h2.command.dml.Update;
import v14.h2.constraint.ConstraintActionType;
import v14.h2.engine.Database;
import v14.h2.engine.Domain;
import v14.h2.engine.FunctionAlias;
import v14.h2.engine.IsolationLevel;
import v14.h2.engine.Mode;
import v14.h2.engine.Procedure;
import v14.h2.engine.Session;
import v14.h2.engine.User;
import v14.h2.engine.UserAggregate;
import v14.h2.expression.Alias;
import v14.h2.expression.BinaryOperation;
import v14.h2.expression.ConcatenationOperation;
import v14.h2.expression.Expression;
import v14.h2.expression.ExpressionColumn;
import v14.h2.expression.ExpressionList;
import v14.h2.expression.ExpressionWithFlags;
import v14.h2.expression.Format;
import v14.h2.expression.Parameter;
import v14.h2.expression.Rownum;
import v14.h2.expression.SequenceValue;
import v14.h2.expression.Subquery;
import v14.h2.expression.TimeZoneOperation;
import v14.h2.expression.TypedValueExpression;
import v14.h2.expression.UnaryOperation;
import v14.h2.expression.ValueExpression;
import v14.h2.expression.Variable;
import v14.h2.expression.Wildcard;
import v14.h2.expression.aggregate.AbstractAggregate;
import v14.h2.expression.aggregate.Aggregate;
import v14.h2.expression.aggregate.AggregateType;
import v14.h2.expression.aggregate.JavaAggregate;
import v14.h2.expression.analysis.DataAnalysisOperation;
import v14.h2.expression.analysis.Window;
import v14.h2.expression.analysis.WindowFrame;
import v14.h2.expression.analysis.WindowFrameBound;
import v14.h2.expression.analysis.WindowFrameBoundType;
import v14.h2.expression.analysis.WindowFrameExclusion;
import v14.h2.expression.analysis.WindowFrameUnits;
import v14.h2.expression.analysis.WindowFunction;
import v14.h2.expression.analysis.WindowFunctionType;
import v14.h2.expression.condition.BooleanTest;
import v14.h2.expression.condition.CompareLike;
import v14.h2.expression.condition.Comparison;
import v14.h2.expression.condition.ConditionAndOr;
import v14.h2.expression.condition.ConditionIn;
import v14.h2.expression.condition.ConditionInParameter;
import v14.h2.expression.condition.ConditionInQuery;
import v14.h2.expression.condition.ConditionLocalAndGlobal;
import v14.h2.expression.condition.ConditionNot;
import v14.h2.expression.condition.ExistsPredicate;
import v14.h2.expression.condition.IsJsonPredicate;
import v14.h2.expression.condition.NullPredicate;
import v14.h2.expression.condition.TypePredicate;
import v14.h2.expression.condition.UniquePredicate;
import v14.h2.expression.function.Function;
import v14.h2.expression.function.FunctionCall;
import v14.h2.expression.function.JavaFunction;
import v14.h2.expression.function.TableFunction;
import v14.h2.index.Index;
import v14.h2.message.DbException;
import v14.h2.schema.Schema;
import v14.h2.schema.SchemaObject;
import v14.h2.schema.Sequence;
import v14.h2.table.Column;
import v14.h2.table.DataChangeDeltaTable;
import v14.h2.table.DualTable;
import v14.h2.table.FunctionTable;
import v14.h2.table.IndexColumn;
import v14.h2.table.IndexHints;
import v14.h2.table.RangeTable;
import v14.h2.table.Table;
import v14.h2.table.TableFilter;
import v14.h2.table.TableView;
import v14.h2.util.IntervalUtils;
import v14.h2.util.ParserUtil;
import v14.h2.util.StringUtils;
import v14.h2.util.Utils;
import v14.h2.util.geometry.EWKTUtils;
import v14.h2.util.json.JSONItemType;
import v14.h2.value.CompareMode;
import v14.h2.value.DataType;
import v14.h2.value.ExtTypeInfo;
import v14.h2.value.ExtTypeInfoEnum;
import v14.h2.value.ExtTypeInfoGeometry;
import v14.h2.value.TypeInfo;
import v14.h2.value.Value;
import v14.h2.value.ValueArray;
import v14.h2.value.ValueBytes;
import v14.h2.value.ValueDate;
import v14.h2.value.ValueDecimal;
import v14.h2.value.ValueInt;
import v14.h2.value.ValueJson;
import v14.h2.value.ValueLong;
import v14.h2.value.ValueNull;
import v14.h2.value.ValueRow;
import v14.h2.value.ValueString;
import v14.h2.value.ValueTime;
import v14.h2.value.ValueTimeTimeZone;
import v14.h2.value.ValueTimestamp;
import v14.h2.value.ValueTimestampTimeZone;

public class Parser {
    private static final String WITH_STATEMENT_SUPPORTS_LIMITED_SUB_STATEMENTS = "WITH statement supports only SELECT, TABLE, VALUES, CREATE TABLE, INSERT, UPDATE, MERGE or DELETE statements";
    private static final int CHAR_END = 1;
    private static final int CHAR_VALUE = 2;
    private static final int CHAR_QUOTED = 3;
    private static final int CHAR_NAME = 4;
    private static final int CHAR_SPECIAL_1 = 5;
    private static final int CHAR_SPECIAL_2 = 6;
    private static final int CHAR_STRING = 7;
    private static final int CHAR_DOT = 8;
    private static final int CHAR_DOLLAR_QUOTED_STRING = 9;
    private static final int PARAMETER = 62;
    private static final int END = 63;
    private static final int VALUE = 64;
    private static final int EQUAL = 65;
    private static final int BIGGER_EQUAL = 66;
    private static final int BIGGER = 67;
    private static final int SMALLER = 68;
    private static final int SMALLER_EQUAL = 69;
    private static final int NOT_EQUAL = 70;
    private static final int AT = 71;
    private static final int MINUS_SIGN = 72;
    private static final int PLUS_SIGN = 73;
    private static final int CONCATENATION = 74;
    private static final int OPEN_PAREN = 75;
    private static final int CLOSE_PAREN = 76;
    private static final int SPATIAL_INTERSECTS = 77;
    private static final int ASTERISK = 78;
    private static final int COMMA = 79;
    private static final int DOT = 80;
    private static final int OPEN_BRACE = 81;
    private static final int CLOSE_BRACE = 82;
    private static final int SLASH = 83;
    private static final int PERCENT = 84;
    private static final int SEMICOLON = 85;
    private static final int COLON = 86;
    private static final int OPEN_BRACKET = 87;
    private static final int CLOSE_BRACKET = 88;
    private static final int TILDE = 89;
    private static final int COLON_COLON = 90;
    private static final int COLON_EQ = 91;
    private static final int NOT_TILDE = 92;
    private static final String[] TOKENS = new String[]{null, null, null, "ALL", "ARRAY", "CASE", "CHECK", "CONSTRAINT", "CROSS", "CURRENT_CATALOG", "CURRENT_DATE", "CURRENT_SCHEMA", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "DISTINCT", "EXCEPT", "EXISTS", "FALSE", "FETCH", "FOR", "FOREIGN", "FROM", "FULL", "GROUP", "HAVING", "IF", "INNER", "INTERSECT", "INTERSECTS", "INTERVAL", "IS", "JOIN", "LEFT", "LIKE", "LIMIT", "LOCALTIME", "LOCALTIMESTAMP", "MINUS", "NATURAL", "NOT", "NULL", "OFFSET", "ON", "ORDER", "PRIMARY", "QUALIFY", "RIGHT", "ROW", "_ROWID_", "ROWNUM", "SELECT", "TABLE", "TRUE", "UNION", "UNIQUE", "UNKNOWN", "USING", "VALUES", "WHERE", "WINDOW", "WITH", "?", null, null, "=", ">=", ">", "<", "<=", "<>", "@", "-", "+", "||", "(", ")", "&&", "*", ",", ".", "{", "}", "/", "%", ";", ":", "[", "]", "~", "::", ":=", "!~"};
    private static final Comparator<TableFilter> TABLE_FILTER_COMPARATOR = new Comparator<TableFilter>(){

        @Override
        public int compare(TableFilter tableFilter, TableFilter tableFilter2) {
            if (tableFilter == tableFilter2) {
                return 0;
            }
            assert (tableFilter.getOrderInFrom() != tableFilter2.getOrderInFrom());
            return tableFilter.getOrderInFrom() > tableFilter2.getOrderInFrom() ? 1 : -1;
        }
    };
    private final Database database;
    private final Session session;
    private final boolean identifiersToLower;
    private final boolean identifiersToUpper;
    private int[] characterTypes;
    private int currentTokenType;
    private String currentToken;
    private boolean currentTokenQuoted;
    private Value currentValue;
    private String originalSQL;
    private String sqlCommand;
    private char[] sqlCommandChars;
    private int lastParseIndex;
    private int parseIndex;
    private CreateView createView;
    private Prepared currentPrepared;
    private Select currentSelect;
    private ArrayList<Parameter> parameters;
    private ArrayList<Parameter> indexedParameterList;
    private ArrayList<Parameter> suppliedParameters;
    private ArrayList<Parameter> suppliedParameterList;
    private String schemaName;
    private ArrayList<String> expectedList;
    private boolean rightsChecked;
    private boolean recompileAlways;
    private boolean literalsChecked;
    private int orderInFrom;

    public Parser(Session session) {
        this.database = session.getDatabase();
        this.identifiersToLower = this.database.getSettings().databaseToLower;
        this.identifiersToUpper = this.database.getSettings().databaseToUpper;
        this.session = session;
    }

    public Parser() {
        this.database = null;
        this.identifiersToLower = false;
        this.identifiersToUpper = false;
        this.session = null;
    }

    public Prepared prepare(String string) {
        Prepared prepared = this.parse(string);
        prepared.prepare();
        if (this.currentTokenType != 63) {
            throw this.getSyntaxError();
        }
        return prepared;
    }

    public Command prepareCommand(String string) {
        try {
            String string2;
            Prepared prepared = this.parse(string);
            if (this.currentTokenType != 85 && this.currentTokenType != 63) {
                this.addExpected(85);
                throw this.getSyntaxError();
            }
            try {
                prepared.prepare();
            }
            catch (Throwable throwable) {
                CommandContainer.clearCTE(this.session, prepared);
                throw throwable;
            }
            if (this.parseIndex < string.length()) {
                string = string.substring(0, this.parseIndex);
            }
            CommandContainer commandContainer = new CommandContainer(this.session, string, prepared);
            if (this.currentTokenType == 85 && !StringUtils.isWhitespaceOrEmpty(string2 = this.originalSQL.substring(this.parseIndex))) {
                return this.prepareCommandList(commandContainer, string, string2);
            }
            return commandContainer;
        }
        catch (DbException dbException) {
            throw dbException.addSQL(this.originalSQL);
        }
    }

    private CommandList prepareCommandList(CommandContainer commandContainer, String string, String string2) {
        try {
            ArrayList<Prepared> arrayList = Utils.newSmallArrayList();
            boolean bl = false;
            do {
                Prepared prepared;
                if (bl) {
                    return new CommandList(this.session, string, commandContainer, arrayList, this.parameters, string2);
                }
                this.suppliedParameters = this.parameters;
                this.suppliedParameterList = this.indexedParameterList;
                try {
                    prepared = this.parse(string2);
                }
                catch (DbException dbException) {
                    if (dbException.getErrorCode() == 90123) {
                        throw dbException;
                    }
                    return new CommandList(this.session, string, commandContainer, arrayList, this.parameters, string2);
                }
                if (prepared instanceof DefineCommand) {
                    bl = true;
                }
                arrayList.add(prepared);
                if (this.currentTokenType == 63) break;
                if (this.currentTokenType == 85) continue;
                this.addExpected(85);
                throw this.getSyntaxError();
            } while (!StringUtils.isWhitespaceOrEmpty(string2 = this.originalSQL.substring(this.parseIndex)));
            return new CommandList(this.session, string, commandContainer, arrayList, this.parameters, null);
        }
        catch (Throwable throwable) {
            commandContainer.clearCTE();
            throw throwable;
        }
    }

    Prepared parse(String string) {
        Prepared prepared;
        try {
            prepared = this.parse(string, false);
        }
        catch (DbException dbException) {
            if (dbException.getErrorCode() == 42000) {
                prepared = this.parse(string, true);
            }
            throw dbException.addSQL(string);
        }
        prepared.setPrepareAlways(this.recompileAlways);
        prepared.setParameterList(this.parameters);
        return prepared;
    }

    private Prepared parse(String string, boolean bl) {
        this.initialize(string);
        this.expectedList = bl ? new ArrayList() : null;
        this.parameters = this.suppliedParameters != null ? this.suppliedParameters : Utils.newSmallArrayList();
        this.indexedParameterList = this.suppliedParameterList;
        this.currentSelect = null;
        this.currentPrepared = null;
        this.createView = null;
        this.recompileAlways = false;
        this.read();
        return this.parsePrepared();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private Prepared parsePrepared() {
        int n;
        void var2_41;
        int n2 = this.lastParseIndex;
        Object var2_2 = null;
        switch (this.currentTokenType) {
            case 63: 
            case 85: {
                NoOperation noOperation = new NoOperation(this.session);
                this.setSQL(noOperation, null, n2);
                return noOperation;
            }
            case 62: {
                this.readTerm();
                this.parameters.get(0).setValue(ValueNull.INSTANCE);
                this.read(65);
                this.read("CALL");
                Call call = this.parseCall();
                break;
            }
            case 51: 
            case 52: 
            case 58: 
            case 75: {
                Query query = this.parseQuery();
                break;
            }
            case 61: {
                this.read();
                Prepared prepared = this.parseWithStatementOrQuery();
                break;
            }
            case 2: {
                if (this.currentTokenQuoted) break;
                switch (this.currentToken.charAt(0) & 0xFFDF) {
                    case 65: {
                        if (this.readIf("ALTER")) {
                            Prepared prepared = this.parseAlter();
                            break;
                        }
                        if (!this.readIf("ANALYZE")) break;
                        Prepared prepared = this.parseAnalyze();
                        break;
                    }
                    case 66: {
                        if (this.readIf("BACKUP")) {
                            Prepared prepared = this.parseBackup();
                            break;
                        }
                        if (!this.readIf("BEGIN")) break;
                        TransactionCommand transactionCommand = this.parseBegin();
                        break;
                    }
                    case 67: {
                        if (this.readIf("COMMIT")) {
                            TransactionCommand transactionCommand = this.parseCommit();
                            break;
                        }
                        if (this.readIf("CREATE")) {
                            Prepared prepared = this.parseCreate();
                            break;
                        }
                        if (this.readIf("CALL")) {
                            Call call = this.parseCall();
                            break;
                        }
                        if (this.readIf("CHECKPOINT")) {
                            TransactionCommand transactionCommand = this.parseCheckpoint();
                            break;
                        }
                        if (!this.readIf("COMMENT")) break;
                        Prepared prepared = this.parseComment();
                        break;
                    }
                    case 68: {
                        if (this.readIf("DELETE")) {
                            Delete delete = this.parseDelete();
                            break;
                        }
                        if (this.readIf("DROP")) {
                            Prepared prepared = this.parseDrop();
                            break;
                        }
                        if (this.readIf("DECLARE")) {
                            Prepared prepared = this.parseCreate();
                            break;
                        }
                        if (this.database.getMode().getEnum() == Mode.ModeEnum.MSSQLServer || !this.readIf("DEALLOCATE")) break;
                        DeallocateProcedure deallocateProcedure = this.parseDeallocate();
                        break;
                    }
                    case 69: {
                        if (this.readIf("EXPLAIN")) {
                            Explain explain = this.parseExplain();
                            break;
                        }
                        if (this.database.getMode().getEnum() != Mode.ModeEnum.MSSQLServer) {
                            if (!this.readIf("EXECUTE")) break;
                            Prepared prepared = this.parseExecutePostgre();
                            break;
                        }
                        if (!this.readIf("EXEC") && !this.readIf("EXECUTE")) break;
                        Prepared prepared = this.parseExecuteSQLServer();
                        break;
                    }
                    case 71: {
                        if (!this.readIf("GRANT")) break;
                        GrantRevoke grantRevoke = this.parseGrantRevoke(49);
                        break;
                    }
                    case 72: {
                        if (!this.readIf("HELP")) break;
                        Prepared prepared = this.parseHelp();
                        break;
                    }
                    case 73: {
                        if (!this.readIf("INSERT")) break;
                        Insert insert = this.parseInsert();
                        break;
                    }
                    case 77: {
                        if (!this.readIf("MERGE")) break;
                        Prepared prepared = this.parseMerge();
                        break;
                    }
                    case 80: {
                        if (this.database.getMode().getEnum() == Mode.ModeEnum.MSSQLServer || !this.readIf("PREPARE")) break;
                        Prepared prepared = this.parsePrepare();
                        break;
                    }
                    case 82: {
                        if (this.readIf("ROLLBACK")) {
                            TransactionCommand transactionCommand = this.parseRollback();
                            break;
                        }
                        if (this.readIf("REVOKE")) {
                            GrantRevoke grantRevoke = this.parseGrantRevoke(50);
                            break;
                        }
                        if (this.readIf("RUNSCRIPT")) {
                            RunScriptCommand runScriptCommand = this.parseRunScript();
                            break;
                        }
                        if (this.readIf("RELEASE")) {
                            Prepared prepared = this.parseReleaseSavepoint();
                            break;
                        }
                        if (!this.database.getMode().replaceInto || !this.readIf("REPLACE")) break;
                        Merge merge = this.parseReplace();
                        break;
                    }
                    case 83: {
                        if (this.readIf("SET")) {
                            Prepared prepared = this.parseSet();
                            break;
                        }
                        if (this.readIf("SAVEPOINT")) {
                            TransactionCommand transactionCommand = this.parseSavepoint();
                            break;
                        }
                        if (this.readIf("SCRIPT")) {
                            ScriptCommand scriptCommand = this.parseScript();
                            break;
                        }
                        if (this.readIf("SHUTDOWN")) {
                            TransactionCommand transactionCommand = this.parseShutdown();
                            break;
                        }
                        if (!this.readIf("SHOW")) break;
                        Prepared prepared = this.parseShow();
                        break;
                    }
                    case 84: {
                        if (!this.readIf("TRUNCATE")) break;
                        Prepared prepared = this.parseTruncate();
                        break;
                    }
                    case 85: {
                        if (this.readIf("UPDATE")) {
                            Update update = this.parseUpdate();
                            break;
                        }
                        if (!this.readIf("USE")) break;
                        Prepared prepared = this.parseUse();
                    }
                }
                break;
            }
        }
        if (var2_41 == null) {
            throw this.getSyntaxError();
        }
        if (this.indexedParameterList != null) {
            int n3 = this.indexedParameterList.size();
            for (n = 0; n < n3; ++n) {
                if (this.indexedParameterList.get(n) != null) continue;
                this.indexedParameterList.set(n, new Parameter(n));
            }
            this.parameters = this.indexedParameterList;
        }
        if (this.readIf(81)) {
            do {
                if ((n = (int)this.readLong() - 1) < 0 || n >= this.parameters.size()) {
                    throw this.getSyntaxError();
                }
                Parameter parameter = this.parameters.get(n);
                if (parameter == null) {
                    throw this.getSyntaxError();
                }
                this.read(86);
                Expression expression = this.readExpression();
                expression = expression.optimize(this.session);
                parameter.setValue(expression.getValue(this.session));
            } while (this.readIf(79));
            this.read(82);
            for (Parameter parameter : this.parameters) {
                parameter.checkSet();
            }
            this.parameters.clear();
        }
        this.setSQL((Prepared)var2_41, null, n2);
        return var2_41;
    }

    private DbException getSyntaxError() {
        if (this.expectedList == null || this.expectedList.isEmpty()) {
            return DbException.getSyntaxError(this.sqlCommand, this.parseIndex);
        }
        return DbException.getSyntaxError(this.sqlCommand, this.parseIndex, StringUtils.join(new StringBuilder(), this.expectedList, ", ").toString());
    }

    private Prepared parseBackup() {
        BackupCommand backupCommand = new BackupCommand(this.session);
        this.read("TO");
        backupCommand.setFileName(this.readExpression());
        return backupCommand;
    }

    private Prepared parseAnalyze() {
        Analyze analyze = new Analyze(this.session);
        if (this.readIf(52)) {
            Table table = this.readTableOrView();
            analyze.setTable(table);
        }
        if (this.readIf("SAMPLE_SIZE")) {
            analyze.setTop(this.readNonNegativeInt());
        }
        return analyze;
    }

    private TransactionCommand parseBegin() {
        if (!this.readIf("WORK")) {
            this.readIf("TRANSACTION");
        }
        TransactionCommand transactionCommand = new TransactionCommand(this.session, 83);
        return transactionCommand;
    }

    private TransactionCommand parseCommit() {
        if (this.readIf("TRANSACTION")) {
            TransactionCommand transactionCommand = new TransactionCommand(this.session, 78);
            transactionCommand.setTransactionName(this.readUniqueIdentifier());
            return transactionCommand;
        }
        TransactionCommand transactionCommand = new TransactionCommand(this.session, 71);
        this.readIf("WORK");
        return transactionCommand;
    }

    private TransactionCommand parseShutdown() {
        int n = 80;
        if (this.readIf("IMMEDIATELY")) {
            n = 81;
        } else if (this.readIf("COMPACT")) {
            n = 82;
        } else if (this.readIf("DEFRAG")) {
            n = 84;
        } else {
            this.readIf("SCRIPT");
        }
        return new TransactionCommand(this.session, n);
    }

    private TransactionCommand parseRollback() {
        TransactionCommand transactionCommand;
        if (this.readIf("TRANSACTION")) {
            TransactionCommand transactionCommand2 = new TransactionCommand(this.session, 79);
            transactionCommand2.setTransactionName(this.readUniqueIdentifier());
            return transactionCommand2;
        }
        if (this.readIf("TO")) {
            this.read("SAVEPOINT");
            transactionCommand = new TransactionCommand(this.session, 75);
            transactionCommand.setSavepointName(this.readUniqueIdentifier());
        } else {
            this.readIf("WORK");
            transactionCommand = new TransactionCommand(this.session, 72);
        }
        return transactionCommand;
    }

    private Prepared parsePrepare() {
        Object object;
        if (this.readIf("COMMIT")) {
            TransactionCommand transactionCommand = new TransactionCommand(this.session, 77);
            transactionCommand.setTransactionName(this.readUniqueIdentifier());
            return transactionCommand;
        }
        String string = this.readAliasIdentifier();
        if (this.readIf(75)) {
            object = Utils.newSmallArrayList();
            int n = 0;
            while (true) {
                Column column = this.parseColumnForTable("C" + n, true, false);
                ((ArrayList)object).add(column);
                if (!this.readIfMore()) break;
                ++n;
            }
        }
        this.read("AS");
        object = this.parsePrepared();
        PrepareProcedure prepareProcedure = new PrepareProcedure(this.session);
        prepareProcedure.setProcedureName(string);
        prepareProcedure.setPrepared((Prepared)object);
        return prepareProcedure;
    }

    private TransactionCommand parseSavepoint() {
        TransactionCommand transactionCommand = new TransactionCommand(this.session, 74);
        transactionCommand.setSavepointName(this.readUniqueIdentifier());
        return transactionCommand;
    }

    private Prepared parseReleaseSavepoint() {
        NoOperation noOperation = new NoOperation(this.session);
        this.readIf("SAVEPOINT");
        this.readUniqueIdentifier();
        return noOperation;
    }

    private Schema findSchema(String string) {
        if (string == null) {
            return null;
        }
        Schema schema = this.database.findSchema(string);
        if (schema == null && this.equalsToken("SESSION", string)) {
            schema = this.database.getSchema(this.session.getCurrentSchemaName());
        }
        return schema;
    }

    private Schema getSchema(String string) {
        if (string == null) {
            return null;
        }
        Schema schema = this.findSchema(string);
        if (schema == null) {
            throw DbException.get(90079, string);
        }
        return schema;
    }

    private Schema getSchema() {
        return this.getSchema(this.schemaName);
    }

    private Schema getSchemaWithDefault() {
        if (this.schemaName == null) {
            this.schemaName = this.session.getCurrentSchemaName();
        }
        return this.getSchema(this.schemaName);
    }

    private Column readTableColumn(TableFilter tableFilter) {
        boolean bl = false;
        String string = null;
        if (this.currentTokenType == 49) {
            this.read();
            bl = true;
        } else {
            string = this.readColumnIdentifier();
            if (this.readIf(80)) {
                String string2 = string;
                if (this.currentTokenType == 49) {
                    this.read();
                    bl = true;
                } else {
                    string = this.readColumnIdentifier();
                    if (this.readIf(80)) {
                        String string3 = string2;
                        string2 = string;
                        if (this.currentTokenType == 49) {
                            this.read();
                            bl = true;
                        } else {
                            string = this.readColumnIdentifier();
                            if (this.readIf(80)) {
                                this.checkDatabaseName(string3);
                                string3 = string2;
                                string2 = string;
                                if (this.currentTokenType == 49) {
                                    this.read();
                                    bl = true;
                                } else {
                                    string = this.readColumnIdentifier();
                                }
                            }
                        }
                        if (!this.equalsToken(string3, tableFilter.getTable().getSchema().getName())) {
                            throw DbException.get(90079, string3);
                        }
                    }
                }
                if (!this.equalsToken(string2, tableFilter.getTableAlias())) {
                    throw DbException.get(42102, string2);
                }
            }
        }
        return bl ? tableFilter.getRowIdColumn() : tableFilter.getTable().getColumn(string);
    }

    private Update parseUpdate() {
        Update update = new Update(this.session);
        this.currentPrepared = update;
        int n = this.lastParseIndex;
        Expression expression = null;
        if (this.database.getMode().getEnum() == Mode.ModeEnum.MSSQLServer && this.readIf("TOP")) {
            this.read(75);
            expression = this.readTerm().optimize(this.session);
            update.setLimit(expression);
            this.read(76);
        }
        TableFilter tableFilter = this.readSimpleTableFilter(0, null);
        update.setTableFilter(tableFilter);
        this.parseUpdateSetClause(update, tableFilter, n, expression == null);
        return update;
    }

    private void parseUpdateSetClause(Update update, TableFilter tableFilter, int n, boolean bl) {
        Object object;
        this.read("SET");
        do {
            if (this.readIf(75)) {
                Object object2;
                object = Utils.newSmallArrayList();
                do {
                    object2 = this.readTableColumn(tableFilter);
                    ((ArrayList)object).add(object2);
                } while (this.readIfMore());
                this.read(65);
                object2 = this.readExpression();
                int n2 = ((ArrayList)object).size();
                if (object2 instanceof ExpressionList) {
                    ExpressionList expressionList = (ExpressionList)object2;
                    if (expressionList.getType().getValueType() != 39 || n2 != expressionList.getSubexpressionCount()) {
                        throw DbException.get(21002);
                    }
                    for (int i = 0; i < n2; ++i) {
                        update.setAssignment((Column)((ArrayList)object).get(i), expressionList.getSubexpression(i));
                    }
                } else {
                    if (n2 == 1) {
                        update.setAssignment((Column)((ArrayList)object).get(0), (Expression)object2);
                        continue;
                    }
                    for (int i = 0; i < n2; ++i) {
                        update.setAssignment((Column)((ArrayList)object).get(i), Function.getFunctionWithArgs(this.database, 209, new Expression[]{object2, ValueExpression.get(ValueInt.get(i + 1))}));
                    }
                }
            } else {
                object = this.readTableColumn(tableFilter);
                this.read(65);
                update.setAssignment((Column)object, this.readExpressionOrDefault());
            }
        } while (this.readIf(79));
        if (this.readIf(59)) {
            object = this.readExpression();
            update.setCondition((Expression)object);
        }
        if (bl) {
            if (this.readIf(44)) {
                this.read("BY");
                this.parseSimpleOrderList();
            }
            if (this.readIf(35)) {
                object = this.readTerm().optimize(this.session);
                update.setLimit((Expression)object);
            }
        }
        this.setSQL(update, "UPDATE", n);
    }

    private TableFilter readSimpleTableFilter(int n, Collection<String> collection) {
        Table table = this.readTableOrView();
        String string = null;
        if (this.readIf("AS")) {
            string = this.readAliasIdentifier();
        } else if (!(this.currentTokenType != 2 || Parser.equalsTokenIgnoreCase(this.currentToken, "SET") || collection != null && this.isTokenInList(collection))) {
            string = this.readAliasIdentifier();
        }
        return new TableFilter(this.session, table, string, this.rightsChecked, this.currentSelect, n, null);
    }

    private Delete parseDelete() {
        Delete delete = new Delete(this.session);
        Expression expression = null;
        if (this.readIf("TOP")) {
            expression = this.readTerm().optimize(this.session);
        }
        this.currentPrepared = delete;
        int n = this.lastParseIndex;
        if (!this.readIf(22) && this.database.getMode().getEnum() == Mode.ModeEnum.MySQL) {
            this.readIdentifierWithSchema();
            this.read(22);
        }
        TableFilter tableFilter = this.readSimpleTableFilter(0, null);
        delete.setTableFilter(tableFilter);
        if (this.readIf(59)) {
            delete.setCondition(this.readExpression());
        }
        if (expression == null && this.readIf(35)) {
            expression = this.readTerm().optimize(this.session);
        }
        delete.setLimit(expression);
        this.setSQL(delete, "DELETE", n);
        return delete;
    }

    private IndexColumn[] parseIndexColumnList() {
        ArrayList<IndexColumn> arrayList = Utils.newSmallArrayList();
        do {
            IndexColumn indexColumn = new IndexColumn();
            indexColumn.columnName = this.readColumnIdentifier();
            indexColumn.sortType = this.parseSortType();
            arrayList.add(indexColumn);
        } while (this.readIfMore());
        return arrayList.toArray(new IndexColumn[0]);
    }

    private int parseSortType() {
        int n = this.parseSimpleSortType();
        if (this.readIf("NULLS")) {
            if (this.readIf("FIRST")) {
                n |= 2;
            } else {
                this.read("LAST");
                n |= 4;
            }
        }
        return n;
    }

    private int parseSimpleSortType() {
        if (!this.readIf("ASC") && this.readIf("DESC")) {
            return 1;
        }
        return 0;
    }

    private String[] parseColumnList() {
        ArrayList<String> arrayList = Utils.newSmallArrayList();
        do {
            String string = this.readColumnIdentifier();
            arrayList.add(string);
        } while (this.readIfMore());
        return arrayList.toArray(new String[0]);
    }

    private Column[] parseColumnList(Table table) {
        ArrayList<Column> arrayList = Utils.newSmallArrayList();
        HashSet<Column> hashSet = new HashSet<Column>();
        if (!this.readIf(76)) {
            do {
                Column column;
                if (!hashSet.add(column = this.parseColumn(table))) {
                    throw DbException.get(42121, column.getSQL(false));
                }
                arrayList.add(column);
            } while (this.readIfMore());
        }
        return arrayList.toArray(new Column[0]);
    }

    private Column parseColumn(Table table) {
        if (this.currentTokenType == 49) {
            this.read();
            return table.getRowIdColumn();
        }
        return table.getColumn(this.readColumnIdentifier());
    }

    private boolean readIfMore() {
        if (this.readIf(79)) {
            return true;
        }
        this.read(76);
        return false;
    }

    private Prepared parseHelp() {
        Select select = new Select(this.session, null);
        select.setWildcard();
        String string = this.database.sysIdentifier("INFORMATION_SCHEMA");
        Table table = this.database.getSchema(string).resolveTableOrView(this.session, this.database.sysIdentifier("HELP"));
        Function function = Function.getFunctionWithArgs(this.database, 76, new ExpressionColumn(this.database, string, this.database.sysIdentifier("HELP"), this.database.sysIdentifier("TOPIC"), false));
        TableFilter tableFilter = new TableFilter(this.session, table, null, this.rightsChecked, select, 0, null);
        select.addTableFilter(tableFilter, true);
        while (this.currentTokenType != 63) {
            String string2 = this.currentToken;
            this.read();
            CompareLike compareLike = new CompareLike(this.database, function, ValueExpression.get(ValueString.get('%' + string2 + '%')), null, false);
            select.addCondition(compareLike);
        }
        select.init();
        return select;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Prepared parseShow() {
        Object object;
        String string;
        ArrayList<Value> arrayList = Utils.newSmallArrayList();
        StringBuilder stringBuilder = new StringBuilder("SELECT ");
        if (this.readIf("CLIENT_ENCODING")) {
            stringBuilder.append("'UNICODE' AS CLIENT_ENCODING FROM DUAL");
        } else if (this.readIf("DEFAULT_TRANSACTION_ISOLATION")) {
            stringBuilder.append("'read committed' AS DEFAULT_TRANSACTION_ISOLATION FROM DUAL");
        } else if (this.readIf("TRANSACTION")) {
            this.read("ISOLATION");
            this.read("LEVEL");
            stringBuilder.append("'read committed' AS TRANSACTION_ISOLATION FROM DUAL");
        } else if (this.readIf("DATESTYLE")) {
            stringBuilder.append("'ISO' AS DATESTYLE FROM DUAL");
        } else if (this.readIf("SERVER_VERSION")) {
            stringBuilder.append("'8.2.23' AS SERVER_VERSION FROM DUAL");
        } else if (this.readIf("SERVER_ENCODING")) {
            stringBuilder.append("'UTF8' AS SERVER_ENCODING FROM DUAL");
        } else if (this.readIf("TABLES")) {
            string = this.database.getMainSchema().getName();
            if (this.readIf(22)) {
                string = this.readUniqueIdentifier();
            }
            stringBuilder.append("TABLE_NAME, TABLE_SCHEMA FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA=? ORDER BY TABLE_NAME");
            arrayList.add(ValueString.get(string));
        } else if (this.readIf("COLUMNS")) {
            this.read(22);
            string = this.readIdentifierWithSchema();
            object = this.getSchema().getName();
            arrayList.add(ValueString.get(string));
            if (this.readIf(22)) {
                object = this.readUniqueIdentifier();
            }
            stringBuilder.append("C.COLUMN_NAME FIELD, C.TYPE_NAME || '(' || C.NUMERIC_PRECISION || ')' TYPE, C.IS_NULLABLE \"NULL\", CASE (SELECT MAX(I.INDEX_TYPE_NAME) FROM INFORMATION_SCHEMA.INDEXES I WHERE I.TABLE_SCHEMA=C.TABLE_SCHEMA AND I.TABLE_NAME=C.TABLE_NAME AND I.COLUMN_NAME=C.COLUMN_NAME)WHEN 'PRIMARY KEY' THEN 'PRI' WHEN 'UNIQUE INDEX' THEN 'UNI' ELSE '' END KEY, IFNULL(COLUMN_DEFAULT, 'NULL') DEFAULT FROM INFORMATION_SCHEMA.COLUMNS C WHERE C.TABLE_NAME=? AND C.TABLE_SCHEMA=? ORDER BY C.ORDINAL_POSITION");
            arrayList.add(ValueString.get((String)object));
        } else if (this.readIf("DATABASES") || this.readIf("SCHEMAS")) {
            stringBuilder.append("SCHEMA_NAME FROM INFORMATION_SCHEMA.SCHEMATA");
        }
        boolean bl = this.session.getAllowLiterals();
        try {
            this.session.setAllowLiterals(true);
            object = Parser.prepare(this.session, stringBuilder.toString(), arrayList);
            return object;
        }
        finally {
            this.session.setAllowLiterals(bl);
        }
    }

    private static Prepared prepare(Session session, String string, ArrayList<Value> arrayList) {
        Prepared prepared = session.prepare(string);
        ArrayList<Parameter> arrayList2 = prepared.getParameters();
        if (arrayList2 != null) {
            int n = arrayList2.size();
            for (int i = 0; i < n; ++i) {
                Parameter parameter = arrayList2.get(i);
                parameter.setValue(arrayList.get(i));
            }
        }
        return prepared;
    }

    private boolean isQuery() {
        boolean bl;
        int n = this.lastParseIndex;
        while (this.readIf(75)) {
        }
        switch (this.currentTokenType) {
            case 51: 
            case 58: 
            case 61: {
                bl = true;
                break;
            }
            case 52: {
                this.read();
                bl = !this.readIf(75);
                break;
            }
            default: {
                bl = false;
            }
        }
        this.parseIndex = n;
        this.read();
        return bl;
    }

    private Prepared parseMerge() {
        Column[] columnArray;
        int n = this.lastParseIndex;
        this.read("INTO");
        List<String> list = Collections.singletonList("KEY");
        TableFilter tableFilter = this.readSimpleTableFilter(0, list);
        if (this.readIf(57)) {
            return this.parseMergeUsing(tableFilter, n);
        }
        Merge merge = new Merge(this.session, false);
        this.currentPrepared = merge;
        merge.setTable(tableFilter.getTable());
        Table table = merge.getTable();
        if (this.readIf(75)) {
            if (this.isQuery()) {
                merge.setQuery(this.parseQuery());
                this.read(76);
                return merge;
            }
            columnArray = this.parseColumnList(table);
            merge.setColumns(columnArray);
        }
        if (this.readIf("KEY")) {
            this.read(75);
            columnArray = this.parseColumnList(table);
            merge.setKeys(columnArray);
        }
        if (this.readIf(58)) {
            this.parseValuesForCommand(merge);
        } else {
            merge.setQuery(this.parseQuery());
        }
        return merge;
    }

    private MergeUsing parseMergeUsing(TableFilter tableFilter, int n) {
        Object object;
        String[] stringArray;
        Object object2;
        MergeUsing mergeUsing = new MergeUsing(this.session, tableFilter);
        this.currentPrepared = mergeUsing;
        if (this.isQuery()) {
            mergeUsing.setQuery(this.parseQuery());
            object2 = this.readFromAlias(null);
            if (object2 == null) {
                object2 = "QUERY_ALIAS_" + this.parseIndex;
            }
            mergeUsing.setQueryAlias((String)object2);
            stringArray = new String[]{null};
            object = TableView.createQueryColumnTemplateList(null, mergeUsing.getQuery(), stringArray);
            TableView tableView = this.createCTEView((String)object2, stringArray[0], (List<Column>)object, false, false, true);
            TableFilter tableFilter2 = new TableFilter(this.session, tableView, (String)object2, this.rightsChecked, null, 0, null);
            mergeUsing.setSourceTableFilter(tableFilter2);
        } else {
            object2 = this.readTableFilter();
            mergeUsing.setSourceTableFilter((TableFilter)object2);
            stringArray = new Select(this.session, null);
            stringArray.setWildcard();
            object = new TableFilter(this.session, ((TableFilter)object2).getTable(), ((TableFilter)object2).getTableAlias(), this.rightsChecked, (Select)stringArray, 0, null);
            stringArray.addTableFilter((TableFilter)object, true);
            stringArray.init();
            mergeUsing.setQuery((Query)stringArray);
        }
        this.read(43);
        object2 = this.readExpression();
        mergeUsing.setOnCondition((Expression)object2);
        this.read("WHEN");
        do {
            boolean bl;
            if (bl = this.readIf("MATCHED")) {
                this.parseWhenMatched(mergeUsing);
                continue;
            }
            this.parseWhenNotMatched(mergeUsing);
        } while (this.readIf("WHEN"));
        this.setSQL(mergeUsing, "MERGE", n);
        return mergeUsing;
    }

    private void parseWhenMatched(MergeUsing mergeUsing) {
        Object object;
        Expression expression = this.readIf("AND") ? this.readExpression() : null;
        this.read("THEN");
        int n = this.lastParseIndex;
        Update update = null;
        if (this.readIf("UPDATE")) {
            update = new Update(this.session);
            object = mergeUsing.getTargetTableFilter();
            update.setTableFilter((TableFilter)object);
            this.parseUpdateSetClause(update, (TableFilter)object, n, false);
            n = this.lastParseIndex;
        }
        object = null;
        if (this.readIf("DELETE")) {
            object = new Delete(this.session);
            ((Delete)object).setTableFilter(mergeUsing.getTargetTableFilter());
            if (this.readIf(59)) {
                ((Delete)object).setCondition(this.readExpression());
            }
            this.setSQL((Prepared)object, "DELETE", n);
        }
        if (update == null && object == null) {
            throw this.getSyntaxError();
        }
        MergeUsing.WhenMatched whenMatched = new MergeUsing.WhenMatched(mergeUsing);
        whenMatched.setAndCondition(expression);
        whenMatched.setUpdateCommand(update);
        whenMatched.setDeleteCommand((Delete)object);
        mergeUsing.addWhen(whenMatched);
    }

    private void parseWhenNotMatched(MergeUsing mergeUsing) {
        this.read(40);
        this.read("MATCHED");
        Expression expression = this.readIf("AND") ? this.readExpression() : null;
        this.read("THEN");
        if (!this.readIf("INSERT")) {
            throw this.getSyntaxError();
        }
        Insert insert = new Insert(this.session);
        insert.setTable(mergeUsing.getTargetTable());
        this.parseInsertGivenTable(insert, mergeUsing.getTargetTable());
        MergeUsing.WhenNotMatched whenNotMatched = new MergeUsing.WhenNotMatched(mergeUsing);
        whenNotMatched.setAndCondition(expression);
        whenNotMatched.setInsertCommand(insert);
        mergeUsing.addWhen(whenNotMatched);
    }

    private Insert parseInsert() {
        Insert insert = new Insert(this.session);
        this.currentPrepared = insert;
        Mode mode = this.database.getMode();
        if (mode.onDuplicateKeyUpdate && this.readIf("IGNORE")) {
            insert.setIgnore(true);
        }
        this.read("INTO");
        Table table = this.readTableOrView();
        insert.setTable(table);
        Insert insert2 = this.parseInsertGivenTable(insert, table);
        if (insert2 != null) {
            return insert2;
        }
        if (mode.onDuplicateKeyUpdate && this.readIf(43)) {
            this.read("DUPLICATE");
            this.read("KEY");
            this.read("UPDATE");
            do {
                Object object;
                String string = this.readColumnIdentifier();
                if (this.readIf(80)) {
                    object = string;
                    Object object2 = this.readColumnIdentifier();
                    if (this.readIf(80)) {
                        if (!table.getSchema().getName().equals(object)) {
                            throw DbException.get(90080);
                        }
                        string = this.readColumnIdentifier();
                    } else {
                        string = object2;
                        object2 = object;
                    }
                    if (!table.getName().equals(object2)) {
                        throw DbException.get(42102, (String)object2);
                    }
                }
                object = table.getColumn(string);
                this.read(65);
                insert.addAssignmentForDuplicate((Column)object, this.readExpressionOrDefault());
            } while (this.readIf(79));
        }
        if (mode.insertOnConflict && this.readIf(43)) {
            this.read("CONFLICT");
            this.read("DO");
            this.read("NOTHING");
            insert.setIgnore(true);
        }
        if (mode.isolationLevelInSelectOrInsertStatement) {
            this.parseIsolationClause();
        }
        return insert;
    }

    private Insert parseInsertGivenTable(Insert insert, Table table) {
        Column[] columnArray = null;
        if (this.readIf(75)) {
            if (this.isQuery()) {
                insert.setQuery(this.parseQuery());
                this.read(76);
                return insert;
            }
            columnArray = this.parseColumnList(table);
            insert.setColumns(columnArray);
        }
        if (this.readIf("DIRECT")) {
            insert.setInsertFromSelect(true);
        }
        if (this.readIf("SORTED")) {
            insert.setSortedInsertMode(true);
        }
        if (this.readIf("DEFAULT")) {
            this.read(58);
            insert.addRow(new Expression[0]);
        } else if (this.readIf(58)) {
            this.parseValuesForCommand(insert);
        } else if (this.readIf("SET")) {
            if (columnArray != null) {
                throw this.getSyntaxError();
            }
            ArrayList<Column> arrayList = Utils.newSmallArrayList();
            ArrayList<Expression> arrayList2 = Utils.newSmallArrayList();
            do {
                arrayList.add(this.parseColumn(table));
                this.read(65);
                arrayList2.add(this.readExpressionOrDefault());
            } while (this.readIf(79));
            insert.setColumns(arrayList.toArray(new Column[0]));
            insert.addRow(arrayList2.toArray(new Expression[0]));
        } else {
            insert.setQuery(this.parseQuery());
        }
        return null;
    }

    private Merge parseReplace() {
        Merge merge = new Merge(this.session, true);
        this.currentPrepared = merge;
        this.read("INTO");
        Table table = this.readTableOrView();
        merge.setTable(table);
        if (this.readIf(75)) {
            if (this.isQuery()) {
                merge.setQuery(this.parseQuery());
                this.read(76);
                return merge;
            }
            Column[] columnArray = this.parseColumnList(table);
            merge.setColumns(columnArray);
        }
        if (this.readIf(58)) {
            this.parseValuesForCommand(merge);
        } else {
            merge.setQuery(this.parseQuery());
        }
        return merge;
    }

    private void parseValuesForCommand(CommandWithValues commandWithValues) {
        ArrayList<Expression> arrayList = Utils.newSmallArrayList();
        do {
            boolean bl;
            arrayList.clear();
            if (this.readIf(48)) {
                this.read(75);
                bl = true;
            } else {
                bl = this.readIf(75);
            }
            if (bl) {
                if (!this.readIf(76)) {
                    do {
                        arrayList.add(this.readIf("DEFAULT") ? null : this.readExpression());
                    } while (this.readIfMore());
                }
            } else {
                arrayList.add(this.readIf("DEFAULT") ? null : this.readExpression());
            }
            commandWithValues.addRow(arrayList.toArray(new Expression[0]));
        } while (this.readIf(79));
    }

    /*
     * Enabled aggressive block sorting
     */
    private TableFilter readTableFilter() {
        Object object;
        Table table;
        String string;
        block20: {
            block28: {
                Schema schema;
                block27: {
                    block26: {
                        block25: {
                            int n;
                            boolean bl;
                            block24: {
                                block23: {
                                    block22: {
                                        string = null;
                                        if (this.readIf(75)) {
                                            if (this.isQuery()) {
                                                Query query = this.parseSelectUnion();
                                                this.read(76);
                                                string = this.session.getNextSystemIdentifier(this.sqlCommand);
                                                table = query.toTable(string, this.parameters, this.createView != null, this.currentSelect);
                                                break block20;
                                            } else {
                                                TableFilter tableFilter = this.readTableFilter();
                                                tableFilter = this.readJoin(tableFilter);
                                                this.read(76);
                                                string = this.readFromAlias(null);
                                                if (string != null) {
                                                    tableFilter.setAlias(string);
                                                    ArrayList<String> arrayList = this.readDerivedColumnNames();
                                                    if (arrayList != null) {
                                                        tableFilter.setDerivedColumns(arrayList);
                                                    }
                                                }
                                                return tableFilter;
                                            }
                                        }
                                        if (!this.readIf(58)) break block22;
                                        TableValueConstructor tableValueConstructor = this.parseValues();
                                        string = this.session.getNextSystemIdentifier(this.sqlCommand);
                                        table = tableValueConstructor.toTable(string, this.parameters, this.createView != null, this.currentSelect);
                                        break block20;
                                    }
                                    if (!this.readIf(52)) break block23;
                                    this.read(75);
                                    Function function = this.readFunctionParameters(Function.getFunction(this.database, 223));
                                    table = new FunctionTable(this.database.getMainSchema(), this.session, function, function);
                                    break block20;
                                }
                                bl = this.currentTokenQuoted;
                                object = this.readColumnIdentifier();
                                n = this.parseIndex;
                                this.schemaName = null;
                                if (!this.readIf(80)) break block24;
                                object = this.readIdentifierWithSchema2((String)object);
                                break block25;
                            }
                            if (bl || !this.readIf(52)) break block25;
                            table = this.readDataChangeDeltaTable((String)object, n);
                            break block20;
                        }
                        if (this.schemaName != null) break block26;
                        schema = null;
                        break block27;
                    }
                    schema = this.findSchema(this.schemaName);
                    if (schema != null) break block27;
                    if (!this.isDualTable((String)object)) {
                        throw DbException.get(90079, this.schemaName);
                    }
                    table = new DualTable(this.database);
                    break block20;
                }
                boolean bl = this.readIf(75);
                if (bl && this.readIf("INDEX")) {
                    this.readIdentifierWithSchema(null);
                    this.read(76);
                    bl = false;
                }
                if (!bl) break block28;
                Schema schema2 = this.database.getMainSchema();
                if (this.equalsToken((String)object, "SYSTEM_RANGE") || this.equalsToken((String)object, "GENERATE_SERIES")) {
                    Expression expression = this.readExpression();
                    this.read(79);
                    Expression expression2 = this.readExpression();
                    if (this.readIf(79)) {
                        Expression expression3 = this.readExpression();
                        this.read(76);
                        table = new RangeTable(schema2, expression, expression2, expression3);
                        break block20;
                    } else {
                        this.read(76);
                        table = new RangeTable(schema2, expression, expression2);
                    }
                    break block20;
                } else {
                    table = this.readTableFunction((String)object, schema, schema2);
                }
                break block20;
            }
            table = this.readTableOrView((String)object);
        }
        ArrayList<String> arrayList = null;
        object = null;
        if (this.readIf("USE")) {
            if (this.readIf("INDEX")) {
                object = this.parseIndexHints(table);
            } else {
                string = "USE";
                arrayList = this.readDerivedColumnNames();
            }
        } else if ((string = this.readFromAlias(string)) != null) {
            arrayList = this.readDerivedColumnNames();
            if (this.readIf("USE")) {
                this.read("INDEX");
                object = this.parseIndexHints(table);
            }
        }
        if (this.database.getMode().discardWithTableHints) {
            this.discardWithTableHints();
        }
        if (table.isView() && table.isTableExpression() && string == null) {
            string = table.getName();
        }
        TableFilter tableFilter = new TableFilter(this.session, table, string, this.rightsChecked, this.currentSelect, this.orderInFrom++, (IndexHints)object);
        if (arrayList != null) {
            tableFilter.setDerivedColumns(arrayList);
        }
        return tableFilter;
    }

    private Table readDataChangeDeltaTable(String string, int n) {
        DataChangeStatement dataChangeStatement;
        this.read(75);
        if (!this.identifiersToUpper) {
            string = StringUtils.toUpperEnglish(string);
        }
        DataChangeDeltaTable.ResultOption resultOption = DataChangeDeltaTable.ResultOption.FINAL;
        switch (string) {
            case "OLD": {
                resultOption = DataChangeDeltaTable.ResultOption.OLD;
                if (this.readIf("UPDATE")) {
                    dataChangeStatement = this.parseUpdate();
                    break;
                }
                if (this.readIf("DELETE")) {
                    dataChangeStatement = this.parseDelete();
                    break;
                }
                if (this.readIf("MERGE")) {
                    dataChangeStatement = (DataChangeStatement)((Object)this.parseMerge());
                    break;
                }
                if (this.database.getMode().replaceInto && this.readIf("REPLACE")) {
                    dataChangeStatement = this.parseReplace();
                    break;
                }
                throw this.getSyntaxError();
            }
            case "NEW": {
                resultOption = DataChangeDeltaTable.ResultOption.NEW;
            }
            case "FINAL": {
                if (this.readIf("INSERT")) {
                    dataChangeStatement = this.parseInsert();
                    break;
                }
                if (this.readIf("UPDATE")) {
                    dataChangeStatement = this.parseUpdate();
                    break;
                }
                if (this.readIf("MERGE")) {
                    dataChangeStatement = (DataChangeStatement)((Object)this.parseMerge());
                    break;
                }
                if (this.database.getMode().replaceInto && this.readIf("REPLACE")) {
                    dataChangeStatement = this.parseReplace();
                    break;
                }
                throw this.getSyntaxError();
            }
            default: {
                this.parseIndex = n;
                this.addExpected("OLD TABLE");
                this.addExpected("NEW TABLE");
                this.addExpected("FINAL TABLE");
                throw this.getSyntaxError();
            }
        }
        this.read(76);
        if (resultOption == DataChangeDeltaTable.ResultOption.FINAL && dataChangeStatement.getTable().hasInsteadOfTrigger()) {
            throw DbException.getUnsupportedException("FINAL TABLE with INSTEAD OF trigger");
        }
        if (dataChangeStatement instanceof MergeUsing && ((MergeUsing)dataChangeStatement).hasCombinedMatchedClause()) {
            throw DbException.getUnsupportedException((Object)((Object)resultOption) + " TABLE with Oracle-style MERGE WHEN MATCHED THEN (UPDATE + DELETE)");
        }
        return new DataChangeDeltaTable(this.getSchemaWithDefault(), this.session, dataChangeStatement, resultOption);
    }

    private Table readTableFunction(String string, Schema schema, Schema schema2) {
        Expression expression = this.readFunction(schema, string);
        if (!(expression instanceof FunctionCall)) {
            throw this.getSyntaxError();
        }
        FunctionCall functionCall = (FunctionCall)((Object)expression);
        if (!functionCall.isDeterministic()) {
            this.recompileAlways = true;
        }
        return new FunctionTable(schema2, this.session, expression, functionCall);
    }

    private IndexHints parseIndexHints(Table table) {
        this.read(75);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        if (!this.readIf(76)) {
            do {
                String string = this.readIdentifierWithSchema();
                Index index = table.getIndex(string);
                linkedHashSet.add(index.getName());
            } while (this.readIfMore());
        }
        return IndexHints.createUseIndexHints(linkedHashSet);
    }

    private String readFromAlias(String string) {
        if (this.readIf("AS") || this.currentTokenType == 2) {
            string = this.readAliasIdentifier();
        }
        return string;
    }

    private ArrayList<String> readDerivedColumnNames() {
        if (this.readIf(75)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            do {
                arrayList.add(this.readAliasIdentifier());
            } while (this.readIfMore());
            return arrayList;
        }
        return null;
    }

    private void discardWithTableHints() {
        if (this.readIf(61)) {
            this.read(75);
            do {
                this.discardTableHint();
            } while (this.readIfMore());
        }
    }

    private void discardTableHint() {
        if (this.readIf("INDEX")) {
            if (this.readIf(75)) {
                do {
                    this.readExpression();
                } while (this.readIfMore());
            } else {
                this.read(65);
                this.readExpression();
            }
        } else {
            this.readExpression();
        }
    }

    private Prepared parseTruncate() {
        this.read(52);
        Table table = this.readTableOrView();
        boolean bl = this.database.getMode().truncateTableRestartIdentity;
        if (this.readIf("CONTINUE")) {
            this.read("IDENTITY");
            bl = false;
        } else if (this.readIf("RESTART")) {
            this.read("IDENTITY");
            bl = true;
        }
        TruncateTable truncateTable = new TruncateTable(this.session);
        truncateTable.setTable(table);
        truncateTable.setRestart(bl);
        return truncateTable;
    }

    private boolean readIfExists(boolean bl) {
        if (this.readIf(26)) {
            this.read(17);
            bl = true;
        }
        return bl;
    }

    private Prepared parseComment() {
        String string;
        int n = 0;
        this.read(43);
        boolean bl = false;
        if (this.readIf(52) || this.readIf("VIEW")) {
            n = 0;
        } else if (this.readIf("COLUMN")) {
            bl = true;
            n = 0;
        } else if (this.readIf("CONSTANT")) {
            n = 11;
        } else if (this.readIf(7)) {
            n = 5;
        } else if (this.readIf("ALIAS")) {
            n = 9;
        } else if (this.readIf("INDEX")) {
            n = 1;
        } else if (this.readIf("ROLE")) {
            n = 7;
        } else if (this.readIf("SCHEMA")) {
            n = 10;
        } else if (this.readIf("SEQUENCE")) {
            n = 3;
        } else if (this.readIf("TRIGGER")) {
            n = 4;
        } else if (this.readIf("USER")) {
            n = 2;
        } else if (this.readIf("DOMAIN")) {
            n = 12;
        } else {
            throw this.getSyntaxError();
        }
        SetComment setComment = new SetComment(this.session);
        if (bl) {
            String string2;
            string = this.readColumnIdentifier();
            String string3 = null;
            this.read(80);
            boolean bl2 = this.database.getMode().allowEmptySchemaValuesAsDefaultSchema;
            String string4 = string2 = bl2 && this.currentTokenType == 80 ? null : this.readColumnIdentifier();
            if (this.readIf(80)) {
                string3 = string;
                string = string2;
                String string5 = string2 = bl2 && this.currentTokenType == 80 ? null : this.readColumnIdentifier();
                if (this.readIf(80)) {
                    this.checkDatabaseName(string3);
                    string3 = string;
                    string = string2;
                    string2 = this.readColumnIdentifier();
                }
            }
            if (string2 == null || string == null) {
                throw DbException.getSyntaxError(this.sqlCommand, this.lastParseIndex, "table.column");
            }
            this.schemaName = string3 != null ? string3 : this.session.getCurrentSchemaName();
            setComment.setColumn(true);
            setComment.setColumnName(string2);
        } else {
            string = this.readIdentifierWithSchema();
        }
        setComment.setSchemaName(this.schemaName);
        setComment.setObjectName(string);
        setComment.setObjectType(n);
        this.read(31);
        setComment.setCommentExpression(this.readExpression());
        return setComment;
    }

    private Prepared parseDrop() {
        if (this.readIf(52)) {
            boolean bl = this.readIfExists(false);
            DropTable dropTable = new DropTable(this.session);
            do {
                String string = this.readIdentifierWithSchema();
                dropTable.addTable(this.getSchema(), string);
            } while (this.readIf(79));
            bl = this.readIfExists(bl);
            dropTable.setIfExists(bl);
            if (this.readIf("CASCADE")) {
                dropTable.setDropAction(ConstraintActionType.CASCADE);
                this.readIf("CONSTRAINTS");
            } else if (this.readIf("RESTRICT")) {
                dropTable.setDropAction(ConstraintActionType.RESTRICT);
            } else if (this.readIf("IGNORE")) {
                dropTable.setDropAction(ConstraintActionType.SET_DEFAULT);
            }
            return dropTable;
        }
        if (this.readIf("INDEX")) {
            boolean bl = this.readIfExists(false);
            String string = this.readIdentifierWithSchema();
            DropIndex dropIndex = new DropIndex(this.session, this.getSchema());
            dropIndex.setIndexName(string);
            bl = this.readIfExists(bl);
            dropIndex.setIfExists(bl);
            if (this.readIf(43)) {
                this.readIdentifierWithSchema();
            }
            return dropIndex;
        }
        if (this.readIf("USER")) {
            boolean bl = this.readIfExists(false);
            DropUser dropUser = new DropUser(this.session);
            dropUser.setUserName(this.readUniqueIdentifier());
            bl = this.readIfExists(bl);
            this.readIf("CASCADE");
            dropUser.setIfExists(bl);
            return dropUser;
        }
        if (this.readIf("SEQUENCE")) {
            boolean bl = this.readIfExists(false);
            String string = this.readIdentifierWithSchema();
            DropSequence dropSequence = new DropSequence(this.session, this.getSchema());
            dropSequence.setSequenceName(string);
            bl = this.readIfExists(bl);
            dropSequence.setIfExists(bl);
            return dropSequence;
        }
        if (this.readIf("CONSTANT")) {
            boolean bl = this.readIfExists(false);
            String string = this.readIdentifierWithSchema();
            DropConstant dropConstant = new DropConstant(this.session, this.getSchema());
            dropConstant.setConstantName(string);
            bl = this.readIfExists(bl);
            dropConstant.setIfExists(bl);
            return dropConstant;
        }
        if (this.readIf("TRIGGER")) {
            boolean bl = this.readIfExists(false);
            String string = this.readIdentifierWithSchema();
            DropTrigger dropTrigger = new DropTrigger(this.session, this.getSchema());
            dropTrigger.setTriggerName(string);
            bl = this.readIfExists(bl);
            dropTrigger.setIfExists(bl);
            return dropTrigger;
        }
        if (this.readIf("VIEW")) {
            boolean bl = this.readIfExists(false);
            String string = this.readIdentifierWithSchema();
            DropView dropView = new DropView(this.session, this.getSchema());
            dropView.setViewName(string);
            bl = this.readIfExists(bl);
            dropView.setIfExists(bl);
            ConstraintActionType constraintActionType = this.parseCascadeOrRestrict();
            if (constraintActionType != null) {
                dropView.setDropAction(constraintActionType);
            }
            return dropView;
        }
        if (this.readIf("ROLE")) {
            boolean bl = this.readIfExists(false);
            DropRole dropRole = new DropRole(this.session);
            dropRole.setRoleName(this.readUniqueIdentifier());
            bl = this.readIfExists(bl);
            dropRole.setIfExists(bl);
            return dropRole;
        }
        if (this.readIf("ALIAS")) {
            boolean bl = this.readIfExists(false);
            String string = this.readIdentifierWithSchema();
            DropFunctionAlias dropFunctionAlias = new DropFunctionAlias(this.session, this.getSchema());
            dropFunctionAlias.setAliasName(string);
            bl = this.readIfExists(bl);
            dropFunctionAlias.setIfExists(bl);
            return dropFunctionAlias;
        }
        if (this.readIf("SCHEMA")) {
            boolean bl = this.readIfExists(false);
            DropSchema dropSchema = new DropSchema(this.session);
            dropSchema.setSchemaName(this.readUniqueIdentifier());
            bl = this.readIfExists(bl);
            dropSchema.setIfExists(bl);
            ConstraintActionType constraintActionType = this.parseCascadeOrRestrict();
            if (constraintActionType != null) {
                dropSchema.setDropAction(constraintActionType);
            }
            return dropSchema;
        }
        if (this.readIf(3)) {
            this.read("OBJECTS");
            DropDatabase dropDatabase = new DropDatabase(this.session);
            dropDatabase.setDropAllObjects(true);
            if (this.readIf("DELETE")) {
                this.read("FILES");
                dropDatabase.setDeleteFiles(true);
            }
            return dropDatabase;
        }
        if (this.readIf("DOMAIN") || this.readIf("TYPE") || this.readIf("DATATYPE")) {
            return this.parseDropDomain();
        }
        if (this.readIf("AGGREGATE")) {
            return this.parseDropAggregate();
        }
        if (this.readIf("SYNONYM")) {
            boolean bl = this.readIfExists(false);
            String string = this.readIdentifierWithSchema();
            DropSynonym dropSynonym = new DropSynonym(this.session, this.getSchema());
            dropSynonym.setSynonymName(string);
            bl = this.readIfExists(bl);
            dropSynonym.setIfExists(bl);
            return dropSynonym;
        }
        throw this.getSyntaxError();
    }

    private DropDomain parseDropDomain() {
        boolean bl = this.readIfExists(false);
        DropDomain dropDomain = new DropDomain(this.session);
        dropDomain.setTypeName(this.readUniqueIdentifier());
        bl = this.readIfExists(bl);
        dropDomain.setIfExists(bl);
        ConstraintActionType constraintActionType = this.parseCascadeOrRestrict();
        if (constraintActionType != null) {
            dropDomain.setDropAction(constraintActionType);
        }
        return dropDomain;
    }

    private DropAggregate parseDropAggregate() {
        boolean bl = this.readIfExists(false);
        DropAggregate dropAggregate = new DropAggregate(this.session);
        dropAggregate.setName(this.readUniqueIdentifier());
        bl = this.readIfExists(bl);
        dropAggregate.setIfExists(bl);
        return dropAggregate;
    }

    private TableFilter readJoin(TableFilter tableFilter) {
        TableFilter tableFilter2 = tableFilter;
        while (true) {
            TableFilter tableFilter3;
            switch (this.currentTokenType) {
                case 47: {
                    this.read();
                    this.readIf("OUTER");
                    this.read(32);
                    tableFilter3 = this.readTableFilter();
                    tableFilter3 = this.readJoin(tableFilter3);
                    Expression expression = this.readJoinSpecification(tableFilter, tableFilter3, true);
                    this.addJoin(tableFilter3, tableFilter, true, expression);
                    tableFilter = tableFilter3;
                    break;
                }
                case 33: {
                    this.read();
                    this.readIf("OUTER");
                    this.read(32);
                    tableFilter3 = this.readTableFilter();
                    tableFilter3 = this.readJoin(tableFilter3);
                    Expression expression = this.readJoinSpecification(tableFilter, tableFilter3, false);
                    this.addJoin(tableFilter, tableFilter3, true, expression);
                    break;
                }
                case 23: {
                    this.read();
                    throw this.getSyntaxError();
                }
                case 27: {
                    this.read();
                    this.read(32);
                    tableFilter3 = this.readTableFilter();
                    tableFilter = this.readJoin(tableFilter);
                    Expression expression = this.readJoinSpecification(tableFilter, tableFilter3, false);
                    this.addJoin(tableFilter, tableFilter3, false, expression);
                    break;
                }
                case 32: {
                    this.read();
                    tableFilter3 = this.readTableFilter();
                    tableFilter = this.readJoin(tableFilter);
                    Expression expression = this.readJoinSpecification(tableFilter, tableFilter3, false);
                    this.addJoin(tableFilter, tableFilter3, false, expression);
                    break;
                }
                case 8: {
                    this.read();
                    this.read(32);
                    tableFilter3 = this.readTableFilter();
                    this.addJoin(tableFilter, tableFilter3, false, null);
                    break;
                }
                case 39: {
                    this.read();
                    this.read(32);
                    tableFilter3 = this.readTableFilter();
                    Expression expression = null;
                    for (Column column : tableFilter2.getTable().getColumns()) {
                        Column column2 = tableFilter3.getColumn(tableFilter2.getColumnName(column), true);
                        if (column2 == null) continue;
                        expression = this.addJoinColumn(expression, tableFilter2, tableFilter3, column, column2, false);
                    }
                    this.addJoin(tableFilter, tableFilter3, false, expression);
                    break;
                }
                default: {
                    if (this.expectedList != null) {
                        this.addMultipleExpected(47, 33, 27, 32, 8, 39);
                    }
                    return tableFilter;
                }
            }
            tableFilter2 = tableFilter3;
        }
    }

    private Expression readJoinSpecification(TableFilter tableFilter, TableFilter tableFilter2, boolean bl) {
        Expression expression = null;
        if (this.readIf(43)) {
            expression = this.readExpression();
        } else if (this.readIf(57)) {
            this.read(75);
            do {
                String string = this.readColumnIdentifier();
                expression = this.addJoinColumn(expression, tableFilter, tableFilter2, tableFilter.getColumn(string, false), tableFilter2.getColumn(string, false), bl);
            } while (this.readIfMore());
        }
        return expression;
    }

    private Expression addJoinColumn(Expression expression, TableFilter tableFilter, TableFilter tableFilter2, Column column, Column column2, boolean bl) {
        if (bl) {
            tableFilter.addCommonJoinColumns(column, column2, tableFilter2);
            tableFilter2.addCommonJoinColumnToExclude(column2);
        } else {
            tableFilter.addCommonJoinColumns(column, column, tableFilter);
            tableFilter2.addCommonJoinColumnToExclude(column2);
        }
        ExpressionColumn expressionColumn = new ExpressionColumn(this.database, tableFilter.getSchemaName(), tableFilter.getTableAlias(), tableFilter.getColumnName(column), false);
        ExpressionColumn expressionColumn2 = new ExpressionColumn(this.database, tableFilter2.getSchemaName(), tableFilter2.getTableAlias(), tableFilter2.getColumnName(column2), false);
        Comparison comparison = new Comparison(this.session, 0, expressionColumn, expressionColumn2);
        expression = expression == null ? comparison : new ConditionAndOr(0, expression, comparison);
        return expression;
    }

    private void addJoin(TableFilter tableFilter, TableFilter tableFilter2, boolean bl, Expression expression) {
        if (tableFilter2.getJoin() != null) {
            String string = "SYSTEM_JOIN_" + this.parseIndex;
            TableFilter tableFilter3 = new TableFilter(this.session, new DualTable(this.database), string, this.rightsChecked, this.currentSelect, tableFilter2.getOrderInFrom(), null);
            tableFilter3.setNestedJoin(tableFilter2);
            tableFilter2 = tableFilter3;
        }
        tableFilter.addJoin(tableFilter2, bl, expression);
    }

    private Prepared parseExecutePostgre() {
        if (this.readIf("IMMEDIATE")) {
            return new ExecuteImmediate(this.session, this.readExpression());
        }
        ExecuteProcedure executeProcedure = new ExecuteProcedure(this.session);
        String string = this.readAliasIdentifier();
        Procedure procedure = this.session.getProcedure(string);
        if (procedure == null) {
            throw DbException.get(90077, string);
        }
        executeProcedure.setProcedure(procedure);
        if (this.readIf(75)) {
            int n = 0;
            while (true) {
                executeProcedure.setExpression(n, this.readExpression());
                if (!this.readIfMore()) break;
                ++n;
            }
        }
        return executeProcedure;
    }

    private Prepared parseExecuteSQLServer() {
        FunctionAlias functionAlias;
        Expression[] expressionArray;
        Call call = new Call(this.session);
        this.currentPrepared = call;
        String string = null;
        String string2 = this.readColumnIdentifier();
        if (this.readIf(80)) {
            string = string2;
            string2 = this.readColumnIdentifier();
            if (this.readIf(80)) {
                this.checkDatabaseName(string);
                string = string2;
                string2 = this.readColumnIdentifier();
            }
        }
        if (string != null) {
            expressionArray = this.database.getSchema(string);
            functionAlias = expressionArray.findFunction(string2);
        } else {
            functionAlias = this.findFunctionAlias(this.session.getCurrentSchemaName(), string2);
        }
        if (functionAlias == null) {
            throw DbException.get(90022, string2);
        }
        ArrayList<Expression> arrayList = Utils.newSmallArrayList();
        if (this.currentTokenType != 85 && this.currentTokenType != 63) {
            do {
                arrayList.add(this.readExpression());
            } while (this.readIf(79));
        }
        expressionArray = arrayList.toArray(new Expression[0]);
        call.setExpression(new JavaFunction(functionAlias, expressionArray));
        return call;
    }

    private DeallocateProcedure parseDeallocate() {
        this.readIf("PLAN");
        String string = this.readAliasIdentifier();
        DeallocateProcedure deallocateProcedure = new DeallocateProcedure(this.session);
        deallocateProcedure.setProcedureName(string);
        return deallocateProcedure;
    }

    private Explain parseExplain() {
        Explain explain = new Explain(this.session);
        if (this.readIf("ANALYZE")) {
            explain.setExecuteCommand(true);
        } else if (this.readIf("PLAN")) {
            this.readIf(20);
        }
        switch (this.currentTokenType) {
            case 51: 
            case 52: 
            case 58: 
            case 61: 
            case 75: {
                Query query = this.parseQuery();
                query.setNeverLazy(true);
                explain.setCommand(query);
                break;
            }
            default: {
                if (this.readIf("DELETE")) {
                    explain.setCommand(this.parseDelete());
                    break;
                }
                if (this.readIf("UPDATE")) {
                    explain.setCommand(this.parseUpdate());
                    break;
                }
                if (this.readIf("INSERT")) {
                    explain.setCommand(this.parseInsert());
                    break;
                }
                if (this.readIf("MERGE")) {
                    explain.setCommand(this.parseMerge());
                    break;
                }
                throw this.getSyntaxError();
            }
        }
        return explain;
    }

    private Query parseQuery() {
        int n = this.parameters.size();
        Query query = this.parseSelectUnion();
        int n2 = this.parameters.size();
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>(n2);
        for (int i = n; i < n2; ++i) {
            arrayList.add(this.parameters.get(i));
        }
        query.setParameterList(arrayList);
        query.init();
        return query;
    }

    private Prepared parseWithStatementOrQuery() {
        int n = this.parameters.size();
        Prepared prepared = this.parseWith();
        int n2 = this.parameters.size();
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>(n2);
        for (int i = n; i < n2; ++i) {
            arrayList.add(this.parameters.get(i));
        }
        prepared.setParameterList(arrayList);
        if (prepared instanceof Query) {
            Query query = (Query)prepared;
            query.init();
        }
        return prepared;
    }

    private Query parseSelectUnion() {
        int n = this.lastParseIndex;
        Query query = this.parseQuerySub();
        while (true) {
            SelectUnion.UnionType unionType;
            if (this.readIf(54)) {
                if (this.readIf(3)) {
                    unionType = SelectUnion.UnionType.UNION_ALL;
                } else {
                    this.readIf(15);
                    unionType = SelectUnion.UnionType.UNION;
                }
            } else if (this.readIf(16) || this.readIf(38)) {
                unionType = SelectUnion.UnionType.EXCEPT;
            } else {
                if (!this.readIf(28)) break;
                unionType = SelectUnion.UnionType.INTERSECT;
            }
            query = new SelectUnion(this.session, unionType, query, this.parseQuerySub());
        }
        this.parseEndOfQuery(query);
        this.setSQL(query, null, n);
        return query;
    }

    private void parseEndOfQuery(Query query) {
        Object object;
        Select select;
        if (this.readIf(44)) {
            this.read("BY");
            select = this.currentSelect;
            if (query instanceof Select) {
                this.currentSelect = (Select)query;
            }
            ArrayList<SelectOrderBy> arrayList = Utils.newSmallArrayList();
            do {
                boolean bl = !this.readIf(65);
                object = new SelectOrderBy();
                Expression expression = this.readExpression();
                if (bl && expression instanceof ValueExpression && expression.getType().getValueType() == 4) {
                    ((SelectOrderBy)object).columnIndexExpr = expression;
                } else if (expression instanceof Parameter) {
                    this.recompileAlways = true;
                    ((SelectOrderBy)object).columnIndexExpr = expression;
                } else {
                    ((SelectOrderBy)object).expression = expression;
                }
                ((SelectOrderBy)object).sortType = this.parseSortType();
                arrayList.add((SelectOrderBy)object);
            } while (this.readIf(79));
            query.setOrder(arrayList);
            this.currentSelect = select;
        }
        if (query.getLimit() == null) {
            select = this.currentSelect;
            this.currentSelect = null;
            boolean bl = false;
            if (this.readIf(42)) {
                bl = true;
                query.setOffset(this.readExpression().optimize(this.session));
                if (!this.readIf(48)) {
                    this.readIf("ROWS");
                }
            }
            if (this.readIf(19)) {
                bl = true;
                if (!this.readIf("FIRST")) {
                    this.read("NEXT");
                }
                if (this.readIf(48) || this.readIf("ROWS")) {
                    query.setLimit(ValueExpression.get(ValueInt.get(1)));
                } else {
                    Expression expression = this.readExpression().optimize(this.session);
                    query.setLimit(expression);
                    if (this.readIf("PERCENT")) {
                        query.setFetchPercent(true);
                    }
                    if (!this.readIf(48)) {
                        this.read("ROWS");
                    }
                }
                if (this.readIf(61)) {
                    this.read("TIES");
                    query.setWithTies(true);
                } else {
                    this.read("ONLY");
                }
            }
            if (!bl && this.readIf(35)) {
                Expression expression = this.readExpression().optimize(this.session);
                query.setLimit(expression);
                if (this.readIf(42)) {
                    object = this.readExpression().optimize(this.session);
                    query.setOffset((Expression)object);
                } else if (this.readIf(79)) {
                    object = expression;
                    expression = this.readExpression().optimize(this.session);
                    query.setOffset((Expression)object);
                    query.setLimit(expression);
                }
            }
            if (this.readIf("SAMPLE_SIZE")) {
                Expression expression = this.readExpression().optimize(this.session);
                query.setSampleSize(expression);
            }
            this.currentSelect = select;
        }
        if (this.readIf(20)) {
            if (this.readIf("UPDATE")) {
                if (this.readIf("OF")) {
                    do {
                        this.readIdentifierWithSchema();
                    } while (this.readIf(79));
                } else if (this.readIf("NOWAIT")) {
                    // empty if block
                }
                query.setForUpdate(true);
            } else if (this.readIf("READ") || this.readIf(19)) {
                this.read("ONLY");
            }
        }
        if (this.database.getMode().isolationLevelInSelectOrInsertStatement) {
            this.parseIsolationClause();
        }
    }

    private void parseIsolationClause() {
        if (this.readIf(61)) {
            if (this.readIf("RR") || this.readIf("RS")) {
                if (this.readIf("USE")) {
                    this.read("AND");
                    this.read("KEEP");
                    if (this.readIf("SHARE") || this.readIf("UPDATE") || this.readIf("EXCLUSIVE")) {
                        // empty if block
                    }
                    this.read("LOCKS");
                }
            } else if (this.readIf("CS") || this.readIf("UR")) {
                // empty if block
            }
        }
    }

    private Query parseQuerySub() {
        if (this.readIf(75)) {
            Query query = this.parseSelectUnion();
            this.read(76);
            return query;
        }
        if (this.readIf(61)) {
            Query query;
            try {
                query = (Query)this.parseWith();
            }
            catch (ClassCastException classCastException) {
                throw DbException.get(42000, "WITH statement supports only SELECT (query) in this context");
            }
            query.setNeverLazy(true);
            return query;
        }
        if (this.readIf(51)) {
            return this.parseSelect();
        }
        if (this.readIf(52)) {
            return this.parseExplicitTable();
        }
        this.read(58);
        return this.parseValues();
    }

    private void parseSelectFromPart(Select select) {
        do {
            TableFilter tableFilter = this.readTableFilter();
            this.parseJoinTableFilter(tableFilter, select);
        } while (this.readIf(79));
        if (this.session.isForceJoinOrder()) {
            Collections.sort(select.getTopFilters(), TABLE_FILTER_COMPARATOR);
        }
    }

    private void parseJoinTableFilter(TableFilter tableFilter, final Select select) {
        tableFilter = this.readJoin(tableFilter);
        select.addTableFilter(tableFilter, true);
        boolean bl = false;
        while (true) {
            TableFilter tableFilter2;
            TableFilter tableFilter3;
            if ((tableFilter3 = tableFilter.getNestedJoin()) != null) {
                tableFilter3.visit(new TableFilter.TableFilterVisitor(){

                    @Override
                    public void accept(TableFilter tableFilter) {
                        select.addTableFilter(tableFilter, false);
                    }
                });
            }
            if ((tableFilter2 = tableFilter.getJoin()) == null) break;
            if (bl |= tableFilter2.isJoinOuter()) {
                select.addTableFilter(tableFilter2, false);
            } else {
                Expression expression = tableFilter2.getJoinCondition();
                if (expression != null) {
                    select.addCondition(expression);
                }
                tableFilter2.removeJoinCondition();
                tableFilter.removeJoin();
                select.addTableFilter(tableFilter2, true);
            }
            tableFilter = tableFilter2;
        }
    }

    private void parseSelectExpressions(Select select) {
        Expression expression;
        ArrayList<Expression> arrayList;
        Select select2 = this.currentSelect;
        this.currentSelect = null;
        if (this.readIf("TOP")) {
            arrayList = this.readTerm().optimize(this.session);
            select.setLimit((Expression)((Object)arrayList));
            if (this.readIf("PERCENT")) {
                select.setFetchPercent(true);
            }
            if (this.readIf(61)) {
                this.read("TIES");
                select.setWithTies(true);
            }
        } else if (this.readIf(35)) {
            arrayList = this.readTerm().optimize(this.session);
            select.setOffset((Expression)((Object)arrayList));
            expression = this.readTerm().optimize(this.session);
            select.setLimit(expression);
        }
        this.currentSelect = select2;
        if (this.readIf(15)) {
            if (this.readIf(43)) {
                this.read(75);
                arrayList = Utils.newSmallArrayList();
                do {
                    arrayList.add(this.readExpression());
                } while (this.readIfMore());
                select.setDistinct(arrayList.toArray(new Expression[0]));
            } else {
                select.setDistinct();
            }
        } else {
            this.readIf(3);
        }
        arrayList = Utils.newSmallArrayList();
        do {
            if (this.readIf(78)) {
                arrayList.add(this.parseWildcard(null, null));
                continue;
            }
            switch (this.currentTokenType) {
                case 19: 
                case 22: 
                case 24: 
                case 25: 
                case 42: 
                case 44: 
                case 46: 
                case 59: 
                case 60: 
                case 63: 
                case 85: {
                    break;
                }
                default: {
                    expression = this.readExpression();
                    if (this.readIf("AS") || this.currentTokenType == 2) {
                        String string = this.readAliasIdentifier();
                        boolean bl = this.database.getSettings().aliasColumnName;
                        expression = new Alias(expression, string, bl |= this.database.getMode().aliasColumnName);
                    }
                    arrayList.add(expression);
                }
            }
        } while (this.readIf(79));
        select.setExpressions(arrayList);
    }

    private Select parseSelect() {
        Object object;
        Select select = new Select(this.session, this.currentSelect);
        int n = this.lastParseIndex;
        Select select2 = this.currentSelect;
        Prepared prepared = this.currentPrepared;
        this.currentSelect = select;
        this.currentPrepared = select;
        this.parseSelectExpressions(select);
        if (!this.readIf(22)) {
            object = new TableFilter(this.session, new DualTable(this.database), null, this.rightsChecked, this.currentSelect, 0, null);
            select.addTableFilter((TableFilter)object, true);
        } else {
            this.parseSelectFromPart(select);
        }
        if (this.readIf(59)) {
            select.addCondition(this.readExpressionWithGlobalConditions());
        }
        this.currentSelect = select2;
        if (this.readIf(24)) {
            this.read("BY");
            select.setGroupQuery();
            object = Utils.newSmallArrayList();
            do {
                if (this.readIf(75)) {
                    if (this.readIf(76)) continue;
                    do {
                        ((ArrayList)object).add(this.readExpression());
                    } while (this.readIfMore());
                    continue;
                }
                ((ArrayList)object).add(this.readExpression());
            } while (this.readIf(79));
            if (!((ArrayList)object).isEmpty()) {
                select.setGroupBy((ArrayList<Expression>)object);
            }
        }
        this.currentSelect = select;
        if (this.readIf(25)) {
            select.setGroupQuery();
            select.setHaving(this.readExpressionWithGlobalConditions());
        }
        if (this.readIf(60)) {
            do {
                int n2 = this.parseIndex;
                String string = this.readAliasIdentifier();
                this.read("AS");
                Window window = this.readWindowSpecification();
                if (this.currentSelect.addWindow(string, window)) continue;
                throw DbException.getSyntaxError(this.sqlCommand, n2, "unique identifier");
            } while (this.readIf(79));
        }
        if (this.readIf(46)) {
            select.setWindowQuery();
            select.setQualify(this.readExpressionWithGlobalConditions());
        }
        select.setParameterList(this.parameters);
        this.currentSelect = select2;
        this.currentPrepared = prepared;
        this.setSQL(select, "SELECT", n);
        return select;
    }

    private Query parseExplicitTable() {
        int n = this.lastParseIndex;
        Table table = this.readTableOrView();
        Select select = new Select(this.session, this.currentSelect);
        TableFilter tableFilter = new TableFilter(this.session, table, null, this.rightsChecked, select, this.orderInFrom++, null);
        select.addTableFilter(tableFilter, true);
        select.setExplicitTable();
        this.setSQL(select, "TABLE", n);
        return select;
    }

    private void setSQL(Prepared prepared, String string, int n) {
        String string2;
        int n2 = this.lastParseIndex;
        if (string != null) {
            StringBuilder stringBuilder = new StringBuilder(string.length() + n2 - n + 1).append(string).append(' ');
            string2 = StringUtils.trimSubstring(stringBuilder, this.originalSQL, n, n2).toString();
        } else {
            string2 = StringUtils.trimSubstring(this.originalSQL, n, n2);
        }
        prepared.setSQL(string2);
    }

    private Expression readExpressionOrDefault() {
        if (this.readIf("DEFAULT")) {
            return ValueExpression.getDefault();
        }
        return this.readExpression();
    }

    private Expression readExpressionWithGlobalConditions() {
        Expression expression = this.readCondition();
        if (this.readIf("AND")) {
            expression = this.readAnd(new ConditionAndOr(0, expression, this.readCondition()));
        } else if (this.readIf("_LOCAL_AND_GLOBAL_")) {
            expression = this.readAnd(new ConditionLocalAndGlobal(expression, this.readCondition()));
        }
        while (this.readIf("OR")) {
            expression = new ConditionAndOr(1, expression, this.readAnd(this.readCondition()));
        }
        return expression;
    }

    private Expression readExpression() {
        Expression expression = this.readAnd(this.readCondition());
        while (this.readIf("OR")) {
            expression = new ConditionAndOr(1, expression, this.readAnd(this.readCondition()));
        }
        return expression;
    }

    private Expression readAnd(Expression expression) {
        while (this.readIf("AND")) {
            expression = new ConditionAndOr(0, expression, this.readCondition());
        }
        return expression;
    }

    private Expression readCondition() {
        switch (this.currentTokenType) {
            case 40: {
                this.read();
                return new ConditionNot(this.readCondition());
            }
            case 17: {
                this.read();
                this.read(75);
                Query query = this.parseQuery();
                this.read(76);
                return new ExistsPredicate(query);
            }
            case 29: {
                this.read();
                this.read(75);
                Expression expression = this.readConcat();
                this.read(79);
                Expression expression2 = this.readConcat();
                this.read(76);
                return new Comparison(this.session, 9, expression, expression2);
            }
            case 55: {
                this.read();
                this.read(75);
                Query query = this.parseQuery();
                this.read(76);
                return new UniquePredicate(query);
            }
        }
        if (this.expectedList != null) {
            this.addMultipleExpected(40, 17, 29, 55);
        }
        Expression expression = this.readConcat();
        while (true) {
            Object object;
            int n = this.parseIndex;
            boolean bl = this.readIf(40);
            if (bl && this.isToken(41)) {
                this.parseIndex = n;
                this.currentToken = "NOT";
                this.currentTokenType = 40;
                break;
            }
            if (this.readIf(34)) {
                Expression expression3 = this.readConcat();
                Expression expression4 = null;
                if (this.readIf("ESCAPE")) {
                    expression4 = this.readConcat();
                }
                this.recompileAlways = true;
                expression = new CompareLike(this.database, expression, expression3, expression4, false);
            } else if (this.readIf("ILIKE")) {
                Function function = Function.getFunctionWithArgs(this.database, 203, expression);
                function.setDataType(TypeInfo.TYPE_STRING_IGNORECASE);
                expression = function;
                Expression expression5 = this.readConcat();
                object = null;
                if (this.readIf("ESCAPE")) {
                    object = this.readConcat();
                }
                this.recompileAlways = true;
                expression = new CompareLike(this.database, expression, expression5, (Expression)object, false);
            } else if (this.readIf("REGEXP")) {
                Expression expression6 = this.readConcat();
                this.recompileAlways = true;
                expression = new CompareLike(this.database, expression, expression6, null, true);
            } else if (this.readIf(31)) {
                boolean bl2 = this.readIf(40);
                switch (this.currentTokenType) {
                    case 41: {
                        this.read();
                        expression = new NullPredicate(expression, bl2);
                        break;
                    }
                    case 15: {
                        this.read();
                        this.read(22);
                        expression = new Comparison(this.session, bl2 ? 16 : 21, expression, this.readConcat());
                        break;
                    }
                    case 53: {
                        this.read();
                        expression = new BooleanTest(expression, bl2, true);
                        break;
                    }
                    case 18: {
                        this.read();
                        expression = new BooleanTest(expression, bl2, false);
                        break;
                    }
                    case 56: {
                        this.read();
                        expression = new BooleanTest(expression, bl2, null);
                        break;
                    }
                    default: {
                        if (this.readIf("OF")) {
                            expression = this.readTypePredicate(expression, bl2);
                            break;
                        }
                        if (this.readIf("JSON")) {
                            expression = this.readJsonPredicate(expression, bl2);
                            break;
                        }
                        if (this.expectedList != null) {
                            this.addMultipleExpected(41, 15, 53, 18, 56);
                        }
                        if (!this.database.isStarting()) {
                            throw this.getSyntaxError();
                        }
                        expression = new Comparison(this.session, bl2 ? 21 : 16, expression, this.readConcat());
                        break;
                    }
                }
            } else if (this.readIf("IN")) {
                expression = this.readInPredicate(expression);
            } else if (this.readIf("BETWEEN")) {
                Expression expression7 = this.readConcat();
                this.read("AND");
                Expression expression8 = this.readConcat();
                object = new Comparison(this.session, 3, expression7, expression);
                Comparison comparison = new Comparison(this.session, 1, expression8, expression);
                expression = new ConditionAndOr(0, (Expression)object, comparison);
            } else {
                if (bl) {
                    throw this.getSyntaxError();
                }
                int n2 = Parser.getCompareType(this.currentTokenType);
                if (n2 < 0) break;
                this.read();
                int n3 = this.lastParseIndex;
                if (this.readIf(3)) {
                    this.read(75);
                    if (this.isQuery()) {
                        object = this.parseQuery();
                        expression = new ConditionInQuery(this.database, expression, (Query)object, true, n2);
                        this.read(76);
                    } else {
                        this.parseIndex = n3;
                        this.read();
                        expression = new Comparison(this.session, n2, expression, this.readConcat());
                    }
                } else if (this.readIf("ANY") || this.readIf("SOME")) {
                    this.read(75);
                    if (this.currentTokenType == 62 && n2 == 0) {
                        object = this.readParameter();
                        expression = new ConditionInParameter(this.database, expression, (Parameter)object);
                        this.read(76);
                    } else if (this.isQuery()) {
                        object = this.parseQuery();
                        expression = new ConditionInQuery(this.database, expression, (Query)object, false, n2);
                        this.read(76);
                    } else {
                        this.parseIndex = n3;
                        this.read();
                        expression = new Comparison(this.session, n2, expression, this.readConcat());
                    }
                } else {
                    expression = new Comparison(this.session, n2, expression, this.readConcat());
                }
            }
            if (!bl) continue;
            expression = new ConditionNot(expression);
        }
        return expression;
    }

    private TypePredicate readTypePredicate(Expression expression, boolean bl) {
        this.read(75);
        ArrayList<TypeInfo> arrayList = Utils.newSmallArrayList();
        do {
            arrayList.add(this.parseColumnWithType(null, false).getType());
        } while (this.readIfMore());
        return new TypePredicate(expression, bl, arrayList.toArray(new TypeInfo[0]));
    }

    private Expression readInPredicate(Expression expression) {
        ArrayList<Expression> arrayList;
        this.read(75);
        if (this.database.getMode().allowEmptyInPredicate && this.readIf(76)) {
            return ValueExpression.getBoolean(false);
        }
        if (this.isQuery()) {
            Query query = this.parseQuery();
            if (!this.readIfMore()) {
                return new ConditionInQuery(this.database, expression, query, false, 0);
            }
            arrayList = Utils.newSmallArrayList();
            arrayList.add(new Subquery(query));
        } else {
            arrayList = Utils.newSmallArrayList();
        }
        do {
            arrayList.add(this.readExpression());
        } while (this.readIfMore());
        return new ConditionIn(this.database, expression, arrayList);
    }

    private IsJsonPredicate readJsonPredicate(Expression expression, boolean bl) {
        JSONItemType jSONItemType = this.readIf("VALUE") ? JSONItemType.VALUE : (this.readIf(4) ? JSONItemType.ARRAY : (this.readIf("OBJECT") ? JSONItemType.OBJECT : (this.readIf("SCALAR") ? JSONItemType.SCALAR : JSONItemType.VALUE)));
        boolean bl2 = false;
        if (this.readIf(61)) {
            this.read(55);
            this.readIf("KEYS");
            bl2 = true;
        } else if (this.readIf("WITHOUT")) {
            this.read(55);
            this.readIf("KEYS");
        }
        return new IsJsonPredicate(expression, bl, bl2, jSONItemType);
    }

    private Expression readConcat() {
        Expression expression = this.readSum();
        while (true) {
            Function function;
            if (this.readIf(74)) {
                expression = new ConcatenationOperation(expression, this.readSum());
                continue;
            }
            if (this.readIf(89)) {
                if (this.readIf(78)) {
                    function = Function.getFunctionWithArgs(this.database, 203, expression);
                    function.setDataType(TypeInfo.TYPE_STRING_IGNORECASE);
                    expression = function;
                }
                expression = new CompareLike(this.database, expression, this.readSum(), null, true);
                continue;
            }
            if (!this.readIf(92)) break;
            if (this.readIf(78)) {
                function = Function.getFunctionWithArgs(this.database, 203, expression);
                function.setDataType(TypeInfo.TYPE_STRING_IGNORECASE);
                expression = function;
            }
            expression = new ConditionNot(new CompareLike(this.database, expression, this.readSum(), null, true));
        }
        return expression;
    }

    private Expression readSum() {
        Expression expression = this.readFactor();
        while (true) {
            if (this.readIf(73)) {
                expression = new BinaryOperation(BinaryOperation.OpType.PLUS, expression, this.readFactor());
                continue;
            }
            if (!this.readIf(72)) break;
            expression = new BinaryOperation(BinaryOperation.OpType.MINUS, expression, this.readFactor());
        }
        return expression;
    }

    private Expression readFactor() {
        Expression expression = this.readTerm();
        while (true) {
            if (this.readIf(78)) {
                expression = new BinaryOperation(BinaryOperation.OpType.MULTIPLY, expression, this.readTerm());
                continue;
            }
            if (this.readIf(83)) {
                expression = new BinaryOperation(BinaryOperation.OpType.DIVIDE, expression, this.readTerm());
                continue;
            }
            if (!this.readIf(84)) break;
            expression = new BinaryOperation(BinaryOperation.OpType.MODULUS, expression, this.readTerm());
        }
        return expression;
    }

    private Expression readAggregate(AggregateType aggregateType, String string) {
        Aggregate aggregate;
        if (this.currentSelect == null) {
            throw this.getSyntaxError();
        }
        switch (aggregateType) {
            case COUNT: {
                if (this.readIf(78)) {
                    aggregate = new Aggregate(AggregateType.COUNT_ALL, new Expression[0], this.currentSelect, false);
                    break;
                }
                boolean bl = this.readDistinctAgg();
                Expression expression = this.readExpression();
                if (expression instanceof Wildcard && !bl) {
                    aggregate = new Aggregate(AggregateType.COUNT_ALL, new Expression[0], this.currentSelect, false);
                    break;
                }
                aggregate = new Aggregate(AggregateType.COUNT, new Expression[]{expression}, this.currentSelect, bl);
                break;
            }
            case LISTAGG: {
                Expression[] expressionArray;
                boolean bl = this.readDistinctAgg();
                Expression expression = this.readExpression();
                Expression expression2 = null;
                ArrayList<SelectOrderBy> arrayList = null;
                if (this.equalsToken("STRING_AGG", string)) {
                    this.read(79);
                    expression2 = this.readExpression();
                    if (this.readIf(44)) {
                        this.read("BY");
                        arrayList = this.parseSimpleOrderList();
                    }
                } else if (this.equalsToken("GROUP_CONCAT", string)) {
                    if (this.readIf(44)) {
                        this.read("BY");
                        arrayList = this.parseSimpleOrderList();
                    }
                    if (this.readIf("SEPARATOR")) {
                        expression2 = this.readExpression();
                    }
                } else {
                    if (this.readIf(79)) {
                        expression2 = this.readExpression();
                    }
                    if (this.readIf(43)) {
                        this.read("OVERFLOW");
                        this.read("ERROR");
                    }
                }
                if (expression2 == null) {
                    Expression[] expressionArray2 = new Expression[1];
                    expressionArray = expressionArray2;
                    expressionArray2[0] = expression;
                } else {
                    Expression[] expressionArray3 = new Expression[2];
                    expressionArray3[0] = expression;
                    expressionArray = expressionArray3;
                    expressionArray3[1] = expression2;
                }
                Expression[] expressionArray4 = expressionArray;
                int n = this.lastParseIndex;
                this.read(76);
                if (arrayList == null && this.isToken("WITHIN")) {
                    aggregate = this.readWithinGroup(aggregateType, expressionArray4, bl, false);
                    break;
                }
                this.parseIndex = n;
                this.read();
                aggregate = new Aggregate(AggregateType.LISTAGG, expressionArray4, this.currentSelect, bl);
                if (arrayList == null) break;
                aggregate.setOrderByList(arrayList);
                break;
            }
            case ARRAY_AGG: {
                boolean bl = this.readDistinctAgg();
                aggregate = new Aggregate(AggregateType.ARRAY_AGG, new Expression[]{this.readExpression()}, this.currentSelect, bl);
                this.readAggregateOrderBy(aggregate);
                break;
            }
            case RANK: 
            case DENSE_RANK: 
            case PERCENT_RANK: 
            case CUME_DIST: {
                if (this.isToken(76)) {
                    return this.readWindowFunction(string);
                }
                ArrayList<Expression> arrayList = Utils.newSmallArrayList();
                do {
                    arrayList.add(this.readExpression());
                } while (this.readIfMore());
                aggregate = this.readWithinGroup(aggregateType, arrayList.toArray(new Expression[0]), false, true);
                break;
            }
            case PERCENTILE_CONT: 
            case PERCENTILE_DISC: {
                Expression expression = this.readExpression();
                this.read(76);
                aggregate = this.readWithinGroup(aggregateType, new Expression[]{expression}, false, false);
                break;
            }
            case MODE: {
                if (this.readIf(76)) {
                    aggregate = this.readWithinGroup(AggregateType.MODE, new Expression[0], false, false);
                    break;
                }
                Expression expression = this.readExpression();
                aggregate = new Aggregate(aggregateType, new Expression[0], this.currentSelect, false);
                if (this.readIf(44)) {
                    this.read("BY");
                    Expression expression3 = this.readExpression();
                    String string2 = expression.getSQL(true);
                    String string3 = expression3.getSQL(true);
                    if (!string2.equals(string3)) {
                        throw DbException.getSyntaxError(42131, this.sqlCommand, this.lastParseIndex, string2, string3);
                    }
                    this.readAggregateOrder(aggregate, expression, true);
                    break;
                }
                this.readAggregateOrder(aggregate, expression, false);
                break;
            }
            case JSON_OBJECTAGG: {
                boolean bl = this.readIf("KEY");
                Expression expression = this.readExpression();
                if (bl) {
                    this.read("VALUE");
                } else if (!this.readIf("VALUE")) {
                    this.read(86);
                }
                Expression expression4 = this.readExpression();
                aggregate = new Aggregate(AggregateType.JSON_OBJECTAGG, new Expression[]{expression, expression4}, this.currentSelect, false);
                this.readJsonObjectFunctionFlags(aggregate, false);
                break;
            }
            case JSON_ARRAYAGG: {
                aggregate = new Aggregate(AggregateType.JSON_ARRAYAGG, new Expression[]{this.readExpression()}, this.currentSelect, false);
                this.readAggregateOrderBy(aggregate);
                aggregate.setFlags(1);
                this.readJsonObjectFunctionFlags(aggregate, true);
                break;
            }
            default: {
                boolean bl = this.readDistinctAgg();
                aggregate = new Aggregate(aggregateType, new Expression[]{this.readExpression()}, this.currentSelect, bl);
            }
        }
        this.read(76);
        this.readFilterAndOver(aggregate);
        return aggregate;
    }

    private Aggregate readWithinGroup(AggregateType aggregateType, Expression[] expressionArray, boolean bl, boolean bl2) {
        this.read("WITHIN");
        this.read(24);
        this.read(75);
        this.read(44);
        this.read("BY");
        Aggregate aggregate = new Aggregate(aggregateType, expressionArray, this.currentSelect, bl);
        if (bl2) {
            int n = expressionArray.length;
            ArrayList<SelectOrderBy> arrayList = new ArrayList<SelectOrderBy>(n);
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    this.read(79);
                }
                SelectOrderBy selectOrderBy = new SelectOrderBy();
                selectOrderBy.expression = this.readExpression();
                selectOrderBy.sortType = this.parseSimpleSortType();
                arrayList.add(selectOrderBy);
            }
            aggregate.setOrderByList(arrayList);
        } else {
            this.readAggregateOrder(aggregate, this.readExpression(), true);
        }
        return aggregate;
    }

    private void readAggregateOrder(Aggregate aggregate, Expression expression, boolean bl) {
        ArrayList<SelectOrderBy> arrayList = new ArrayList<SelectOrderBy>(1);
        SelectOrderBy selectOrderBy = new SelectOrderBy();
        selectOrderBy.expression = expression;
        if (bl) {
            selectOrderBy.sortType = this.parseSimpleSortType();
        }
        arrayList.add(selectOrderBy);
        aggregate.setOrderByList(arrayList);
    }

    private void readAggregateOrderBy(Aggregate aggregate) {
        if (this.readIf(44)) {
            this.read("BY");
            aggregate.setOrderByList(this.parseSimpleOrderList());
        }
    }

    private ArrayList<SelectOrderBy> parseSimpleOrderList() {
        ArrayList<SelectOrderBy> arrayList = Utils.newSmallArrayList();
        do {
            SelectOrderBy selectOrderBy = new SelectOrderBy();
            selectOrderBy.expression = this.readExpression();
            selectOrderBy.sortType = this.parseSortType();
            arrayList.add(selectOrderBy);
        } while (this.readIf(79));
        return arrayList;
    }

    private JavaFunction readJavaFunction(Schema schema, String string, boolean bl) {
        FunctionAlias functionAlias = schema != null ? schema.findFunction(string) : this.findFunctionAlias(this.session.getCurrentSchemaName(), string);
        if (functionAlias == null) {
            if (bl) {
                throw DbException.get(90022, string);
            }
            return null;
        }
        ArrayList<Expression> arrayList = Utils.newSmallArrayList();
        if (!this.readIf(76)) {
            do {
                arrayList.add(this.readExpression());
            } while (this.readIfMore());
        }
        return new JavaFunction(functionAlias, arrayList.toArray(new Expression[0]));
    }

    private JavaAggregate readJavaAggregate(UserAggregate userAggregate) {
        boolean bl = this.readDistinctAgg();
        ArrayList<Expression> arrayList = Utils.newSmallArrayList();
        do {
            arrayList.add(this.readExpression());
        } while (this.readIfMore());
        Expression[] expressionArray = arrayList.toArray(new Expression[0]);
        JavaAggregate javaAggregate = new JavaAggregate(userAggregate, expressionArray, this.currentSelect, bl);
        this.readFilterAndOver(javaAggregate);
        return javaAggregate;
    }

    private boolean readDistinctAgg() {
        if (this.readIf(15)) {
            return true;
        }
        this.readIf(3);
        return false;
    }

    private void readFilterAndOver(AbstractAggregate abstractAggregate) {
        if (this.readIf("FILTER")) {
            this.read(75);
            this.read(59);
            Expression expression = this.readExpression();
            this.read(76);
            abstractAggregate.setFilterCondition(expression);
        }
        this.readOver(abstractAggregate);
    }

    private void readOver(DataAnalysisOperation dataAnalysisOperation) {
        if (this.readIf("OVER")) {
            dataAnalysisOperation.setOverCondition(this.readWindowNameOrSpecification());
            this.currentSelect.setWindowQuery();
        } else if (dataAnalysisOperation.isAggregate()) {
            this.currentSelect.setGroupQuery();
        } else {
            throw this.getSyntaxError();
        }
    }

    private Window readWindowNameOrSpecification() {
        return this.isToken(75) ? this.readWindowSpecification() : new Window(this.readAliasIdentifier(), null, null, null);
    }

    private Window readWindowSpecification() {
        Object object;
        Object object2;
        this.read(75);
        String string = null;
        if (this.currentTokenType == 2) {
            object2 = this.currentToken;
            if (this.currentTokenQuoted || !this.equalsToken((String)object2, "PARTITION") && !this.equalsToken((String)object2, "ROWS") && !this.equalsToken((String)object2, "RANGE") && !this.equalsToken((String)object2, "GROUPS")) {
                string = object2;
                this.read();
            }
        }
        object2 = null;
        if (this.readIf("PARTITION")) {
            this.read("BY");
            object2 = Utils.newSmallArrayList();
            do {
                object = this.readExpression();
                ((ArrayList)object2).add(object);
            } while (this.readIf(79));
        }
        object = null;
        if (this.readIf(44)) {
            this.read("BY");
            object = this.parseSimpleOrderList();
        }
        WindowFrame windowFrame = this.readWindowFrame();
        this.read(76);
        return new Window(string, (ArrayList<Expression>)object2, (ArrayList<SelectOrderBy>)object, windowFrame);
    }

    private WindowFrame readWindowFrame() {
        WindowFrame windowFrame;
        WindowFrameBound windowFrameBound;
        WindowFrameBound windowFrameBound2;
        WindowFrameUnits windowFrameUnits;
        if (this.readIf("ROWS")) {
            windowFrameUnits = WindowFrameUnits.ROWS;
        } else if (this.readIf("RANGE")) {
            windowFrameUnits = WindowFrameUnits.RANGE;
        } else if (this.readIf("GROUPS")) {
            windowFrameUnits = WindowFrameUnits.GROUPS;
        } else {
            return null;
        }
        if (this.readIf("BETWEEN")) {
            windowFrameBound2 = this.readWindowFrameRange();
            this.read("AND");
            windowFrameBound = this.readWindowFrameRange();
        } else {
            windowFrameBound2 = this.readWindowFrameStarting();
            windowFrameBound = null;
        }
        int n = this.lastParseIndex;
        WindowFrameExclusion windowFrameExclusion = WindowFrameExclusion.EXCLUDE_NO_OTHERS;
        if (this.readIf("EXCLUDE")) {
            if (this.readIf("CURRENT")) {
                this.read(48);
                windowFrameExclusion = WindowFrameExclusion.EXCLUDE_CURRENT_ROW;
            } else if (this.readIf(24)) {
                windowFrameExclusion = WindowFrameExclusion.EXCLUDE_GROUP;
            } else if (this.readIf("TIES")) {
                windowFrameExclusion = WindowFrameExclusion.EXCLUDE_TIES;
            } else {
                this.read("NO");
                this.read("OTHERS");
            }
        }
        if (!(windowFrame = new WindowFrame(windowFrameUnits, windowFrameBound2, windowFrameBound, windowFrameExclusion)).isValid()) {
            throw DbException.getSyntaxError(this.sqlCommand, n);
        }
        return windowFrame;
    }

    private WindowFrameBound readWindowFrameStarting() {
        if (this.readIf("UNBOUNDED")) {
            this.read("PRECEDING");
            return new WindowFrameBound(WindowFrameBoundType.UNBOUNDED_PRECEDING, null);
        }
        if (this.readIf("CURRENT")) {
            this.read(48);
            return new WindowFrameBound(WindowFrameBoundType.CURRENT_ROW, null);
        }
        Expression expression = this.readExpression();
        this.read("PRECEDING");
        return new WindowFrameBound(WindowFrameBoundType.PRECEDING, expression);
    }

    private WindowFrameBound readWindowFrameRange() {
        if (this.readIf("UNBOUNDED")) {
            if (this.readIf("PRECEDING")) {
                return new WindowFrameBound(WindowFrameBoundType.UNBOUNDED_PRECEDING, null);
            }
            this.read("FOLLOWING");
            return new WindowFrameBound(WindowFrameBoundType.UNBOUNDED_FOLLOWING, null);
        }
        if (this.readIf("CURRENT")) {
            this.read(48);
            return new WindowFrameBound(WindowFrameBoundType.CURRENT_ROW, null);
        }
        Expression expression = this.readExpression();
        if (this.readIf("PRECEDING")) {
            return new WindowFrameBound(WindowFrameBoundType.PRECEDING, expression);
        }
        this.read("FOLLOWING");
        return new WindowFrameBound(WindowFrameBoundType.FOLLOWING, expression);
    }

    private AggregateType getAggregateType(String string) {
        if (!this.identifiersToUpper) {
            string = StringUtils.toUpperEnglish(string);
        }
        return Aggregate.getAggregateType(string);
    }

    private Expression readFunction(Schema schema, String string) {
        Object object;
        if (schema != null) {
            return this.readJavaFunction(schema, string, true);
        }
        boolean bl = this.database.isAllowBuiltinAliasOverride();
        if (bl && (object = this.readJavaFunction(null, string, false)) != null) {
            return object;
        }
        object = this.getAggregateType(string);
        if (object != null) {
            return this.readAggregate((AggregateType)((Object)object), string);
        }
        Function function = Function.getFunction(this.database, string);
        if (function == null) {
            WindowFunction windowFunction = this.readWindowFunction(string);
            if (windowFunction != null) {
                return windowFunction;
            }
            UserAggregate userAggregate = this.database.findAggregate(string);
            if (userAggregate != null) {
                return this.readJavaAggregate(userAggregate);
            }
            if (bl) {
                throw DbException.get(90022, string);
            }
            return this.readJavaFunction(null, string, true);
        }
        return this.readFunctionParameters(function);
    }

    private Function readFunctionParameters(Function function) {
        switch (function.getFunctionType()) {
            case 203: {
                function.addParameter(this.readExpression());
                this.read("AS");
                function.setDataType(this.parseColumnWithType(null, false).getType());
                this.read(76);
                break;
            }
            case 202: {
                if (this.database.getMode().swapConvertFunctionParameters) {
                    function.setDataType(this.parseColumnWithType(null, false).getType());
                    this.read(79);
                    function.addParameter(this.readExpression());
                    this.read(76);
                    break;
                }
                function.addParameter(this.readExpression());
                this.read(79);
                function.setDataType(this.parseColumnWithType(null, false).getType());
                this.read(76);
                break;
            }
            case 119: {
                function.addParameter(ValueExpression.get(ValueString.get(this.currentToken)));
                this.read();
                this.read(22);
                function.addParameter(this.readExpression());
                this.read(76);
                break;
            }
            case 105: 
            case 106: {
                if (this.currentTokenType == 64) {
                    function.addParameter(ValueExpression.get(this.currentValue.convertTo(13)));
                } else {
                    function.addParameter(ValueExpression.get(ValueString.get(this.currentToken)));
                }
                this.read();
                this.read(79);
                function.addParameter(this.readExpression());
                this.read(79);
                function.addParameter(this.readExpression());
                this.read(76);
                break;
            }
            case 73: {
                function.addParameter(this.readExpression());
                if (this.readIf(22)) {
                    function.addParameter(this.readExpression());
                    if (this.readIf(20)) {
                        function.addParameter(this.readExpression());
                    }
                } else if (this.readIf(20)) {
                    function.addParameter(ValueExpression.get(ValueInt.get(0)));
                    function.addParameter(this.readExpression());
                } else {
                    this.read(79);
                    function.addParameter(this.readExpression());
                    if (this.readIf(79)) {
                        function.addParameter(this.readExpression());
                    }
                }
                this.read(76);
                break;
            }
            case 77: {
                function.addParameter(this.readConcat());
                if (!this.readIf(79)) {
                    this.read("IN");
                }
                function.addParameter(this.readExpression());
                this.read(76);
                break;
            }
            case 78: {
                Expression expression;
                int n;
                boolean bl = false;
                if (this.readIf("LEADING")) {
                    n = 1;
                    bl = true;
                } else if (this.readIf("TRAILING")) {
                    n = 2;
                    bl = true;
                } else {
                    bl = this.readIf("BOTH");
                    n = 3;
                }
                Expression expression2 = null;
                function.setFlags(n);
                if (bl) {
                    if (!this.readIf(22)) {
                        expression2 = this.readExpression();
                        this.read(22);
                    }
                    expression = this.readExpression();
                } else if (this.readIf(22)) {
                    expression = this.readExpression();
                } else {
                    expression = this.readExpression();
                    if (this.readIf(22)) {
                        expression2 = expression;
                        expression = this.readExpression();
                    }
                }
                if (!bl && expression2 == null && this.readIf(79)) {
                    expression2 = this.readExpression();
                }
                function.addParameter(expression);
                if (expression2 != null) {
                    function.addParameter(expression2);
                }
                this.read(76);
                break;
            }
            case 223: 
            case 224: {
                Object object;
                ArrayList<Column> arrayList = Utils.newSmallArrayList();
                do {
                    object = this.readAliasIdentifier();
                    Column column = this.parseColumnWithType((String)object, false);
                    arrayList.add(column);
                    this.read(65);
                    function.addParameter(this.readExpression());
                } while (this.readIfMore());
                object = (TableFunction)function;
                ((TableFunction)object).setColumns(arrayList);
                break;
            }
            case 233: {
                ArrayList<Column> arrayList = Utils.newSmallArrayList();
                if (!this.readIf(76)) {
                    int n = 0;
                    do {
                        function.addParameter(this.readExpression());
                        arrayList.add(new Column("C" + ++n, 0));
                    } while (this.readIfMore());
                }
                if (this.readIf(61)) {
                    this.read("ORDINALITY");
                    arrayList.add(new Column("NORD", 4));
                }
                TableFunction tableFunction = (TableFunction)function;
                tableFunction.setColumns(arrayList);
                break;
            }
            case 251: {
                if (!this.readJsonObjectFunctionFlags(function, false)) {
                    do {
                        boolean bl = this.readIf("KEY");
                        function.addParameter(this.readExpression());
                        if (bl) {
                            this.read("VALUE");
                        } else if (!this.readIf("VALUE")) {
                            this.read(86);
                        }
                        function.addParameter(this.readExpression());
                    } while (this.readIf(79));
                    this.readJsonObjectFunctionFlags(function, false);
                }
                this.read(76);
                break;
            }
            case 252: {
                function.setFlags(1);
                if (!this.readJsonObjectFunctionFlags(function, true)) {
                    do {
                        function.addParameter(this.readExpression());
                    } while (this.readIf(79));
                    this.readJsonObjectFunctionFlags(function, true);
                }
                this.read(76);
                break;
            }
            default: {
                if (this.readIf(76)) break;
                do {
                    function.addParameter(this.readExpression());
                } while (this.readIfMore());
            }
        }
        function.doneWithParameters();
        return function;
    }

    private WindowFunction readWindowFunction(String string) {
        WindowFunctionType windowFunctionType;
        if (!this.identifiersToUpper) {
            string = StringUtils.toUpperEnglish(string);
        }
        if ((windowFunctionType = WindowFunctionType.get(string)) == null) {
            return null;
        }
        if (this.currentSelect == null) {
            throw this.getSyntaxError();
        }
        int n = WindowFunction.getMinArgumentCount(windowFunctionType);
        Expression[] expressionArray = null;
        if (n > 0) {
            int n2 = WindowFunction.getMaxArgumentCount(windowFunctionType);
            expressionArray = new Expression[n2];
            if (n == n2) {
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        this.read(79);
                    }
                    expressionArray[i] = this.readExpression();
                }
            } else {
                int n3;
                for (n3 = 0; n3 < n2 && (n3 <= 0 || this.readIf(79)); ++n3) {
                    expressionArray[n3] = this.readExpression();
                }
                if (n3 < n) {
                    throw this.getSyntaxError();
                }
                if (n3 != n2) {
                    expressionArray = Arrays.copyOf(expressionArray, n3);
                }
            }
        }
        this.read(76);
        WindowFunction windowFunction = new WindowFunction(windowFunctionType, this.currentSelect, expressionArray);
        switch (windowFunctionType) {
            case NTH_VALUE: {
                this.readFromFirstOrLast(windowFunction);
            }
            case LEAD: 
            case LAG: 
            case FIRST_VALUE: 
            case LAST_VALUE: {
                this.readRespectOrIgnoreNulls(windowFunction);
            }
        }
        this.readOver(windowFunction);
        return windowFunction;
    }

    private void readFromFirstOrLast(WindowFunction windowFunction) {
        if (this.readIf(22) && !this.readIf("FIRST")) {
            this.read("LAST");
            windowFunction.setFromLast(true);
        }
    }

    private void readRespectOrIgnoreNulls(WindowFunction windowFunction) {
        if (this.readIf("RESPECT")) {
            this.read("NULLS");
        } else if (this.readIf("IGNORE")) {
            this.read("NULLS");
            windowFunction.setIgnoreNulls(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean readJsonObjectFunctionFlags(ExpressionWithFlags expressionWithFlags, boolean bl) {
        int n = this.lastParseIndex;
        boolean bl2 = false;
        int n2 = expressionWithFlags.getFlags();
        if (this.readIf(41)) {
            if (!this.readIf(43)) {
                this.parseIndex = n;
                this.read();
                return false;
            }
            this.read(41);
            n2 &= 0xFFFFFFFE;
            bl2 = true;
        } else if (this.readIf("ABSENT")) {
            if (!this.readIf(43)) {
                this.parseIndex = n;
                this.read();
                return false;
            }
            this.read(41);
            n2 |= 1;
            bl2 = true;
        }
        if (!bl) {
            if (this.readIf(61)) {
                this.read(55);
                this.read("KEYS");
                n2 |= 2;
                bl2 = true;
            } else if (this.readIf("WITHOUT")) {
                if (this.readIf(55)) {
                    this.read("KEYS");
                    n2 &= 0xFFFFFFFD;
                    bl2 = true;
                } else {
                    if (bl2) {
                        throw this.getSyntaxError();
                    }
                    this.parseIndex = n;
                    this.read();
                    return false;
                }
            }
        }
        if (bl2) {
            expressionWithFlags.setFlags(n2);
        }
        return bl2;
    }

    private Expression readKeywordFunction(int n) {
        FunctionAlias functionAlias;
        Function function = Function.getFunction(this.database, n);
        if (this.readIf(75)) {
            this.readFunctionParameters(function);
        } else {
            function.doneWithParameters();
        }
        if (this.database.isAllowBuiltinAliasOverride() && (functionAlias = this.database.getSchema(this.session.getCurrentSchemaName()).findFunction(function.getName())) != null) {
            return new JavaFunction(functionAlias, function.getArgs());
        }
        return function;
    }

    private Expression readFunctionWithoutParameters(int n) {
        FunctionAlias functionAlias;
        Expression[] expressionArray = new Expression[]{};
        Function function = Function.getFunctionWithArgs(this.database, n, expressionArray);
        if (this.database.isAllowBuiltinAliasOverride() && (functionAlias = this.database.getSchema(this.session.getCurrentSchemaName()).findFunction(function.getName())) != null) {
            return new JavaFunction(functionAlias, expressionArray);
        }
        return function;
    }

    private Expression readWildcardRowidOrSequenceValue(String string, String string2) {
        Sequence sequence;
        if (this.readIf(78)) {
            return this.parseWildcard(string, string2);
        }
        if (this.readIf(49)) {
            return new ExpressionColumn(this.database, string, string2, "_ROWID_", true);
        }
        if (string == null) {
            string = this.session.getCurrentSchemaName();
        }
        if (this.readIf("NEXTVAL")) {
            Sequence sequence2 = this.findSequence(string, string2);
            if (sequence2 != null) {
                return new SequenceValue(sequence2, false);
            }
        } else if (this.readIf("CURRVAL") && (sequence = this.findSequence(string, string2)) != null) {
            return new SequenceValue(sequence, true);
        }
        return null;
    }

    private Wildcard parseWildcard(String string, String string2) {
        Wildcard wildcard = new Wildcard(string, string2);
        if (this.readIf(16)) {
            this.read(75);
            ArrayList<ExpressionColumn> arrayList = Utils.newSmallArrayList();
            do {
                String string3 = null;
                String string4 = null;
                String string5 = this.readColumnIdentifier();
                if (this.readIf(80)) {
                    string4 = string5;
                    string5 = this.readColumnIdentifier();
                    if (this.readIf(80)) {
                        string3 = string4;
                        string4 = string5;
                        string5 = this.readColumnIdentifier();
                        if (this.readIf(80)) {
                            this.checkDatabaseName(string3);
                            string3 = string4;
                            string4 = string5;
                            string5 = this.readColumnIdentifier();
                        }
                    }
                }
                arrayList.add(new ExpressionColumn(this.database, string3, string4, string5, false));
            } while (this.readIfMore());
            wildcard.setExceptColumns(arrayList);
        }
        return wildcard;
    }

    private Expression readTermObjectDot(String string) {
        Expression expression = this.readWildcardRowidOrSequenceValue(null, string);
        if (expression != null) {
            return expression;
        }
        String string2 = this.readColumnIdentifier();
        if (this.readIf(75)) {
            return this.readFunction(this.database.getSchema(string), string2);
        }
        if (this.readIf(80)) {
            String string3 = string;
            expression = this.readWildcardRowidOrSequenceValue(string3, string = string2);
            if (expression != null) {
                return expression;
            }
            string2 = this.readColumnIdentifier();
            if (this.readIf(75)) {
                this.checkDatabaseName(string3);
                return this.readFunction(this.database.getSchema(string), string2);
            }
            if (this.readIf(80)) {
                this.checkDatabaseName(string3);
                string3 = string;
                string = string2;
                expression = this.readWildcardRowidOrSequenceValue(string3, string);
                if (expression != null) {
                    return expression;
                }
                string2 = this.readColumnIdentifier();
            }
            return new ExpressionColumn(this.database, string3, string, string2, false);
        }
        return new ExpressionColumn(this.database, null, string, string2, false);
    }

    private void checkDatabaseName(String string) {
        if (!this.database.getIgnoreCatalogs() && !this.equalsToken(this.database.getShortName(), string)) {
            throw DbException.get(90013, string);
        }
    }

    private Parameter readParameter() {
        Parameter parameter;
        boolean bl = Character.isDigit(this.sqlCommandChars[this.parseIndex]);
        if (bl) {
            int n;
            this.readParameterIndex();
            if (this.indexedParameterList == null) {
                if (this.parameters == null) {
                    throw this.getSyntaxError();
                }
                if (!this.parameters.isEmpty()) {
                    throw DbException.get(90123);
                }
                this.indexedParameterList = Utils.newSmallArrayList();
            }
            if ((n = this.currentValue.getInt() - 1) < 0 || n >= 100000) {
                throw DbException.getInvalidValueException("parameter index", n + 1);
            }
            if (this.indexedParameterList.size() <= n) {
                this.indexedParameterList.ensureCapacity(n + 1);
                while (this.indexedParameterList.size() <= n) {
                    this.indexedParameterList.add(null);
                }
            }
            if ((parameter = this.indexedParameterList.get(n)) == null) {
                parameter = new Parameter(n);
                this.indexedParameterList.set(n, parameter);
                this.parameters.add(parameter);
            }
            this.read();
        } else {
            this.read();
            if (this.indexedParameterList != null) {
                throw DbException.get(90123);
            }
            parameter = new Parameter(this.parameters.size());
            this.parameters.add(parameter);
        }
        return parameter;
    }

    private Expression readTerm() {
        Object object;
        block60: {
            int n;
            Expression[] expressionArray;
            Object object2;
            switch (this.currentTokenType) {
                case 71: {
                    this.read();
                    object = new Variable(this.session, this.readAliasIdentifier());
                    if (!this.readIf(91)) break;
                    object2 = this.readExpression();
                    expressionArray = Function.getFunctionWithArgs(this.database, 222, new Expression[]{object, object2});
                    object = expressionArray;
                    break;
                }
                case 62: {
                    object = this.readParameter();
                    break;
                }
                case 51: 
                case 61: {
                    object = new Subquery(this.parseQuery());
                    break;
                }
                case 52: {
                    int n2 = this.lastParseIndex;
                    this.read();
                    if (this.readIf(75)) {
                        object = this.readFunctionParameters(Function.getFunction(this.database, 223));
                        break;
                    }
                    this.parseIndex = n2;
                    this.read();
                    object = new Subquery(this.parseQuery());
                    break;
                }
                case 2: {
                    expressionArray = this.currentToken;
                    boolean bl = this.currentTokenQuoted;
                    this.read();
                    if (this.readIf(75)) {
                        object = this.readFunction(null, (String)expressionArray);
                        break;
                    }
                    if (this.readIf(80)) {
                        object = this.readTermObjectDot((String)expressionArray);
                        break;
                    }
                    if (bl) {
                        object = new ExpressionColumn(this.database, null, null, (String)expressionArray, false);
                        break;
                    }
                    object = this.readTermWithIdentifier((String)expressionArray);
                    break;
                }
                case 72: {
                    this.read();
                    if (this.currentTokenType == 64) {
                        object = ValueExpression.get(this.currentValue.negate());
                        int n3 = ((Expression)object).getType().getValueType();
                        if (n3 == 5 && ((Expression)object).getValue(this.session).getLong() == Integer.MIN_VALUE) {
                            object = ValueExpression.get(ValueInt.get(Integer.MIN_VALUE));
                        } else if (n3 == 6 && ((Expression)object).getValue(this.session).getBigDecimal().compareTo(Value.MIN_LONG_DECIMAL) == 0) {
                            object = ValueExpression.get(ValueLong.MIN);
                        }
                        this.read();
                        break;
                    }
                    object = new UnaryOperation(this.readTerm());
                    break;
                }
                case 73: {
                    this.read();
                    object = this.readTerm();
                    break;
                }
                case 75: {
                    this.read();
                    if (this.readIf(76)) {
                        object = ValueExpression.get(ValueRow.getEmpty());
                        break;
                    }
                    object = this.readExpression();
                    if (!this.readIfMore()) break;
                    ArrayList<Expression> arrayList = Utils.newSmallArrayList();
                    arrayList.add((Expression)object);
                    do {
                        arrayList.add(this.readExpression());
                    } while (this.readIfMore());
                    object = new ExpressionList(arrayList.toArray(new Expression[0]), false);
                    break;
                }
                case 4: {
                    this.read();
                    this.read(87);
                    if (this.readIf(88)) {
                        object = ValueExpression.get(ValueArray.getEmpty());
                        break;
                    }
                    ArrayList<Expression> arrayList = Utils.newSmallArrayList();
                    do {
                        arrayList.add(this.readExpression());
                    } while (this.readIf(79));
                    this.read(88);
                    object = new ExpressionList(arrayList.toArray(new Expression[0]), true);
                    break;
                }
                case 30: {
                    this.read();
                    object = this.readInterval();
                    break;
                }
                case 48: {
                    this.read();
                    this.read(75);
                    if (this.readIf(76)) {
                        object = ValueExpression.get(ValueRow.getEmpty());
                        break;
                    }
                    ArrayList<Expression> arrayList = Utils.newSmallArrayList();
                    do {
                        arrayList.add(this.readExpression());
                    } while (this.readIfMore());
                    object = new ExpressionList(arrayList.toArray(new Expression[0]), false);
                    break;
                }
                case 53: {
                    this.read();
                    object = ValueExpression.getBoolean(true);
                    break;
                }
                case 18: {
                    this.read();
                    object = ValueExpression.getBoolean(false);
                    break;
                }
                case 56: {
                    this.read();
                    object = TypedValueExpression.getUnknown();
                    break;
                }
                case 50: {
                    this.read();
                    if (this.readIf(75)) {
                        this.read(76);
                    }
                    if (this.currentSelect == null && this.currentPrepared == null) {
                        throw this.getSyntaxError();
                    }
                    object = new Rownum(this.currentSelect == null ? this.currentPrepared : this.currentSelect);
                    break;
                }
                case 41: {
                    this.read();
                    object = ValueExpression.getNull();
                    break;
                }
                case 49: {
                    this.read();
                    object = new ExpressionColumn(this.database, null, null, "_ROWID_", true);
                    break;
                }
                case 64: {
                    if (this.currentValue.getValueType() == 13) {
                        object = ValueExpression.get(this.readCharacterStringLiteral());
                        break;
                    }
                    object = ValueExpression.get(this.currentValue);
                    this.read();
                    break;
                }
                case 58: {
                    if (this.database.getMode().onDuplicateKeyUpdate) {
                        this.read();
                        object = this.readKeywordFunction(250);
                        break;
                    }
                    object = new Subquery(this.parseQuery());
                    break;
                }
                case 5: {
                    this.read();
                    object = this.readCase();
                    break;
                }
                case 9: {
                    this.read();
                    object = this.readKeywordFunction(150);
                    break;
                }
                case 10: {
                    this.read();
                    object = this.readKeywordFunction(100);
                    break;
                }
                case 11: {
                    this.read();
                    object = this.readKeywordFunction(215);
                    break;
                }
                case 12: {
                    this.read();
                    object = this.readKeywordFunction(101);
                    break;
                }
                case 13: {
                    this.read();
                    object = this.readKeywordFunction(103);
                    break;
                }
                case 14: {
                    this.read();
                    object = this.readKeywordFunction(151);
                    break;
                }
                case 33: {
                    this.read();
                    object = this.readKeywordFunction(60);
                    break;
                }
                case 36: {
                    this.read();
                    object = this.readKeywordFunction(102);
                    break;
                }
                case 37: {
                    this.read();
                    object = this.readKeywordFunction(104);
                    break;
                }
                case 47: {
                    this.read();
                    object = this.readKeywordFunction(68);
                    break;
                }
                default: {
                    throw this.getSyntaxError();
                }
            }
            if (this.readIf(87)) {
                object = Function.getFunctionWithArgs(this.database, 209, new Expression[]{object, this.readExpression()});
                this.read(88);
            }
            if (this.readIf(90)) {
                if (this.isToken("PG_CATALOG")) {
                    this.read("PG_CATALOG");
                    this.read(80);
                }
                if (this.readIf("REGCLASS")) {
                    object2 = this.findFunctionAlias(this.database.getMainSchema().getName(), "PG_GET_OID");
                    if (object2 == null) {
                        throw this.getSyntaxError();
                    }
                    expressionArray = new Expression[]{object};
                    object = new JavaFunction((FunctionAlias)object2, expressionArray);
                } else {
                    object2 = Function.getFunctionWithArgs(this.database, 203, new Expression[]{object});
                    ((Function)object2).setDataType(this.parseColumnWithType(null, false).getType());
                    object = object2;
                }
            }
            while (true) {
                n = this.lastParseIndex;
                if (this.readIf("AT")) {
                    if (this.readIf("TIME")) {
                        this.read("ZONE");
                        object = new TimeZoneOperation((Expression)object, this.readExpression());
                        continue;
                    }
                    if (this.readIf("LOCAL")) {
                        object = new TimeZoneOperation((Expression)object);
                        continue;
                    }
                    this.parseIndex = n;
                    this.read();
                    break block60;
                }
                if (!this.readIf("FORMAT")) break block60;
                if (!this.readIf("JSON")) break;
                object = new Format((Expression)object, Format.FormatEnum.JSON);
            }
            this.parseIndex = n;
            this.read();
        }
        return object;
    }

    private Expression readTermWithIdentifier(String string) {
        switch (string.charAt(0) & 0xFFDF) {
            case 67: {
                if (!this.equalsToken("CURRENT", string)) break;
                int n = this.lastParseIndex;
                if (this.readIf("VALUE") && this.readIf(20)) {
                    return new SequenceValue(this.readSequence(), true);
                }
                this.parseIndex = n;
                this.read();
                if (this.database.getMode().getEnum() != Mode.ModeEnum.DB2) break;
                return this.parseDB2SpecialRegisters(string);
            }
            case 68: {
                if (this.currentTokenType != 64 || this.currentValue.getValueType() != 13 || !this.equalsToken("DATE", string) && !this.equalsToken("D", string)) break;
                String string2 = this.currentValue.getString();
                this.read();
                return ValueExpression.get(ValueDate.parse(string2));
            }
            case 69: {
                if (this.currentTokenType != 64 || this.currentValue.getValueType() != 13 || !this.equalsToken("E", string)) break;
                String string3 = this.currentValue.getString();
                string3 = StringUtils.replaceAll(string3, "\\\\", "\\");
                this.read();
                return ValueExpression.get(ValueString.get(string3));
            }
            case 74: {
                if (this.currentTokenType == 64) {
                    if (this.currentValue.getValueType() != 13 || !this.equalsToken("JSON", string)) break;
                    return ValueExpression.get(ValueJson.fromJson(this.readCharacterStringLiteral().getString()));
                }
                if (this.currentTokenType != 2 || !this.equalsToken("JSON", string) || !this.equalsToken("X", this.currentToken)) break;
                int n = this.lastParseIndex;
                this.read();
                if (this.currentTokenType == 64 && this.currentValue.getValueType() == 13) {
                    return ValueExpression.get(ValueJson.fromJson(this.readBinaryLiteral()));
                }
                this.parseIndex = n;
                this.read();
                break;
            }
            case 78: {
                if (this.equalsToken("NEXT", string)) {
                    int n = this.lastParseIndex;
                    if (this.readIf("VALUE") && this.readIf(20)) {
                        return new SequenceValue(this.readSequence(), false);
                    }
                    this.parseIndex = n;
                    this.read();
                    break;
                }
                if (this.currentTokenType != 64 || this.currentValue.getValueType() != 13 || !this.equalsToken("N", string)) break;
                return ValueExpression.get(this.readCharacterStringLiteral());
            }
            case 83: {
                if (this.equalsToken("SYSDATE", string)) {
                    return this.readFunctionWithoutParameters(103);
                }
                if (this.equalsToken("SYSTIME", string)) {
                    return this.readFunctionWithoutParameters(102);
                }
                if (!this.equalsToken("SYSTIMESTAMP", string)) break;
                return this.readFunctionWithoutParameters(103);
            }
            case 84: {
                if (this.equalsToken("TIME", string)) {
                    if (this.readIf(61)) {
                        this.read("TIME");
                        this.read("ZONE");
                        if (this.currentTokenType != 64 || this.currentValue.getValueType() != 13) {
                            throw this.getSyntaxError();
                        }
                        String string4 = this.currentValue.getString();
                        this.read();
                        return ValueExpression.get(ValueTimeTimeZone.parse(string4));
                    }
                    boolean bl = this.readIf("WITHOUT");
                    if (bl) {
                        this.read("TIME");
                        this.read("ZONE");
                    }
                    if (this.currentTokenType == 64 && this.currentValue.getValueType() == 13) {
                        String string5 = this.currentValue.getString();
                        this.read();
                        return ValueExpression.get(ValueTime.parse(string5));
                    }
                    if (!bl) break;
                    throw this.getSyntaxError();
                }
                if (this.equalsToken("TIMESTAMP", string)) {
                    if (this.readIf(61)) {
                        this.read("TIME");
                        this.read("ZONE");
                        if (this.currentTokenType != 64 || this.currentValue.getValueType() != 13) {
                            throw this.getSyntaxError();
                        }
                        String string6 = this.currentValue.getString();
                        this.read();
                        return ValueExpression.get(ValueTimestampTimeZone.parse(string6));
                    }
                    boolean bl = this.readIf("WITHOUT");
                    if (bl) {
                        this.read("TIME");
                        this.read("ZONE");
                    }
                    if (this.currentTokenType == 64 && this.currentValue.getValueType() == 13) {
                        String string7 = this.currentValue.getString();
                        this.read();
                        return ValueExpression.get(ValueTimestamp.parse(string7, this.database));
                    }
                    if (!bl) break;
                    throw this.getSyntaxError();
                }
                if (this.equalsToken("TODAY", string)) {
                    return this.readFunctionWithoutParameters(100);
                }
                if (this.currentTokenType != 64 || this.currentValue.getValueType() != 13) break;
                if (this.equalsToken("T", string)) {
                    String string8 = this.currentValue.getString();
                    this.read();
                    return ValueExpression.get(ValueTime.parse(string8));
                }
                if (!this.equalsToken("TS", string)) break;
                String string9 = this.currentValue.getString();
                this.read();
                return ValueExpression.get(ValueTimestamp.parse(string9, this.database));
            }
            case 88: {
                if (this.currentTokenType != 64 || this.currentValue.getValueType() != 13 || !this.equalsToken("X", string)) break;
                return ValueExpression.get(ValueBytes.getNoCopy(this.readBinaryLiteral()));
            }
        }
        return new ExpressionColumn(this.database, null, null, string, false);
    }

    private byte[] readBinaryLiteral() {
        ByteArrayOutputStream byteArrayOutputStream = null;
        do {
            byteArrayOutputStream = StringUtils.convertHexWithSpacesToBytes(byteArrayOutputStream, this.currentValue.getString());
            this.read();
        } while (this.currentTokenType == 64 && this.currentValue.getValueType() == 13);
        return byteArrayOutputStream.toByteArray();
    }

    private Value readCharacterStringLiteral() {
        Value value = this.currentValue;
        this.read();
        if (this.currentTokenType == 64 && this.currentValue.getValueType() == 13) {
            StringBuilder stringBuilder = new StringBuilder(value.getString());
            do {
                stringBuilder.append(this.currentValue.getString());
                this.read();
            } while (this.currentTokenType == 64 && this.currentValue.getValueType() == 13);
            return ValueString.get(stringBuilder.toString());
        }
        return value;
    }

    private Expression readInterval() {
        IntervalQualifier intervalQualifier;
        boolean bl = this.readIf(72);
        if (!bl) {
            this.readIf(73);
        }
        String string = this.readString();
        if (this.readIf("YEAR")) {
            if (this.readIf("TO")) {
                this.read("MONTH");
                intervalQualifier = IntervalQualifier.YEAR_TO_MONTH;
            } else {
                intervalQualifier = IntervalQualifier.YEAR;
            }
        } else if (this.readIf("MONTH")) {
            intervalQualifier = IntervalQualifier.MONTH;
        } else if (this.readIf("DAY")) {
            if (this.readIf("TO")) {
                if (this.readIf("HOUR")) {
                    intervalQualifier = IntervalQualifier.DAY_TO_HOUR;
                } else if (this.readIf("MINUTE")) {
                    intervalQualifier = IntervalQualifier.DAY_TO_MINUTE;
                } else {
                    this.read("SECOND");
                    intervalQualifier = IntervalQualifier.DAY_TO_SECOND;
                }
            } else {
                intervalQualifier = IntervalQualifier.DAY;
            }
        } else if (this.readIf("HOUR")) {
            if (this.readIf("TO")) {
                if (this.readIf("MINUTE")) {
                    intervalQualifier = IntervalQualifier.HOUR_TO_MINUTE;
                } else {
                    this.read("SECOND");
                    intervalQualifier = IntervalQualifier.HOUR_TO_SECOND;
                }
            } else {
                intervalQualifier = IntervalQualifier.HOUR;
            }
        } else if (this.readIf("MINUTE")) {
            if (this.readIf("TO")) {
                this.read("SECOND");
                intervalQualifier = IntervalQualifier.MINUTE_TO_SECOND;
            } else {
                intervalQualifier = IntervalQualifier.MINUTE;
            }
        } else {
            this.read("SECOND");
            intervalQualifier = IntervalQualifier.SECOND;
        }
        try {
            return ValueExpression.get(IntervalUtils.parseInterval(intervalQualifier, bl, string));
        }
        catch (Exception exception) {
            throw DbException.get(22007, exception, "INTERVAL", string);
        }
    }

    private Expression parseDB2SpecialRegisters(String string) {
        if (this.readIf("TIMESTAMP")) {
            if (this.readIf(61)) {
                this.read("TIME");
                this.read("ZONE");
                return this.readKeywordFunction(103);
            }
            return this.readKeywordFunction(104);
        }
        if (this.readIf("TIME")) {
            return this.readFunctionWithoutParameters(102);
        }
        if (this.readIf("DATE")) {
            return this.readFunctionWithoutParameters(100);
        }
        return new ExpressionColumn(this.database, null, null, string, false);
    }

    private Expression readCase() {
        Function function;
        if (this.readIf("END")) {
            this.readIf(5);
            return ValueExpression.getNull();
        }
        if (this.readIf("ELSE")) {
            Expression expression = this.readExpression().optimize(this.session);
            this.read("END");
            this.readIf(5);
            return expression;
        }
        if (this.readIf("WHEN")) {
            function = Function.getFunction(this.database, 206);
            function.addParameter(null);
            do {
                function.addParameter(this.readExpression());
                this.read("THEN");
                function.addParameter(this.readExpression());
            } while (this.readIf("WHEN"));
        } else {
            Expression expression = this.readExpression();
            if (this.readIf("END")) {
                this.readIf(5);
                return ValueExpression.getNull();
            }
            if (this.readIf("ELSE")) {
                Expression expression2 = this.readExpression().optimize(this.session);
                this.read("END");
                this.readIf(5);
                return expression2;
            }
            function = Function.getFunction(this.database, 206);
            function.addParameter(expression);
            this.read("WHEN");
            do {
                function.addParameter(this.readExpression());
                this.read("THEN");
                function.addParameter(this.readExpression());
            } while (this.readIf("WHEN"));
        }
        if (this.readIf("ELSE")) {
            function.addParameter(this.readExpression());
        }
        this.read("END");
        this.readIf("CASE");
        function.doneWithParameters();
        return function;
    }

    private int readNonNegativeInt() {
        int n = this.readInt();
        if (n < 0) {
            throw DbException.getInvalidValueException("non-negative integer", n);
        }
        return n;
    }

    private int readInt() {
        boolean bl = false;
        if (this.currentTokenType == 72) {
            bl = true;
            this.read();
        } else if (this.currentTokenType == 73) {
            this.read();
        }
        if (this.currentTokenType != 64) {
            throw DbException.getSyntaxError(this.sqlCommand, this.parseIndex, "integer");
        }
        if (bl) {
            this.currentValue = this.currentValue.negate();
        }
        int n = this.currentValue.getInt();
        this.read();
        return n;
    }

    private long readNonNegativeLong() {
        long l = this.readLong();
        if (l < 0L) {
            throw DbException.getInvalidValueException("non-negative long", l);
        }
        return l;
    }

    private long readLong() {
        boolean bl = false;
        if (this.currentTokenType == 72) {
            bl = true;
            this.read();
        } else if (this.currentTokenType == 73) {
            this.read();
        }
        if (this.currentTokenType != 64) {
            throw DbException.getSyntaxError(this.sqlCommand, this.parseIndex, "long");
        }
        if (bl) {
            this.currentValue = this.currentValue.negate();
        }
        long l = this.currentValue.getLong();
        this.read();
        return l;
    }

    private boolean readBooleanSetting() {
        switch (this.currentTokenType) {
            case 43: 
            case 53: {
                this.read();
                return true;
            }
            case 18: {
                this.read();
                return false;
            }
            case 64: {
                boolean bl = this.currentValue.getBoolean();
                this.read();
                return bl;
            }
        }
        if (this.readIf("OFF")) {
            return false;
        }
        if (this.expectedList != null) {
            this.addMultipleExpected(43, 53, 18);
        }
        throw this.getSyntaxError();
    }

    private String readString() {
        Expression expression = this.readExpression().optimize(this.session);
        if (!(expression instanceof ValueExpression)) {
            throw DbException.getSyntaxError(this.sqlCommand, this.parseIndex, "string");
        }
        return expression.getValue(this.session).getString();
    }

    private String readIdentifierWithSchema(String string) {
        String string2 = this.readColumnIdentifier();
        this.schemaName = string;
        if (this.readIf(80)) {
            string2 = this.readIdentifierWithSchema2(string2);
        }
        return string2;
    }

    private String readIdentifierWithSchema2(String string) {
        this.schemaName = string;
        if (this.database.getMode().allowEmptySchemaValuesAsDefaultSchema && this.readIf(80)) {
            if (this.equalsToken(this.schemaName, this.database.getShortName()) || this.database.getIgnoreCatalogs()) {
                this.schemaName = this.session.getCurrentSchemaName();
                string = this.readColumnIdentifier();
            }
        } else {
            string = this.readColumnIdentifier();
            if (this.currentTokenType == 80 && (this.equalsToken(this.schemaName, this.database.getShortName()) || this.database.getIgnoreCatalogs())) {
                this.read();
                this.schemaName = string;
                string = this.readColumnIdentifier();
            }
        }
        return string;
    }

    private String readIdentifierWithSchema() {
        return this.readIdentifierWithSchema(this.session.getCurrentSchemaName());
    }

    private String readAliasIdentifier() {
        return this.readColumnIdentifier();
    }

    private String readUniqueIdentifier() {
        return this.readColumnIdentifier();
    }

    private String readColumnIdentifier() {
        if (!(this.currentTokenType == 2 || this.database.isStarting() && this.isKeyword(this.currentToken))) {
            throw DbException.getSyntaxError(this.sqlCommand, this.parseIndex, "identifier");
        }
        String string = this.currentToken;
        this.read();
        return string;
    }

    private void read(String string) {
        if (this.currentTokenQuoted || !this.equalsToken(string, this.currentToken)) {
            this.addExpected(string);
            throw this.getSyntaxError();
        }
        this.read();
    }

    private void read(int n) {
        if (n != this.currentTokenType) {
            this.addExpected(n);
            throw this.getSyntaxError();
        }
        this.read();
    }

    private boolean readIf(String string) {
        if (!this.currentTokenQuoted && this.equalsToken(string, this.currentToken)) {
            this.read();
            return true;
        }
        this.addExpected(string);
        return false;
    }

    private boolean readIf(int n) {
        if (n == this.currentTokenType) {
            this.read();
            return true;
        }
        this.addExpected(n);
        return false;
    }

    private boolean isToken(String string) {
        if (!this.currentTokenQuoted && this.equalsToken(string, this.currentToken)) {
            return true;
        }
        this.addExpected(string);
        return false;
    }

    private boolean isToken(int n) {
        if (n == this.currentTokenType) {
            return true;
        }
        this.addExpected(n);
        return false;
    }

    private boolean equalsToken(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2) || !this.identifiersToUpper && string.equalsIgnoreCase(string2);
    }

    private static boolean equalsTokenIgnoreCase(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2) || string.equalsIgnoreCase(string2);
    }

    private boolean isTokenInList(Collection<String> collection) {
        String string = this.currentToken.toUpperCase();
        return collection.contains(string);
    }

    private void addExpected(String string) {
        if (this.expectedList != null) {
            this.expectedList.add(string);
        }
    }

    private void addExpected(int n) {
        if (this.expectedList != null) {
            this.expectedList.add(TOKENS[n]);
        }
    }

    private void addMultipleExpected(int ... nArray) {
        for (int n : nArray) {
            this.expectedList.add(TOKENS[n]);
        }
    }

    private void read() {
        int n;
        this.currentTokenQuoted = false;
        if (this.expectedList != null) {
            this.expectedList.clear();
        }
        int[] nArray = this.characterTypes;
        this.lastParseIndex = this.parseIndex;
        int n2 = this.parseIndex;
        while ((n = nArray[n2]) == 0) {
            ++n2;
        }
        int n3 = n2;
        char[] cArray = this.sqlCommandChars;
        char c = cArray[n2++];
        this.currentToken = "";
        switch (n) {
            case 4: {
                while ((n = nArray[n2]) == 4 || n == 2) {
                    ++n2;
                }
                this.currentTokenType = ParserUtil.getSaveTokenType(this.sqlCommand, !this.identifiersToUpper, n3, n2, false);
                this.currentToken = this.currentTokenType == 2 ? StringUtils.cache(this.sqlCommand.substring(n3, n2)) : TOKENS[this.currentTokenType];
                this.parseIndex = n2;
                return;
            }
            case 3: {
                String string = null;
                while (true) {
                    int n4 = ++n2;
                    while (cArray[n2] != c) {
                        ++n2;
                    }
                    string = string == null ? this.sqlCommand.substring(n4, n2) : string + this.sqlCommand.substring(n4 - 1, n2);
                    if (cArray[++n2] != c) break;
                }
                this.currentToken = StringUtils.cache(string);
                this.parseIndex = n2;
                this.currentTokenQuoted = true;
                this.currentTokenType = 2;
                return;
            }
            case 6: {
                if (nArray[n2] == 6) {
                    char c2 = cArray[n2++];
                    this.currentTokenType = this.getSpecialType2(c, c2);
                } else {
                    this.currentTokenType = this.getSpecialType1(c);
                }
                this.parseIndex = n2;
                return;
            }
            case 5: {
                this.currentTokenType = this.getSpecialType1(c);
                this.parseIndex = n2;
                return;
            }
            case 2: {
                if (c == '0' && (cArray[n2] == 'X' || cArray[n2] == 'x')) {
                    this.readHexNumber(n2 + 1, n3 + 2, cArray, nArray);
                    return;
                }
                long l = c - 48;
                while (true) {
                    if ((c = cArray[n2]) < '0' || c > '9') {
                        switch (c) {
                            case '.': 
                            case 'E': 
                            case 'e': {
                                this.readDecimal(n3, n2, false);
                                break;
                            }
                            case 'L': 
                            case 'l': {
                                this.readDecimal(n3, n2, true);
                                break;
                            }
                            default: {
                                this.checkLiterals(false);
                                this.currentValue = ValueInt.get((int)l);
                                this.currentTokenType = 64;
                                this.currentToken = "0";
                                this.parseIndex = n2;
                                break;
                            }
                        }
                        break;
                    }
                    if ((l = l * 10L + (long)(c - 48)) > Integer.MAX_VALUE) {
                        this.readDecimal(n3, n2, true);
                        break;
                    }
                    ++n2;
                }
                return;
            }
            case 8: {
                if (nArray[n2] != 2) {
                    this.currentTokenType = 80;
                    this.currentToken = ".";
                    this.parseIndex = n2;
                    return;
                }
                this.readDecimal(n2 - 1, n2, false);
                return;
            }
            case 7: {
                String string = null;
                while (true) {
                    int n5 = ++n2;
                    while (cArray[n2] != '\'') {
                        ++n2;
                    }
                    string = string == null ? this.sqlCommand.substring(n5, n2) : string + this.sqlCommand.substring(n5 - 1, n2);
                    if (cArray[++n2] != '\'') break;
                }
                this.currentToken = "'";
                this.checkLiterals(true);
                this.currentValue = ValueString.get(string, this.database);
                this.parseIndex = n2;
                this.currentTokenType = 64;
                return;
            }
            case 9: {
                int n6 = n2 - 1;
                while (nArray[n2] == 9) {
                    ++n2;
                }
                String string = this.sqlCommand.substring(n6, n2);
                this.currentToken = "'";
                this.checkLiterals(true);
                this.currentValue = ValueString.get(string, this.database);
                this.parseIndex = n2;
                this.currentTokenType = 64;
                return;
            }
            case 1: {
                this.currentTokenType = 63;
                this.parseIndex = n2;
                return;
            }
        }
        throw this.getSyntaxError();
    }

    private void readParameterIndex() {
        int n = this.parseIndex;
        char[] cArray = this.sqlCommandChars;
        char c = cArray[n++];
        long l = c - 48;
        while ((c = cArray[n]) >= '0' && c <= '9') {
            if ((l = l * 10L + (long)(c - 48)) > Integer.MAX_VALUE) {
                throw DbException.getInvalidValueException("parameter index", l);
            }
            ++n;
        }
        this.currentValue = ValueInt.get((int)l);
        this.currentTokenType = 64;
        this.currentToken = "0";
        this.parseIndex = n;
    }

    private void checkLiterals(boolean bl) {
        int n;
        if (!this.literalsChecked && this.session != null && !this.session.getAllowLiterals() && ((n = this.database.getAllowLiterals()) == 0 || bl && n != 2)) {
            throw DbException.get(90116);
        }
    }

    private void readHexNumber(int n, int n2, char[] cArray, int[] nArray) {
        if (this.database.getMode().zeroExLiteralsAreBinaryStrings) {
            char c;
            while ((c = cArray[n]) >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'z') {
                ++n;
            }
            if (nArray[n] == 4) {
                throw DbException.get(90004, this.sqlCommand.substring(n, n + 1));
            }
            this.checkLiterals(true);
            this.currentValue = ValueBytes.getNoCopy(StringUtils.convertHexToBytes(this.sqlCommand.substring(n2, n)));
            this.parseIndex = n;
        } else {
            char c;
            long l = 0L;
            while (true) {
                if ((c = cArray[n]) >= '0' && c <= '9') {
                    l = (l << 4) + (long)c - 48L;
                } else if (c >= 'A' && c <= 'F') {
                    l = (l << 4) + (long)c - 55L;
                } else if (c >= 'a' && c <= 'f') {
                    l = (l << 4) + (long)c - 87L;
                } else {
                    if (n == n2) {
                        this.parseIndex = n;
                        this.addExpected("Hex number");
                        throw this.getSyntaxError();
                    }
                    this.currentValue = ValueInt.get((int)l);
                    break;
                }
                if (l > Integer.MAX_VALUE) {
                    while ((c = cArray[++n]) >= '0' && c <= '9' || c >= 'A' && c <= 'F') {
                    }
                    String string = this.sqlCommand.substring(n2, n);
                    this.currentValue = ValueDecimal.get(new BigInteger(string, 16));
                    break;
                }
                ++n;
            }
            c = cArray[n];
            if (c == 'L' || c == 'l') {
                ++n;
            }
            this.parseIndex = n;
            if (nArray[n] == 4) {
                this.addExpected("Hex number");
                throw this.getSyntaxError();
            }
            this.checkLiterals(false);
        }
        this.currentTokenType = 64;
        this.currentToken = "0";
    }

    private void readDecimal(int n, int n2, boolean bl) {
        int n3;
        char[] cArray = this.sqlCommandChars;
        int[] nArray = this.characterTypes;
        while (true) {
            if ((n3 = nArray[n2]) == 8) {
                bl = false;
            } else if (n3 != 2) break;
            ++n2;
        }
        n3 = cArray[n2];
        if (n3 == 69 || n3 == 101) {
            bl = false;
            if ((n3 = cArray[++n2]) == 43 || n3 == 45) {
                ++n2;
            }
            if (nArray[n2] != 2) {
                throw this.getSyntaxError();
            }
            while (nArray[++n2] == 2) {
            }
        }
        this.parseIndex = n2;
        this.checkLiterals(false);
        if (bl && n2 - n <= 19) {
            BigInteger bigInteger = new BigInteger(this.sqlCommand.substring(n, n2));
            if (bigInteger.compareTo(ValueLong.MAX_BI) <= 0) {
                n3 = cArray[n2];
                if (n3 == 76 || n3 == 108) {
                    ++this.parseIndex;
                }
                this.currentValue = ValueLong.get(bigInteger.longValue());
                this.currentTokenType = 64;
                return;
            }
            this.currentValue = ValueDecimal.get(bigInteger);
        } else {
            BigDecimal bigDecimal;
            try {
                bigDecimal = new BigDecimal(this.sqlCommandChars, n, n2 - n);
            }
            catch (NumberFormatException numberFormatException) {
                throw DbException.get(22018, numberFormatException, this.sqlCommand.substring(n, n2));
            }
            this.currentValue = ValueDecimal.get(bigDecimal);
        }
        this.currentTokenType = 64;
    }

    private void initialize(String string) {
        if (string == null) {
            string = "";
        }
        this.originalSQL = string;
        this.sqlCommand = string;
        int n = string.length() + 1;
        char[] cArray = new char[n];
        int[] nArray = new int[n];
        string.getChars(0, --n, cArray, 0);
        boolean bl = false;
        cArray[n] = 32;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            int n4 = 0;
            switch (c) {
                case '/': {
                    if (cArray[i + 1] == '*') {
                        bl = true;
                        cArray[i] = 32;
                        cArray[i + 1] = 32;
                        n2 = i;
                        this.checkRunOver(i += 2, n, n2);
                        while (cArray[i] != '*' || cArray[i + 1] != '/') {
                            cArray[i++] = 32;
                            this.checkRunOver(i, n, n2);
                        }
                        cArray[i] = 32;
                        cArray[i + 1] = 32;
                        ++i;
                        break;
                    }
                    if (cArray[i + 1] == '/') {
                        bl = true;
                        n2 = i;
                        while ((c = cArray[i]) != '\n' && c != '\r' && i < n - 1) {
                            cArray[i++] = 32;
                            this.checkRunOver(i, n, n2);
                        }
                        break;
                    }
                    n4 = 5;
                    break;
                }
                case '-': {
                    if (cArray[i + 1] == '-') {
                        bl = true;
                        n2 = i;
                        while ((c = cArray[i]) != '\n' && c != '\r' && i < n - 1) {
                            cArray[i++] = 32;
                            this.checkRunOver(i, n, n2);
                        }
                        break;
                    }
                    n4 = 5;
                    break;
                }
                case '$': {
                    if (cArray[i + 1] == '$' && (i == 0 || cArray[i - 1] <= ' ')) {
                        bl = true;
                        cArray[i] = 32;
                        cArray[i + 1] = 32;
                        n2 = i;
                        this.checkRunOver(i += 2, n, n2);
                        while (cArray[i] != '$' || cArray[i + 1] != '$') {
                            nArray[i++] = 9;
                            this.checkRunOver(i, n, n2);
                        }
                        cArray[i] = 32;
                        cArray[i + 1] = 32;
                        ++i;
                        break;
                    }
                    if (n3 == 4 || n3 == 2) {
                        n4 = 4;
                        break;
                    }
                    n4 = 5;
                    break;
                }
                case '%': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case ';': 
                case '?': 
                case '@': 
                case ']': 
                case '{': 
                case '}': {
                    n4 = 5;
                    break;
                }
                case '!': 
                case '&': 
                case ':': 
                case '<': 
                case '=': 
                case '>': 
                case '|': 
                case '~': {
                    n4 = 6;
                    break;
                }
                case '.': {
                    n4 = 8;
                    break;
                }
                case '\'': {
                    nArray[i] = 7;
                    n4 = 7;
                    n2 = i;
                    while (cArray[++i] != '\'') {
                        this.checkRunOver(i, n, n2);
                    }
                    break;
                }
                case '[': {
                    if (this.database.getMode().squareBracketQuotedNames) {
                        cArray[i] = 34;
                        bl = true;
                        nArray[i] = 3;
                        n4 = 3;
                        n2 = i;
                        while (cArray[++i] != ']') {
                            this.checkRunOver(i, n, n2);
                        }
                        cArray[i] = 34;
                        break;
                    }
                    n4 = 5;
                    break;
                }
                case '`': {
                    char c2;
                    nArray[i] = 3;
                    n4 = 3;
                    n2 = i;
                    while (cArray[++i] != '`') {
                        this.checkRunOver(i, n, n2);
                        c = cArray[i];
                        if (!this.identifiersToUpper && !this.identifiersToLower || (c2 = this.identifiersToUpper ? Character.toUpperCase(c) : Character.toLowerCase(c)) == c) continue;
                        cArray[i] = c2;
                        bl = true;
                    }
                    break;
                }
                case '\"': {
                    nArray[i] = 3;
                    n4 = 3;
                    n2 = i;
                    while (cArray[++i] != '\"') {
                        this.checkRunOver(i, n, n2);
                    }
                    break;
                }
                case '_': {
                    n4 = 4;
                    break;
                }
                case '#': {
                    if (this.database.getMode().supportPoundSymbolForColumnNames) {
                        n4 = 4;
                        break;
                    }
                    n4 = 5;
                    break;
                }
                default: {
                    char c2;
                    if (c >= 'a' && c <= 'z') {
                        if (this.identifiersToUpper) {
                            cArray[i] = (char)(c - 32);
                            bl = true;
                        }
                        n4 = 4;
                        break;
                    }
                    if (c >= 'A' && c <= 'Z') {
                        if (this.identifiersToLower) {
                            cArray[i] = (char)(c + 32);
                            bl = true;
                        }
                        n4 = 4;
                        break;
                    }
                    if (c >= '0' && c <= '9') {
                        n4 = 2;
                        break;
                    }
                    if (c <= ' ' || Character.isSpaceChar(c)) break;
                    if (Character.isJavaIdentifierPart(c)) {
                        n4 = 4;
                        if (!this.identifiersToUpper && !this.identifiersToLower) break;
                        char c3 = c2 = this.identifiersToUpper ? Character.toUpperCase(c) : Character.toLowerCase(c);
                        if (c2 == c) break;
                        cArray[i] = c2;
                        bl = true;
                        break;
                    }
                    n4 = 5;
                }
            }
            nArray[i] = n4;
            n3 = n4;
        }
        this.sqlCommandChars = cArray;
        nArray[n] = 1;
        this.characterTypes = nArray;
        if (bl) {
            this.sqlCommand = new String(cArray, 0, n);
        }
        this.parseIndex = 0;
    }

    private void checkRunOver(int n, int n2, int n3) {
        if (n >= n2) {
            this.parseIndex = n3;
            throw this.getSyntaxError();
        }
    }

    private int getSpecialType1(char c) {
        switch (c) {
            case '$': 
            case '?': {
                return 62;
            }
            case '@': {
                return 71;
            }
            case '+': {
                return 73;
            }
            case '-': {
                return 72;
            }
            case '*': {
                return 78;
            }
            case ',': {
                return 79;
            }
            case '{': {
                return 81;
            }
            case '}': {
                return 82;
            }
            case '/': {
                return 83;
            }
            case '%': {
                return 84;
            }
            case ';': {
                return 85;
            }
            case ':': {
                return 86;
            }
            case '[': {
                return 87;
            }
            case ']': {
                return 88;
            }
            case '~': {
                return 89;
            }
            case '(': {
                return 75;
            }
            case ')': {
                return 76;
            }
            case '<': {
                return 68;
            }
            case '>': {
                return 67;
            }
            case '=': {
                return 65;
            }
        }
        throw this.getSyntaxError();
    }

    private int getSpecialType2(char c, char c2) {
        switch (c) {
            case ':': {
                if (c2 == ':') {
                    return 90;
                }
                if (c2 != '=') break;
                return 91;
            }
            case '>': {
                if (c2 != '=') break;
                return 66;
            }
            case '<': {
                if (c2 == '=') {
                    return 69;
                }
                if (c2 != '>') break;
                return 70;
            }
            case '!': {
                if (c2 == '=') {
                    return 70;
                }
                if (c2 != '~') break;
                return 92;
            }
            case '|': {
                if (c2 != '|') break;
                return 74;
            }
            case '&': {
                if (c2 != '&') break;
                return 77;
            }
        }
        throw this.getSyntaxError();
    }

    private boolean isKeyword(String string) {
        return ParserUtil.isKeyword(string, !this.identifiersToUpper);
    }

    private Column parseColumnForTable(String string, boolean bl, boolean bl2) {
        String string2;
        Object object;
        Column column;
        boolean bl3 = this.readIf("IDENTITY");
        if (bl3 || this.readIf("BIGSERIAL")) {
            if (bl3 && this.database.getMode().disallowedTypes.contains("IDENTITY")) {
                throw DbException.get(50004, this.currentToken);
            }
            column = new Column(string, 5);
            column.setOriginalSQL("IDENTITY");
            this.parseAutoIncrement(column);
            if (!this.database.getMode().serialColumnIsNotPK) {
                column.setPrimaryKey(true);
            }
        } else if (this.readIf("SERIAL")) {
            column = new Column(string, 4);
            column.setOriginalSQL("SERIAL");
            this.parseAutoIncrement(column);
            if (!this.database.getMode().serialColumnIsNotPK) {
                column.setPrimaryKey(true);
            }
        } else {
            column = this.parseColumnWithType(string, bl2);
        }
        if (this.readIf("INVISIBLE")) {
            column.setVisible(false);
        } else if (this.readIf("VISIBLE")) {
            column.setVisible(true);
        }
        NullConstraintType nullConstraintType = this.parseNotNullConstraint();
        switch (nullConstraintType) {
            case NULL_IS_ALLOWED: {
                column.setNullable(true);
                break;
            }
            case NULL_IS_NOT_ALLOWED: {
                column.setNullable(false);
                break;
            }
            case NO_NULL_CONSTRAINT_FOUND: {
                column.setNullable(bl & column.isNullable());
                break;
            }
            default: {
                throw DbException.get(90088, "Internal Error - unhandled case: " + nullConstraintType.name());
            }
        }
        if (this.readIf("AS")) {
            if (bl3) {
                this.getSyntaxError();
            }
            object = this.readExpression();
            column.setComputedExpression((Expression)object);
        } else if (this.readIf("DEFAULT")) {
            object = this.readExpression();
            column.setDefaultExpression(this.session, (Expression)object);
        } else if (this.readIf("GENERATED")) {
            if (!this.readIf("ALWAYS")) {
                this.read("BY");
                this.read("DEFAULT");
            }
            this.read("AS");
            this.read("IDENTITY");
            object = new SequenceOptions();
            if (this.readIf(75)) {
                this.parseSequenceOptions((SequenceOptions)object, null, true);
                this.read(76);
            }
            column.setAutoIncrementOptions((SequenceOptions)object);
        }
        if (this.readIf(43)) {
            this.read("UPDATE");
            object = this.readExpression();
            column.setOnUpdateExpression(this.session, (Expression)object);
        }
        if (NullConstraintType.NULL_IS_NOT_ALLOWED == this.parseNotNullConstraint()) {
            column.setNullable(false);
        }
        if (this.readIf("AUTO_INCREMENT") || this.readIf("BIGSERIAL") || this.readIf("SERIAL")) {
            this.parseAutoIncrement(column);
            this.parseNotNullConstraint();
        } else if (this.readIf("IDENTITY")) {
            this.parseAutoIncrement(column);
            column.setPrimaryKey(true);
            this.parseNotNullConstraint();
        }
        if (this.readIf("NULL_TO_DEFAULT")) {
            column.setConvertNullToDefault(true);
        }
        if (this.readIf("SEQUENCE")) {
            object = this.readSequence();
            column.setSequence((Sequence)object);
        }
        if (this.readIf("SELECTIVITY")) {
            int n = this.readNonNegativeInt();
            column.setSelectivity(n);
        }
        if ((string2 = this.readCommentIf()) != null) {
            column.setComment(string2);
        }
        return column;
    }

    private void parseAutoIncrement(Column column) {
        SequenceOptions sequenceOptions = new SequenceOptions();
        if (this.readIf(75)) {
            sequenceOptions.setStartValue(ValueExpression.get(ValueLong.get(this.readLong())));
            if (this.readIf(79)) {
                sequenceOptions.setIncrement(ValueExpression.get(ValueLong.get(this.readLong())));
            }
            this.read(76);
        }
        column.setAutoIncrementOptions(sequenceOptions);
    }

    private String readCommentIf() {
        if (this.readIf("COMMENT")) {
            this.readIf(31);
            return this.readString();
        }
        return null;
    }

    private Column parseColumnWithType(String string, boolean bl) {
        Object object;
        Object object2;
        DataType dataType;
        Object object3;
        Domain domain;
        String string2 = this.currentToken;
        boolean bl2 = false;
        int n = -1;
        int n2 = -1;
        if (this.readIf("LONG")) {
            if (this.readIf("RAW")) {
                string2 = "LONG RAW";
            }
        } else if (this.readIf("DOUBLE")) {
            if (this.readIf("PRECISION")) {
                string2 = "DOUBLE PRECISION";
            }
        } else if (this.readIf("CHARACTER")) {
            if (this.readIf("VARYING")) {
                string2 = "CHARACTER VARYING";
            } else if (this.readIf("LARGE")) {
                this.read("OBJECT");
                string2 = "CHARACTER LARGE OBJECT";
            }
        } else if (this.readIf("BINARY")) {
            if (this.readIf("VARYING")) {
                string2 = "BINARY VARYING";
            } else if (this.readIf("LARGE")) {
                this.read("OBJECT");
                string2 = "BINARY LARGE OBJECT";
            }
        } else if (this.readIf("TIME")) {
            if (this.readIf(75)) {
                n2 = this.readNonNegativeInt();
                if (n2 > 9) {
                    throw DbException.get(90051, Integer.toString(n2));
                }
                this.read(76);
            }
            if (this.readIf(61)) {
                this.read("TIME");
                this.read("ZONE");
                string2 = "TIME WITH TIME ZONE";
            } else if (this.readIf("WITHOUT")) {
                this.read("TIME");
                this.read("ZONE");
                string2 = "TIME WITHOUT TIME ZONE";
            }
        } else if (this.readIf("TIMESTAMP")) {
            if (this.readIf(75)) {
                n2 = this.readNonNegativeInt();
                if (this.readIf(79)) {
                    n2 = this.readNonNegativeInt();
                }
                if (n2 > 9) {
                    throw DbException.get(90051, Integer.toString(n2));
                }
                this.read(76);
            }
            if (this.readIf(61)) {
                this.read("TIME");
                this.read("ZONE");
                string2 = "TIMESTAMP WITH TIME ZONE";
            } else if (this.readIf("WITHOUT")) {
                this.read("TIME");
                this.read("ZONE");
                string2 = "TIMESTAMP WITHOUT TIME ZONE";
            }
        } else if (this.readIf(30)) {
            if (this.readIf("YEAR")) {
                if (this.readIf(75)) {
                    n = this.readNonNegativeInt();
                    this.read(76);
                }
                if (this.readIf("TO")) {
                    this.read("MONTH");
                    string2 = "INTERVAL YEAR TO MONTH";
                } else {
                    string2 = "INTERVAL YEAR";
                }
            } else if (this.readIf("MONTH")) {
                if (this.readIf(75)) {
                    n = this.readNonNegativeInt();
                    this.read(76);
                }
                string2 = "INTERVAL MONTH";
            } else if (this.readIf("DAY")) {
                if (this.readIf(75)) {
                    n = this.readNonNegativeInt();
                    this.read(76);
                }
                if (this.readIf("TO")) {
                    if (this.readIf("HOUR")) {
                        string2 = "INTERVAL DAY TO HOUR";
                    } else if (this.readIf("MINUTE")) {
                        string2 = "INTERVAL DAY TO MINUTE";
                    } else {
                        this.read("SECOND");
                        if (this.readIf(75)) {
                            n2 = this.readNonNegativeInt();
                            this.read(76);
                        }
                        string2 = "INTERVAL DAY TO SECOND";
                    }
                } else {
                    string2 = "INTERVAL DAY";
                }
            } else if (this.readIf("HOUR")) {
                if (this.readIf(75)) {
                    n = this.readNonNegativeInt();
                    this.read(76);
                }
                if (this.readIf("TO")) {
                    if (this.readIf("MINUTE")) {
                        string2 = "INTERVAL HOUR TO MINUTE";
                    } else {
                        this.read("SECOND");
                        if (this.readIf(75)) {
                            n2 = this.readNonNegativeInt();
                            this.read(76);
                        }
                        string2 = "INTERVAL HOUR TO SECOND";
                    }
                } else {
                    string2 = "INTERVAL HOUR";
                }
            } else if (this.readIf("MINUTE")) {
                if (this.readIf(75)) {
                    n = this.readNonNegativeInt();
                    this.read(76);
                }
                if (this.readIf("TO")) {
                    this.read("SECOND");
                    if (this.readIf(75)) {
                        n2 = this.readNonNegativeInt();
                        this.read(76);
                    }
                    string2 = "INTERVAL MINUTE TO SECOND";
                } else {
                    string2 = "INTERVAL MINUTE";
                }
            } else {
                this.read("SECOND");
                if (this.readIf(75)) {
                    n = this.readNonNegativeInt();
                    if (this.readIf(79)) {
                        n2 = this.readNonNegativeInt();
                    }
                    this.read(76);
                }
                string2 = "INTERVAL SECOND";
            }
        } else {
            bl2 = true;
        }
        long l = -1L;
        ExtTypeInfo extTypeInfo = null;
        int n3 = -1;
        String string3 = null;
        Column column = null;
        if (!this.identifiersToUpper) {
            string2 = StringUtils.toUpperEnglish(string2);
        }
        if ((domain = this.database.findDomain(string2)) != null) {
            column = domain.getColumn();
            object3 = column.getType();
            dataType = DataType.getDataType(((TypeInfo)object3).getValueType());
            string3 = column.getComment();
            string2 = bl ? domain.getSQL(true) : column.getOriginalSQL();
            l = ((TypeInfo)object3).getPrecision();
            n3 = ((TypeInfo)object3).getScale();
            extTypeInfo = ((TypeInfo)object3).getExtTypeInfo();
        } else {
            object3 = this.database.getMode();
            dataType = DataType.getTypeByName(string2, (Mode)object3);
            if (dataType == null || ((Mode)object3).disallowedTypes.contains(string2)) {
                throw DbException.get(50004, this.currentToken);
            }
        }
        int n4 = dataType.type;
        if (this.database.getIgnoreCase() && n4 == 13 && !this.equalsToken("VARCHAR_CASESENSITIVE", string2)) {
            string2 = "VARCHAR_IGNORECASE";
            dataType = DataType.getTypeByName(string2, this.database.getMode());
        }
        if (bl2) {
            this.read();
        }
        l = l == -1L ? dataType.defaultPrecision : l;
        int n5 = n3 = n3 == -1 ? dataType.defaultScale : n3;
        if (dataType.supportsPrecision || dataType.supportsScale) {
            if (n4 == 9 || n4 == 11 || n4 == 24 || n4 == 41) {
                if (n2 >= 0) {
                    n3 = n2;
                    switch (n4) {
                        case 9: {
                            if (string2.equals("TIME WITHOUT TIME ZONE")) {
                                string2 = "TIME(" + n2 + ") WITHOUT TIME ZONE";
                                break;
                            }
                            string2 = string2 + '(' + n2 + ')';
                            break;
                        }
                        case 41: {
                            string2 = "TIME(" + n2 + ") WITH TIME ZONE";
                            break;
                        }
                        case 11: {
                            if (string2.equals("TIMESTAMP WITHOUT TIME ZONE")) {
                                string2 = "TIMESTAMP(" + n2 + ") WITHOUT TIME ZONE";
                                break;
                            }
                            string2 = string2 + '(' + n2 + ')';
                            break;
                        }
                        case 24: {
                            string2 = "TIMESTAMP(" + n2 + ") WITH TIME ZONE";
                        }
                    }
                } else if (string2.equals("DATETIME") || string2.equals("DATETIME2")) {
                    if (this.readIf(75)) {
                        n2 = this.readNonNegativeInt();
                        if (n2 > 9) {
                            throw DbException.get(90051, Integer.toString(n2));
                        }
                        this.read(76);
                        n3 = n2;
                        string2 = string2 + '(' + n2 + ')';
                    }
                } else if (string2.equals("SMALLDATETIME")) {
                    n3 = 0;
                }
            } else if (n4 == 17) {
                if (this.readIf(87)) {
                    l = this.readNonNegativeInt();
                    this.read(88);
                    string2 = string2 + '[' + l + ']';
                }
            } else if (DataType.isIntervalType(n4)) {
                if (n >= 0 || n2 >= 0) {
                    IntervalQualifier intervalQualifier = IntervalQualifier.valueOf(n4 - 26);
                    string2 = intervalQualifier.getTypeName(n, n2);
                    if (n >= 0) {
                        if (n <= 0 || n > 18) {
                            throw DbException.get(90051, Integer.toString(n));
                        }
                        l = n;
                    }
                    if (n2 >= 0) {
                        if (n2 > 9) {
                            throw DbException.get(90051, Integer.toString(n2));
                        }
                        n3 = n2;
                    }
                }
            } else if (this.readIf(75)) {
                if (!this.readIf("MAX")) {
                    long l2 = this.readPrecision();
                    string2 = string2 + "(" + l2;
                    if (dataType.supportsScale) {
                        if (this.readIf(79)) {
                            n3 = this.readInt();
                            string2 = string2 + ", " + n3;
                        } else {
                            n3 = 0;
                        }
                    }
                    l = l2;
                    string2 = string2 + ")";
                }
                this.read(76);
            }
        } else if (n4 == 7 && string2.equals("FLOAT")) {
            if (this.readIf(75)) {
                int n6 = this.readNonNegativeInt();
                this.read(76);
                if (n6 > 53) {
                    throw DbException.get(90051, Integer.toString(n6));
                }
                if (n6 <= 24) {
                    dataType = DataType.getDataType(8);
                }
                string2 = string2 + '(' + n6 + ')';
            }
        } else if (n4 == 25) {
            if (extTypeInfo == null) {
                String[] stringArray = null;
                if (this.readIf(75)) {
                    object2 = new ArrayList<String>();
                    String string4 = this.readString();
                    ((ArrayList)object2).add(string4);
                    while (this.readIfMore()) {
                        object = this.readString();
                        ((ArrayList)object2).add(object);
                    }
                    stringArray = ((ArrayList)object2).toArray(new String[0]);
                }
                try {
                    extTypeInfo = new ExtTypeInfoEnum(stringArray);
                }
                catch (DbException dbException) {
                    throw dbException.addSQL(string2);
                }
                string2 = string2 + extTypeInfo.getCreateSQL();
            }
        } else if (n4 == 22) {
            if (extTypeInfo == null && this.readIf(75)) {
                int n7 = 0;
                if (this.currentTokenType != 2 || this.currentTokenQuoted) {
                    throw this.getSyntaxError();
                }
                if (!this.readIf("GEOMETRY")) {
                    try {
                        n7 = EWKTUtils.parseGeometryType(this.currentToken);
                        this.read();
                        if (n7 / 1000 == 0 && this.currentTokenType == 2 && !this.currentTokenQuoted) {
                            n7 += EWKTUtils.parseDimensionSystem(this.currentToken) * 1000;
                            this.read();
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw this.getSyntaxError();
                    }
                }
                object2 = null;
                if (this.readIf(79)) {
                    object2 = this.readInt();
                }
                this.read(76);
                extTypeInfo = new ExtTypeInfoGeometry(n7, (Integer)object2);
                string2 = string2 + extTypeInfo.getCreateSQL();
            }
        } else if (this.readIf(75)) {
            this.readNonNegativeInt();
            this.read(76);
        }
        if (this.readIf(20)) {
            this.read("BIT");
            this.read("DATA");
            if (dataType.type == 13) {
                dataType = DataType.getTypeByName("BINARY", this.database.getMode());
            }
        }
        this.readIf("UNSIGNED");
        int n8 = dataType.type;
        if ((long)n3 > l && dataType.supportsPrecision && dataType.supportsScale && !DataType.isIntervalType(n8)) {
            throw DbException.get(90051, Integer.toString(n3), Long.toString(l));
        }
        object2 = new Column(string, TypeInfo.getTypeInfo(n8, l, n3, extTypeInfo));
        if (column != null) {
            ((Column)object2).setNullable(column.isNullable());
            ((Column)object2).setDefaultExpression(this.session, column.getDefaultExpression());
            int n9 = column.getSelectivity();
            if (n9 != 50) {
                ((Column)object2).setSelectivity(n9);
            }
            object = column.getCheckConstraint(this.session, string);
            ((Column)object2).addCheckConstraint(this.session, (Expression)object);
        }
        ((Column)object2).setComment(string3);
        ((Column)object2).setOriginalSQL(string2);
        if (bl) {
            ((Column)object2).setDomain(domain);
        }
        return object2;
    }

    private long readPrecision() {
        long l = this.readNonNegativeLong();
        if (this.currentTokenType == 2 && !this.currentTokenQuoted && this.currentToken.length() == 1) {
            long l2;
            switch (this.currentToken.charAt(0) & 0xFFDF) {
                case 75: {
                    l2 = 1024L;
                    break;
                }
                case 77: {
                    l2 = 0x100000L;
                    break;
                }
                case 71: {
                    l2 = 0x40000000L;
                    break;
                }
                case 84: {
                    l2 = 0x10000000000L;
                    break;
                }
                case 80: {
                    l2 = 0x4000000000000L;
                    break;
                }
                default: {
                    throw this.getSyntaxError();
                }
            }
            if (l > Long.MAX_VALUE / l2) {
                throw DbException.getInvalidValueException("precision", l + this.currentToken);
            }
            l *= l2;
            this.read();
        }
        if (!(this.currentTokenType != 2 || this.currentTokenQuoted || this.readIf("CHARACTERS") || this.readIf("OCTETS") || this.readIf("CHAR"))) {
            this.readIf("BYTE");
        }
        return l;
    }

    private Prepared parseCreate() {
        boolean bl = false;
        if (this.readIf("OR")) {
            this.read("REPLACE");
            bl = true;
        }
        boolean bl2 = this.readIf("FORCE");
        if (this.readIf("VIEW")) {
            return this.parseCreateView(bl2, bl);
        }
        if (this.readIf("ALIAS")) {
            return this.parseCreateFunctionAlias(bl2);
        }
        if (this.readIf("SEQUENCE")) {
            return this.parseCreateSequence();
        }
        if (this.readIf("USER")) {
            return this.parseCreateUser();
        }
        if (this.readIf("TRIGGER")) {
            return this.parseCreateTrigger(bl2);
        }
        if (this.readIf("ROLE")) {
            return this.parseCreateRole();
        }
        if (this.readIf("SCHEMA")) {
            return this.parseCreateSchema();
        }
        if (this.readIf("CONSTANT")) {
            return this.parseCreateConstant();
        }
        if (this.readIf("DOMAIN") || this.readIf("TYPE") || this.readIf("DATATYPE")) {
            return this.parseCreateDomain();
        }
        if (this.readIf("AGGREGATE")) {
            return this.parseCreateAggregate(bl2);
        }
        if (this.readIf("LINKED")) {
            return this.parseCreateLinkedTable(false, false, bl2);
        }
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.readIf("MEMORY")) {
            bl3 = true;
        } else if (this.readIf("CACHED")) {
            bl4 = true;
        }
        if (this.readIf("LOCAL")) {
            this.read("TEMPORARY");
            if (this.readIf("LINKED")) {
                return this.parseCreateLinkedTable(true, false, bl2);
            }
            this.read(52);
            return this.parseCreateTable(true, false, bl4);
        }
        if (this.readIf("GLOBAL")) {
            this.read("TEMPORARY");
            if (this.readIf("LINKED")) {
                return this.parseCreateLinkedTable(true, true, bl2);
            }
            this.read(52);
            return this.parseCreateTable(true, true, bl4);
        }
        if (this.readIf("TEMP") || this.readIf("TEMPORARY")) {
            if (this.readIf("LINKED")) {
                return this.parseCreateLinkedTable(true, true, bl2);
            }
            this.read(52);
            return this.parseCreateTable(true, true, bl4);
        }
        if (this.readIf(52)) {
            if (!bl4 && !bl3) {
                bl4 = this.database.getDefaultTableType() == 0;
            }
            return this.parseCreateTable(false, false, bl4);
        }
        if (this.readIf("SYNONYM")) {
            return this.parseCreateSynonym(bl);
        }
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        String string = null;
        Schema schema = null;
        boolean bl9 = false;
        if (this.readIf(45)) {
            this.read("KEY");
            if (this.readIf("HASH")) {
                bl5 = true;
            }
            bl6 = true;
            if (!this.isToken(43)) {
                bl9 = this.readIfNotExists();
                string = this.readIdentifierWithSchema(null);
                schema = this.getSchema();
            }
        } else {
            if (this.readIf(55)) {
                bl7 = true;
            }
            if (this.readIf("HASH")) {
                bl5 = true;
            }
            if (this.readIf("SPATIAL")) {
                bl8 = true;
            }
            if (this.readIf("INDEX")) {
                if (!this.isToken(43)) {
                    bl9 = this.readIfNotExists();
                    string = this.readIdentifierWithSchema(null);
                    schema = this.getSchema();
                }
            } else {
                throw this.getSyntaxError();
            }
        }
        this.read(43);
        String string2 = this.readIdentifierWithSchema();
        this.checkSchema(schema);
        CreateIndex createIndex = new CreateIndex(this.session, this.getSchema());
        createIndex.setIfNotExists(bl9);
        createIndex.setPrimaryKey(bl6);
        createIndex.setTableName(string2);
        createIndex.setUnique(bl7);
        createIndex.setIndexName(string);
        createIndex.setComment(this.readCommentIf());
        this.read(75);
        createIndex.setIndexColumns(this.parseIndexColumnList());
        if (this.readIf(57)) {
            if (bl5) {
                throw this.getSyntaxError();
            }
            if (bl8) {
                throw this.getSyntaxError();
            }
            if (!this.readIf("BTREE")) {
                if (this.readIf("RTREE")) {
                    bl8 = true;
                } else if (this.readIf("HASH")) {
                    bl5 = true;
                } else {
                    throw this.getSyntaxError();
                }
            }
        }
        createIndex.setHash(bl5);
        createIndex.setSpatial(bl8);
        return createIndex;
    }

    private boolean addRoleOrRight(GrantRevoke grantRevoke) {
        if (this.readIf(51)) {
            grantRevoke.addRight(1);
            return true;
        }
        if (this.readIf("DELETE")) {
            grantRevoke.addRight(2);
            return true;
        }
        if (this.readIf("INSERT")) {
            grantRevoke.addRight(4);
            return true;
        }
        if (this.readIf("UPDATE")) {
            grantRevoke.addRight(8);
            return true;
        }
        if (this.readIf(3)) {
            grantRevoke.addRight(15);
            return true;
        }
        if (this.readIf("ALTER")) {
            this.read("ANY");
            this.read("SCHEMA");
            grantRevoke.addRight(16);
            grantRevoke.addTable(null);
            return false;
        }
        if (this.readIf("CONNECT")) {
            return true;
        }
        if (this.readIf("RESOURCE")) {
            return true;
        }
        grantRevoke.addRoleName(this.readUniqueIdentifier());
        return false;
    }

    private GrantRevoke parseGrantRevoke(int n) {
        GrantRevoke grantRevoke = new GrantRevoke(this.session);
        grantRevoke.setOperationType(n);
        boolean bl = this.addRoleOrRight(grantRevoke);
        while (this.readIf(79)) {
            this.addRoleOrRight(grantRevoke);
            if (!grantRevoke.isRightMode() || !grantRevoke.isRoleMode()) continue;
            throw DbException.get(90072);
        }
        if (bl && this.readIf(43)) {
            if (this.readIf("SCHEMA")) {
                Schema schema = this.database.getSchema(this.readAliasIdentifier());
                grantRevoke.setSchema(schema);
            } else {
                do {
                    Table table = this.readTableOrView();
                    grantRevoke.addTable(table);
                } while (this.readIf(79));
            }
        }
        if (n == 49) {
            this.read("TO");
        } else {
            this.read(22);
        }
        grantRevoke.setGranteeName(this.readUniqueIdentifier());
        return grantRevoke;
    }

    private TableValueConstructor parseValues() {
        int n;
        ArrayList<Column> arrayList = Utils.newSmallArrayList();
        ArrayList<ArrayList<Expression>> arrayList2 = Utils.newSmallArrayList();
        do {
            boolean bl;
            n = 0;
            ArrayList arrayList3 = Utils.newSmallArrayList();
            if (this.readIf(48)) {
                this.read(75);
                bl = true;
            } else {
                bl = this.readIf(75);
            }
            do {
                Column column;
                Expression expression = this.readExpression();
                expression = expression.optimize(this.session);
                TypeInfo typeInfo = expression.getType();
                String string = "C" + (n + 1);
                if (arrayList2.isEmpty()) {
                    if (typeInfo.getValueType() == -1) {
                        typeInfo = TypeInfo.TYPE_STRING;
                    }
                    column = new Column(string, typeInfo);
                    arrayList.add(column);
                } else {
                    if (n >= arrayList.size()) {
                        throw DbException.get(21002);
                    }
                    typeInfo = Value.getHigherType(((Column)arrayList.get(n)).getType(), typeInfo);
                    column = new Column(string, typeInfo);
                    arrayList.set(n, column);
                }
                arrayList3.add(expression);
                ++n;
            } while (bl && this.readIfMore());
            arrayList2.add(arrayList3);
        } while (this.readIf(79));
        n = arrayList.size();
        for (ArrayList arrayList4 : arrayList2) {
            if (arrayList4.size() == n) continue;
            throw DbException.get(21002);
        }
        for (int i = 0; i < n; ++i) {
            Column column = (Column)arrayList.get(i);
            if (column.getType().getValueType() != -1) continue;
            Column column2 = new Column(column.getName(), 13);
            arrayList.set(i, column2);
        }
        return new TableValueConstructor(this.session, arrayList.toArray(new Column[0]), arrayList2);
    }

    private Call parseCall() {
        Call call = new Call(this.session);
        this.currentPrepared = call;
        call.setExpression(this.readExpression());
        return call;
    }

    private CreateRole parseCreateRole() {
        CreateRole createRole = new CreateRole(this.session);
        createRole.setIfNotExists(this.readIfNotExists());
        createRole.setRoleName(this.readUniqueIdentifier());
        return createRole;
    }

    private CreateSchema parseCreateSchema() {
        CreateSchema createSchema = new CreateSchema(this.session);
        createSchema.setIfNotExists(this.readIfNotExists());
        createSchema.setSchemaName(this.readUniqueIdentifier());
        if (this.readIf("AUTHORIZATION")) {
            createSchema.setAuthorization(this.readUniqueIdentifier());
        } else {
            createSchema.setAuthorization(this.session.getUser().getName());
        }
        if (this.readIf(61)) {
            createSchema.setTableEngineParams(this.readTableEngineParams());
        }
        return createSchema;
    }

    private ArrayList<String> readTableEngineParams() {
        ArrayList<String> arrayList = Utils.newSmallArrayList();
        do {
            arrayList.add(this.readUniqueIdentifier());
        } while (this.readIf(79));
        return arrayList;
    }

    private CreateSequence parseCreateSequence() {
        boolean bl = this.readIfNotExists();
        String string = this.readIdentifierWithSchema();
        CreateSequence createSequence = new CreateSequence(this.session, this.getSchema());
        createSequence.setIfNotExists(bl);
        createSequence.setSequenceName(string);
        SequenceOptions sequenceOptions = new SequenceOptions();
        this.parseSequenceOptions(sequenceOptions, createSequence, true);
        createSequence.setOptions(sequenceOptions);
        return createSequence;
    }

    private boolean readIfNotExists() {
        if (this.readIf(26)) {
            this.read(40);
            this.read(17);
            return true;
        }
        return false;
    }

    private boolean readIfAffinity() {
        return this.readIf("AFFINITY") || this.readIf("SHARD");
    }

    private CreateConstant parseCreateConstant() {
        boolean bl = this.readIfNotExists();
        String string = this.readIdentifierWithSchema();
        Schema schema = this.getSchema();
        if (this.isKeyword(string)) {
            throw DbException.get(90114, string);
        }
        this.read("VALUE");
        Expression expression = this.readExpression();
        CreateConstant createConstant = new CreateConstant(this.session, schema);
        createConstant.setConstantName(string);
        createConstant.setExpression(expression);
        createConstant.setIfNotExists(bl);
        return createConstant;
    }

    private CreateAggregate parseCreateAggregate(boolean bl) {
        boolean bl2 = this.readIfNotExists();
        CreateAggregate createAggregate = new CreateAggregate(this.session);
        createAggregate.setForce(bl);
        String string = this.readIdentifierWithSchema();
        if (this.isKeyword(string) || Function.getFunction(this.database, string) != null || this.getAggregateType(string) != null) {
            throw DbException.get(90076, string);
        }
        createAggregate.setName(string);
        createAggregate.setSchema(this.getSchema());
        createAggregate.setIfNotExists(bl2);
        this.read(20);
        createAggregate.setJavaClassMethod(this.readUniqueIdentifier());
        return createAggregate;
    }

    private CreateDomain parseCreateDomain() {
        boolean bl = this.readIfNotExists();
        CreateDomain createDomain = new CreateDomain(this.session);
        createDomain.setTypeName(this.readUniqueIdentifier());
        this.read("AS");
        Column column = this.parseColumnForTable("VALUE", true, false);
        if (this.readIf(6)) {
            Expression expression = this.readExpression();
            column.addCheckConstraint(this.session, expression);
        }
        column.rename(null);
        createDomain.setColumn(column);
        createDomain.setIfNotExists(bl);
        return createDomain;
    }

    private CreateTrigger parseCreateTrigger(boolean bl) {
        boolean bl2;
        boolean bl3;
        boolean bl4 = this.readIfNotExists();
        String string = this.readIdentifierWithSchema(null);
        Schema schema = this.getSchema();
        if (this.readIf("INSTEAD")) {
            this.read("OF");
            bl3 = true;
            bl2 = true;
        } else if (this.readIf("BEFORE")) {
            bl2 = false;
            bl3 = true;
        } else {
            this.read("AFTER");
            bl2 = false;
            bl3 = false;
        }
        int n = 0;
        boolean bl5 = false;
        do {
            if (this.readIf("INSERT")) {
                n |= 1;
                continue;
            }
            if (this.readIf("UPDATE")) {
                n |= 2;
                continue;
            }
            if (this.readIf("DELETE")) {
                n |= 4;
                continue;
            }
            if (this.readIf(51)) {
                n |= 8;
                continue;
            }
            if (this.readIf("ROLLBACK")) {
                bl5 = true;
                continue;
            }
            throw this.getSyntaxError();
        } while (this.readIf(79) || this.database.getMode().getEnum() == Mode.ModeEnum.PostgreSQL && this.readIf("OR"));
        this.read(43);
        String string2 = this.readIdentifierWithSchema();
        this.checkSchema(schema);
        CreateTrigger createTrigger = new CreateTrigger(this.session, this.getSchema());
        createTrigger.setForce(bl);
        createTrigger.setTriggerName(string);
        createTrigger.setIfNotExists(bl4);
        createTrigger.setInsteadOf(bl2);
        createTrigger.setBefore(bl3);
        createTrigger.setOnRollback(bl5);
        createTrigger.setTypeMask(n);
        createTrigger.setTableName(string2);
        if (this.readIf(20)) {
            this.read("EACH");
            this.read(48);
            createTrigger.setRowBased(true);
        } else {
            createTrigger.setRowBased(false);
        }
        if (this.readIf("QUEUE")) {
            createTrigger.setQueueSize(this.readNonNegativeInt());
        }
        createTrigger.setNoWait(this.readIf("NOWAIT"));
        if (this.readIf("AS")) {
            createTrigger.setTriggerSource(this.readString());
        } else {
            this.read("CALL");
            createTrigger.setTriggerClassName(this.readUniqueIdentifier());
        }
        return createTrigger;
    }

    private CreateUser parseCreateUser() {
        CreateUser createUser = new CreateUser(this.session);
        createUser.setIfNotExists(this.readIfNotExists());
        createUser.setUserName(this.readUniqueIdentifier());
        createUser.setComment(this.readCommentIf());
        if (this.readIf("PASSWORD")) {
            createUser.setPassword(this.readExpression());
        } else if (this.readIf("SALT")) {
            createUser.setSalt(this.readExpression());
            this.read("HASH");
            createUser.setHash(this.readExpression());
        } else if (this.readIf("IDENTIFIED")) {
            this.read("BY");
            createUser.setPassword(ValueExpression.get(ValueString.get(this.readColumnIdentifier())));
        } else {
            throw this.getSyntaxError();
        }
        if (this.readIf("ADMIN")) {
            createUser.setAdmin(true);
        }
        return createUser;
    }

    private CreateFunctionAlias parseCreateFunctionAlias(boolean bl) {
        boolean bl2;
        String string;
        boolean bl3 = this.readIfNotExists();
        if (this.currentTokenType != 2) {
            string = this.currentToken;
            this.read();
            this.schemaName = this.session.getCurrentSchemaName();
        } else {
            string = this.readIdentifierWithSchema();
        }
        boolean bl4 = bl2 = Function.getFunction(this.database, string) != null;
        if (!(this.database.isAllowBuiltinAliasOverride() && bl2 || !this.isKeyword(string) && !bl2 && this.getAggregateType(string) == null)) {
            throw DbException.get(90076, string);
        }
        CreateFunctionAlias createFunctionAlias = new CreateFunctionAlias(this.session, this.getSchema());
        createFunctionAlias.setForce(bl);
        createFunctionAlias.setAliasName(string);
        createFunctionAlias.setIfNotExists(bl3);
        createFunctionAlias.setDeterministic(this.readIf("DETERMINISTIC"));
        this.readIf("NOBUFFER");
        if (this.readIf("AS")) {
            createFunctionAlias.setSource(this.readString());
        } else {
            this.read(20);
            createFunctionAlias.setJavaClassMethod(this.readUniqueIdentifier());
        }
        return createFunctionAlias;
    }

    private Prepared parseWith() {
        ArrayList<TableView> arrayList = new ArrayList<TableView>();
        try {
            return this.parseWith1(arrayList);
        }
        catch (Throwable throwable) {
            CommandContainer.clearCTE(this.session, arrayList);
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Prepared parseWith1(List<TableView> list) {
        Prepared prepared;
        this.readIf("RECURSIVE");
        boolean bl = !this.session.isParsingCreateView();
        do {
            list.add(this.parseSingleCommonTableExpression(bl));
        } while (this.readIf(79));
        Collections.reverse(list);
        int n = 0;
        while (this.readIf(75)) {
            ++n;
        }
        if (this.isToken(51) || this.isToken(58)) {
            prepared = this.parseWithQuery();
        } else if (this.isToken(52)) {
            int n2 = this.lastParseIndex;
            this.read();
            if (this.isToken(75)) throw DbException.get(42000, WITH_STATEMENT_SUPPORTS_LIMITED_SUB_STATEMENTS);
            this.parseIndex = n2;
            this.read();
            prepared = this.parseWithQuery();
        } else if (this.readIf("INSERT")) {
            prepared = this.parseInsert();
            prepared.setPrepareAlways(true);
        } else if (this.readIf("UPDATE")) {
            prepared = this.parseUpdate();
            prepared.setPrepareAlways(true);
        } else if (this.readIf("MERGE")) {
            prepared = this.parseMerge();
            prepared.setPrepareAlways(true);
        } else if (this.readIf("DELETE")) {
            prepared = this.parseDelete();
            prepared.setPrepareAlways(true);
        } else {
            if (!this.readIf("CREATE")) throw DbException.get(42000, WITH_STATEMENT_SUPPORTS_LIMITED_SUB_STATEMENTS);
            if (!this.isToken(52)) {
                throw DbException.get(42000, WITH_STATEMENT_SUPPORTS_LIMITED_SUB_STATEMENTS);
            }
            prepared = this.parseCreate();
            prepared.setPrepareAlways(true);
        }
        while (n > 0) {
            this.read(76);
            --n;
        }
        if (!bl) return prepared;
        prepared.setCteCleanups(list);
        return prepared;
    }

    private Prepared parseWithQuery() {
        Query query = this.parseSelectUnion();
        query.setPrepareAlways(true);
        query.setNeverLazy(true);
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableView parseSingleCommonTableExpression(boolean bl) {
        List<Column> list;
        String[] stringArray;
        Object object;
        String string = this.readIdentifierWithSchema();
        Schema schema = this.getSchema();
        ArrayList<Column> arrayList = Utils.newSmallArrayList();
        String[] stringArray2 = null;
        if (this.readIf(75)) {
            stringArray2 = this.parseColumnList();
            object = stringArray2;
            int n = ((String[])object).length;
            for (int i = 0; i < n; ++i) {
                stringArray = object[i];
                arrayList.add(new Column((String)stringArray, 13));
            }
        }
        if ((object = !bl ? this.getSchema().findTableOrView(this.session, string) : this.session.findLocalTempTable(string)) != null) {
            if (!(object instanceof TableView)) {
                throw DbException.get(42101, string);
            }
            TableView tableView = (TableView)object;
            if (!tableView.isTableExpression()) {
                throw DbException.get(42101, string);
            }
            if (!bl) {
                ((Table)object).lock(this.session, true, true);
                this.database.removeSchemaObject(this.session, (SchemaObject)object);
            } else {
                this.session.removeLocalTempTable((Table)object);
            }
        }
        Table table = TableView.createShadowTableForRecursiveTableExpression(bl, this.session, string, schema, arrayList, this.database);
        stringArray = new String[]{null};
        try {
            this.read("AS");
            this.read(75);
            Query query = this.parseQuery();
            if (!bl) {
                query.session = this.session;
            }
            this.read(76);
            list = TableView.createQueryColumnTemplateList(stringArray2, query, stringArray);
        }
        finally {
            TableView.destroyShadowTableForRecursiveExpression(bl, this.session, table);
        }
        return this.createCTEView(string, stringArray[0], list, true, true, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableView createCTEView(String string, String string2, List<Column> list, boolean bl, boolean bl2, boolean bl3) {
        TableView tableView;
        Schema schema = this.getSchemaWithDefault();
        int n = this.database.allocateObjectId();
        Column[] columnArray = list.toArray(new Column[0]);
        Session session = this.session;
        synchronized (session) {
            tableView = new TableView(schema, n, string, string2, this.parameters, columnArray, this.session, bl, false, true, bl3);
            if (!tableView.isRecursiveQueryDetected() && bl) {
                if (!bl3) {
                    this.database.addSchemaObject(this.session, tableView);
                    tableView.lock(this.session, true, true);
                    this.database.removeSchemaObject(this.session, tableView);
                } else {
                    this.session.removeLocalTempTable(tableView);
                }
                tableView = new TableView(schema, n, string, string2, this.parameters, columnArray, this.session, false, false, true, bl3);
            }
            this.database.unlockMeta(this.session);
        }
        tableView.setTableExpression(true);
        tableView.setTemporary(bl3);
        tableView.setHidden(true);
        tableView.setOnCommitDrop(false);
        if (bl2) {
            if (!bl3) {
                this.database.addSchemaObject(this.session, tableView);
                tableView.unlock(this.session);
                this.database.unlockMeta(this.session);
            } else {
                this.session.addLocalTempTable(tableView);
            }
        }
        return tableView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CreateView parseCreateView(boolean bl, boolean bl2) {
        Object object;
        CreateView createView;
        boolean bl3 = this.readIfNotExists();
        boolean bl4 = this.readIf("TABLE_EXPRESSION");
        String string = this.readIdentifierWithSchema();
        this.createView = createView = new CreateView(this.session, this.getSchema());
        createView.setViewName(string);
        createView.setIfNotExists(bl3);
        createView.setComment(this.readCommentIf());
        createView.setOrReplace(bl2);
        createView.setForce(bl);
        createView.setTableExpression(bl4);
        if (this.readIf(75)) {
            object = this.parseColumnList();
            createView.setColumnNames((String[])object);
        }
        object = StringUtils.cache(this.sqlCommand.substring(this.parseIndex));
        this.read("AS");
        try {
            Query query;
            this.session.setParsingCreateView(true, string);
            try {
                query = this.parseQuery();
                query.prepare();
            }
            finally {
                this.session.setParsingCreateView(false, string);
            }
            createView.setSelect(query);
        }
        catch (DbException dbException) {
            if (bl) {
                createView.setSelectSQL((String)object);
                while (this.currentTokenType != 63) {
                    this.read();
                }
            }
            throw dbException;
        }
        return createView;
    }

    private TransactionCommand parseCheckpoint() {
        TransactionCommand transactionCommand = this.readIf("SYNC") ? new TransactionCommand(this.session, 76) : new TransactionCommand(this.session, 73);
        return transactionCommand;
    }

    private Prepared parseAlter() {
        if (this.readIf(52)) {
            return this.parseAlterTable();
        }
        if (this.readIf("USER")) {
            return this.parseAlterUser();
        }
        if (this.readIf("INDEX")) {
            return this.parseAlterIndex();
        }
        if (this.readIf("SCHEMA")) {
            return this.parseAlterSchema();
        }
        if (this.readIf("SEQUENCE")) {
            return this.parseAlterSequence();
        }
        if (this.readIf("VIEW")) {
            return this.parseAlterView();
        }
        throw this.getSyntaxError();
    }

    private void checkSchema(Schema schema) {
        if (schema != null && this.getSchema() != schema) {
            throw DbException.get(90080);
        }
    }

    private AlterIndexRename parseAlterIndex() {
        boolean bl = this.readIfExists(false);
        String string = this.readIdentifierWithSchema();
        Schema schema = this.getSchema();
        AlterIndexRename alterIndexRename = new AlterIndexRename(this.session);
        alterIndexRename.setOldSchema(schema);
        alterIndexRename.setOldName(string);
        alterIndexRename.setIfExists(bl);
        this.read("RENAME");
        this.read("TO");
        String string2 = this.readIdentifierWithSchema(schema.getName());
        this.checkSchema(schema);
        alterIndexRename.setNewName(string2);
        return alterIndexRename;
    }

    private DefineCommand parseAlterView() {
        boolean bl = this.readIfExists(false);
        String string = this.readIdentifierWithSchema();
        Schema schema = this.getSchema();
        Table table = schema.findTableOrView(this.session, string);
        if (!(table instanceof TableView) && !bl) {
            throw DbException.get(90037, string);
        }
        if (this.readIf("RENAME")) {
            this.read("TO");
            String string2 = this.readIdentifierWithSchema(schema.getName());
            this.checkSchema(schema);
            AlterTableRename alterTableRename = new AlterTableRename(this.session, this.getSchema());
            alterTableRename.setOldTableName(string);
            alterTableRename.setNewTableName(string2);
            alterTableRename.setIfTableExists(bl);
            return alterTableRename;
        }
        this.read("RECOMPILE");
        TableView tableView = (TableView)table;
        AlterView alterView = new AlterView(this.session);
        alterView.setIfExists(bl);
        alterView.setView(tableView);
        return alterView;
    }

    private Prepared parseAlterSchema() {
        boolean bl = this.readIfExists(false);
        String string = this.readIdentifierWithSchema();
        Schema schema = this.getSchema();
        this.read("RENAME");
        this.read("TO");
        String string2 = this.readIdentifierWithSchema(schema.getName());
        Schema schema2 = this.findSchema(string);
        if (schema2 == null) {
            if (bl) {
                return new NoOperation(this.session);
            }
            throw DbException.get(90079, string);
        }
        AlterSchemaRename alterSchemaRename = new AlterSchemaRename(this.session);
        alterSchemaRename.setOldSchema(schema2);
        this.checkSchema(schema);
        alterSchemaRename.setNewName(string2);
        return alterSchemaRename;
    }

    private AlterSequence parseAlterSequence() {
        boolean bl = this.readIfExists(false);
        String string = this.readIdentifierWithSchema();
        AlterSequence alterSequence = new AlterSequence(this.session, this.getSchema());
        alterSequence.setSequenceName(string);
        alterSequence.setIfExists(bl);
        SequenceOptions sequenceOptions = new SequenceOptions();
        this.parseSequenceOptions(sequenceOptions, null, false);
        alterSequence.setOptions(sequenceOptions);
        return alterSequence;
    }

    private void parseSequenceOptions(SequenceOptions sequenceOptions, CreateSequence createSequence, boolean bl) {
        while (true) {
            if (this.readIf(bl ? "START" : "RESTART")) {
                this.readIf(61);
                sequenceOptions.setStartValue(this.readExpression());
                continue;
            }
            if (this.readIf("INCREMENT")) {
                this.readIf("BY");
                sequenceOptions.setIncrement(this.readExpression());
                continue;
            }
            if (this.readIf("MINVALUE")) {
                sequenceOptions.setMinValue(this.readExpression());
                continue;
            }
            if (this.readIf("NOMINVALUE")) {
                sequenceOptions.setMinValue(ValueExpression.getNull());
                continue;
            }
            if (this.readIf("MAXVALUE")) {
                sequenceOptions.setMaxValue(this.readExpression());
                continue;
            }
            if (this.readIf("NOMAXVALUE")) {
                sequenceOptions.setMaxValue(ValueExpression.getNull());
                continue;
            }
            if (this.readIf("CYCLE")) {
                sequenceOptions.setCycle(true);
                continue;
            }
            if (this.readIf("NOCYCLE")) {
                sequenceOptions.setCycle(false);
                continue;
            }
            if (this.readIf("NO")) {
                if (this.readIf("MINVALUE")) {
                    sequenceOptions.setMinValue(ValueExpression.getNull());
                    continue;
                }
                if (this.readIf("MAXVALUE")) {
                    sequenceOptions.setMaxValue(ValueExpression.getNull());
                    continue;
                }
                if (this.readIf("CYCLE")) {
                    sequenceOptions.setCycle(false);
                    continue;
                }
                if (!this.readIf("CACHE")) break;
                sequenceOptions.setCacheSize(ValueExpression.get(ValueLong.get(1L)));
                continue;
            }
            if (this.readIf("CACHE")) {
                sequenceOptions.setCacheSize(this.readExpression());
                continue;
            }
            if (this.readIf("NOCACHE")) {
                sequenceOptions.setCacheSize(ValueExpression.get(ValueLong.get(1L)));
                continue;
            }
            if (createSequence == null) break;
            if (this.readIf("BELONGS_TO_TABLE")) {
                createSequence.setBelongsToTable(true);
                continue;
            }
            if (!this.readIf(44)) break;
        }
    }

    private AlterUser parseAlterUser() {
        String string = this.readUniqueIdentifier();
        if (this.readIf("SET")) {
            AlterUser alterUser = new AlterUser(this.session);
            alterUser.setType(19);
            alterUser.setUser(this.database.getUser(string));
            if (this.readIf("PASSWORD")) {
                alterUser.setPassword(this.readExpression());
            } else if (this.readIf("SALT")) {
                alterUser.setSalt(this.readExpression());
                this.read("HASH");
                alterUser.setHash(this.readExpression());
            } else {
                throw this.getSyntaxError();
            }
            return alterUser;
        }
        if (this.readIf("RENAME")) {
            this.read("TO");
            AlterUser alterUser = new AlterUser(this.session);
            alterUser.setType(18);
            alterUser.setUser(this.database.getUser(string));
            String string2 = this.readUniqueIdentifier();
            alterUser.setNewName(string2);
            return alterUser;
        }
        if (this.readIf("ADMIN")) {
            AlterUser alterUser = new AlterUser(this.session);
            alterUser.setType(17);
            User user = this.database.getUser(string);
            alterUser.setUser(user);
            if (this.readIf(53)) {
                alterUser.setAdmin(true);
            } else if (this.readIf(18)) {
                alterUser.setAdmin(false);
            } else {
                throw this.getSyntaxError();
            }
            return alterUser;
        }
        throw this.getSyntaxError();
    }

    private void readIfEqualOrTo() {
        if (!this.readIf(65)) {
            this.readIf("TO");
        }
    }

    private Prepared parseSet() {
        int n;
        if (this.readIf(71)) {
            Set set = new Set(this.session, 33);
            set.setString(this.readAliasIdentifier());
            this.readIfEqualOrTo();
            set.setExpression(this.readExpression());
            return set;
        }
        if (this.readIf("AUTOCOMMIT")) {
            this.readIfEqualOrTo();
            boolean bl = this.readBooleanSetting();
            int n2 = bl ? 69 : 70;
            return new TransactionCommand(this.session, n2);
        }
        if (this.readIf("EXCLUSIVE")) {
            this.readIfEqualOrTo();
            Set set = new Set(this.session, 31);
            set.setExpression(this.readExpression());
            return set;
        }
        if (this.readIf("IGNORECASE")) {
            this.readIfEqualOrTo();
            boolean bl = this.readBooleanSetting();
            Set set = new Set(this.session, 1);
            set.setInt(bl ? 1 : 0);
            return set;
        }
        if (this.readIf("PASSWORD")) {
            this.readIfEqualOrTo();
            AlterUser alterUser = new AlterUser(this.session);
            alterUser.setType(19);
            alterUser.setUser(this.session.getUser());
            alterUser.setPassword(this.readExpression());
            return alterUser;
        }
        if (this.readIf("SALT")) {
            this.readIfEqualOrTo();
            AlterUser alterUser = new AlterUser(this.session);
            alterUser.setType(19);
            alterUser.setUser(this.session.getUser());
            alterUser.setSalt(this.readExpression());
            this.read("HASH");
            alterUser.setHash(this.readExpression());
            return alterUser;
        }
        if (this.readIf("MODE")) {
            this.readIfEqualOrTo();
            Set set = new Set(this.session, 3);
            set.setString(this.readAliasIdentifier());
            return set;
        }
        if (this.readIf("COMPRESS_LOB")) {
            this.readIfEqualOrTo();
            Set set = new Set(this.session, 23);
            if (this.currentTokenType == 64) {
                set.setString(this.readString());
            } else {
                set.setString(this.readUniqueIdentifier());
            }
            return set;
        }
        if (this.readIf("DATABASE")) {
            this.readIfEqualOrTo();
            this.read("COLLATION");
            return this.parseSetCollation();
        }
        if (this.readIf("COLLATION")) {
            this.readIfEqualOrTo();
            return this.parseSetCollation();
        }
        if (this.readIf("BINARY_COLLATION")) {
            this.readIfEqualOrTo();
            return this.parseSetBinaryCollation(36);
        }
        if (this.readIf("UUID_COLLATION")) {
            this.readIfEqualOrTo();
            return this.parseSetBinaryCollation(49);
        }
        if (this.readIf("CLUSTER")) {
            this.readIfEqualOrTo();
            Set set = new Set(this.session, 13);
            set.setString(this.readString());
            return set;
        }
        if (this.readIf("DATABASE_EVENT_LISTENER")) {
            this.readIfEqualOrTo();
            Set set = new Set(this.session, 15);
            set.setString(this.readString());
            return set;
        }
        if (this.readIf("ALLOW_LITERALS")) {
            this.readIfEqualOrTo();
            Set set = new Set(this.session, 24);
            if (this.readIf("NONE")) {
                set.setInt(0);
            } else if (this.readIf(3)) {
                set.setInt(2);
            } else if (this.readIf("NUMBERS")) {
                set.setInt(1);
            } else {
                set.setInt(this.readNonNegativeInt());
            }
            return set;
        }
        if (this.readIf("DEFAULT_TABLE_TYPE")) {
            this.readIfEqualOrTo();
            Set set = new Set(this.session, 7);
            if (this.readIf("MEMORY")) {
                set.setInt(1);
            } else if (this.readIf("CACHED")) {
                set.setInt(0);
            } else {
                set.setInt(this.readNonNegativeInt());
            }
            return set;
        }
        if (this.readIf("CREATE")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("HSQLDB.DEFAULT_TABLE_TYPE")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("PAGE_STORE")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("CACHE_TYPE")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("FILE_LOCK")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("DB_CLOSE_ON_EXIT")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("AUTO_SERVER")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("AUTO_SERVER_PORT")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("AUTO_RECONNECT")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("ASSERT")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("ACCESS_MODE_DATA")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("OPEN_NEW")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("JMX")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("PAGE_SIZE")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("RECOVER")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("NAMES")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("SCOPE_GENERATED_KEYS")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("SCHEMA")) {
            this.readIfEqualOrTo();
            Set set = new Set(this.session, 25);
            set.setExpression(this.readExpressionOrIdentifier());
            return set;
        }
        if (this.readIf("CATALOG")) {
            this.readIfEqualOrTo();
            Set set = new Set(this.session, 51);
            set.setExpression(this.readExpressionOrIdentifier());
            return set;
        }
        if (this.readIf("DATESTYLE")) {
            String string;
            this.readIfEqualOrTo();
            if (!this.readIf("ISO") && !this.equalsToken(string = this.readString(), "ISO")) {
                throw this.getSyntaxError();
            }
            return new NoOperation(this.session);
        }
        if (this.readIf("SEARCH_PATH") || this.readIf(SetTypes.getTypeName(27))) {
            this.readIfEqualOrTo();
            Set set = new Set(this.session, 27);
            ArrayList<String> arrayList = Utils.newSmallArrayList();
            do {
                arrayList.add(this.readAliasIdentifier());
            } while (this.readIf(79));
            set.setStringArray(arrayList.toArray(new String[0]));
            return set;
        }
        if (this.readIf("JAVA_OBJECT_SERIALIZER")) {
            this.readIfEqualOrTo();
            return this.parseSetJavaObjectSerializer();
        }
        if (this.readIf("IGNORE_CATALOGS")) {
            this.readIfEqualOrTo();
            boolean bl = this.readBooleanSetting();
            Set set = new Set(this.session, 50);
            set.setInt(bl ? 1 : 0);
            return set;
        }
        if (this.readIf("SESSION")) {
            this.read("CHARACTERISTICS");
            this.read("AS");
            this.read("TRANSACTION");
            return this.parseSetTransactionMode();
        }
        if (this.readIf("TRANSACTION")) {
            return this.parseSetTransactionMode();
        }
        if (this.isToken("LOGSIZE")) {
            this.currentToken = SetTypes.getTypeName(2);
        }
        if (this.isToken("FOREIGN_KEY_CHECKS")) {
            this.currentToken = SetTypes.getTypeName(29);
        }
        String string = this.currentToken;
        if (!this.identifiersToUpper) {
            string = StringUtils.toUpperEnglish(string);
        }
        if ((n = SetTypes.getType(string)) < 0) {
            throw this.getSyntaxError();
        }
        this.read();
        this.readIfEqualOrTo();
        Set set = new Set(this.session, n);
        set.setExpression(this.readExpression());
        return set;
    }

    private Prepared parseSetTransactionMode() {
        IsolationLevel isolationLevel;
        this.read("ISOLATION");
        this.read("LEVEL");
        if (this.readIf("READ")) {
            if (this.readIf("UNCOMMITTED")) {
                isolationLevel = IsolationLevel.READ_UNCOMMITTED;
            } else {
                this.read("COMMITTED");
                isolationLevel = IsolationLevel.READ_COMMITTED;
            }
        } else if (this.readIf("REPEATABLE")) {
            this.read("READ");
            isolationLevel = IsolationLevel.REPEATABLE_READ;
        } else if (this.readIf("SNAPSHOT")) {
            isolationLevel = IsolationLevel.SNAPSHOT;
        } else {
            this.read("SERIALIZABLE");
            isolationLevel = IsolationLevel.SERIALIZABLE;
        }
        return new SetSessionCharacteristics(this.session, isolationLevel);
    }

    private Expression readExpressionOrIdentifier() {
        if (this.currentTokenType == 2) {
            return ValueExpression.get(ValueString.get(this.readAliasIdentifier()));
        }
        return this.readExpression();
    }

    private Prepared parseUse() {
        this.readIfEqualOrTo();
        Set set = new Set(this.session, 25);
        set.setExpression(ValueExpression.get(ValueString.get(this.readAliasIdentifier())));
        return set;
    }

    private Set parseSetCollation() {
        Set set = new Set(this.session, 12);
        String string = this.readAliasIdentifier();
        set.setString(string);
        if (this.equalsToken(string, "OFF")) {
            return set;
        }
        Collator collator = CompareMode.getCollator(string);
        if (collator == null) {
            throw DbException.getInvalidValueException("collation", string);
        }
        if (this.readIf("STRENGTH")) {
            if (this.readIf(45)) {
                set.setInt(0);
            } else if (this.readIf("SECONDARY")) {
                set.setInt(1);
            } else if (this.readIf("TERTIARY")) {
                set.setInt(2);
            } else if (this.readIf("IDENTICAL")) {
                set.setInt(3);
            }
        } else {
            set.setInt(collator.getStrength());
        }
        return set;
    }

    private Set parseSetBinaryCollation(int n) {
        String string = this.readAliasIdentifier();
        if (this.equalsToken(string, "UNSIGNED") || this.equalsToken(string, "SIGNED")) {
            Set set = new Set(this.session, n);
            set.setString(string);
            return set;
        }
        throw DbException.getInvalidValueException(SetTypes.getTypeName(n), string);
    }

    private Set parseSetJavaObjectSerializer() {
        Set set = new Set(this.session, 37);
        String string = this.readString();
        set.setString(string);
        return set;
    }

    private RunScriptCommand parseRunScript() {
        RunScriptCommand runScriptCommand = new RunScriptCommand(this.session);
        this.read(22);
        runScriptCommand.setFileNameExpr(this.readExpression());
        if (this.readIf("COMPRESSION")) {
            runScriptCommand.setCompressionAlgorithm(this.readUniqueIdentifier());
        }
        if (this.readIf("CIPHER")) {
            runScriptCommand.setCipher(this.readUniqueIdentifier());
            if (this.readIf("PASSWORD")) {
                runScriptCommand.setPassword(this.readExpression());
            }
        }
        if (this.readIf("CHARSET")) {
            runScriptCommand.setCharset(Charset.forName(this.readString()));
        }
        return runScriptCommand;
    }

    private ScriptCommand parseScript() {
        ScriptCommand scriptCommand = new ScriptCommand(this.session);
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        if (this.readIf("NODATA")) {
            bl = false;
        } else {
            if (this.readIf("SIMPLE")) {
                bl5 = true;
            }
            if (this.readIf("COLUMNS")) {
                bl6 = true;
            }
        }
        if (this.readIf("NOPASSWORDS")) {
            bl2 = false;
        }
        if (this.readIf("NOSETTINGS")) {
            bl3 = false;
        }
        if (this.readIf("DROP")) {
            bl4 = true;
        }
        if (this.readIf("BLOCKSIZE")) {
            long l = this.readLong();
            scriptCommand.setLobBlockSize(l);
        }
        scriptCommand.setData(bl);
        scriptCommand.setPasswords(bl2);
        scriptCommand.setSettings(bl3);
        scriptCommand.setDrop(bl4);
        scriptCommand.setSimple(bl5);
        scriptCommand.setWithColumns(bl6);
        if (this.readIf("TO")) {
            scriptCommand.setFileNameExpr(this.readExpression());
            if (this.readIf("COMPRESSION")) {
                scriptCommand.setCompressionAlgorithm(this.readUniqueIdentifier());
            }
            if (this.readIf("CIPHER")) {
                scriptCommand.setCipher(this.readUniqueIdentifier());
                if (this.readIf("PASSWORD")) {
                    scriptCommand.setPassword(this.readExpression());
                }
            }
            if (this.readIf("CHARSET")) {
                scriptCommand.setCharset(Charset.forName(this.readString()));
            }
        }
        if (this.readIf("SCHEMA")) {
            HashSet<String> hashSet = new HashSet<String>();
            do {
                hashSet.add(this.readUniqueIdentifier());
            } while (this.readIf(79));
            scriptCommand.setSchemaNames(hashSet);
        } else if (this.readIf(52)) {
            ArrayList<Table> arrayList = Utils.newSmallArrayList();
            do {
                arrayList.add(this.readTableOrView());
            } while (this.readIf(79));
            scriptCommand.setTables(arrayList);
        }
        return scriptCommand;
    }

    private boolean isDualTable(String string) {
        return (this.schemaName == null || this.equalsToken(this.schemaName, "SYS")) && this.equalsToken("DUAL", string) || this.database.getMode().sysDummy1 && (this.schemaName == null || this.equalsToken(this.schemaName, "SYSIBM")) && this.equalsToken("SYSDUMMY1", string);
    }

    private Table readTableOrView() {
        return this.readTableOrView(this.readIdentifierWithSchema(null));
    }

    private Table readTableOrView(String string) {
        if (this.schemaName != null) {
            Table table = this.getSchema().resolveTableOrView(this.session, string);
            if (table != null) {
                return table;
            }
        } else {
            Table table = this.database.getSchema(this.session.getCurrentSchemaName()).resolveTableOrView(this.session, string);
            if (table != null) {
                return table;
            }
            String[] stringArray = this.session.getSchemaSearchPath();
            if (stringArray != null) {
                for (String string2 : stringArray) {
                    Schema schema = this.database.getSchema(string2);
                    table = schema.resolveTableOrView(this.session, string);
                    if (table == null) continue;
                    return table;
                }
            }
        }
        if (this.isDualTable(string)) {
            return new DualTable(this.database);
        }
        throw DbException.get(42102, string);
    }

    private FunctionAlias findFunctionAlias(String string, String string2) {
        FunctionAlias functionAlias = this.database.getSchema(string).findFunction(string2);
        if (functionAlias != null) {
            return functionAlias;
        }
        String[] stringArray = this.session.getSchemaSearchPath();
        if (stringArray != null) {
            for (String string3 : stringArray) {
                functionAlias = this.database.getSchema(string3).findFunction(string2);
                if (functionAlias == null) continue;
                return functionAlias;
            }
        }
        return null;
    }

    private Sequence findSequence(String string, String string2) {
        Sequence sequence = this.database.getSchema(string).findSequence(string2);
        if (sequence != null) {
            return sequence;
        }
        String[] stringArray = this.session.getSchemaSearchPath();
        if (stringArray != null) {
            for (String string3 : stringArray) {
                sequence = this.database.getSchema(string3).findSequence(string2);
                if (sequence == null) continue;
                return sequence;
            }
        }
        return null;
    }

    private Sequence readSequence() {
        String string = this.readIdentifierWithSchema(null);
        if (this.schemaName != null) {
            return this.getSchema().getSequence(string);
        }
        Sequence sequence = this.findSequence(this.session.getCurrentSchemaName(), string);
        if (sequence != null) {
            return sequence;
        }
        throw DbException.get(90036, string);
    }

    private Prepared parseAlterTable() {
        boolean bl = this.readIfExists(false);
        String string = this.readIdentifierWithSchema();
        Schema schema = this.getSchema();
        if (this.readIf("ADD")) {
            DefineCommand defineCommand = this.parseAlterTableAddConstraintIf(string, schema, bl);
            if (defineCommand != null) {
                return defineCommand;
            }
            return this.parseAlterTableAddColumn(string, schema, bl);
        }
        if (this.readIf("SET")) {
            return this.parseAlterTableSet(schema, string, bl);
        }
        if (this.readIf("RENAME")) {
            return this.parseAlterTableRename(schema, string, bl);
        }
        if (this.readIf("DROP")) {
            return this.parseAlterTableDrop(schema, string, bl);
        }
        if (this.readIf("ALTER")) {
            return this.parseAlterTableAlter(schema, string, bl);
        }
        Mode mode = this.database.getMode();
        if (mode.alterTableExtensionsMySQL || mode.alterTableModifyColumn) {
            return this.parseAlterTableCompatibility(schema, string, bl, mode);
        }
        throw this.getSyntaxError();
    }

    private Prepared parseAlterTableAlter(Schema schema, String string, boolean bl) {
        this.readIf("COLUMN");
        boolean bl2 = this.readIfExists(false);
        String string2 = this.readColumnIdentifier();
        Column column = this.columnIfTableExists(schema, string, string2, bl, bl2);
        if (this.readIf("RENAME")) {
            this.read("TO");
            AlterTableRenameColumn alterTableRenameColumn = new AlterTableRenameColumn(this.session, schema);
            alterTableRenameColumn.setTableName(string);
            alterTableRenameColumn.setIfTableExists(bl);
            alterTableRenameColumn.setIfExists(bl2);
            alterTableRenameColumn.setOldColumnName(string2);
            String string3 = this.readColumnIdentifier();
            alterTableRenameColumn.setNewColumnName(string3);
            return alterTableRenameColumn;
        }
        if (this.readIf("DROP")) {
            if (this.readIf("DEFAULT")) {
                AlterTableAlterColumn alterTableAlterColumn = new AlterTableAlterColumn(this.session, schema);
                alterTableAlterColumn.setTableName(string);
                alterTableAlterColumn.setIfTableExists(bl);
                alterTableAlterColumn.setOldColumn(column);
                alterTableAlterColumn.setType(10);
                alterTableAlterColumn.setDefaultExpression(null);
                return alterTableAlterColumn;
            }
            if (this.readIf(43)) {
                this.read("UPDATE");
                AlterTableAlterColumn alterTableAlterColumn = new AlterTableAlterColumn(this.session, schema);
                alterTableAlterColumn.setTableName(string);
                alterTableAlterColumn.setIfTableExists(bl);
                alterTableAlterColumn.setOldColumn(column);
                alterTableAlterColumn.setType(90);
                alterTableAlterColumn.setDefaultExpression(null);
                return alterTableAlterColumn;
            }
            this.read(40);
            this.read(41);
            AlterTableAlterColumn alterTableAlterColumn = new AlterTableAlterColumn(this.session, schema);
            alterTableAlterColumn.setTableName(string);
            alterTableAlterColumn.setIfTableExists(bl);
            alterTableAlterColumn.setOldColumn(column);
            alterTableAlterColumn.setType(9);
            return alterTableAlterColumn;
        }
        if (this.readIf("TYPE")) {
            return this.parseAlterTableAlterColumnDataType(schema, string, string2, bl, bl2);
        }
        if (this.readIf("SET")) {
            if (this.readIf("DATA")) {
                this.read("TYPE");
                return this.parseAlterTableAlterColumnDataType(schema, string, string2, bl, bl2);
            }
            AlterTableAlterColumn alterTableAlterColumn = new AlterTableAlterColumn(this.session, schema);
            alterTableAlterColumn.setTableName(string);
            alterTableAlterColumn.setIfTableExists(bl);
            alterTableAlterColumn.setOldColumn(column);
            NullConstraintType nullConstraintType = this.parseNotNullConstraint();
            switch (nullConstraintType) {
                case NULL_IS_ALLOWED: {
                    alterTableAlterColumn.setType(9);
                    break;
                }
                case NULL_IS_NOT_ALLOWED: {
                    alterTableAlterColumn.setType(8);
                    break;
                }
                case NO_NULL_CONSTRAINT_FOUND: {
                    if (this.readIf("DEFAULT")) {
                        Expression expression = this.readExpression();
                        alterTableAlterColumn.setType(10);
                        alterTableAlterColumn.setDefaultExpression(expression);
                        break;
                    }
                    if (this.readIf(43)) {
                        this.read("UPDATE");
                        Expression expression = this.readExpression();
                        alterTableAlterColumn.setType(90);
                        alterTableAlterColumn.setDefaultExpression(expression);
                        break;
                    }
                    if (this.readIf("INVISIBLE")) {
                        alterTableAlterColumn.setType(87);
                        alterTableAlterColumn.setVisible(false);
                        break;
                    }
                    if (!this.readIf("VISIBLE")) break;
                    alterTableAlterColumn.setType(87);
                    alterTableAlterColumn.setVisible(true);
                    break;
                }
                default: {
                    throw DbException.get(90088, "Internal Error - unhandled case: " + nullConstraintType.name());
                }
            }
            return alterTableAlterColumn;
        }
        if (this.readIf("RESTART")) {
            this.readIf(61);
            Prepared prepared = this.readAlterColumnRestartWith(schema, column, bl2);
            return this.commandIfTableExists(schema, string, bl, prepared);
        }
        if (this.readIf("SELECTIVITY")) {
            AlterTableAlterColumn alterTableAlterColumn = new AlterTableAlterColumn(this.session, schema);
            alterTableAlterColumn.setTableName(string);
            alterTableAlterColumn.setIfTableExists(bl);
            alterTableAlterColumn.setType(13);
            alterTableAlterColumn.setOldColumn(column);
            alterTableAlterColumn.setSelectivity(this.readExpression());
            return alterTableAlterColumn;
        }
        return this.parseAlterTableAlterColumnType(schema, string, string2, bl, bl2, true);
    }

    private Prepared parseAlterTableDrop(Schema schema, String string, boolean bl) {
        Object object;
        Prepared prepared;
        if (this.readIf(7)) {
            boolean bl2 = this.readIfExists(false);
            String string2 = this.readIdentifierWithSchema(schema.getName());
            bl2 = this.readIfExists(bl2);
            this.checkSchema(schema);
            AlterTableDropConstraint alterTableDropConstraint = new AlterTableDropConstraint(this.session, this.getSchema(), bl2);
            alterTableDropConstraint.setConstraintName(string2);
            return this.commandIfTableExists(schema, string, bl, alterTableDropConstraint);
        }
        if (this.readIf(45)) {
            this.read("KEY");
            Table table = this.tableIfTableExists(schema, string, bl);
            if (table == null) {
                return new NoOperation(this.session);
            }
            Index index = table.getPrimaryKey();
            DropIndex dropIndex = new DropIndex(this.session, schema);
            dropIndex.setIndexName(index.getName());
            return dropIndex;
        }
        if (this.database.getMode().alterTableExtensionsMySQL && (prepared = this.parseAlterTableDropCompatibility(schema, string, bl)) != null) {
            return prepared;
        }
        this.readIf("COLUMN");
        boolean bl3 = this.readIfExists(false);
        ArrayList<Column> arrayList = new ArrayList<Column>();
        Table table = this.tableIfTableExists(schema, string, bl);
        boolean bl4 = this.readIf(75);
        do {
            Column column;
            object = this.readColumnIdentifier();
            if (table == null || (column = table.getColumn((String)object, bl3)) == null) continue;
            arrayList.add(column);
        } while (this.readIf(79));
        if (bl4) {
            this.read(76);
        }
        if (table == null || arrayList.isEmpty()) {
            return new NoOperation(this.session);
        }
        object = new AlterTableAlterColumn(this.session, schema);
        ((AlterTableAlterColumn)object).setType(12);
        ((AlterTableAlterColumn)object).setTableName(string);
        ((AlterTableAlterColumn)object).setIfTableExists(bl);
        ((AlterTableAlterColumn)object).setColumnsToRemove(arrayList);
        return object;
    }

    private Prepared parseAlterTableDropCompatibility(Schema schema, String string, boolean bl) {
        if (this.readIf(21)) {
            this.read("KEY");
            boolean bl2 = this.readIfExists(false);
            String string2 = this.readIdentifierWithSchema(schema.getName());
            this.checkSchema(schema);
            AlterTableDropConstraint alterTableDropConstraint = new AlterTableDropConstraint(this.session, this.getSchema(), bl2);
            alterTableDropConstraint.setConstraintName(string2);
            return this.commandIfTableExists(schema, string, bl, alterTableDropConstraint);
        }
        if (this.readIf("INDEX")) {
            SchemaCommand schemaCommand;
            boolean bl3 = this.readIfExists(false);
            String string3 = this.readIdentifierWithSchema(schema.getName());
            if (schema.findIndex(this.session, string3) != null) {
                DropIndex dropIndex = new DropIndex(this.session, this.getSchema());
                dropIndex.setIndexName(string3);
                schemaCommand = dropIndex;
            } else {
                AlterTableDropConstraint alterTableDropConstraint = new AlterTableDropConstraint(this.session, this.getSchema(), bl3);
                alterTableDropConstraint.setConstraintName(string3);
                schemaCommand = alterTableDropConstraint;
            }
            return this.commandIfTableExists(schema, string, bl, schemaCommand);
        }
        return null;
    }

    private Prepared parseAlterTableRename(Schema schema, String string, boolean bl) {
        if (this.readIf("COLUMN")) {
            String string2 = this.readColumnIdentifier();
            this.read("TO");
            AlterTableRenameColumn alterTableRenameColumn = new AlterTableRenameColumn(this.session, schema);
            alterTableRenameColumn.setTableName(string);
            alterTableRenameColumn.setIfTableExists(bl);
            alterTableRenameColumn.setOldColumnName(string2);
            String string3 = this.readColumnIdentifier();
            alterTableRenameColumn.setNewColumnName(string3);
            return alterTableRenameColumn;
        }
        if (this.readIf(7)) {
            String string4 = this.readIdentifierWithSchema(schema.getName());
            this.checkSchema(schema);
            this.read("TO");
            AlterTableRenameConstraint alterTableRenameConstraint = new AlterTableRenameConstraint(this.session, schema);
            alterTableRenameConstraint.setConstraintName(string4);
            String string5 = this.readColumnIdentifier();
            alterTableRenameConstraint.setNewConstraintName(string5);
            return this.commandIfTableExists(schema, string, bl, alterTableRenameConstraint);
        }
        this.read("TO");
        String string6 = this.readIdentifierWithSchema(schema.getName());
        this.checkSchema(schema);
        AlterTableRename alterTableRename = new AlterTableRename(this.session, this.getSchema());
        alterTableRename.setOldTableName(string);
        alterTableRename.setNewTableName(string6);
        alterTableRename.setIfTableExists(bl);
        alterTableRename.setHidden(this.readIf("HIDDEN"));
        return alterTableRename;
    }

    private Prepared parseAlterTableSet(Schema schema, String string, boolean bl) {
        this.read("REFERENTIAL_INTEGRITY");
        int n = 55;
        boolean bl2 = this.readBooleanSetting();
        AlterTableSet alterTableSet = new AlterTableSet(this.session, schema, n, bl2);
        alterTableSet.setTableName(string);
        alterTableSet.setIfTableExists(bl);
        if (this.readIf(6)) {
            alterTableSet.setCheckExisting(true);
        } else if (this.readIf("NOCHECK")) {
            alterTableSet.setCheckExisting(false);
        }
        return alterTableSet;
    }

    private Prepared parseAlterTableCompatibility(Schema schema, String string, boolean bl, Mode mode) {
        if (mode.alterTableExtensionsMySQL) {
            if (this.readIf("AUTO_INCREMENT")) {
                this.readIf(65);
                Table table = this.tableIfTableExists(schema, string, bl);
                if (table == null) {
                    return new NoOperation(this.session);
                }
                Index index = table.findPrimaryKey();
                if (index != null) {
                    for (IndexColumn indexColumn : index.getIndexColumns()) {
                        Column column = indexColumn.column;
                        if (column.getSequence() == null) continue;
                        return this.readAlterColumnRestartWith(schema, column, false);
                    }
                }
                throw DbException.get(42122, "AUTO_INCREMENT PRIMARY KEY");
            }
            if (this.readIf("CHANGE")) {
                this.readIf("COLUMN");
                String string2 = this.readColumnIdentifier();
                String string3 = this.readColumnIdentifier();
                Column column = this.columnIfTableExists(schema, string, string2, bl, false);
                boolean bl2 = column == null ? true : column.isNullable();
                this.parseColumnForTable(string3, bl2, true);
                AlterTableRenameColumn alterTableRenameColumn = new AlterTableRenameColumn(this.session, schema);
                alterTableRenameColumn.setTableName(string);
                alterTableRenameColumn.setIfTableExists(bl);
                alterTableRenameColumn.setOldColumnName(string2);
                alterTableRenameColumn.setNewColumnName(string3);
                return alterTableRenameColumn;
            }
        }
        if (mode.alterTableModifyColumn && this.readIf("MODIFY")) {
            AlterTableAlterColumn alterTableAlterColumn;
            this.readIf("COLUMN");
            boolean bl3 = this.readIf(75);
            String string4 = this.readColumnIdentifier();
            NullConstraintType nullConstraintType = this.parseNotNullConstraint();
            switch (nullConstraintType) {
                case NULL_IS_ALLOWED: 
                case NULL_IS_NOT_ALLOWED: {
                    alterTableAlterColumn = new AlterTableAlterColumn(this.session, schema);
                    alterTableAlterColumn.setTableName(string);
                    alterTableAlterColumn.setIfTableExists(bl);
                    Column column = this.columnIfTableExists(schema, string, string4, bl, false);
                    alterTableAlterColumn.setOldColumn(column);
                    if (nullConstraintType == NullConstraintType.NULL_IS_ALLOWED) {
                        alterTableAlterColumn.setType(9);
                        break;
                    }
                    alterTableAlterColumn.setType(8);
                    break;
                }
                case NO_NULL_CONSTRAINT_FOUND: {
                    alterTableAlterColumn = this.parseAlterTableAlterColumnType(schema, string, string4, bl, false, mode.getEnum() != Mode.ModeEnum.MySQL);
                    break;
                }
                default: {
                    throw DbException.get(90088, "Internal Error - unhandled case: " + nullConstraintType.name());
                }
            }
            if (bl3) {
                this.read(76);
            }
            return alterTableAlterColumn;
        }
        throw this.getSyntaxError();
    }

    private Prepared readAlterColumnRestartWith(Schema schema, Column column, boolean bl) {
        Expression expression = this.readExpression();
        if (column == null) {
            return new NoOperation(this.session);
        }
        AlterSequence alterSequence = new AlterSequence(this.session, schema);
        alterSequence.setColumn(column);
        SequenceOptions sequenceOptions = new SequenceOptions();
        sequenceOptions.setStartValue(expression);
        alterSequence.setOptions(sequenceOptions);
        return alterSequence;
    }

    private Table tableIfTableExists(Schema schema, String string, boolean bl) {
        Table table = schema.resolveTableOrView(this.session, string);
        if (table == null && !bl) {
            throw DbException.get(42102, string);
        }
        return table;
    }

    private Column columnIfTableExists(Schema schema, String string, String string2, boolean bl, boolean bl2) {
        Table table = this.tableIfTableExists(schema, string, bl);
        if (table == null) {
            return null;
        }
        return table.getColumn(string2, bl2);
    }

    private Prepared commandIfTableExists(Schema schema, String string, boolean bl, Prepared prepared) {
        return this.tableIfTableExists(schema, string, bl) == null ? new NoOperation(this.session) : prepared;
    }

    private AlterTableAlterColumn parseAlterTableAlterColumnType(Schema schema, String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        Object object;
        Column column = this.columnIfTableExists(schema, string, string2, bl, bl2);
        Column column2 = this.parseColumnForTable(string2, !bl3 || column == null || column.isNullable(), true);
        if (this.readIf(6)) {
            object = this.readExpression();
            column2.addCheckConstraint(this.session, (Expression)object);
        }
        object = new AlterTableAlterColumn(this.session, schema);
        ((AlterTableAlterColumn)object).setTableName(string);
        ((AlterTableAlterColumn)object).setIfTableExists(bl);
        ((AlterTableAlterColumn)object).setType(11);
        ((AlterTableAlterColumn)object).setOldColumn(column);
        ((AlterTableAlterColumn)object).setNewColumn(column2);
        return object;
    }

    private AlterTableAlterColumn parseAlterTableAlterColumnDataType(Schema schema, String string, String string2, boolean bl, boolean bl2) {
        Object object;
        Column column = this.columnIfTableExists(schema, string, string2, bl, bl2);
        Column column2 = this.parseColumnWithType(string2, true);
        if (column != null) {
            String string3;
            if (!column.isNullable()) {
                column2.setNullable(false);
            }
            if (!column.getVisible()) {
                column2.setVisible(false);
            }
            if ((object = column.getDefaultExpression()) != null) {
                column2.setDefaultExpression(this.session, (Expression)object);
            }
            if ((object = column.getOnUpdateExpression()) != null) {
                column2.setOnUpdateExpression(this.session, (Expression)object);
            }
            if ((object = column.getCheckConstraint(this.session, string2)) != null) {
                column2.addCheckConstraint(this.session, (Expression)object);
            }
            if ((string3 = column.getComment()) != null) {
                column2.setComment(string3);
            }
        }
        object = new AlterTableAlterColumn(this.session, schema);
        ((AlterTableAlterColumn)object).setTableName(string);
        ((AlterTableAlterColumn)object).setIfTableExists(bl);
        ((AlterTableAlterColumn)object).setType(11);
        ((AlterTableAlterColumn)object).setOldColumn(column);
        ((AlterTableAlterColumn)object).setNewColumn(column2);
        return object;
    }

    private AlterTableAlterColumn parseAlterTableAddColumn(String string, Schema schema, boolean bl) {
        this.readIf("COLUMN");
        AlterTableAlterColumn alterTableAlterColumn = new AlterTableAlterColumn(this.session, schema);
        alterTableAlterColumn.setType(7);
        alterTableAlterColumn.setTableName(string);
        alterTableAlterColumn.setIfTableExists(bl);
        if (this.readIf(75)) {
            alterTableAlterColumn.setIfNotExists(false);
            do {
                this.parseTableColumnDefinition(alterTableAlterColumn, schema, string, false);
            } while (this.readIfMore());
        } else {
            boolean bl2 = this.readIfNotExists();
            alterTableAlterColumn.setIfNotExists(bl2);
            this.parseTableColumnDefinition(alterTableAlterColumn, schema, string, false);
        }
        if (this.readIf("BEFORE")) {
            alterTableAlterColumn.setAddBefore(this.readColumnIdentifier());
        } else if (this.readIf("AFTER")) {
            alterTableAlterColumn.setAddAfter(this.readColumnIdentifier());
        } else if (this.readIf("FIRST")) {
            alterTableAlterColumn.setAddFirst();
        }
        return alterTableAlterColumn;
    }

    private ConstraintActionType parseAction() {
        ConstraintActionType constraintActionType = this.parseCascadeOrRestrict();
        if (constraintActionType != null) {
            return constraintActionType;
        }
        if (this.readIf("NO")) {
            this.read("ACTION");
            return ConstraintActionType.RESTRICT;
        }
        this.read("SET");
        if (this.readIf(41)) {
            return ConstraintActionType.SET_NULL;
        }
        this.read("DEFAULT");
        return ConstraintActionType.SET_DEFAULT;
    }

    private ConstraintActionType parseCascadeOrRestrict() {
        if (this.readIf("CASCADE")) {
            return ConstraintActionType.CASCADE;
        }
        if (this.readIf("RESTRICT")) {
            return ConstraintActionType.RESTRICT;
        }
        return null;
    }

    private DefineCommand parseAlterTableAddConstraintIf(String string, Schema schema, boolean bl) {
        AlterTableAddConstraint alterTableAddConstraint;
        String string2 = null;
        String string3 = null;
        boolean bl2 = false;
        Mode mode = this.database.getMode();
        boolean bl3 = mode.indexDefinitionInCreateTable;
        if (this.readIf(7)) {
            bl2 = this.readIfNotExists();
            string2 = this.readIdentifierWithSchema(schema.getName());
            this.checkSchema(schema);
            string3 = this.readCommentIf();
            bl3 = true;
        }
        if (this.readIf(45)) {
            this.read("KEY");
            AlterTableAddConstraint alterTableAddConstraint2 = new AlterTableAddConstraint(this.session, schema, bl2);
            alterTableAddConstraint2.setType(6);
            alterTableAddConstraint2.setComment(string3);
            alterTableAddConstraint2.setConstraintName(string2);
            alterTableAddConstraint2.setTableName(string);
            alterTableAddConstraint2.setIfTableExists(bl);
            if (this.readIf("HASH")) {
                alterTableAddConstraint2.setPrimaryKeyHash(true);
            }
            this.read(75);
            alterTableAddConstraint2.setIndexColumns(this.parseIndexColumnList());
            if (this.readIf("INDEX")) {
                String string4 = this.readIdentifierWithSchema();
                alterTableAddConstraint2.setIndex(this.getSchema().findIndex(this.session, string4));
            }
            return alterTableAddConstraint2;
        }
        if (bl3 && (this.isToken("INDEX") || this.isToken("KEY"))) {
            int n = this.lastParseIndex;
            this.read();
            if (DataType.getTypeByName(this.currentToken, mode) != null) {
                this.parseIndex = n;
                this.read();
                return null;
            }
            CreateIndex createIndex = new CreateIndex(this.session, schema);
            createIndex.setComment(string3);
            createIndex.setTableName(string);
            createIndex.setIfTableExists(bl);
            if (!this.readIf(75)) {
                createIndex.setIndexName(this.readUniqueIdentifier());
                this.read(75);
            }
            createIndex.setIndexColumns(this.parseIndexColumnList());
            if (this.readIf(57)) {
                this.read("BTREE");
            }
            return createIndex;
        }
        if (mode.allowAffinityKey && this.readIfAffinity()) {
            this.read("KEY");
            this.read(75);
            CreateIndex createIndex = this.createAffinityIndex(schema, string, this.parseIndexColumnList());
            createIndex.setIfTableExists(bl);
            return createIndex;
        }
        if (this.readIf(6)) {
            alterTableAddConstraint = new AlterTableAddConstraint(this.session, schema, bl2);
            alterTableAddConstraint.setType(3);
            alterTableAddConstraint.setCheckExpression(this.readExpression());
        } else if (this.readIf(55)) {
            this.readIf("KEY");
            this.readIf("INDEX");
            alterTableAddConstraint = new AlterTableAddConstraint(this.session, schema, bl2);
            alterTableAddConstraint.setType(4);
            if (!this.readIf(75)) {
                string2 = this.readUniqueIdentifier();
                this.read(75);
            }
            alterTableAddConstraint.setIndexColumns(this.parseIndexColumnList());
            if (this.readIf("INDEX")) {
                String string5 = this.readIdentifierWithSchema();
                alterTableAddConstraint.setIndex(this.getSchema().findIndex(this.session, string5));
            }
            if (this.readIf(57)) {
                this.read("BTREE");
            }
        } else if (this.readIf(21)) {
            alterTableAddConstraint = new AlterTableAddConstraint(this.session, schema, bl2);
            alterTableAddConstraint.setType(5);
            this.read("KEY");
            this.read(75);
            alterTableAddConstraint.setIndexColumns(this.parseIndexColumnList());
            if (this.readIf("INDEX")) {
                String string6 = this.readIdentifierWithSchema();
                alterTableAddConstraint.setIndex(schema.findIndex(this.session, string6));
            }
            this.read("REFERENCES");
            this.parseReferences(alterTableAddConstraint, schema, string);
        } else {
            if (string2 != null) {
                throw this.getSyntaxError();
            }
            return null;
        }
        if (this.readIf("NOCHECK")) {
            alterTableAddConstraint.setCheckExisting(false);
        } else {
            this.readIf(6);
            alterTableAddConstraint.setCheckExisting(true);
        }
        alterTableAddConstraint.setTableName(string);
        alterTableAddConstraint.setIfTableExists(bl);
        alterTableAddConstraint.setConstraintName(string2);
        alterTableAddConstraint.setComment(string3);
        return alterTableAddConstraint;
    }

    private void parseReferences(AlterTableAddConstraint alterTableAddConstraint, Schema schema, String string) {
        String string2;
        if (this.readIf(75)) {
            alterTableAddConstraint.setRefTableName(schema, string);
            alterTableAddConstraint.setRefIndexColumns(this.parseIndexColumnList());
        } else {
            string2 = this.readIdentifierWithSchema(schema.getName());
            alterTableAddConstraint.setRefTableName(this.getSchema(), string2);
            if (this.readIf(75)) {
                alterTableAddConstraint.setRefIndexColumns(this.parseIndexColumnList());
            }
        }
        if (this.readIf("INDEX")) {
            string2 = this.readIdentifierWithSchema();
            alterTableAddConstraint.setRefIndex(this.getSchema().findIndex(this.session, string2));
        }
        while (this.readIf(43)) {
            if (this.readIf("DELETE")) {
                alterTableAddConstraint.setDeleteAction(this.parseAction());
                continue;
            }
            this.read("UPDATE");
            alterTableAddConstraint.setUpdateAction(this.parseAction());
        }
        if (this.readIf(40)) {
            this.read("DEFERRABLE");
        } else {
            this.readIf("DEFERRABLE");
        }
    }

    private CreateLinkedTable parseCreateLinkedTable(boolean bl, boolean bl2, boolean bl3) {
        this.read(52);
        boolean bl4 = this.readIfNotExists();
        String string = this.readIdentifierWithSchema();
        CreateLinkedTable createLinkedTable = new CreateLinkedTable(this.session, this.getSchema());
        createLinkedTable.setTemporary(bl);
        createLinkedTable.setGlobalTemporary(bl2);
        createLinkedTable.setForce(bl3);
        createLinkedTable.setIfNotExists(bl4);
        createLinkedTable.setTableName(string);
        createLinkedTable.setComment(this.readCommentIf());
        this.read(75);
        createLinkedTable.setDriver(this.readString());
        this.read(79);
        createLinkedTable.setUrl(this.readString());
        this.read(79);
        createLinkedTable.setUser(this.readString());
        this.read(79);
        createLinkedTable.setPassword(this.readString());
        this.read(79);
        String string2 = this.readString();
        if (this.readIf(79)) {
            createLinkedTable.setOriginalSchema(string2);
            string2 = this.readString();
        }
        createLinkedTable.setOriginalTable(string2);
        this.read(76);
        if (this.readIf("EMIT")) {
            this.read("UPDATES");
            createLinkedTable.setEmitUpdates(true);
        } else if (this.readIf("READONLY")) {
            createLinkedTable.setReadOnly(true);
        }
        return createLinkedTable;
    }

    private CreateTable parseCreateTable(boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = this.readIfNotExists();
        String string = this.readIdentifierWithSchema();
        if (bl && bl2 && this.equalsToken("SESSION", this.schemaName)) {
            this.schemaName = this.session.getCurrentSchemaName();
            bl2 = false;
        }
        Schema schema = this.getSchema();
        CreateTable createTable = new CreateTable(this.session, schema);
        createTable.setPersistIndexes(bl3);
        createTable.setTemporary(bl);
        createTable.setGlobalTemporary(bl2);
        createTable.setIfNotExists(bl4);
        createTable.setTableName(string);
        createTable.setComment(this.readCommentIf());
        if (this.readIf(75) && !this.readIf(76)) {
            do {
                this.parseTableColumnDefinition(createTable, schema, string, true);
            } while (this.readIfMore());
        }
        if (this.database.getMode().getEnum() == Mode.ModeEnum.MySQL) {
            this.parseCreateTableMySQLTableOptions(createTable);
        }
        if (this.readIf("ENGINE")) {
            createTable.setTableEngine(this.readUniqueIdentifier());
        }
        if (this.readIf(61)) {
            createTable.setTableEngineParams(this.readTableEngineParams());
        }
        if (bl) {
            if (this.readIf(43)) {
                this.read("COMMIT");
                if (this.readIf("DROP")) {
                    createTable.setOnCommitDrop();
                } else if (this.readIf("DELETE")) {
                    this.read("ROWS");
                    createTable.setOnCommitTruncate();
                }
            } else if (this.readIf(40)) {
                if (this.readIf("PERSISTENT")) {
                    createTable.setPersistData(false);
                } else {
                    this.read("LOGGED");
                }
            }
            if (this.readIf("TRANSACTIONAL")) {
                createTable.setTransactional(true);
            }
        } else if (!bl3 && this.readIf(40)) {
            this.read("PERSISTENT");
            createTable.setPersistData(false);
        }
        if (this.readIf("HIDDEN")) {
            createTable.setHidden(true);
        }
        if (this.readIf("AS")) {
            if (this.readIf("SORTED")) {
                createTable.setSortedInsertMode(true);
            }
            createTable.setQuery(this.parseQuery());
            if (this.readIf(61)) {
                createTable.setWithNoData(this.readIf("NO"));
                this.read("DATA");
            }
        }
        return createTable;
    }

    private void parseTableColumnDefinition(CommandWithColumns commandWithColumns, Schema schema, String string, boolean bl) {
        DefineCommand defineCommand = this.parseAlterTableAddConstraintIf(string, schema, false);
        if (defineCommand != null) {
            commandWithColumns.addConstraintCommand(defineCommand);
        } else {
            String string2;
            IndexColumn[] indexColumnArray;
            boolean bl2;
            Object object;
            IndexColumn[] indexColumnArray2;
            String string3 = this.readColumnIdentifier();
            if (bl && (this.currentTokenType == 79 || this.currentTokenType == 76)) {
                commandWithColumns.addColumn(new Column(string3, TypeInfo.TYPE_UNKNOWN));
                return;
            }
            Column column = this.parseColumnForTable(string3, true, true);
            if (column.isAutoIncrement() && column.isPrimaryKey()) {
                column.setPrimaryKey(false);
                indexColumnArray2 = new IndexColumn[]{new IndexColumn()};
                indexColumnArray2[0].columnName = column.getName();
                object = new AlterTableAddConstraint(this.session, schema, false);
                ((AlterTableAddConstraint)object).setType(6);
                ((AlterTableAddConstraint)object).setTableName(string);
                ((AlterTableAddConstraint)object).setIndexColumns(indexColumnArray2);
                commandWithColumns.addConstraintCommand((DefineCommand)object);
            }
            commandWithColumns.addColumn(column);
            indexColumnArray2 = null;
            if (this.readIf(7)) {
                indexColumnArray2 = this.readColumnIdentifier();
            }
            object = this.database.getMode();
            boolean bl3 = bl2 = ((Mode)object).allowAffinityKey && this.readIfAffinity();
            if (this.readIf(45)) {
                this.read("KEY");
                boolean bl4 = this.readIf("HASH");
                indexColumnArray = new IndexColumn[]{new IndexColumn()};
                indexColumnArray[0].columnName = column.getName();
                AlterTableAddConstraint alterTableAddConstraint = new AlterTableAddConstraint(this.session, schema, false);
                alterTableAddConstraint.setConstraintName((String)indexColumnArray2);
                alterTableAddConstraint.setPrimaryKeyHash(bl4);
                alterTableAddConstraint.setType(6);
                alterTableAddConstraint.setTableName(string);
                alterTableAddConstraint.setIndexColumns(indexColumnArray);
                commandWithColumns.addConstraintCommand(alterTableAddConstraint);
                if (this.readIf("AUTO_INCREMENT")) {
                    this.parseAutoIncrement(column);
                }
                if (((Mode)object).useIdentityAsAutoIncrement) {
                    if (this.readIf(40)) {
                        this.read(41);
                        column.setNullable(false);
                    }
                    if (this.readIf("IDENTITY")) {
                        this.parseAutoIncrement(column);
                    }
                }
                if (bl2) {
                    CreateIndex createIndex = this.createAffinityIndex(schema, string, indexColumnArray);
                    commandWithColumns.addConstraintCommand(createIndex);
                }
            } else if (bl2) {
                this.read("KEY");
                IndexColumn[] indexColumnArray3 = new IndexColumn[]{new IndexColumn()};
                indexColumnArray3[0].columnName = column.getName();
                indexColumnArray = this.createAffinityIndex(schema, string, indexColumnArray3);
                commandWithColumns.addConstraintCommand((DefineCommand)indexColumnArray);
            } else if (this.readIf(55)) {
                AlterTableAddConstraint alterTableAddConstraint = new AlterTableAddConstraint(this.session, schema, false);
                alterTableAddConstraint.setConstraintName((String)indexColumnArray2);
                alterTableAddConstraint.setType(4);
                indexColumnArray = new IndexColumn[]{new IndexColumn()};
                indexColumnArray[0].columnName = string3;
                alterTableAddConstraint.setIndexColumns(indexColumnArray);
                alterTableAddConstraint.setTableName(string);
                commandWithColumns.addConstraintCommand(alterTableAddConstraint);
            }
            if (NullConstraintType.NULL_IS_NOT_ALLOWED == this.parseNotNullConstraint()) {
                column.setNullable(false);
            }
            if (column.getComment() == null && (string2 = this.readCommentIf()) != null) {
                column.setComment(string2);
            }
            if (this.readIf(6)) {
                Expression expression = this.readExpression();
                column.addCheckConstraint(this.session, expression);
            }
            if (this.readIf("REFERENCES")) {
                AlterTableAddConstraint alterTableAddConstraint = new AlterTableAddConstraint(this.session, schema, false);
                alterTableAddConstraint.setConstraintName((String)indexColumnArray2);
                alterTableAddConstraint.setType(5);
                indexColumnArray = new IndexColumn[]{new IndexColumn()};
                indexColumnArray[0].columnName = string3;
                alterTableAddConstraint.setIndexColumns(indexColumnArray);
                alterTableAddConstraint.setTableName(string);
                this.parseReferences(alterTableAddConstraint, schema, string);
                commandWithColumns.addConstraintCommand(alterTableAddConstraint);
            }
        }
    }

    private void parseCreateTableMySQLTableOptions(CreateTable createTable) {
        boolean bl = false;
        while (true) {
            block19: {
                if (this.readIf("AUTO_INCREMENT")) {
                    this.readIf(65);
                    Expression expression = this.readExpression();
                    AlterTableAddConstraint alterTableAddConstraint = createTable.getPrimaryKey();
                    if (alterTableAddConstraint != null) {
                        for (IndexColumn indexColumn : alterTableAddConstraint.getIndexColumns()) {
                            String string = indexColumn.columnName;
                            for (Column column : createTable.getColumns()) {
                                SequenceOptions sequenceOptions;
                                if (!this.database.equalsIdentifiers(column.getName(), string) || (sequenceOptions = column.getAutoIncrementOptions()) == null) continue;
                                sequenceOptions.setStartValue(expression);
                                break block19;
                            }
                        }
                    }
                    throw DbException.get(42122, "AUTO_INCREMENT PRIMARY KEY");
                }
                if (this.readIf("DEFAULT")) {
                    if (this.readIf("CHARACTER")) {
                        this.read("SET");
                    } else {
                        this.read("CHARSET");
                    }
                    this.readMySQLCharset();
                } else if (this.readIf("CHARACTER")) {
                    this.read("SET");
                    this.readMySQLCharset();
                } else if (this.readIf("CHARSET")) {
                    this.readMySQLCharset();
                } else if (this.readIf("COMMENT")) {
                    this.readIf(65);
                    createTable.setComment(this.readString());
                } else if (this.readIf("ENGINE")) {
                    this.readIf(65);
                    this.readUniqueIdentifier();
                } else if (this.readIf("ROW_FORMAT")) {
                    this.readIf(65);
                    this.readColumnIdentifier();
                } else {
                    if (!bl) break;
                    throw this.getSyntaxError();
                }
            }
            bl = this.readIf(79);
        }
    }

    private void readMySQLCharset() {
        this.readIf(65);
        if (!this.readIf("UTF8")) {
            this.read("UTF8MB4");
        }
    }

    private NullConstraintType parseNotNullConstraint() {
        NullConstraintType nullConstraintType = NullConstraintType.NO_NULL_CONSTRAINT_FOUND;
        if (this.isToken(40) || this.isToken(41)) {
            if (this.readIf(40)) {
                this.read(41);
                nullConstraintType = NullConstraintType.NULL_IS_NOT_ALLOWED;
            } else {
                this.read(41);
                nullConstraintType = NullConstraintType.NULL_IS_ALLOWED;
            }
            if (this.database.getMode().getEnum() == Mode.ModeEnum.Oracle) {
                if (this.readIf("ENABLE")) {
                    this.readIf("VALIDATE");
                    if (this.readIf("NOVALIDATE")) {
                        nullConstraintType = NullConstraintType.NULL_IS_ALLOWED;
                    }
                }
                if (this.readIf("DISABLE")) {
                    nullConstraintType = NullConstraintType.NULL_IS_ALLOWED;
                    this.readIf("VALIDATE");
                    this.readIf("NOVALIDATE");
                }
            }
        }
        return nullConstraintType;
    }

    private CreateSynonym parseCreateSynonym(boolean bl) {
        boolean bl2 = this.readIfNotExists();
        String string = this.readIdentifierWithSchema();
        Schema schema = this.getSchema();
        this.read(20);
        String string2 = this.readIdentifierWithSchema();
        Schema schema2 = this.getSchema();
        CreateSynonym createSynonym = new CreateSynonym(this.session, schema);
        createSynonym.setName(string);
        createSynonym.setSynonymFor(string2);
        createSynonym.setSynonymForSchema(schema2);
        createSynonym.setComment(this.readCommentIf());
        createSynonym.setIfNotExists(bl2);
        createSynonym.setOrReplace(bl);
        return createSynonym;
    }

    private CreateIndex createAffinityIndex(Schema schema, String string, IndexColumn[] indexColumnArray) {
        CreateIndex createIndex = new CreateIndex(this.session, schema);
        createIndex.setTableName(string);
        createIndex.setIndexColumns(indexColumnArray);
        createIndex.setAffinity(true);
        return createIndex;
    }

    private static int getCompareType(int n) {
        switch (n) {
            case 65: {
                return 0;
            }
            case 66: {
                return 1;
            }
            case 67: {
                return 2;
            }
            case 68: {
                return 4;
            }
            case 69: {
                return 3;
            }
            case 70: {
                return 5;
            }
            case 77: {
                return 9;
            }
        }
        return -1;
    }

    public static String quoteIdentifier(String string, boolean bl) {
        if (string == null) {
            return "\"\"";
        }
        if (!bl && ParserUtil.isSimpleIdentifier(string, false, false)) {
            return string;
        }
        return StringUtils.quoteIdentifier(string);
    }

    public static StringBuilder quoteIdentifier(StringBuilder stringBuilder, String string, boolean bl) {
        if (string == null) {
            return stringBuilder.append("\"\"");
        }
        if (!bl && ParserUtil.isSimpleIdentifier(string, false, false)) {
            return stringBuilder.append(string);
        }
        return StringUtils.quoteIdentifier(stringBuilder, string);
    }

    public void setLiteralsChecked(boolean bl) {
        this.literalsChecked = bl;
    }

    public void setRightsChecked(boolean bl) {
        this.rightsChecked = bl;
    }

    public void setSuppliedParameterList(ArrayList<Parameter> arrayList) {
        this.suppliedParameterList = arrayList;
    }

    public Expression parseExpression(String string) {
        this.parameters = Utils.newSmallArrayList();
        this.initialize(string);
        this.read();
        return this.readExpression();
    }

    public Table parseTableName(String string) {
        this.parameters = Utils.newSmallArrayList();
        this.initialize(string);
        this.read();
        return this.readTableOrView();
    }

    public Object parseColumnList(String string, int n) {
        this.initialize(string);
        this.parseIndex = n;
        this.read();
        this.read(75);
        if (this.readIf(76)) {
            return Utils.EMPTY_INT_ARRAY;
        }
        if (this.currentTokenType == 2) {
            ArrayList<String> arrayList = Utils.newSmallArrayList();
            do {
                if (this.currentTokenType != 2) {
                    throw this.getSyntaxError();
                }
                arrayList.add(this.currentToken);
                this.read();
            } while (this.readIfMore());
            return arrayList.toArray(new String[0]);
        }
        if (this.currentTokenType == 64) {
            ArrayList arrayList = Utils.newSmallArrayList();
            do {
                arrayList.add(this.readInt());
            } while (this.readIfMore());
            int n2 = arrayList.size();
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = (Integer)arrayList.get(i);
            }
            return nArray;
        }
        throw this.getSyntaxError();
    }

    public int getLastParseIndex() {
        return this.lastParseIndex;
    }

    public String toString() {
        return StringUtils.addAsterisk(this.sqlCommand, this.parseIndex);
    }

    private static enum NullConstraintType {
        NULL_IS_ALLOWED,
        NULL_IS_NOT_ALLOWED,
        NO_NULL_CONSTRAINT_FOUND;

    }
}

