/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.tls.service.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.nifi.toolkit.tls.commandLine.CommandLineParseException;
import org.apache.nifi.toolkit.tls.configuration.TlsConfig;
import org.apache.nifi.toolkit.tls.service.BaseCertificateAuthorityCommandLine;
import org.apache.nifi.toolkit.tls.service.server.TlsCertificateAuthorityService;
import org.apache.nifi.toolkit.tls.util.InputStreamFactory;
import org.apache.nifi.util.StringUtils;

public class TlsCertificateAuthorityServiceCommandLine
extends BaseCertificateAuthorityCommandLine {
    public static final String DESCRIPTION = "Acts as a Certificate Authority that can be used by clients to get Certificates";
    public static final String NIFI_CA_KEYSTORE = "nifi-ca-keystore.";
    private final InputStreamFactory inputStreamFactory;

    public TlsCertificateAuthorityServiceCommandLine() {
        this(FileInputStream::new);
    }

    public TlsCertificateAuthorityServiceCommandLine(InputStreamFactory inputStreamFactory) {
        super(DESCRIPTION);
        this.inputStreamFactory = inputStreamFactory;
    }

    public static void main(String[] args) throws Exception {
        TlsCertificateAuthorityServiceCommandLine tlsCertificateAuthorityServiceCommandLine = new TlsCertificateAuthorityServiceCommandLine();
        try {
            tlsCertificateAuthorityServiceCommandLine.parse(args);
        }
        catch (CommandLineParseException e) {
            System.exit(e.getExitCode().ordinal());
        }
        TlsCertificateAuthorityService tlsCertificateAuthorityService = new TlsCertificateAuthorityService();
        tlsCertificateAuthorityService.start(tlsCertificateAuthorityServiceCommandLine.createConfig(), tlsCertificateAuthorityServiceCommandLine.getConfigJsonOut(), tlsCertificateAuthorityServiceCommandLine.differentPasswordForKeyAndKeystore());
        System.out.println("Server Started");
        System.out.flush();
    }

    public TlsConfig createConfig() throws IOException {
        String configJsonIn = this.getConfigJsonIn();
        if (!StringUtils.isEmpty((String)configJsonIn)) {
            try (InputStream inputStream = this.inputStreamFactory.create(new File(configJsonIn));){
                TlsConfig tlsConfig = (TlsConfig)new ObjectMapper().readValue(inputStream, TlsConfig.class);
                tlsConfig.initDefaults();
                TlsConfig tlsConfig2 = tlsConfig;
                return tlsConfig2;
            }
        }
        TlsConfig tlsConfig = new TlsConfig();
        tlsConfig.setCaHostname(this.getCertificateAuthorityHostname());
        tlsConfig.setDn(this.getDn());
        tlsConfig.setToken(this.getToken());
        tlsConfig.setPort(this.getPort());
        tlsConfig.setKeyStore(NIFI_CA_KEYSTORE + this.getKeyStoreType().toLowerCase());
        tlsConfig.setKeyStoreType(this.getKeyStoreType());
        tlsConfig.setKeySize(this.getKeySize());
        tlsConfig.setKeyPairAlgorithm(this.getKeyAlgorithm());
        tlsConfig.setSigningAlgorithm(this.getSigningAlgorithm());
        tlsConfig.setDays(this.getDays());
        return tlsConfig;
    }

    @Override
    protected String getTokenDescription() {
        return "The token to use to prevent MITM (required and must be same as one used by clients)";
    }

    @Override
    protected String getDnDescription() {
        return "The dn to use for the CA certificate";
    }

    @Override
    protected String getPortDescription() {
        return "The port for the Certificate Authority to listen on";
    }

    @Override
    protected String getDnHostname() {
        String dnHostname = this.getCertificateAuthorityHostname();
        if (StringUtils.isEmpty((String)dnHostname)) {
            return "YOUR_CA_HOSTNAME";
        }
        return dnHostname;
    }
}

