/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.tls.properties;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class NiFiPropertiesWriter {
    private final List<String> lines;
    private final Map<String, String> updatedValues;

    public NiFiPropertiesWriter(List<String> lines) {
        this.lines = new ArrayList<String>(lines);
        this.updatedValues = new HashMap<String, String>();
    }

    public void setPropertyValue(String key, String value) {
        this.updatedValues.put(key, value);
    }

    public void writeNiFiProperties(OutputStream outputStream) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream));){
            HashMap<String, String> remainingValues = new HashMap<String, String>(this.updatedValues);
            HashSet<String> keysSeen = new HashSet<String>();
            for (String string : this.lines) {
                String key = string.split("=")[0].trim();
                boolean outputLine = true;
                if (!key.isEmpty() && !key.startsWith("#")) {
                    if (!keysSeen.add(key)) {
                        throw new IOException("Found key more than once in nifi.properties: " + key);
                    }
                    String value = (String)remainingValues.remove(key);
                    if (value != null) {
                        writer.write(key);
                        writer.write("=");
                        writer.write(value);
                        outputLine = false;
                    }
                }
                if (outputLine) {
                    writer.write(string);
                }
                writer.newLine();
            }
            for (Map.Entry entry : remainingValues.entrySet()) {
                writer.write((String)entry.getKey());
                writer.write("=");
                writer.write((String)entry.getValue());
                writer.newLine();
            }
        }
    }
}

