/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine;

import io.questdb.cairo.Reopenable;
import io.questdb.std.MemoryPages;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.Unsafe;

public abstract class AbstractRedBlackTree
implements Mutable,
Reopenable {
    protected static final byte BLACK = 0;
    protected static final byte EMPTY = -1;
    protected static final int O_LEFT = 8;
    protected static final byte RED = 1;
    private static final int BLOCK_SIZE = 33;
    private static final int O_COLOUR = 24;
    private static final int O_REF = 25;
    private static final int O_RIGHT = 16;
    protected final MemoryPages mem;
    protected long root = -1L;

    public AbstractRedBlackTree(long keyPageSize, int keyMaxPages) {
        assert (keyPageSize >= (long)this.getBlockSize());
        this.mem = new MemoryPages(keyPageSize, keyMaxPages);
    }

    @Override
    public void clear() {
        this.root = -1L;
        this.mem.clear();
    }

    @Override
    public void close() {
        this.root = -1L;
        Misc.free(this.mem);
    }

    @Override
    public void reopen() {
        this.mem.reopen();
    }

    public long size() {
        return this.mem.countNumberOf(this.getBlockSize());
    }

    private void rotateLeft(long p) {
        if (p != -1L) {
            long r = AbstractRedBlackTree.rightOf(p);
            long lr = AbstractRedBlackTree.leftOf(r);
            AbstractRedBlackTree.setRight(p, lr);
            if (lr != -1L) {
                AbstractRedBlackTree.setParent(lr, p);
            }
            long pp = AbstractRedBlackTree.parentOf(p);
            AbstractRedBlackTree.setParent(r, pp);
            if (pp == -1L) {
                this.root = r;
            } else if (AbstractRedBlackTree.leftOf(pp) == p) {
                AbstractRedBlackTree.setLeft(pp, r);
            } else {
                AbstractRedBlackTree.setRight(pp, r);
            }
            AbstractRedBlackTree.setLeft(r, p);
            AbstractRedBlackTree.setParent(p, r);
        }
    }

    private void rotateRight(long p) {
        if (p != -1L) {
            long l = AbstractRedBlackTree.leftOf(p);
            long rl = AbstractRedBlackTree.rightOf(l);
            AbstractRedBlackTree.setLeft(p, rl);
            if (rl != -1L) {
                AbstractRedBlackTree.setParent(rl, p);
            }
            long pp = AbstractRedBlackTree.parentOf(p);
            AbstractRedBlackTree.setParent(l, pp);
            if (pp == -1L) {
                this.root = l;
            } else if (AbstractRedBlackTree.rightOf(pp) == p) {
                AbstractRedBlackTree.setRight(pp, l);
            } else {
                AbstractRedBlackTree.setLeft(pp, l);
            }
            AbstractRedBlackTree.setRight(l, p);
            AbstractRedBlackTree.setParent(p, l);
        }
    }

    protected static byte colorOf(long blockAddress) {
        return blockAddress == -1L ? (byte)0 : Unsafe.getUnsafe().getByte(blockAddress + 24L);
    }

    protected static long leftOf(long blockAddress) {
        return blockAddress == -1L ? -1L : Unsafe.getUnsafe().getLong(blockAddress + 8L);
    }

    protected static long parent2Of(long blockAddress) {
        return AbstractRedBlackTree.parentOf(AbstractRedBlackTree.parentOf(blockAddress));
    }

    protected static long parentOf(long blockAddress) {
        return blockAddress == -1L ? -1L : Unsafe.getUnsafe().getLong(blockAddress);
    }

    protected static long refOf(long blockAddress) {
        return blockAddress == -1L ? -1L : Unsafe.getUnsafe().getLong(blockAddress + 25L);
    }

    protected static long rightOf(long blockAddress) {
        return blockAddress == -1L ? -1L : Unsafe.getUnsafe().getLong(blockAddress + 16L);
    }

    protected static void setColor(long blockAddress, byte colour) {
        Unsafe.getUnsafe().putByte(blockAddress + 24L, colour);
    }

    protected static void setLeft(long blockAddress, long left) {
        Unsafe.getUnsafe().putLong(blockAddress + 8L, left);
    }

    protected static void setParent(long blockAddress, long parent) {
        Unsafe.getUnsafe().putLong(blockAddress, parent);
    }

    protected static void setRef(long blockAddress, long recRef) {
        Unsafe.getUnsafe().putLong(blockAddress + 25L, recRef);
    }

    protected static void setRight(long blockAddress, long right) {
        Unsafe.getUnsafe().putLong(blockAddress + 16L, right);
    }

    protected static long successor(long current) {
        long p = AbstractRedBlackTree.rightOf(current);
        if (p != -1L) {
            long l;
            while ((l = AbstractRedBlackTree.leftOf(p)) != -1L) {
                p = l;
            }
        } else {
            p = AbstractRedBlackTree.parentOf(current);
            long ch = current;
            while (p != -1L && ch == AbstractRedBlackTree.rightOf(p)) {
                ch = p;
                p = AbstractRedBlackTree.parentOf(p);
            }
        }
        return p;
    }

    protected long allocateBlock() {
        long p = this.mem.allocate(this.getBlockSize());
        AbstractRedBlackTree.setLeft(p, -1L);
        AbstractRedBlackTree.setRight(p, -1L);
        AbstractRedBlackTree.setColor(p, (byte)0);
        return p;
    }

    protected long findMaxNode() {
        long parent;
        long p = this.root;
        do {
            parent = p;
        } while ((p = AbstractRedBlackTree.rightOf(p)) > -1L);
        return parent;
    }

    protected long findMinNode() {
        long parent;
        long p = this.root;
        do {
            parent = p;
        } while ((p = AbstractRedBlackTree.leftOf(p)) > -1L);
        return parent;
    }

    void fixDelete(long node, long parent) {
        boolean isLeftChild;
        if (this.root == -1L) {
            return;
        }
        boolean bl = isLeftChild = parent != -1L && AbstractRedBlackTree.leftOf(parent) == node;
        while (node != this.root && AbstractRedBlackTree.colorOf(node) == 0) {
            long sibling;
            if (isLeftChild) {
                sibling = AbstractRedBlackTree.rightOf(parent);
                if (AbstractRedBlackTree.colorOf(sibling) == 1) {
                    AbstractRedBlackTree.setColor(sibling, (byte)0);
                    AbstractRedBlackTree.setColor(parent, (byte)1);
                    this.rotateLeft(parent);
                    sibling = AbstractRedBlackTree.rightOf(parent);
                }
                if (AbstractRedBlackTree.colorOf(AbstractRedBlackTree.leftOf(sibling)) == 0 && AbstractRedBlackTree.colorOf(AbstractRedBlackTree.rightOf(sibling)) == 0) {
                    AbstractRedBlackTree.setColor(sibling, (byte)1);
                    node = parent;
                    parent = AbstractRedBlackTree.parentOf(parent);
                    isLeftChild = parent != -1L && AbstractRedBlackTree.leftOf(parent) == node;
                    continue;
                }
                if (AbstractRedBlackTree.colorOf(AbstractRedBlackTree.rightOf(sibling)) == 0) {
                    AbstractRedBlackTree.setColor(AbstractRedBlackTree.leftOf(sibling), (byte)0);
                    AbstractRedBlackTree.setColor(sibling, (byte)1);
                    this.rotateRight(sibling);
                    sibling = AbstractRedBlackTree.rightOf(parent);
                }
                AbstractRedBlackTree.setColor(sibling, AbstractRedBlackTree.colorOf(parent));
                AbstractRedBlackTree.setColor(parent, (byte)0);
                if (AbstractRedBlackTree.rightOf(sibling) != -1L) {
                    AbstractRedBlackTree.setColor(AbstractRedBlackTree.rightOf(sibling), (byte)0);
                }
                this.rotateLeft(parent);
                break;
            }
            sibling = AbstractRedBlackTree.leftOf(parent);
            if (AbstractRedBlackTree.colorOf(sibling) == 1) {
                AbstractRedBlackTree.setColor(sibling, (byte)0);
                AbstractRedBlackTree.setColor(parent, (byte)1);
                this.rotateRight(parent);
                sibling = AbstractRedBlackTree.leftOf(parent);
            }
            if (AbstractRedBlackTree.colorOf(AbstractRedBlackTree.leftOf(sibling)) == 0 && AbstractRedBlackTree.colorOf(AbstractRedBlackTree.rightOf(sibling)) == 0) {
                AbstractRedBlackTree.setColor(sibling, (byte)1);
                node = parent;
                parent = AbstractRedBlackTree.parentOf(parent);
                isLeftChild = parent != -1L && AbstractRedBlackTree.leftOf(parent) == node;
                continue;
            }
            if (AbstractRedBlackTree.colorOf(AbstractRedBlackTree.leftOf(sibling)) == 0) {
                AbstractRedBlackTree.setColor(AbstractRedBlackTree.rightOf(sibling), (byte)0);
                AbstractRedBlackTree.setColor(sibling, (byte)1);
                this.rotateLeft(sibling);
                sibling = AbstractRedBlackTree.leftOf(parent);
            }
            AbstractRedBlackTree.setColor(sibling, AbstractRedBlackTree.colorOf(parent));
            AbstractRedBlackTree.setColor(parent, (byte)0);
            if (AbstractRedBlackTree.leftOf(sibling) != -1L) {
                AbstractRedBlackTree.setColor(AbstractRedBlackTree.leftOf(sibling), (byte)0);
            }
            this.rotateRight(parent);
            break;
        }
        if (node != -1L) {
            AbstractRedBlackTree.setColor(node, (byte)0);
        }
    }

    protected void fixInsert(long x) {
        long px;
        AbstractRedBlackTree.setColor(x, (byte)1);
        while (x != -1L && x != this.root && AbstractRedBlackTree.colorOf(px = AbstractRedBlackTree.parentOf(x)) == 1) {
            long y;
            long p20x = AbstractRedBlackTree.parent2Of(x);
            if (px == AbstractRedBlackTree.leftOf(p20x)) {
                y = AbstractRedBlackTree.rightOf(p20x);
                if (AbstractRedBlackTree.colorOf(y) == 1) {
                    AbstractRedBlackTree.setColor(px, (byte)0);
                    AbstractRedBlackTree.setColor(y, (byte)0);
                    AbstractRedBlackTree.setColor(p20x, (byte)1);
                    x = p20x;
                    continue;
                }
                if (x == AbstractRedBlackTree.rightOf(px)) {
                    x = px;
                    this.rotateLeft(x);
                    px = AbstractRedBlackTree.parentOf(x);
                    p20x = AbstractRedBlackTree.parent2Of(x);
                }
                AbstractRedBlackTree.setColor(px, (byte)0);
                AbstractRedBlackTree.setColor(p20x, (byte)1);
                this.rotateRight(p20x);
                continue;
            }
            y = AbstractRedBlackTree.leftOf(p20x);
            if (AbstractRedBlackTree.colorOf(y) == 1) {
                AbstractRedBlackTree.setColor(px, (byte)0);
                AbstractRedBlackTree.setColor(y, (byte)0);
                AbstractRedBlackTree.setColor(p20x, (byte)1);
                x = p20x;
                continue;
            }
            if (x == AbstractRedBlackTree.leftOf(px)) {
                x = AbstractRedBlackTree.parentOf(x);
                this.rotateRight(x);
                px = AbstractRedBlackTree.parentOf(x);
                p20x = AbstractRedBlackTree.parent2Of(x);
            }
            AbstractRedBlackTree.setColor(px, (byte)0);
            AbstractRedBlackTree.setColor(p20x, (byte)1);
            this.rotateLeft(p20x);
        }
        AbstractRedBlackTree.setColor(this.root, (byte)0);
    }

    protected int getBlockSize() {
        return 33;
    }

    protected void putParent(long value) {
        this.root = this.allocateBlock();
        AbstractRedBlackTree.setRef(this.root, value);
        AbstractRedBlackTree.setParent(this.root, -1L);
    }

    protected long remove(long node) {
        long nodeToRemove = AbstractRedBlackTree.leftOf(node) == -1L || AbstractRedBlackTree.rightOf(node) == -1L ? node : AbstractRedBlackTree.successor(node);
        long current = AbstractRedBlackTree.leftOf(nodeToRemove) != -1L ? AbstractRedBlackTree.leftOf(nodeToRemove) : AbstractRedBlackTree.rightOf(nodeToRemove);
        long parent = AbstractRedBlackTree.parentOf(nodeToRemove);
        if (current != -1L) {
            AbstractRedBlackTree.setParent(current, parent);
        }
        if (parent == -1L) {
            this.root = current;
        } else if (AbstractRedBlackTree.leftOf(parent) == nodeToRemove) {
            AbstractRedBlackTree.setLeft(parent, current);
        } else {
            AbstractRedBlackTree.setRight(parent, current);
        }
        if (nodeToRemove != node) {
            long tmp = AbstractRedBlackTree.refOf(nodeToRemove);
            AbstractRedBlackTree.setRef(nodeToRemove, AbstractRedBlackTree.refOf(node));
            AbstractRedBlackTree.setRef(node, tmp);
        }
        if (AbstractRedBlackTree.colorOf(nodeToRemove) == 0) {
            this.fixDelete(current, parent);
        }
        return nodeToRemove;
    }
}

