/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text.types;

import io.questdb.cairo.TableWriter;
import io.questdb.cutlass.text.types.AbstractTypeAdapter;
import io.questdb.cutlass.text.types.TimestampCompatibleAdapter;
import io.questdb.std.Mutable;
import io.questdb.std.NumericException;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.datetime.DateLocale;
import io.questdb.std.str.DirectByteCharSequence;

public class DateAdapter
extends AbstractTypeAdapter
implements Mutable,
TimestampCompatibleAdapter {
    private DateFormat format;
    private DateLocale locale;

    @Override
    public void clear() {
        this.format = null;
        this.locale = null;
    }

    @Override
    public long getTimestamp(DirectByteCharSequence value) throws Exception {
        return this.parseLong(value) * 1000L;
    }

    @Override
    public int getType() {
        return 7;
    }

    public DateAdapter of(DateFormat format, DateLocale locale) {
        this.format = format;
        this.locale = locale;
        return this;
    }

    @Override
    public boolean probe(DirectByteCharSequence text) {
        try {
            this.format.parse(text, this.locale);
            return true;
        }
        catch (NumericException e) {
            return false;
        }
    }

    @Override
    public void write(TableWriter.Row row, int column, DirectByteCharSequence value) throws Exception {
        row.putDate(column, this.parseLong(value));
    }

    private long parseLong(DirectByteCharSequence value) throws NumericException {
        return this.format.parse(value, this.locale);
    }
}

