/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util.console;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.apache.nifi.util.console.CharacterDevice;
import org.apache.nifi.util.console.ConsoleDevice;
import org.apache.nifi.util.console.TextDevice;

public final class TextDevices {
    private static TextDevice DEFAULT = System.console() == null ? TextDevices.streamDevice(System.in, System.out) : new ConsoleDevice(System.console());

    private TextDevices() {
    }

    public static TextDevice defaultTextDevice() {
        return DEFAULT;
    }

    public static TextDevice streamDevice(InputStream in, OutputStream out) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        PrintWriter writer = new PrintWriter(out, true);
        return new CharacterDevice(reader, writer);
    }

    public static TextDevice characterDevice(BufferedReader reader, PrintWriter writer) {
        return new CharacterDevice(reader, writer);
    }
}

