/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.swap;

import java.util.Collections;
import java.util.List;
import org.apache.nifi.controller.queue.QueueSize;
import org.apache.nifi.controller.repository.SwapSummary;
import org.apache.nifi.controller.repository.claim.ResourceClaim;

public class StandardSwapSummary
implements SwapSummary {
    public static final SwapSummary EMPTY_SUMMARY = new StandardSwapSummary(new QueueSize(0, 0L), null, Collections.emptyList(), 0L, 0L);
    private final QueueSize queueSize;
    private final Long maxFlowFileId;
    private final List<ResourceClaim> resourceClaims;
    private final Long minLastQueueDate;
    private final Long totalLastQueueDate;

    public StandardSwapSummary(QueueSize queueSize, Long maxFlowFileId, List<ResourceClaim> resourceClaims, Long minLastQueueDate, Long totalLastQueueDate) {
        this.queueSize = queueSize;
        this.maxFlowFileId = maxFlowFileId;
        this.resourceClaims = Collections.unmodifiableList(resourceClaims);
        this.minLastQueueDate = minLastQueueDate;
        this.totalLastQueueDate = totalLastQueueDate;
    }

    public QueueSize getQueueSize() {
        return this.queueSize;
    }

    public Long getMaxFlowFileId() {
        return this.maxFlowFileId;
    }

    public List<ResourceClaim> getResourceClaims() {
        return this.resourceClaims;
    }

    public Long getMinLastQueueDate() {
        return this.minLastQueueDate;
    }

    public Long getTotalLastQueueDate() {
        return this.totalLastQueueDate;
    }
}

