/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.analytics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.nifi.controller.status.analytics.StatusAnalyticsModel;
import org.apache.nifi.controller.status.analytics.StatusMetricExtractFunction;
import org.apache.nifi.controller.status.history.StatusHistoryUtil;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.NarThreadContextClassLoader;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.Tuple;
import org.apache.nifi.web.api.dto.status.StatusHistoryDTO;
import org.apache.nifi.web.api.dto.status.StatusSnapshotDTO;

public class StatusAnalyticsModelMapFactory {
    private static final String QUEUED_COUNT_METRIC = "queuedCount";
    private static final String QUEUED_BYTES_METRIC = "queuedBytes";
    private static final String INPUT_COUNT_METRIC = "inputCount";
    private static final String INPUT_BYTES_METRIC = "inputBytes";
    private static final String OUTPUT_COUNT_METRIC = "outputCount";
    private static final String OUTPUT_BYTES_METRIC = "outputBytes";
    final ExtensionManager extensionManager;
    final NiFiProperties niFiProperties;

    public StatusAnalyticsModelMapFactory(ExtensionManager extensionManager, NiFiProperties niFiProperties) {
        this.extensionManager = extensionManager;
        this.niFiProperties = niFiProperties;
    }

    public Map<String, Tuple<StatusAnalyticsModel, StatusMetricExtractFunction>> getConnectionStatusModelMap() {
        HashMap<String, Tuple<StatusAnalyticsModel, StatusMetricExtractFunction>> modelMap = new HashMap<String, Tuple<StatusAnalyticsModel, StatusMetricExtractFunction>>();
        StatusMetricExtractFunction extract = this.getConnectionStatusExtractFunction();
        Tuple countModelFunction = new Tuple((Object)this.createModelInstance(this.extensionManager, this.niFiProperties), (Object)extract);
        Tuple byteModelFunction = new Tuple((Object)this.createModelInstance(this.extensionManager, this.niFiProperties), (Object)extract);
        modelMap.put(QUEUED_COUNT_METRIC, countModelFunction);
        modelMap.put(QUEUED_BYTES_METRIC, byteModelFunction);
        return modelMap;
    }

    private StatusAnalyticsModel createModelInstance(ExtensionManager extensionManager, NiFiProperties nifiProperties) {
        String implementationClassName = nifiProperties.getProperty("nifi.analytics.connection.model.implementation", "org.apache.nifi.controller.status.analytics.models.OrdinaryLeastSquares");
        if (implementationClassName == null) {
            throw new RuntimeException("Cannot create Analytics Model because the NiFi Properties is missing the following property: nifi.analytics.connection.model.implementation");
        }
        try {
            return (StatusAnalyticsModel)NarThreadContextClassLoader.createInstance((ExtensionManager)extensionManager, (String)implementationClassName, StatusAnalyticsModel.class, (NiFiProperties)nifiProperties);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private StatusMetricExtractFunction getConnectionStatusExtractFunction() {
        return (metric, statusHistory) -> {
            ArrayList<Double> values = new ArrayList<Double>();
            ArrayList<Double[]> features = new ArrayList<Double[]>();
            Random rand = new Random();
            StatusHistoryDTO statusHistoryDTO = StatusHistoryUtil.createStatusHistoryDTO(statusHistory);
            for (StatusSnapshotDTO snap : statusHistoryDTO.getAggregateSnapshots()) {
                Double inOutRatio;
                ArrayList<Double> featureArray = new ArrayList<Double>();
                Long snapValue = (Long)snap.getStatusMetrics().get(metric);
                long snapTime = snap.getTimestamp().getTime();
                featureArray.add(Double.valueOf(snapTime));
                Double randomError = (double)rand.nextInt(1000) * 1.0E-7;
                if (metric.equals(QUEUED_COUNT_METRIC)) {
                    Long inputCount = (Long)snap.getStatusMetrics().get(INPUT_COUNT_METRIC);
                    Long outputCount = (Long)snap.getStatusMetrics().get(OUTPUT_COUNT_METRIC);
                    inOutRatio = (double)outputCount.longValue() / (double)inputCount.longValue() + randomError;
                    featureArray.add(Double.isNaN(inOutRatio) ? randomError : inOutRatio);
                } else {
                    Long inputBytes = (Long)snap.getStatusMetrics().get(INPUT_BYTES_METRIC);
                    Long outputBytes = (Long)snap.getStatusMetrics().get(OUTPUT_BYTES_METRIC);
                    inOutRatio = (double)outputBytes.longValue() / (double)inputBytes.longValue() + randomError;
                    featureArray.add(Double.isNaN(inOutRatio) ? randomError : inOutRatio);
                }
                values.add(Double.valueOf(snapValue.longValue()));
                features.add(featureArray.toArray(new Double[featureArray.size()]));
            }
            return new Tuple(features.stream(), values.stream());
        };
    }
}

