/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.nifi.controller.lifecycle.TaskTermination;
import org.apache.nifi.processor.exception.TerminatedTaskException;

public class TaskTerminationInputStream
extends InputStream {
    private final TaskTermination taskTermination;
    private final InputStream delegate;
    private final Runnable terminatedCallback;

    public TaskTerminationInputStream(InputStream delegate, TaskTermination taskTermination, Runnable terminatedCallback) {
        this.delegate = delegate;
        this.taskTermination = taskTermination;
        this.terminatedCallback = terminatedCallback;
    }

    private void verifyNotTerminated() {
        if (this.taskTermination.isTerminated()) {
            TerminatedTaskException tte = new TerminatedTaskException();
            if (this.terminatedCallback != null) {
                try {
                    this.terminatedCallback.run();
                }
                catch (Exception e) {
                    tte.addSuppressed((Throwable)e);
                }
            }
            throw tte;
        }
    }

    @Override
    public int read() throws IOException {
        this.verifyNotTerminated();
        return this.delegate.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.verifyNotTerminated();
        return this.delegate.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.verifyNotTerminated();
        return this.delegate.read(b, off, len);
    }

    @Override
    public int available() throws IOException {
        this.verifyNotTerminated();
        return this.delegate.available();
    }

    @Override
    public long skip(long n) throws IOException {
        this.verifyNotTerminated();
        return this.delegate.skip(n);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.verifyNotTerminated();
        this.delegate.reset();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.verifyNotTerminated();
        this.delegate.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        this.verifyNotTerminated();
        return this.delegate.markSupported();
    }

    @Override
    public void close() throws IOException {
        block5: {
            try {
                this.delegate.close();
            }
            catch (Exception e) {
                if (!this.taskTermination.isTerminated()) break block5;
                TerminatedTaskException tte = new TerminatedTaskException();
                tte.addSuppressed((Throwable)e);
                if (this.terminatedCallback != null) {
                    try {
                        this.terminatedCallback.run();
                    }
                    catch (Exception callbackException) {
                        tte.addSuppressed((Throwable)callbackException);
                    }
                }
                throw tte;
            }
        }
        this.verifyNotTerminated();
    }
}

