/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.nifi.controller.Snippet;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.registry.flow.VersionControlInformation;
import org.apache.nifi.web.api.dto.ComponentDTO;
import org.apache.nifi.web.api.dto.ConnectionDTO;
import org.apache.nifi.web.api.dto.FlowSnippetDTO;
import org.apache.nifi.web.api.dto.PositionDTO;
import org.apache.nifi.web.api.dto.ProcessGroupDTO;
import org.apache.nifi.web.api.dto.VersionControlInformationDTO;

public final class SnippetUtils {
    public static void moveSnippet(FlowSnippetDTO snippet, Double x, Double y) {
        SnippetUtils.moveAndScaleSnippet(snippet, x, y, 1.0, 1.0);
    }

    public static void moveAndScaleSnippet(FlowSnippetDTO snippet, Double x, Double y, double factorX, double factorY) {
        if (x != null && y != null) {
            PositionDTO origin = new PositionDTO(x, y);
            Collection<ConnectionDTO> connections = SnippetUtils.getConnections(snippet);
            Collection<ComponentDTO> components = SnippetUtils.getComponents(snippet);
            if (connections.isEmpty() && components.isEmpty()) {
                return;
            }
            Map<ComponentDTO, PositionDTO> componentPositionLookup = SnippetUtils.getPositionLookup(components);
            Map<ConnectionDTO, List<PositionDTO>> connectionPositionLookup = SnippetUtils.getConnectionPositionLookup(connections);
            PositionDTO currentOrigin = SnippetUtils.getOrigin(componentPositionLookup.values(), connectionPositionLookup.values());
            for (PositionDTO positionDTO : componentPositionLookup.values()) {
                positionDTO.setX(Double.valueOf(origin.getX() + (positionDTO.getX() - currentOrigin.getX()) * factorX));
                positionDTO.setY(Double.valueOf(origin.getY() + (positionDTO.getY() - currentOrigin.getY()) * factorY));
            }
            for (List list : connectionPositionLookup.values()) {
                for (PositionDTO bend : list) {
                    bend.setX(Double.valueOf(origin.getX() + (bend.getX() - currentOrigin.getX()) * factorX));
                    bend.setY(Double.valueOf(origin.getY() + (bend.getY() - currentOrigin.getY()) * factorY));
                }
            }
            SnippetUtils.applyUpdatedPositions(componentPositionLookup, connectionPositionLookup);
        }
    }

    public static void scaleSnippet(FlowSnippetDTO snippet, double factorX, double factorY) {
        Collection<ConnectionDTO> connections = SnippetUtils.getConnections(snippet);
        Collection<ComponentDTO> components = SnippetUtils.getComponents(snippet);
        if (connections.isEmpty() && components.isEmpty()) {
            return;
        }
        Map<ComponentDTO, PositionDTO> componentPositionLookup = SnippetUtils.getPositionLookup(components);
        Map<ConnectionDTO, List<PositionDTO>> connectionPositionLookup = SnippetUtils.getConnectionPositionLookup(connections);
        for (PositionDTO positionDTO : componentPositionLookup.values()) {
            positionDTO.setX(Double.valueOf(positionDTO.getX() * factorX));
            positionDTO.setY(Double.valueOf(positionDTO.getY() * factorY));
        }
        for (List list : connectionPositionLookup.values()) {
            for (PositionDTO bend : list) {
                bend.setX(Double.valueOf(bend.getX() * factorX));
                bend.setY(Double.valueOf(bend.getY() * factorY));
            }
        }
        SnippetUtils.applyUpdatedPositions(componentPositionLookup, connectionPositionLookup);
    }

    public static List<ProcessGroupDTO> findAllProcessGroups(FlowSnippetDTO snippet) {
        ArrayList<ProcessGroupDTO> allProcessGroups = new ArrayList<ProcessGroupDTO>(snippet.getProcessGroups());
        for (ProcessGroupDTO childGroup : snippet.getProcessGroups()) {
            allProcessGroups.addAll(SnippetUtils.findAllProcessGroups(childGroup.getContents()));
        }
        return allProcessGroups;
    }

    private static Collection<ConnectionDTO> getConnections(FlowSnippetDTO contents) {
        HashSet<ConnectionDTO> connections = new HashSet<ConnectionDTO>();
        if (contents.getConnections() != null) {
            connections.addAll(contents.getConnections());
        }
        return connections;
    }

    private static Collection<ComponentDTO> getComponents(FlowSnippetDTO contents) {
        HashSet<ComponentDTO> components = new HashSet<ComponentDTO>();
        if (contents.getInputPorts() != null) {
            components.addAll(contents.getInputPorts());
        }
        if (contents.getLabels() != null) {
            components.addAll(contents.getLabels());
        }
        if (contents.getOutputPorts() != null) {
            components.addAll(contents.getOutputPorts());
        }
        if (contents.getProcessGroups() != null) {
            components.addAll(contents.getProcessGroups());
        }
        if (contents.getProcessors() != null) {
            components.addAll(contents.getProcessors());
        }
        if (contents.getFunnels() != null) {
            components.addAll(contents.getFunnels());
        }
        if (contents.getRemoteProcessGroups() != null) {
            components.addAll(contents.getRemoteProcessGroups());
        }
        return components;
    }

    private static Map<ComponentDTO, PositionDTO> getPositionLookup(Collection<ComponentDTO> components) {
        HashMap<ComponentDTO, PositionDTO> positionLookup = new HashMap<ComponentDTO, PositionDTO>();
        for (ComponentDTO component : components) {
            positionLookup.put(component, new PositionDTO(component.getPosition().getX(), component.getPosition().getY()));
        }
        return positionLookup;
    }

    private static Map<ConnectionDTO, List<PositionDTO>> getConnectionPositionLookup(Collection<ConnectionDTO> connections) {
        HashMap<ConnectionDTO, List<PositionDTO>> positionLookup = new HashMap<ConnectionDTO, List<PositionDTO>>();
        for (ConnectionDTO connection : connections) {
            List bendsCopy;
            if (connection.getBends() == null) {
                bendsCopy = Collections.emptyList();
            } else {
                bendsCopy = new ArrayList(connection.getBends().size());
                for (PositionDTO bend : connection.getBends()) {
                    bendsCopy.add(new PositionDTO(bend.getX(), bend.getY()));
                }
            }
            positionLookup.put(connection, bendsCopy);
        }
        return positionLookup;
    }

    private static PositionDTO getOrigin(Collection<PositionDTO> componentPositions, Collection<List<PositionDTO>> connectionPositions) {
        Double x = null;
        Double y = null;
        if (componentPositions.isEmpty() && connectionPositions.isEmpty()) {
            throw new IllegalArgumentException("Unable to compute the origin for an empty snippet.");
        }
        for (PositionDTO positionDTO : componentPositions) {
            if (positionDTO == null) continue;
            if (x == null || positionDTO.getX() < x) {
                x = positionDTO.getX();
            }
            if (y != null && !(positionDTO.getY() < y)) continue;
            y = positionDTO.getY();
        }
        for (List list : connectionPositions) {
            for (PositionDTO point : list) {
                if (x == null || point.getX() < x) {
                    x = point.getX();
                }
                if (y != null && !(point.getY() < y)) continue;
                y = point.getY();
            }
        }
        return new PositionDTO(x, y);
    }

    private static void applyUpdatedPositions(Map<ComponentDTO, PositionDTO> componentPositionLookup, Map<ConnectionDTO, List<PositionDTO>> connectionPositionLookup) {
        for (Map.Entry<ComponentDTO, PositionDTO> entry : componentPositionLookup.entrySet()) {
            ComponentDTO component = entry.getKey();
            PositionDTO position = entry.getValue();
            component.setPosition(position);
        }
        for (Map.Entry<Object, Object> entry : connectionPositionLookup.entrySet()) {
            ConnectionDTO connection = (ConnectionDTO)entry.getKey();
            List bends = (List)entry.getValue();
            connection.setBends(bends);
        }
    }

    public static void verifyNoVersionControlConflicts(Snippet snippet, ProcessGroup parentGroup, ProcessGroup destination) {
        if (snippet == null) {
            return;
        }
        if (snippet.getProcessGroups() == null) {
            return;
        }
        ArrayList<VersionControlInformation> vcis = new ArrayList<VersionControlInformation>();
        for (String groupId : snippet.getProcessGroups().keySet()) {
            ProcessGroup group = parentGroup.getProcessGroup(groupId);
            if (group == null) continue;
            SnippetUtils.findAllVersionControlInfo(group, vcis);
        }
        SnippetUtils.verifyNoDuplicateVersionControlInfo(destination, vcis);
    }

    public static void verifyNoVersionControlConflicts(FlowSnippetDTO snippetContents, ProcessGroup destination) {
        ArrayList<VersionControlInformationDTO> vcis = new ArrayList<VersionControlInformationDTO>();
        for (ProcessGroupDTO childGroup : snippetContents.getProcessGroups()) {
            SnippetUtils.findAllVersionControlInfo(childGroup, vcis);
        }
        SnippetUtils.verifyNoDuplicateVersionControlInfoDtos(destination, vcis);
    }

    private static void verifyNoDuplicateVersionControlInfoDtos(ProcessGroup group, Collection<VersionControlInformationDTO> snippetVcis) {
        ProcessGroup parent;
        VersionControlInformation vci = group.getVersionControlInformation();
        if (vci != null) {
            for (VersionControlInformationDTO snippetVci : snippetVcis) {
                if (!vci.getBucketIdentifier().equals(snippetVci.getBucketId()) || !vci.getFlowIdentifier().equals(snippetVci.getFlowId())) continue;
                throw new IllegalArgumentException("Cannot place the given Process Group into the desired destination because the destination group or one of its ancestor groups is under Version Control and one of the selected Process Groups is also under Version Control with the same Flow. A Process Group that is under Version Control cannot contain a child Process Group that points to the same Versioned Flow.");
            }
        }
        if ((parent = group.getParent()) != null) {
            SnippetUtils.verifyNoDuplicateVersionControlInfoDtos(parent, snippetVcis);
        }
    }

    private static void verifyNoDuplicateVersionControlInfo(ProcessGroup group, Collection<VersionControlInformation> snippetVcis) {
        ProcessGroup parent;
        VersionControlInformation vci = group.getVersionControlInformation();
        if (vci != null) {
            for (VersionControlInformation snippetVci : snippetVcis) {
                if (!vci.getBucketIdentifier().equals(snippetVci.getBucketIdentifier()) || !vci.getFlowIdentifier().equals(snippetVci.getFlowIdentifier())) continue;
                throw new IllegalArgumentException("Cannot place the given Process Group into the desired destination because the destination group or one of its ancestor groups is under Version Control and one of the selected Process Groups is also under Version Control with the same Flow. A Process Group that is under Version Control cannot contain a child Process Group that points to the same Versioned Flow.");
            }
        }
        if ((parent = group.getParent()) != null) {
            SnippetUtils.verifyNoDuplicateVersionControlInfo(parent, snippetVcis);
        }
    }

    private static void findAllVersionControlInfo(ProcessGroupDTO dto, List<VersionControlInformationDTO> found) {
        FlowSnippetDTO contents;
        VersionControlInformationDTO vci = dto.getVersionControlInformation();
        if (vci != null) {
            found.add(vci);
        }
        if ((contents = dto.getContents()) != null) {
            for (ProcessGroupDTO child : contents.getProcessGroups()) {
                SnippetUtils.findAllVersionControlInfo(child, found);
            }
        }
    }

    private static void findAllVersionControlInfo(ProcessGroup group, List<VersionControlInformation> found) {
        if (group == null) {
            return;
        }
        VersionControlInformation vci = group.getVersionControlInformation();
        if (vci != null) {
            found.add(vci);
        }
        for (ProcessGroup childGroup : group.findAllProcessGroups()) {
            SnippetUtils.findAllVersionControlInfo(childGroup, found);
        }
    }
}

