/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.logging.LogLevel;

public class TerminationAwareLogger
implements ComponentLog {
    private static final String TERMINATED_TASK_PREFIX = "[Terminated Process] - ";
    private final ComponentLog logger;
    private volatile boolean terminated = false;

    public TerminationAwareLogger(ComponentLog logger) {
        this.logger = logger;
    }

    public void terminate() {
        this.terminated = true;
    }

    private boolean isTerminated() {
        return this.terminated;
    }

    private String getMessage(String originalMessage, LogLevel logLevel) {
        return TERMINATED_TASK_PREFIX + logLevel.name() + " - " + originalMessage;
    }

    public void warn(String msg, Throwable t) {
        if (this.isTerminated()) {
            this.logger.debug(this.getMessage(msg, LogLevel.WARN), t);
            return;
        }
        this.logger.warn(msg, t);
    }

    public void warn(String msg, Object ... os) {
        if (this.isTerminated()) {
            this.logger.debug(this.getMessage(msg, LogLevel.WARN), os);
            return;
        }
        this.logger.warn(msg, os);
    }

    public void warn(String msg, Object[] os, Throwable t) {
        if (this.isTerminated()) {
            this.logger.debug(this.getMessage(msg, LogLevel.WARN), os, t);
            return;
        }
        this.logger.warn(msg, os, t);
    }

    public void warn(String msg) {
        if (this.isTerminated()) {
            this.logger.debug(this.getMessage(msg, LogLevel.WARN));
            return;
        }
        this.logger.warn(msg);
    }

    public void trace(String msg, Throwable t) {
        if (this.isTerminated()) {
            this.logger.trace(this.getMessage(msg, LogLevel.TRACE), t);
            return;
        }
        this.logger.trace(msg, t);
    }

    public void trace(String msg, Object ... os) {
        if (this.isTerminated()) {
            this.logger.trace(this.getMessage(msg, LogLevel.TRACE), os);
            return;
        }
        this.logger.trace(msg, os);
    }

    public void trace(String msg) {
        if (this.isTerminated()) {
            this.logger.trace(this.getMessage(msg, LogLevel.TRACE));
            return;
        }
        this.logger.trace(msg);
    }

    public void trace(String msg, Object[] os, Throwable t) {
        if (this.isTerminated()) {
            this.logger.trace(this.getMessage(msg, LogLevel.TRACE), os, t);
            return;
        }
        this.logger.trace(msg, os, t);
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void info(String msg, Throwable t) {
        if (this.isTerminated()) {
            this.logger.debug(this.getMessage(msg, LogLevel.INFO), t);
            return;
        }
        this.logger.info(msg, t);
    }

    public void info(String msg, Object ... os) {
        if (this.isTerminated()) {
            this.logger.debug(this.getMessage(msg, LogLevel.INFO), os);
            return;
        }
        this.logger.info(msg, os);
    }

    public void info(String msg) {
        if (this.isTerminated()) {
            this.logger.debug(this.getMessage(msg, LogLevel.INFO));
            return;
        }
        this.logger.info(msg);
    }

    public void info(String msg, Object[] os, Throwable t) {
        if (this.isTerminated()) {
            this.logger.debug(this.getMessage(msg, LogLevel.INFO), os, t);
            return;
        }
        this.logger.info(msg, os, t);
    }

    public String getName() {
        return this.logger.getName();
    }

    public void error(String msg, Throwable t) {
        if (this.isTerminated()) {
            this.logger.debug(this.getMessage(msg, LogLevel.ERROR), t);
            return;
        }
        this.logger.error(msg, t);
    }

    public void error(String msg, Object ... os) {
        if (this.isTerminated()) {
            this.logger.debug(this.getMessage(msg, LogLevel.ERROR), os);
            return;
        }
        this.logger.error(msg, os);
    }

    public void error(String msg) {
        if (this.isTerminated()) {
            this.logger.debug(this.getMessage(msg, LogLevel.ERROR));
            return;
        }
        this.logger.error(msg);
    }

    public void error(String msg, Object[] os, Throwable t) {
        if (this.isTerminated()) {
            this.logger.debug(this.getMessage(msg, LogLevel.ERROR), os, t);
            return;
        }
        this.logger.error(msg, os, t);
    }

    public void debug(String msg, Throwable t) {
        if (this.isTerminated()) {
            this.logger.debug(this.getMessage(msg, LogLevel.DEBUG), t);
            return;
        }
        this.logger.debug(msg, t);
    }

    public void debug(String msg, Object ... os) {
        if (this.isTerminated()) {
            this.logger.debug(this.getMessage(msg, LogLevel.DEBUG), os);
            return;
        }
        this.logger.debug(msg, os);
    }

    public void debug(String msg, Object[] os, Throwable t) {
        if (this.isTerminated()) {
            this.logger.debug(this.getMessage(msg, LogLevel.DEBUG), os, t);
            return;
        }
        this.logger.debug(msg, os, t);
    }

    public void debug(String msg) {
        if (this.isTerminated()) {
            this.logger.debug(this.getMessage(msg, LogLevel.DEBUG));
            return;
        }
        this.logger.debug(msg);
    }

    public void log(LogLevel level, String msg, Throwable t) {
        if (this.isTerminated()) {
            this.logger.debug(this.getMessage(msg, level), t);
            return;
        }
        this.logger.log(level, msg, t);
    }

    public void log(LogLevel level, String msg, Object ... os) {
        if (this.isTerminated()) {
            this.logger.debug(this.getMessage(msg, level), os);
            return;
        }
        this.logger.log(level, msg, os);
    }

    public void log(LogLevel level, String msg) {
        if (this.isTerminated()) {
            this.logger.debug(this.getMessage(msg, level));
            return;
        }
        this.logger.log(level, msg);
    }

    public void log(LogLevel level, String msg, Object[] os, Throwable t) {
        if (this.isTerminated()) {
            this.logger.debug(this.getMessage(msg, level), os, t);
            return;
        }
        this.logger.log(level, msg, os, t);
    }
}

