/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.ssl;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.nifi.security.ssl.BuilderConfigurationException;
import org.apache.nifi.security.ssl.TrustManagerBuilder;

public class StandardTrustManagerBuilder
implements TrustManagerBuilder {
    private KeyStore trustStore;

    @Override
    public X509TrustManager build() {
        TrustManager[] trustManagers = this.getTrustManagers();
        if (trustManagers == null) {
            throw new BuilderConfigurationException("Trust Managers not found: Trust Store required");
        }
        Optional<X509TrustManager> configuredTrustManager = Arrays.stream(trustManagers).filter(trustManager -> trustManager instanceof X509TrustManager).map(trustManager -> (X509TrustManager)trustManager).findFirst();
        return configuredTrustManager.orElseThrow(() -> new BuilderConfigurationException("X.509 Trust Manager not found"));
    }

    public StandardTrustManagerBuilder trustStore(KeyStore trustStore) {
        this.trustStore = Objects.requireNonNull(trustStore, "Trust Store required");
        return this;
    }

    private TrustManager[] getTrustManagers() {
        TrustManager[] trustManagers;
        if (this.trustStore == null) {
            trustManagers = null;
        } else {
            TrustManagerFactory trustManagerFactory = this.getTrustManagerFactory();
            try {
                trustManagerFactory.init(this.trustStore);
            }
            catch (KeyStoreException e) {
                throw new BuilderConfigurationException("Trust Manager initialization failed", e);
            }
            trustManagers = trustManagerFactory.getTrustManagers();
        }
        return trustManagers;
    }

    private TrustManagerFactory getTrustManagerFactory() {
        String algorithm = TrustManagerFactory.getDefaultAlgorithm();
        try {
            return TrustManagerFactory.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            String message = String.format("TrustManagerFactory creation failed with algorithm [%s]", algorithm);
            throw new BuilderConfigurationException(message, e);
        }
    }
}

