/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.protocol;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.StringUtils;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class NodeIdentifier {
    private final String id;
    private final String apiAddress;
    private final int apiPort;
    private final String socketAddress;
    private final int socketPort;
    private final String loadBalanceAddress;
    private final int loadBalancePort;
    private final String siteToSiteAddress;
    private final Integer siteToSitePort;
    private final Integer siteToSiteHttpApiPort;
    private final Boolean siteToSiteSecure;
    private final Set<String> nodeIdentities;

    public NodeIdentifier(String id, String apiAddress, int apiPort, String socketAddress, int socketPort, String siteToSiteAddress, Integer siteToSitePort, Integer siteToSiteHttpApiPort, boolean siteToSiteSecure) {
        this(id, apiAddress, apiPort, socketAddress, socketPort, socketAddress, 6342, siteToSiteAddress, siteToSitePort, siteToSiteHttpApiPort, siteToSiteSecure, null);
    }

    public NodeIdentifier(String id, String apiAddress, int apiPort, String socketAddress, int socketPort, String loadBalanceAddress, int loadBalancePort, String siteToSiteAddress, Integer siteToSitePort, Integer siteToSiteHttpApiPort, boolean siteToSiteSecure) {
        this(id, apiAddress, apiPort, socketAddress, socketPort, loadBalanceAddress, loadBalancePort, siteToSiteAddress, siteToSitePort, siteToSiteHttpApiPort, siteToSiteSecure, null);
    }

    public NodeIdentifier(String id, String apiAddress, int apiPort, String socketAddress, int socketPort, String loadBalanceAddress, int loadBalancePort, String siteToSiteAddress, Integer siteToSitePort, Integer siteToSiteHttpApiPort, boolean siteToSiteSecure, Set<String> nodeIdentities) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("Node ID may not be empty or null.");
        }
        if (StringUtils.isBlank((CharSequence)apiAddress)) {
            throw new IllegalArgumentException("Node API address may not be empty or null.");
        }
        if (StringUtils.isBlank((CharSequence)socketAddress)) {
            throw new IllegalArgumentException("Node socket address may not be empty or null.");
        }
        this.validatePort(apiPort);
        this.validatePort(socketPort);
        this.validatePort(loadBalancePort);
        if (siteToSitePort != null) {
            this.validatePort(siteToSitePort);
        }
        this.id = id;
        this.apiAddress = apiAddress;
        this.apiPort = apiPort;
        this.socketAddress = socketAddress;
        this.socketPort = socketPort;
        this.loadBalanceAddress = loadBalanceAddress;
        this.loadBalancePort = loadBalancePort;
        this.nodeIdentities = nodeIdentities == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<String>(nodeIdentities));
        this.siteToSiteAddress = siteToSiteAddress == null ? apiAddress : siteToSiteAddress;
        this.siteToSitePort = siteToSitePort;
        this.siteToSiteHttpApiPort = siteToSiteHttpApiPort;
        this.siteToSiteSecure = siteToSiteSecure;
    }

    public NodeIdentifier() {
        this.id = null;
        this.apiAddress = null;
        this.apiPort = 0;
        this.socketAddress = null;
        this.socketPort = 0;
        this.loadBalanceAddress = null;
        this.loadBalancePort = 0;
        this.nodeIdentities = Collections.emptySet();
        this.siteToSiteAddress = null;
        this.siteToSitePort = null;
        this.siteToSiteHttpApiPort = null;
        this.siteToSiteSecure = false;
    }

    public String getId() {
        return this.id;
    }

    public Set<String> getNodeIdentities() {
        return this.nodeIdentities;
    }

    public String getApiAddress() {
        return this.apiAddress;
    }

    public int getApiPort() {
        return this.apiPort;
    }

    public String getSocketAddress() {
        return this.socketAddress;
    }

    public int getSocketPort() {
        return this.socketPort;
    }

    public String getLoadBalanceAddress() {
        return this.loadBalanceAddress;
    }

    public int getLoadBalancePort() {
        return this.loadBalancePort;
    }

    private void validatePort(int port) {
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("Port must be inclusively in the range [1, 65535].  Port given: " + port);
        }
    }

    public String getSiteToSiteAddress() {
        return this.siteToSiteAddress;
    }

    public Integer getSiteToSitePort() {
        return this.siteToSitePort;
    }

    public Integer getSiteToSiteHttpApiPort() {
        return this.siteToSiteHttpApiPort;
    }

    public boolean isSiteToSiteSecure() {
        return this.siteToSiteSecure;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeIdentifier other = (NodeIdentifier)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public boolean logicallyEquals(NodeIdentifier other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!Objects.equals(this.apiAddress, other.apiAddress)) {
            return false;
        }
        if (this.apiPort != other.apiPort) {
            return false;
        }
        if (!Objects.equals(this.socketAddress, other.socketAddress)) {
            return false;
        }
        return this.socketPort == other.socketPort;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (this.id != null ? this.id.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return this.apiAddress + ":" + this.apiPort;
    }

    public String getFullDescription() {
        return "NodeIdentifier[UUID=" + this.id + ", API Address = " + this.apiAddress + ":" + this.apiPort + ", Cluster Socket Address = " + this.socketAddress + ":" + this.socketPort + ", Load Balance Address = " + this.loadBalanceAddress + ":" + this.loadBalancePort + ", Site-to-Site Raw Address = " + this.siteToSiteAddress + ":" + this.siteToSitePort + ", Site-to-Site HTTP Address = " + this.apiAddress + ":" + this.siteToSiteHttpApiPort + ", Site-to-Site Secure = " + this.siteToSiteSecure + ", Node Identities = " + this.nodeIdentities + "]";
    }
}

