/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.ops;

import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.EntryUnavailableException;
import io.questdb.cairo.TableWriterAPI;
import io.questdb.cairo.sql.AsyncWriterCommand;
import io.questdb.cairo.sql.OperationFuture;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.ops.AbstractOperation;
import io.questdb.griffin.engine.ops.DoneOperationFuture;
import io.questdb.griffin.engine.ops.OperationFutureImpl;
import io.questdb.mp.SCSequence;
import io.questdb.std.WeakSelfReturningObjectPool;
import org.jetbrains.annotations.Nullable;

public abstract class OperationDispatcher<T extends AbstractOperation> {
    private final DoneOperationFuture doneFuture = new DoneOperationFuture();
    private final CairoEngine engine;
    private final WeakSelfReturningObjectPool<OperationFutureImpl> futurePool;
    private final String lockReason;

    public OperationDispatcher(CairoEngine engine, String lockReason) {
        this.engine = engine;
        this.futurePool = new WeakSelfReturningObjectPool<OperationFutureImpl>(pool -> new OperationFutureImpl(engine, pool), 2);
        this.lockReason = lockReason;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public OperationFuture execute(T operation, SqlExecutionContext sqlExecutionContext, @Nullable SCSequence eventSubSeq, boolean closeOnDone) {
        ((AbstractOperation)operation).withContext(sqlExecutionContext);
        boolean isDone = false;
        try {
            OperationFuture operationFuture;
            Throwable throwable;
            TableWriterAPI writer;
            block19: {
                block20: {
                    writer = this.engine.getTableWriterAPI(sqlExecutionContext.getCairoSecurityContext(), ((AbstractOperation)operation).getTableToken(), this.lockReason);
                    throwable = null;
                    long result = this.apply(operation, writer);
                    isDone = true;
                    operationFuture = this.doneFuture.of(result);
                    if (writer == null) break block19;
                    if (throwable == null) break block20;
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block19;
                }
                writer.close();
            }
            return operationFuture;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (writer != null) {
                            if (throwable != null) {
                                try {
                                    writer.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                writer.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (EntryUnavailableException busyException) {
                    if (eventSubSeq == null) {
                        throw busyException;
                    }
                    OperationFutureImpl future = (OperationFutureImpl)this.futurePool.pop();
                    future.of((AsyncWriterCommand)operation, sqlExecutionContext, eventSubSeq, ((AbstractOperation)operation).getTableNamePosition(), closeOnDone);
                    OperationFutureImpl operationFutureImpl = future;
                    return operationFutureImpl;
                }
            }
        }
        finally {
            if (closeOnDone && isDone) {
                ((AbstractOperation)operation).close();
            }
        }
    }

    protected abstract long apply(T var1, TableWriterAPI var2);
}

