/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.GeoHashes;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.GeoByteFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.Constants;
import io.questdb.std.IntList;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;

public class CastStrToGeoHashFunctionFactory
implements FunctionFactory {
    public static Function newInstance(int argPosition, int geoType, Function value) throws SqlException {
        if (value.isConstant()) {
            int bits = ColumnType.getGeoHashBits(geoType);
            assert (bits > 0 && bits < 61);
            return Constants.getGeoHashConstantWithType(CastStrToGeoHashFunctionFactory.getGeoHashImpl(value.getStr(null), argPosition, bits), geoType);
        }
        return new Func(geoType, value, argPosition);
    }

    @Override
    public String getSignature() {
        return "cast(Sg)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function value = args.getQuick(0);
        int argPosition = argPositions.getQuick(0);
        int geoType = args.getQuick(1).getType();
        return CastStrToGeoHashFunctionFactory.newInstance(argPosition, geoType, value);
    }

    private static long getGeoHashImpl(CharSequence value, int position, int typeBits) throws SqlException {
        if (value == null || value.length() == 0) {
            return -1L;
        }
        int actualBits = value.length() * 5;
        if (actualBits < typeBits) {
            throw SqlException.position(position).put("string is too short to cast to chosen GEOHASH precision [len=").put(value.length()).put(", precision=").put(typeBits).put(']');
        }
        int parseChars = (typeBits - 1) / 5 + 1;
        try {
            long lvalue = GeoHashes.fromString(value, 0, parseChars);
            return lvalue >>> parseChars * 5 - typeBits;
        }
        catch (NumericException e) {
            throw SqlException.position(position).put("invalid GEOHASH");
        }
    }

    public static class Func
    extends GeoByteFunction
    implements UnaryFunction {
        private final Function arg;
        private final int bitsPrecision;
        private final int position;

        public Func(int geoType, Function arg, int position) {
            super(geoType);
            this.arg = arg;
            this.position = position;
            this.bitsPrecision = ColumnType.getGeoHashBits(geoType);
            assert (this.bitsPrecision > 0 && this.bitsPrecision < 61);
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public byte getGeoByte(Record rec) {
            assert (this.bitsPrecision < 8);
            return (byte)this.getGeoHashLong0(rec);
        }

        @Override
        public int getGeoInt(Record rec) {
            assert (this.bitsPrecision >= 16 && this.bitsPrecision < 32);
            return (int)this.getGeoHashLong0(rec);
        }

        @Override
        public long getGeoLong(Record rec) {
            assert (this.bitsPrecision >= 32);
            return this.getGeoHashLong0(rec);
        }

        @Override
        public short getGeoShort(Record rec) {
            assert (this.bitsPrecision >= 8 && this.bitsPrecision < 16);
            return (short)this.getGeoHashLong0(rec);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.arg).val("::geohash");
        }

        private long getGeoHashLong0(Record rec) {
            try {
                return CastStrToGeoHashFunctionFactory.getGeoHashImpl(this.arg.getStr(rec), this.position, this.bitsPrecision);
            }
            catch (SqlException e) {
                return -1L;
            }
        }
    }
}

