/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.component.behavior.AjaxBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.component.html.HtmlCommandScript;
import javax.faces.component.search.SearchExpressionContext;
import javax.faces.component.search.SearchExpressionHandler;
import javax.faces.component.search.SearchExpressionHint;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import org.apache.myfaces.shared.renderkit.RendererUtils;
import org.apache.myfaces.shared.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared.renderkit.html.util.FormInfo;
import org.apache.myfaces.shared.renderkit.html.util.JavascriptUtils;
import org.apache.myfaces.shared.renderkit.html.util.ResourceUtils;
import org.apache.myfaces.shared.renderkit.html.util.SharedStringBuilder;
import org.apache.myfaces.shared.util.StringUtils;

public class HtmlCommandScriptRenderer
extends HtmlRenderer {
    private static final Set<SearchExpressionHint> EXPRESSION_HINTS = EnumSet.of(SearchExpressionHint.RESOLVE_CLIENT_SIDE, SearchExpressionHint.RESOLVE_SINGLE_COMPONENT);
    private static final String AJAX_KEY_ONERROR = "onerror";
    private static final String AJAX_KEY_ONEVENT = "onevent";
    private static final String AJAX_KEY_EXECUTE = "execute";
    private static final String AJAX_KEY_RENDER = "render";
    private static final String AJAX_KEY_DELAY = "delay";
    private static final String AJAX_KEY_RESETVALUES = "resetValues";
    private static final String AJAX_VAL_THIS = "this";
    private static final String JS_AJAX_REQUEST = "jsf.ajax.request";
    private static final String AJAX_SB = "oam.renderkit.AJAX_SB";
    private static final String AJAX_PARAM_SB = "oam.renderkit.AJAX_PARAM_SB";

    @Override
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        super.encodeBegin(context, component);
        HtmlCommandScript commandScript = (HtmlCommandScript)component;
        ResponseWriter writer = context.getResponseWriter();
        ResourceUtils.renderDefaultJsfJsInlineIfNecessary(context, writer);
        writer.startElement("span", component);
        writer.writeAttribute("id", component.getClientId(context), null);
        writer.startElement("script", component);
        writer.writeAttribute("type", "text/javascript", null);
        HtmlRendererUtils.ScriptContext script = new HtmlRendererUtils.ScriptContext();
        String cmdName = commandScript.getName();
        String name = cmdName != null && cmdName.length() > 0 ? JavascriptUtils.getValidJavascriptName(cmdName, true) : JavascriptUtils.getValidJavascriptName(component.getClientId(context), true);
        script.prettyLine();
        script.increaseIndent();
        script.append("var " + name + " = function(o){var o=(typeof o==='object')&&o?o:{};");
        script.prettyLine();
        AjaxBehavior ajaxBehavior = new AjaxBehavior();
        Boolean resetValues = commandScript.getResetValues();
        if (resetValues != null) {
            ajaxBehavior.setResetValues(resetValues);
        }
        ajaxBehavior.setOnerror(commandScript.getOnerror());
        ajaxBehavior.setOnevent(commandScript.getOnevent());
        Collection<ClientBehaviorContext.Parameter> eventParameters = null;
        ClientBehaviorContext ccc = ClientBehaviorContext.createClientBehaviorContext(context, component, "action", commandScript.getClientId(context), eventParameters);
        script.append(this.makeAjax(context, ccc, ajaxBehavior, commandScript).toString());
        script.decreaseIndent();
        script.append("}");
        if (commandScript.isAutorun()) {
            script.append(";");
            script.append("myfaces._impl.core._Runtime.addOnLoad(window,");
            script.append(name);
            script.append(");");
        }
        writer.writeText(script.toString(), null);
    }

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        super.encodeEnd(context, component);
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("script");
        writer.endElement("span");
    }

    @Override
    public void decode(FacesContext facesContext, UIComponent component) {
        super.decode(facesContext, component);
        HtmlCommandScript commandScript = (HtmlCommandScript)component;
        if (HtmlRendererUtils.isDisabled(component) || !commandScript.isRendered()) {
            return;
        }
        Map<String, String> paramMap = facesContext.getExternalContext().getRequestParameterMap();
        String behaviorEventName = paramMap.get("javax.faces.behavior.event");
        if (behaviorEventName != null) {
            String item;
            String sourceId = paramMap.get("javax.faces.source");
            String componentClientId = component.getClientId(facesContext);
            String clientId = sourceId;
            if (sourceId.startsWith(componentClientId) && sourceId.length() > componentClientId.length() && StringUtils.isInteger(item = sourceId.substring(componentClientId.length() + 1))) {
                clientId = componentClientId;
            }
            if (component.getClientId(facesContext).equals(clientId)) {
                boolean disabled = HtmlRendererUtils.isDisabled(component);
                FormInfo formInfo = RendererUtils.findNestingForm(component, facesContext);
                boolean activateActionEvent = false;
                if (formInfo != null && !disabled) {
                    String reqValue = facesContext.getExternalContext().getRequestParameterMap().get(HtmlRendererUtils.getHiddenCommandLinkFieldName(formInfo, facesContext));
                    boolean bl = activateActionEvent = reqValue != null && reqValue.equals(clientId) || HtmlRendererUtils.isPartialOrBehaviorSubmit(facesContext, clientId);
                    if (activateActionEvent) {
                        RendererUtils.initPartialValidationAndModelUpdate(component, facesContext);
                    }
                }
                if (activateActionEvent) {
                    component.queueEvent(new ActionEvent(component));
                }
            }
        }
        if (component instanceof ClientBehaviorHolder && !HtmlRendererUtils.isDisabled(component)) {
            HtmlRendererUtils.decodeClientBehaviors(facesContext, component);
        }
    }

    private StringBuilder makeAjax(FacesContext facesContext, ClientBehaviorContext context, AjaxBehavior behavior, HtmlCommandScript commandScript) {
        List<UIParameter> uiParams;
        Object param;
        int i;
        int size;
        StringBuilder retVal = SharedStringBuilder.get(context.getFacesContext(), AJAX_SB, 60);
        StringBuilder paramBuffer = SharedStringBuilder.get(context.getFacesContext(), AJAX_PARAM_SB, 20);
        SearchExpressionContext searchExpressionContext = SearchExpressionContext.createSearchExpressionContext(context.getFacesContext(), context.getComponent(), EXPRESSION_HINTS, null);
        String executes = this.resolveExpressionsAsParameter(paramBuffer, AJAX_KEY_EXECUTE, commandScript.getExecute(), searchExpressionContext);
        String render = this.resolveExpressionsAsParameter(paramBuffer, AJAX_KEY_RENDER, commandScript.getRender(), searchExpressionContext);
        String onError = behavior.getOnerror();
        if (onError != null && !onError.trim().isEmpty()) {
            paramBuffer.setLength(0);
            paramBuffer.append(AJAX_KEY_ONERROR);
            paramBuffer.append(':');
            paramBuffer.append(onError);
            onError = paramBuffer.toString();
        } else {
            onError = null;
        }
        String onEvent = behavior.getOnevent();
        if (onEvent != null && !onEvent.trim().isEmpty()) {
            paramBuffer.setLength(0);
            paramBuffer.append(AJAX_KEY_ONEVENT);
            paramBuffer.append(':');
            paramBuffer.append(onEvent);
            onEvent = paramBuffer.toString();
        } else {
            onEvent = null;
        }
        String delay = behavior.getDelay();
        if (delay != null && !delay.trim().isEmpty()) {
            paramBuffer.setLength(0);
            paramBuffer.append(AJAX_KEY_DELAY);
            paramBuffer.append(':');
            if ("none".equals(delay)) {
                paramBuffer.append('\'');
                paramBuffer.append(delay);
                paramBuffer.append('\'');
            } else {
                paramBuffer.append(delay);
            }
            delay = paramBuffer.toString();
        } else {
            delay = null;
        }
        String resetValues = Boolean.toString(behavior.isResetValues());
        if (resetValues.equals("true")) {
            paramBuffer.setLength(0);
            paramBuffer.append(AJAX_KEY_RESETVALUES);
            paramBuffer.append(':');
            paramBuffer.append(resetValues);
            resetValues = paramBuffer.toString();
        } else {
            resetValues = null;
        }
        String sourceId = null;
        if (context.getSourceId() == null) {
            sourceId = AJAX_VAL_THIS;
        } else {
            paramBuffer.setLength(0);
            paramBuffer.append('\'');
            paramBuffer.append(context.getSourceId());
            paramBuffer.append('\'');
            sourceId = paramBuffer.toString();
            if (!context.getSourceId().trim().equals(context.getComponent().getClientId(context.getFacesContext()))) {
                UIComponent ref = context.getComponent();
                ref = ref.getParent() == null ? ref : ref.getParent();
                UIComponent instance = null;
                try {
                    instance = ref.findComponent(context.getSourceId());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (instance == null && executes == null) {
                    executes = this.resolveExpressionsAsParameter(paramBuffer, AJAX_KEY_EXECUTE, context.getComponent().getClientId(context.getFacesContext()), searchExpressionContext);
                }
            }
        }
        String event = context.getEventName();
        retVal.append(JS_AJAX_REQUEST);
        retVal.append('(');
        retVal.append(sourceId);
        retVal.append(",window.event,myfaces._impl._util._Lang.mixMaps(");
        Collection<ClientBehaviorContext.Parameter> params = context.getParameters();
        int paramSize = params != null ? params.size() : 0;
        ArrayList<String> parameterList = new ArrayList<String>(paramSize + 2);
        if (executes != null) {
            parameterList.add(executes);
        }
        if (render != null) {
            parameterList.add(render);
        }
        if (onError != null) {
            parameterList.add(onError);
        }
        if (onEvent != null) {
            parameterList.add(onEvent);
        }
        if (delay != null) {
            parameterList.add(delay);
        }
        if (resetValues != null) {
            parameterList.add(resetValues);
        }
        if (paramSize > 0) {
            if (params instanceof RandomAccess) {
                List list = (List)params;
                size = list.size();
                for (i = 0; i < size; ++i) {
                    param = (ClientBehaviorContext.Parameter)list.get(i);
                    this.append(paramBuffer, parameterList, ((ClientBehaviorContext.Parameter)param).getName(), ((ClientBehaviorContext.Parameter)param).getValue());
                }
            } else {
                for (ClientBehaviorContext.Parameter param2 : params) {
                    this.append(paramBuffer, parameterList, param2.getName(), param2.getValue());
                }
            }
        }
        if ((uiParams = HtmlRendererUtils.getValidUIParameterChildren(facesContext, commandScript.getChildren(), false, false)) != null && uiParams.size() > 0) {
            size = uiParams.size();
            for (i = 0; i < size; ++i) {
                param = uiParams.get(i);
                this.append(paramBuffer, parameterList, ((UIParameter)param).getName(), ((UIParameter)param).getValue());
            }
        }
        paramBuffer.setLength(0);
        paramBuffer.append('\'');
        paramBuffer.append("javax.faces.behavior.event");
        paramBuffer.append("':'");
        paramBuffer.append(event);
        paramBuffer.append('\'');
        parameterList.add(paramBuffer.toString());
        retVal.append((CharSequence)this.buildOptions(paramBuffer, parameterList));
        retVal.append(",o,false))");
        return retVal;
    }

    private void append(StringBuilder paramBuffer, List<String> parameterList, String paramName, Object paramValue) {
        paramBuffer.setLength(0);
        paramBuffer.append('\'');
        paramBuffer.append(paramName);
        paramBuffer.append("':'");
        if (paramValue != null) {
            paramBuffer.append(paramValue.toString());
        }
        paramBuffer.append('\'');
        parameterList.add(paramBuffer.toString());
    }

    private StringBuilder buildOptions(StringBuilder retVal, List<String> options) {
        retVal.setLength(0);
        retVal.append("{");
        boolean first = true;
        int size = options.size();
        for (int i = 0; i < size; ++i) {
            String option = options.get(i);
            if (option == null || option.trim().isEmpty()) continue;
            if (!first) {
                retVal.append(',');
            } else {
                first = false;
            }
            retVal.append(option);
        }
        retVal.append("}");
        return retVal;
    }

    private String resolveExpressionsAsParameter(StringBuilder retVal, String target, String expressions, SearchExpressionContext searchExpressionContext) {
        if (expressions != null && !expressions.trim().isEmpty()) {
            retVal.setLength(0);
            retVal.append(target);
            retVal.append(':');
            retVal.append('\'');
            SearchExpressionHandler handler = searchExpressionContext.getFacesContext().getApplication().getSearchExpressionHandler();
            List<String> clientIds = handler.resolveClientIds(searchExpressionContext, expressions);
            if (clientIds != null && !clientIds.isEmpty()) {
                for (int i = 0; i < clientIds.size(); ++i) {
                    if (i > 0) {
                        retVal.append(' ');
                    }
                    retVal.append(clientIds.get(i));
                }
            }
            retVal.append('\'');
            return retVal.toString();
        }
        return null;
    }
}

