/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.renderkit.html.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public abstract class HTMLEncoder {
    private static final String HEX_CHARSET = "0123456789ABCDEF";
    private static final String UTF8 = "UTF-8";

    public static String encode(String string) {
        return HTMLEncoder.encode(string, false, true);
    }

    public static String encode(String string, boolean encodeNewline) {
        return HTMLEncoder.encode(string, encodeNewline, true);
    }

    public static String encode(String string, boolean encodeNewline, boolean encodeSubsequentBlanksToNbsp) {
        return HTMLEncoder.encode(string, encodeNewline, encodeSubsequentBlanksToNbsp, true);
    }

    public static String encode(String string, boolean encodeNewline, boolean encodeSubsequentBlanksToNbsp, boolean encodeNonLatin) {
        if (string == null) {
            return "";
        }
        StringBuilder sb = null;
        char c = ' ';
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            String app = null;
            char prevC = c;
            c = string.charAt(i);
            if (c < 'A') {
                switch (c) {
                    case '\"': {
                        app = "&quot;";
                        break;
                    }
                    case '&': {
                        app = "&amp;";
                        break;
                    }
                    case '<': {
                        app = "&lt;";
                        break;
                    }
                    case '>': {
                        app = "&gt;";
                        break;
                    }
                    case ' ': {
                        if (!encodeSubsequentBlanksToNbsp || prevC != 32) break;
                        app = "&#160;";
                        break;
                    }
                    case '\n': {
                        if (!encodeNewline) break;
                        app = "<br/>";
                        break;
                    }
                }
                if (c <= '\u001f' && c != '\t' && c != '\n' && c != '\r') {
                    app = "";
                }
            } else if (encodeNonLatin && c > '\u0080') {
                switch (c) {
                    case '\u00e4': {
                        app = "&auml;";
                        break;
                    }
                    case '\u00c4': {
                        app = "&Auml;";
                        break;
                    }
                    case '\u00f6': {
                        app = "&ouml;";
                        break;
                    }
                    case '\u00d6': {
                        app = "&Ouml;";
                        break;
                    }
                    case '\u00fc': {
                        app = "&uuml;";
                        break;
                    }
                    case '\u00dc': {
                        app = "&Uuml;";
                        break;
                    }
                    case '\u00df': {
                        app = "&szlig;";
                        break;
                    }
                    case '\u20ac': {
                        app = "&euro;";
                        break;
                    }
                    case '\u00ab': {
                        app = "&laquo;";
                        break;
                    }
                    case '\u00bb': {
                        app = "&raquo;";
                        break;
                    }
                    case '\u00a0': {
                        app = "&#160;";
                        break;
                    }
                    default: {
                        app = "&#" + c + ";";
                    }
                }
            }
            if (app != null) {
                if (sb == null) {
                    sb = new StringBuilder(string.substring(0, i));
                }
                sb.append(app);
                continue;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        if (sb == null) {
            return string;
        }
        return sb.toString();
    }

    public static void encode(Writer writer, String string) throws IOException {
        HTMLEncoder.encode(writer, string, false, true);
    }

    public static void encode(Writer writer, String string, boolean encodeNewline) throws IOException {
        HTMLEncoder.encode(writer, string, encodeNewline, true);
    }

    public static void encode(Writer writer, String string, boolean encodeNewline, boolean encodeSubsequentBlanksToNbsp) throws IOException {
        HTMLEncoder.encode(writer, string, encodeNewline, encodeSubsequentBlanksToNbsp, true);
    }

    public static void encode(Writer writer, String string, boolean encodeNewline, boolean encodeSubsequentBlanksToNbsp, boolean encodeNonLatin) throws IOException {
        if (string == null) {
            return;
        }
        int start = 0;
        int c = 32;
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            String app = null;
            int prevC = c;
            c = string.charAt(i);
            if (c < 65) {
                switch (c) {
                    case 34: {
                        app = "&quot;";
                        break;
                    }
                    case 38: {
                        app = "&amp;";
                        break;
                    }
                    case 60: {
                        app = "&lt;";
                        break;
                    }
                    case 62: {
                        app = "&gt;";
                        break;
                    }
                    case 32: {
                        if (!encodeSubsequentBlanksToNbsp || prevC != 32) break;
                        app = "&#160;";
                        break;
                    }
                    case 10: {
                        if (!encodeNewline) break;
                        app = "<br/>";
                        break;
                    }
                }
                if (c <= 31 && c != 9 && c != 10 && c != 13) {
                    app = "";
                }
            } else if (encodeNonLatin && c > 128) {
                switch (c) {
                    case 228: {
                        app = "&auml;";
                        break;
                    }
                    case 196: {
                        app = "&Auml;";
                        break;
                    }
                    case 246: {
                        app = "&ouml;";
                        break;
                    }
                    case 214: {
                        app = "&Ouml;";
                        break;
                    }
                    case 252: {
                        app = "&uuml;";
                        break;
                    }
                    case 220: {
                        app = "&Uuml;";
                        break;
                    }
                    case 223: {
                        app = "&szlig;";
                        break;
                    }
                    case 8364: {
                        app = "&euro;";
                        break;
                    }
                    case 171: {
                        app = "&laquo;";
                        break;
                    }
                    case 187: {
                        app = "&raquo;";
                        break;
                    }
                    case 160: {
                        app = "&#160;";
                        break;
                    }
                    default: {
                        app = "&#" + c + ";";
                    }
                }
            }
            if (app == null) continue;
            if (start < i) {
                writer.write(string, start, i - start);
            }
            start = i + 1;
            writer.write(app);
        }
        if (start == 0) {
            writer.write(string);
        } else if (start < length) {
            writer.write(string, start, length - start);
        }
    }

    public static void encode(char[] string, int offset, int length, Writer writer) throws IOException {
        HTMLEncoder.encode(string, offset, length, false, true, writer);
    }

    public static void encode(char[] string, int offset, int length, boolean encodeNewline, Writer writer) throws IOException {
        HTMLEncoder.encode(string, offset, length, encodeNewline, true, writer);
    }

    public static void encode(char[] string, int offset, int length, boolean encodeNewline, boolean encodeSubsequentBlanksToNbsp, Writer writer) throws IOException {
        HTMLEncoder.encode(string, offset, length, encodeNewline, encodeSubsequentBlanksToNbsp, true, writer);
    }

    public static void encode(char[] string, int offset, int length, boolean encodeNewline, boolean encodeSubsequentBlanksToNbsp, boolean encodeNonLatin, Writer writer) throws IOException {
        if (string == null || length < 0 || offset >= string.length) {
            return;
        }
        offset = Math.max(0, offset);
        int realLength = Math.min(length, string.length - offset);
        int c = 32;
        int start = offset;
        for (int i = offset; i < offset + realLength; ++i) {
            String app = null;
            int prevC = c;
            c = string[i];
            if (c < 65) {
                switch (c) {
                    case 34: {
                        app = "&quot;";
                        break;
                    }
                    case 38: {
                        app = "&amp;";
                        break;
                    }
                    case 60: {
                        app = "&lt;";
                        break;
                    }
                    case 62: {
                        app = "&gt;";
                        break;
                    }
                    case 32: {
                        if (!encodeSubsequentBlanksToNbsp || prevC != 32) break;
                        app = "&#160;";
                        break;
                    }
                    case 10: {
                        if (!encodeNewline) break;
                        app = "<br/>";
                        break;
                    }
                }
                if (c <= 31 && c != 9 && c != 10 && c != 13) {
                    app = "";
                }
            } else if (encodeNonLatin && c > 128) {
                switch (c) {
                    case 228: {
                        app = "&auml;";
                        break;
                    }
                    case 196: {
                        app = "&Auml;";
                        break;
                    }
                    case 246: {
                        app = "&ouml;";
                        break;
                    }
                    case 214: {
                        app = "&Ouml;";
                        break;
                    }
                    case 252: {
                        app = "&uuml;";
                        break;
                    }
                    case 220: {
                        app = "&Uuml;";
                        break;
                    }
                    case 223: {
                        app = "&szlig;";
                        break;
                    }
                    case 8364: {
                        app = "&euro;";
                        break;
                    }
                    case 171: {
                        app = "&laquo;";
                        break;
                    }
                    case 187: {
                        app = "&raquo;";
                        break;
                    }
                    case 160: {
                        app = "&#160;";
                        break;
                    }
                    default: {
                        app = "&#" + c + ";";
                    }
                }
            }
            if (app == null) continue;
            if (start < i) {
                writer.write(string, start, i - start);
            }
            start = i + 1;
            writer.write(app);
        }
        if (start == offset) {
            writer.write(string, offset, realLength);
        } else if (start < offset + realLength) {
            writer.write(string, start, offset + realLength - start);
        }
    }

    public static String encodeURIAttribute(String string, String characterEncoding) throws IOException {
        StringBuilder sb = null;
        boolean endLoop = false;
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            String app = null;
            char c = string.charAt(i);
            if (c <= ' ' || c >= '\u007f' || c == '\"' || c == '<' || c == '>' || c == '\\' || c == '^' || c == '`' || c == '{' || c == '|' || c == '}') {
                app = HTMLEncoder.percentEncode(c, UTF8);
            } else if (c == '%') {
                if (i + 2 < length) {
                    char c1 = string.charAt(i + 1);
                    char c2 = string.charAt(i + 2);
                    if (!((c1 >= '0' && c1 <= '9' || c1 >= 'A' && c1 <= 'Z' || c1 >= 'a' && c1 <= 'z') && (c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z'))) {
                        app = HTMLEncoder.percentEncode(c, UTF8);
                    }
                } else {
                    app = HTMLEncoder.percentEncode(c, UTF8);
                }
            } else if ((c == '?' || c == '#') && i + 1 < length) {
                app = c + HTMLEncoder.encodeURIQuery(string.substring(i + 1), characterEncoding);
                endLoop = true;
            }
            if (app != null) {
                if (sb == null) {
                    sb = new StringBuilder(string.substring(0, i));
                }
                sb.append(app);
            } else if (sb != null) {
                sb.append(c);
            }
            if (endLoop) break;
        }
        if (sb == null) {
            return string;
        }
        return sb.toString();
    }

    private static String percentEncode(char c, String characterEncoding) {
        String app = null;
        app = c > '\u007f' ? HTMLEncoder.percentEncodeNonUsAsciiCharacter(c, characterEncoding) : "%" + HEX_CHARSET.charAt((c >> 4) % 16) + HEX_CHARSET.charAt(c % 16);
        return app;
    }

    private static String percentEncodeNonUsAsciiCharacter(char c, String characterEncoding) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(10);
        StringBuilder builder = new StringBuilder();
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baos, characterEncoding);
            writer.write(c);
            writer.flush();
        }
        catch (IOException e) {
            baos.reset();
            return null;
        }
        byte[] byteArray = baos.toByteArray();
        for (int i = 0; i < byteArray.length; ++i) {
            builder.append('%');
            builder.append(HEX_CHARSET.charAt((((short)byteArray[i] & 0xFF) >> 4) % 16));
            builder.append(HEX_CHARSET.charAt(((short)byteArray[i] & 0xFF) % 16));
        }
        return builder.toString();
    }

    private static String encodeURIQuery(String string, String characterEncoding) {
        StringBuilder sb = null;
        boolean endLoop = false;
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            String app = null;
            char c = string.charAt(i);
            if (c <= ' ' || c >= '\u007f' || c == '\"' || c == '<' || c == '>' || c == '\\' || c == '^' || c == '`' || c == '{' || c == '|' || c == '}') {
                app = HTMLEncoder.percentEncode(c, characterEncoding);
            } else if (c == '%') {
                if (i + 2 < length) {
                    char c1 = string.charAt(i + 1);
                    char c2 = string.charAt(i + 2);
                    if (!((c1 >= '0' && c1 <= '9' || c1 >= 'A' && c1 <= 'Z' || c1 >= 'a' && c1 <= 'z') && (c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z'))) {
                        app = HTMLEncoder.percentEncode(c, characterEncoding);
                    }
                } else {
                    app = HTMLEncoder.percentEncode(c, characterEncoding);
                }
            } else if (c == '&') {
                if (i + 4 < length) {
                    if ('a' != string.charAt(i + 1) || 'm' != string.charAt(i + 2) || 'p' != string.charAt(i + 3) || ';' != string.charAt(i + 4)) {
                        app = "&amp;";
                    }
                } else {
                    app = "&amp;";
                }
            }
            if (app != null) {
                if (sb == null) {
                    sb = new StringBuilder(string.substring(0, i));
                }
                sb.append(app);
            } else if (sb != null) {
                sb.append(c);
            }
            if (endLoop) break;
        }
        if (sb == null) {
            return string;
        }
        return sb.toString();
    }

    public static void encodeURIAttribute(Writer writer, String string, String characterEncoding) throws IOException {
        int start = 0;
        boolean endLoop = false;
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            String app = null;
            char c = string.charAt(i);
            if (c <= ' ' || c >= '\u007f' || c == '\"' || c == '<' || c == '>' || c == '\\' || c == '^' || c == '`' || c == '{' || c == '|' || c == '}') {
                if (start < i) {
                    writer.write(string, start, i - start);
                }
                start = i + 1;
                HTMLEncoder.percentEncode(writer, c, UTF8);
            } else if (c == '%') {
                if (i + 2 < length) {
                    char c1 = string.charAt(i + 1);
                    char c2 = string.charAt(i + 2);
                    if (!((c1 >= '0' && c1 <= '9' || c1 >= 'A' && c1 <= 'Z' || c1 >= 'a' && c1 <= 'z') && (c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z'))) {
                        if (start < i) {
                            writer.write(string, start, i - start);
                        }
                        start = i + 1;
                        HTMLEncoder.percentEncode(writer, c, UTF8);
                    }
                } else {
                    if (start < i) {
                        writer.write(string, start, i - start);
                    }
                    start = i + 1;
                    HTMLEncoder.percentEncode(writer, c, UTF8);
                }
            } else if ((c == '?' || c == '#') && i + 1 < length) {
                if (start < i) {
                    writer.write(string, start, i - start);
                }
                start = i + 1;
                writer.write(c);
                HTMLEncoder.encodeURIQuery(writer, string, i + 1, characterEncoding);
                endLoop = true;
            }
            if (app != null) {
                if (start < i) {
                    writer.write(string, start, i - start);
                }
                start = i + 1;
                writer.write(app);
            }
            if (!endLoop) continue;
            start = length;
            break;
        }
        if (start == 0) {
            writer.write(string);
        } else if (start < length) {
            writer.write(string, start, length - start);
        }
    }

    private static void percentEncode(Writer writer, char c, String characterEncoding) throws IOException {
        if (c > '\u007f') {
            HTMLEncoder.percentEncodeNonUsAsciiCharacter(writer, c, characterEncoding);
        } else {
            writer.write(37);
            writer.write(HEX_CHARSET.charAt((c >> 4) % 16));
            writer.write(HEX_CHARSET.charAt(c % 16));
        }
    }

    private static void percentEncodeNonUsAsciiCharacter(Writer currentWriter, char c, String characterEncoding) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(10);
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baos, characterEncoding);
            writer.write(c);
            writer.flush();
        }
        catch (IOException e) {
            baos.reset();
            return;
        }
        byte[] byteArray = baos.toByteArray();
        for (int i = 0; i < byteArray.length; ++i) {
            currentWriter.write(37);
            currentWriter.write(HEX_CHARSET.charAt((((short)byteArray[i] & 0xFF) >> 4) % 16));
            currentWriter.write(HEX_CHARSET.charAt(((short)byteArray[i] & 0xFF) % 16));
        }
    }

    private static void encodeURIQuery(Writer writer, String string, int offset, String characterEncoding) throws IOException {
        int start = offset;
        int length = string.length();
        int realLength = length - offset;
        for (int i = offset; i < length; ++i) {
            String app = null;
            char c = string.charAt(i);
            if (c <= ' ' || c >= '\u007f' || c == '\"' || c == '<' || c == '>' || c == '\\' || c == '^' || c == '`' || c == '{' || c == '|' || c == '}') {
                if (start < i) {
                    writer.write(string, start, i - start);
                }
                start = i + 1;
                HTMLEncoder.percentEncode(writer, c, characterEncoding);
            } else if (c == '%') {
                if (i + 2 < length) {
                    char c1 = string.charAt(i + 1);
                    char c2 = string.charAt(i + 2);
                    if (!((c1 >= '0' && c1 <= '9' || c1 >= 'A' && c1 <= 'Z' || c1 >= 'a' && c1 <= 'z') && (c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z'))) {
                        if (start < i) {
                            writer.write(string, start, i - start);
                        }
                        start = i + 1;
                        HTMLEncoder.percentEncode(writer, c, characterEncoding);
                    }
                } else {
                    if (start < i) {
                        writer.write(string, start, i - start);
                    }
                    start = i + 1;
                    HTMLEncoder.percentEncode(writer, c, characterEncoding);
                }
            } else if (c == '&') {
                if (i + 4 < length) {
                    if ('a' != string.charAt(i + 1) || 'm' != string.charAt(i + 2) || 'p' != string.charAt(i + 3) || ';' != string.charAt(i + 4)) {
                        app = "&amp;";
                    }
                } else {
                    app = "&amp;";
                }
            }
            if (app == null) continue;
            if (start < i) {
                writer.write(string, start, i - start);
            }
            start = i + 1;
            writer.write(app);
        }
        if (start == offset) {
            writer.write(string, offset, realLength);
        } else if (start < length) {
            writer.write(string, start, length - start);
        }
    }
}

