/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.FSImageLoader;
import org.apache.hadoop.hdfs.web.JsonUtil;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.codec.http.QueryStringDecoder;

class FSImageHandler
extends SimpleChannelUpstreamHandler {
    public static final Log LOG = LogFactory.getLog(FSImageHandler.class);
    private final FSImageLoader image;

    FSImageHandler(FSImageLoader image) throws IOException {
        this.image = image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        ChannelFuture future = e.getFuture();
        try {
            future = this.handleOperation(e);
        }
        finally {
            future.addListener(ChannelFutureListener.CLOSE);
        }
    }

    private ChannelFuture handleOperation(MessageEvent e) throws IOException {
        String content;
        String path;
        String op;
        DefaultHttpResponse response;
        HttpRequest request;
        block8: {
            request = (HttpRequest)e.getMessage();
            response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            response.setHeader("Content-Type", (Object)"application/json");
            if (request.getMethod() != HttpMethod.GET) {
                response.setStatus(HttpResponseStatus.METHOD_NOT_ALLOWED);
                return e.getChannel().write((Object)response);
            }
            QueryStringDecoder decoder = new QueryStringDecoder(request.getUri());
            op = FSImageHandler.getOp(decoder);
            path = null;
            try {
                path = FSImageHandler.getPath(decoder);
                if ("GETFILESTATUS".equals(op)) {
                    content = this.image.getFileStatus(path);
                    break block8;
                }
                if ("LISTSTATUS".equals(op)) {
                    content = this.image.listStatus(path);
                    break block8;
                }
                if ("GETACLSTATUS".equals(op)) {
                    content = this.image.getAclStatus(path);
                    break block8;
                }
                throw new IllegalArgumentException("Invalid value for webhdfs parameter \"op\"");
            }
            catch (IllegalArgumentException ex) {
                response.setStatus(HttpResponseStatus.BAD_REQUEST);
                content = JsonUtil.toJsonString(ex);
            }
            catch (FileNotFoundException ex) {
                response.setStatus(HttpResponseStatus.NOT_FOUND);
                content = JsonUtil.toJsonString(ex);
            }
            catch (Exception ex) {
                content = JsonUtil.toJsonString(ex);
            }
        }
        HttpHeaders.setContentLength((HttpMessage)response, (long)content.length());
        e.getChannel().write((Object)response);
        ChannelFuture future = e.getChannel().write((Object)content);
        LOG.info((Object)(response.getStatus().getCode() + " method=" + request.getMethod().getName() + " op=" + op + " target=" + path));
        return future;
    }

    private static String getOp(QueryStringDecoder decoder) {
        Map parameters = decoder.getParameters();
        return parameters.containsKey("op") ? ((String)((List)parameters.get("op")).get(0)).toUpperCase() : null;
    }

    private static String getPath(QueryStringDecoder decoder) throws FileNotFoundException {
        String path = decoder.getPath();
        if (path.startsWith("/webhdfs/v1/")) {
            return path.substring(11);
        }
        throw new FileNotFoundException("Path: " + path + " should " + "start with \"/webhdfs/v1/\"");
    }
}

