/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public class TableListing {
    private final Column[] columns;
    private int numRows;
    private final boolean showHeader;
    private final int wrapWidth;

    TableListing(Column[] columns, boolean showHeader, int wrapWidth) {
        this.columns = columns;
        this.numRows = 0;
        this.showHeader = showHeader;
        this.wrapWidth = wrapWidth;
    }

    public void addRow(String ... row) {
        if (row.length != this.columns.length) {
            throw new RuntimeException("trying to add a row with " + row.length + " columns, but we have " + this.columns.length + " columns.");
        }
        for (int i = 0; i < this.columns.length; ++i) {
            this.columns[i].addRow(row[i]);
        }
        ++this.numRows;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int width = (this.columns.length - 1) * 2;
        for (int i = 0; i < this.columns.length; ++i) {
            width += this.columns[i].maxWidth;
        }
        while (width > this.wrapWidth) {
            boolean modified = false;
            for (int i = 0; i < this.columns.length; ++i) {
                int maxWidth;
                Column column = this.columns[i];
                if (!column.wrap || (maxWidth = column.getMaxWidth()) <= 4) continue;
                column.setWrapWidth(maxWidth - 1);
                modified = true;
                if (--width <= this.wrapWidth) break;
            }
            if (modified) continue;
            break;
        }
        int startrow = 0;
        if (!this.showHeader) {
            startrow = 1;
        }
        String[][] columnLines = new String[this.columns.length][];
        for (int i = startrow; i < this.numRows + 1; ++i) {
            int maxColumnLines = 0;
            for (int j = 0; j < this.columns.length; ++j) {
                columnLines[j] = this.columns[j].getRow(i);
                if (columnLines[j].length <= maxColumnLines) continue;
                maxColumnLines = columnLines[j].length;
            }
            for (int c = 0; c < maxColumnLines; ++c) {
                String prefix = "";
                for (int j = 0; j < this.columns.length; ++j) {
                    builder.append(prefix);
                    prefix = " ";
                    if (columnLines[j].length > c) {
                        builder.append(columnLines[j][c]);
                        continue;
                    }
                    builder.append(StringUtils.repeat((String)" ", (int)this.columns[j].maxWidth));
                }
                builder.append("\n");
            }
        }
        return builder.toString();
    }

    public static class Builder {
        private final LinkedList<Column> columns = new LinkedList();
        private boolean showHeader = true;
        private int wrapWidth = Integer.MAX_VALUE;

        public Builder addField(String title) {
            return this.addField(title, Justification.LEFT, false);
        }

        public Builder addField(String title, Justification justification) {
            return this.addField(title, justification, false);
        }

        public Builder addField(String title, boolean wrap) {
            return this.addField(title, Justification.LEFT, wrap);
        }

        public Builder addField(String title, Justification justification, boolean wrap) {
            this.columns.add(new Column(title, justification, wrap));
            return this;
        }

        public Builder hideHeaders() {
            this.showHeader = false;
            return this;
        }

        public Builder showHeaders() {
            this.showHeader = true;
            return this;
        }

        public Builder wrapWidth(int width) {
            this.wrapWidth = width;
            return this;
        }

        public TableListing build() {
            return new TableListing(this.columns.toArray(new Column[0]), this.showHeader, this.wrapWidth);
        }
    }

    private static class Column {
        private final ArrayList<String> rows;
        private final Justification justification;
        private final boolean wrap;
        private int wrapWidth = Integer.MAX_VALUE;
        private int maxWidth;

        Column(String title, Justification justification, boolean wrap) {
            this.rows = new ArrayList();
            this.justification = justification;
            this.wrap = wrap;
            this.maxWidth = 0;
            this.addRow(title);
        }

        private void addRow(String val) {
            if (val == null) {
                val = "";
            }
            if (val.length() + 1 > this.maxWidth) {
                this.maxWidth = val.length() + 1;
            }
            if (this.maxWidth > this.wrapWidth) {
                this.maxWidth = this.wrapWidth;
            }
            this.rows.add(val);
        }

        private int getMaxWidth() {
            return this.maxWidth;
        }

        private void setWrapWidth(int width) {
            this.wrapWidth = width;
            if (this.maxWidth > this.wrapWidth) {
                this.maxWidth = this.wrapWidth;
            } else {
                this.maxWidth = 0;
                for (int i = 0; i < this.rows.size(); ++i) {
                    int length = this.rows.get(i).length();
                    if (length <= this.maxWidth) continue;
                    this.maxWidth = length;
                }
            }
        }

        String[] getRow(int idx) {
            String raw = this.rows.get(idx);
            String[] lines = new String[]{raw};
            if (this.wrap) {
                lines = WordUtils.wrap((String)lines[0], (int)this.wrapWidth, (String)"\n", (boolean)true).split("\n");
            }
            for (int i = 0; i < lines.length; ++i) {
                if (this.justification == Justification.LEFT) {
                    lines[i] = StringUtils.rightPad((String)lines[i], (int)this.maxWidth);
                    continue;
                }
                if (this.justification != Justification.RIGHT) continue;
                lines[i] = StringUtils.leftPad((String)lines[i], (int)this.maxWidth);
            }
            return lines;
        }
    }

    public static enum Justification {
        LEFT,
        RIGHT;

    }
}

