/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.converter.SurjectiveConverter;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.code.MD_CharacterSetCode;
import org.apache.sis.internal.jaxb.gmi.MI_Metadata;
import org.apache.sis.internal.jaxb.lan.LocaleAdapter;
import org.apache.sis.internal.jaxb.lan.LocaleAndCharset;
import org.apache.sis.internal.jaxb.lan.OtherLocales;
import org.apache.sis.internal.jaxb.lan.PT_Locale;
import org.apache.sis.internal.jaxb.metadata.CI_Citation;
import org.apache.sis.internal.jaxb.metadata.MD_Identifier;
import org.apache.sis.internal.metadata.Dependencies;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.internal.metadata.legacy.LegacyPropertyAdapter;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.math.FunctionProperty;
import org.apache.sis.metadata.MetadataCopier;
import org.apache.sis.metadata.MetadataStandard;
import org.apache.sis.metadata.iso.DefaultIdentifier;
import org.apache.sis.metadata.iso.DefaultMetadataScope;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.MetadataScopeAdapter;
import org.apache.sis.metadata.iso.citation.DefaultCitation;
import org.apache.sis.metadata.iso.citation.DefaultCitationDate;
import org.apache.sis.metadata.iso.citation.DefaultOnlineResource;
import org.apache.sis.metadata.iso.identification.AbstractIdentification;
import org.apache.sis.metadata.iso.identification.DefaultDataIdentification;
import org.apache.sis.util.Emptiable;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.SimpleInternationalString;
import org.apache.sis.util.collection.Containers;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.ApplicationSchemaInformation;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.MetadataExtensionInformation;
import org.opengis.metadata.PortrayalCatalogueReference;
import org.opengis.metadata.acquisition.AcquisitionInformation;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.CitationDate;
import org.opengis.metadata.citation.DateType;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.constraint.Constraints;
import org.opengis.metadata.content.ContentInformation;
import org.opengis.metadata.distribution.Distribution;
import org.opengis.metadata.identification.CharacterSet;
import org.opengis.metadata.identification.Identification;
import org.opengis.metadata.lineage.Lineage;
import org.opengis.metadata.maintenance.MaintenanceInformation;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.quality.DataQuality;
import org.opengis.metadata.spatial.SpatialRepresentation;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.util.InternationalString;

@XmlType(name="MD_Metadata_Type", propOrder={"metadataIdentifier", "defaultLocale", "parentMetadata", "fileIdentifier", "language", "charset", "parentIdentifier", "hierarchyLevels", "hierarchyLevelNames", "contacts", "dates", "metadataStandard", "metadataProfile", "alternativeMetadataReference", "otherLocales", "metadataLinkage", "dateStamp", "metadataStandardName", "metadataStandardVersion", "dataSetUri", "locales", "spatialRepresentationInfo", "referenceSystemInfo", "metadataExtensionInfo", "identificationInfo", "contentInfo", "distributionInfo", "dataQualityInfo", "portrayalCatalogueInfo", "metadataConstraints", "applicationSchemaInfo", "metadataMaintenance", "resourceLineage", "metadataScope", "acquisitionInformation"})
@XmlRootElement(name="MD_Metadata")
@XmlSeeAlso(value={MI_Metadata.class})
public class DefaultMetadata
extends ISOMetadata
implements Metadata {
    private static final long serialVersionUID = -76483485174667242L;
    private Map<Locale, Charset> locales;
    private Citation parentMetadata;
    private Collection<DefaultMetadataScope> metadataScopes;
    private Collection<ResponsibleParty> contacts;
    private Collection<CitationDate> dateInfo;
    private Collection<Citation> metadataStandards;
    private Collection<Citation> metadataProfiles;
    private Collection<Citation> alternativeMetadataReferences;
    private Collection<OnlineResource> metadataLinkages;
    private Collection<SpatialRepresentation> spatialRepresentationInfo;
    private Collection<ReferenceSystem> referenceSystemInfo;
    private Collection<MetadataExtensionInformation> metadataExtensionInfo;
    private Collection<Identification> identificationInfo;
    private Collection<ContentInformation> contentInfo;
    private Distribution distributionInfo;
    private Collection<DataQuality> dataQualityInfo;
    private Collection<PortrayalCatalogueReference> portrayalCatalogueInfo;
    private Collection<Constraints> metadataConstraints;
    private Collection<ApplicationSchemaInformation> applicationSchemaInfo;
    private MaintenanceInformation metadataMaintenance;
    private Collection<AcquisitionInformation> acquisitionInformation;
    private Collection<Lineage> resourceLineages;

    public DefaultMetadata() {
    }

    public DefaultMetadata(ResponsibleParty responsibleParty, Date date, Identification identification) {
        this.contacts = this.singleton(responsibleParty, ResponsibleParty.class);
        this.identificationInfo = this.singleton(identification, Identification.class);
        if (date != null) {
            this.dateInfo = this.singleton(new DefaultCitationDate(date, DateType.CREATION), CitationDate.class);
        }
    }

    public DefaultMetadata(Metadata metadata) {
        super(metadata);
        if (metadata != null) {
            this.contacts = this.copyCollection(metadata.getContacts(), ResponsibleParty.class);
            this.spatialRepresentationInfo = this.copyCollection(metadata.getSpatialRepresentationInfo(), SpatialRepresentation.class);
            this.referenceSystemInfo = this.copyCollection(metadata.getReferenceSystemInfo(), ReferenceSystem.class);
            this.metadataExtensionInfo = this.copyCollection(metadata.getMetadataExtensionInfo(), MetadataExtensionInformation.class);
            this.identificationInfo = this.copyCollection(metadata.getIdentificationInfo(), Identification.class);
            this.contentInfo = this.copyCollection(metadata.getContentInfo(), ContentInformation.class);
            this.distributionInfo = metadata.getDistributionInfo();
            this.dataQualityInfo = this.copyCollection(metadata.getDataQualityInfo(), DataQuality.class);
            this.portrayalCatalogueInfo = this.copyCollection(metadata.getPortrayalCatalogueInfo(), PortrayalCatalogueReference.class);
            this.metadataConstraints = this.copyCollection(metadata.getMetadataConstraints(), Constraints.class);
            this.applicationSchemaInfo = this.copyCollection(metadata.getApplicationSchemaInfo(), ApplicationSchemaInformation.class);
            this.metadataMaintenance = metadata.getMetadataMaintenance();
            this.acquisitionInformation = this.copyCollection(metadata.getAcquisitionInformation(), AcquisitionInformation.class);
            if (metadata instanceof DefaultMetadata) {
                DefaultMetadata defaultMetadata = (DefaultMetadata)metadata;
                this.identifiers = this.singleton(defaultMetadata.getMetadataIdentifier(), Identifier.class);
                this.parentMetadata = defaultMetadata.getParentMetadata();
                this.locales = this.copyMap(defaultMetadata.getLocalesAndCharsets(), Locale.class);
                this.metadataScopes = this.copyCollection(defaultMetadata.getMetadataScopes(), DefaultMetadataScope.class);
                this.dateInfo = this.copyCollection(defaultMetadata.getDateInfo(), CitationDate.class);
                this.metadataStandards = this.copyCollection(defaultMetadata.getMetadataStandards(), Citation.class);
                this.metadataProfiles = this.copyCollection(defaultMetadata.getMetadataProfiles(), Citation.class);
                this.alternativeMetadataReferences = this.copyCollection(defaultMetadata.getAlternativeMetadataReferences(), Citation.class);
                this.metadataLinkages = this.copyCollection(defaultMetadata.getMetadataLinkages(), OnlineResource.class);
                this.resourceLineages = this.copyCollection(defaultMetadata.getResourceLineages(), Lineage.class);
            } else {
                this.setFileIdentifier(metadata.getFileIdentifier());
                this.setParentIdentifier(metadata.getParentIdentifier());
                this.setLanguage(metadata.getLanguage());
                this.setLocales(metadata.getLocales());
                this.setCharacterSet(metadata.getCharacterSet());
                this.setHierarchyLevels(metadata.getHierarchyLevels());
                this.setHierarchyLevelNames(metadata.getHierarchyLevelNames());
                this.setDateStamp(metadata.getDateStamp());
                this.setMetadataStandardName(metadata.getMetadataStandardName());
                this.setMetadataStandardVersion(metadata.getMetadataStandardVersion());
                try {
                    this.setDataSetUri(metadata.getDataSetUri());
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new IllegalArgumentException(uRISyntaxException);
                }
            }
        }
    }

    public static DefaultMetadata castOrCopy(Metadata metadata) {
        if (metadata == null || metadata instanceof DefaultMetadata) {
            return (DefaultMetadata)metadata;
        }
        return new DefaultMetadata(metadata);
    }

    public static DefaultMetadata deepCopy(Metadata metadata) {
        if (metadata == null) {
            return null;
        }
        return (DefaultMetadata)new MetadataCopier(MetadataStandard.ISO_19115).copy(Metadata.class, metadata);
    }

    @XmlElement(name="metadataIdentifier")
    @XmlJavaTypeAdapter(value=MD_Identifier.Since2014.class)
    @UML(identifier="metadataIdentifier", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Identifier getMetadataIdentifier() {
        return super.getIdentifier();
    }

    public void setMetadataIdentifier(Identifier identifier) {
        super.setIdentifier(identifier);
    }

    @Deprecated
    @Dependencies(value={"getMetadataIdentifier"})
    @XmlElement(name="fileIdentifier", namespace="http://www.isotc211.org/2005/gmd")
    public String getFileIdentifier() {
        Identifier identifier;
        if (FilterByVersion.LEGACY_METADATA.accept() && (identifier = this.getMetadataIdentifier()) != null) {
            return identifier.getCode();
        }
        return null;
    }

    @Deprecated
    public void setFileIdentifier(String string) {
        DefaultIdentifier defaultIdentifier = DefaultIdentifier.castOrCopy(super.getIdentifier());
        if (defaultIdentifier == null) {
            if (string == null) {
                return;
            }
            defaultIdentifier = new DefaultIdentifier();
        }
        defaultIdentifier.setCode(string);
        if (string == null && defaultIdentifier instanceof Emptiable && defaultIdentifier.isEmpty()) {
            defaultIdentifier = null;
        }
        this.setMetadataIdentifier(defaultIdentifier);
    }

    @UML(identifier="defaultLocale+otherLocale", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public Map<Locale, Charset> getLocalesAndCharsets() {
        this.locales = this.nonNullMap(this.locales, Locale.class);
        return this.locales;
    }

    public void setLocalesAndCharsets(Map<? extends Locale, ? extends Charset> map) {
        this.locales = this.writeMap(map, this.locales, Locale.class);
    }

    @Deprecated
    @Dependencies(value={"getLocalesAndCharsets"})
    public Collection<Locale> getLanguages() {
        return FilterByVersion.LEGACY_METADATA.accept() ? LocaleAndCharset.getLanguages(this.getLocalesAndCharsets()) : null;
    }

    @Deprecated
    public void setLanguages(Collection<Locale> collection) {
        this.setLocalesAndCharsets(LocaleAndCharset.setLanguages(this.getLocalesAndCharsets(), collection));
    }

    @Deprecated
    @Dependencies(value={"getLocalesAndCharsets"})
    @XmlElement(name="language", namespace="http://www.isotc211.org/2005/gmd")
    public Locale getLanguage() {
        return FilterByVersion.LEGACY_METADATA.accept() ? CollectionsExt.first(this.getLanguages()) : null;
    }

    @Deprecated
    public void setLanguage(Locale locale) {
        this.setLocalesAndCharsets(OtherLocales.setFirst(this.locales, new PT_Locale(locale)));
    }

    @Deprecated
    @Dependencies(value={"getLocalesAndCharsets"})
    @XmlElement(name="locale", namespace="http://www.isotc211.org/2005/gmd")
    @XmlJavaTypeAdapter(value=LocaleAdapter.Wrapped.class)
    public Collection<Locale> getLocales() {
        if (FilterByVersion.LEGACY_METADATA.accept()) {
            Set<PT_Locale> set = OtherLocales.filter(this.getLocalesAndCharsets());
            return Containers.derivedSet(set, ToLocale.INSTANCE);
        }
        return null;
    }

    @Deprecated
    public void setLocales(Collection<? extends Locale> collection) {
        Collection<Locale> collection2 = this.getLocales();
        if (collection2 != null) {
            collection2.addAll(collection);
        } else if (!collection.isEmpty()) {
            LinkedHashMap<Locale, Object> linkedHashMap = new LinkedHashMap<Locale, Object>();
            for (Locale locale : collection) {
                linkedHashMap.put(locale, null);
            }
            this.setLocalesAndCharsets(linkedHashMap);
        }
    }

    @Deprecated
    @Dependencies(value={"getLocalesAndCharsets"})
    public Collection<Charset> getCharacterSets() {
        return LocaleAndCharset.getCharacterSets(this.getLocalesAndCharsets());
    }

    @Deprecated
    public void setCharacterSets(Collection<? extends Charset> collection) {
        this.setLocalesAndCharsets(LocaleAndCharset.setCharacterSets(this.getLocalesAndCharsets(), collection));
    }

    @Deprecated
    @Dependencies(value={"getLocalesAndCharsets"})
    public CharacterSet getCharacterSet() {
        return MD_CharacterSetCode.fromCharset(LegacyPropertyAdapter.getSingleton(this.getCharacterSets(), Charset.class, null, DefaultMetadata.class, "getCharacterSet"));
    }

    @Deprecated
    public void setCharacterSet(CharacterSet characterSet) {
        this.setCharacterSets(CollectionsExt.singletonOrEmpty(characterSet != null ? characterSet.toCharset() : null));
    }

    @XmlElement(name="parentMetadata")
    @XmlJavaTypeAdapter(value=CI_Citation.Since2014.class)
    @UML(identifier="parentMetadata", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public Citation getParentMetadata() {
        return this.parentMetadata;
    }

    public void setParentMetadata(Citation citation) {
        this.checkWritePermission(this.parentMetadata);
        this.parentMetadata = citation;
    }

    @Deprecated
    @Dependencies(value={"getParentMetadata"})
    @XmlElement(name="parentIdentifier", namespace="http://www.isotc211.org/2005/gmd")
    public String getParentIdentifier() {
        InternationalString internationalString;
        Citation citation;
        if (FilterByVersion.LEGACY_METADATA.accept() && (citation = this.getParentMetadata()) != null && (internationalString = citation.getTitle()) != null) {
            return internationalString.toString();
        }
        return null;
    }

    @Deprecated
    public void setParentIdentifier(String string) {
        this.checkWritePermission(this.parentMetadata);
        DefaultCitation defaultCitation = DefaultCitation.castOrCopy(this.parentMetadata);
        if (string != null) {
            if (defaultCitation == null) {
                defaultCitation = new DefaultCitation();
            }
            defaultCitation.setTitle(new SimpleInternationalString(string));
            this.setParentMetadata(defaultCitation);
        } else if (defaultCitation != null) {
            defaultCitation.setTitle(null);
        }
    }

    @UML(identifier="metadataScope", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public Collection<DefaultMetadataScope> getMetadataScopes() {
        this.metadataScopes = this.nonNullCollection(this.metadataScopes, DefaultMetadataScope.class);
        return this.metadataScopes;
    }

    public void setMetadataScopes(Collection<? extends DefaultMetadataScope> collection) {
        this.metadataScopes = this.writeCollection(collection, this.metadataScopes, DefaultMetadataScope.class);
    }

    @Deprecated
    @Dependencies(value={"getMetadataScopes"})
    @XmlElement(name="hierarchyLevel", namespace="http://www.isotc211.org/2005/gmd")
    public final Collection<ScopeCode> getHierarchyLevels() {
        if (!FilterByVersion.LEGACY_METADATA.accept()) {
            return null;
        }
        return new MetadataScopeAdapter<ScopeCode>(this.getMetadataScopes()){

            @Override
            protected DefaultMetadataScope wrap(ScopeCode scopeCode) {
                return new DefaultMetadataScope(scopeCode, null);
            }

            @Override
            protected ScopeCode unwrap(DefaultMetadataScope defaultMetadataScope) {
                return defaultMetadataScope.getResourceScope();
            }

            @Override
            protected boolean update(DefaultMetadataScope defaultMetadataScope, ScopeCode scopeCode) {
                defaultMetadataScope.setResourceScope(scopeCode);
                return true;
            }
        }.validOrNull();
    }

    @Deprecated
    public void setHierarchyLevels(Collection<? extends ScopeCode> collection) {
        this.checkWritePermission(MetadataUtilities.valueIfDefined(this.metadataScopes));
        ((LegacyPropertyAdapter)this.getHierarchyLevels()).setValues(collection);
    }

    @Deprecated
    @Dependencies(value={"getMetadataScopes"})
    @XmlElement(name="hierarchyLevelName", namespace="http://www.isotc211.org/2005/gmd")
    public final Collection<String> getHierarchyLevelNames() {
        if (!FilterByVersion.LEGACY_METADATA.accept()) {
            return null;
        }
        return new MetadataScopeAdapter<String>(this.getMetadataScopes()){

            @Override
            protected DefaultMetadataScope wrap(String string) {
                return new DefaultMetadataScope(null, string);
            }

            @Override
            protected String unwrap(DefaultMetadataScope defaultMetadataScope) {
                InternationalString internationalString = defaultMetadataScope.getName();
                return internationalString != null ? internationalString.toString() : null;
            }

            @Override
            protected boolean update(DefaultMetadataScope defaultMetadataScope, String string) {
                defaultMetadataScope.setName(string != null ? new SimpleInternationalString(string) : null);
                return true;
            }
        }.validOrNull();
    }

    @Deprecated
    public void setHierarchyLevelNames(Collection<? extends String> collection) {
        this.checkWritePermission(MetadataUtilities.valueIfDefined(this.metadataScopes));
        ((LegacyPropertyAdapter)this.getHierarchyLevelNames()).setValues(collection);
    }

    @XmlElement(name="contact", required=true)
    public Collection<ResponsibleParty> getContacts() {
        this.contacts = this.nonNullCollection(this.contacts, ResponsibleParty.class);
        return this.contacts;
    }

    public void setContacts(Collection<? extends ResponsibleParty> collection) {
        this.contacts = this.writeCollection(collection, this.contacts, ResponsibleParty.class);
    }

    @UML(identifier="dateInfo", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    public Collection<CitationDate> getDateInfo() {
        this.dateInfo = this.nonNullCollection(this.dateInfo, CitationDate.class);
        return this.dateInfo;
    }

    public void setDateInfo(Collection<? extends CitationDate> collection) {
        this.dateInfo = this.writeCollection(collection, this.dateInfo, CitationDate.class);
    }

    @Deprecated
    @Dependencies(value={"getDateInfo"})
    @XmlElement(name="dateStamp", namespace="http://www.isotc211.org/2005/gmd")
    public Date getDateStamp() {
        Collection<CitationDate> collection;
        if (FilterByVersion.LEGACY_METADATA.accept() && (collection = this.getDateInfo()) != null) {
            for (CitationDate citationDate : collection) {
                if (!DateType.CREATION.equals((Object)citationDate.getDateType())) continue;
                return citationDate.getDate();
            }
        }
        return null;
    }

    @Deprecated
    public void setDateStamp(Date date) {
        this.checkWritePermission(MetadataUtilities.valueIfDefined(this.dateInfo));
        Collection<CitationDate> collection = this.dateInfo;
        if (collection == null) {
            if (date == null) {
                return;
            }
            collection = new ArrayList<CitationDate>(1);
        } else {
            Iterator<CitationDate> iterator = collection.iterator();
            while (iterator.hasNext()) {
                CitationDate citationDate = iterator.next();
                if (!DateType.CREATION.equals((Object)citationDate.getDateType())) continue;
                if (date == null) {
                    iterator.remove();
                    return;
                }
                if (citationDate instanceof DefaultCitationDate) {
                    ((DefaultCitationDate)citationDate).setDate(date);
                    return;
                }
                iterator.remove();
                break;
            }
        }
        collection.add(new DefaultCitationDate(date, DateType.CREATION));
        this.setDateInfo(collection);
    }

    @UML(identifier="metadataStandard", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Citation> getMetadataStandards() {
        this.metadataStandards = this.nonNullCollection(this.metadataStandards, Citation.class);
        return this.metadataStandards;
    }

    public void setMetadataStandards(Collection<? extends Citation> collection) {
        this.metadataStandards = this.writeCollection(collection, this.metadataStandards, Citation.class);
    }

    @UML(identifier="metadataProfile", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Citation> getMetadataProfiles() {
        this.metadataProfiles = this.nonNullCollection(this.metadataProfiles, Citation.class);
        return this.metadataProfiles;
    }

    public void setMetadataProfiles(Collection<? extends Citation> collection) {
        this.metadataProfiles = this.writeCollection(collection, this.metadataProfiles, Citation.class);
    }

    @UML(identifier="alternativeMetadataReference", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Citation> getAlternativeMetadataReferences() {
        this.alternativeMetadataReferences = this.nonNullCollection(this.alternativeMetadataReferences, Citation.class);
        return this.alternativeMetadataReferences;
    }

    public void setAlternativeMetadataReferences(Collection<? extends Citation> collection) {
        this.alternativeMetadataReferences = this.writeCollection(collection, this.alternativeMetadataReferences, Citation.class);
    }

    private String getMetadataStandard(boolean bl) {
        Citation citation;
        if (FilterByVersion.LEGACY_METADATA.accept() && (citation = LegacyPropertyAdapter.getSingleton(this.getMetadataStandards(), Citation.class, null, DefaultMetadata.class, bl ? "getMetadataStandardName" : "getMetadataStandardVersion")) != null) {
            InternationalString internationalString;
            InternationalString internationalString2 = internationalString = bl ? citation.getEdition() : citation.getTitle();
            if (internationalString != null) {
                return internationalString.toString();
            }
        }
        return null;
    }

    private void setMetadataStandard(boolean bl, String string) {
        DefaultCitation defaultCitation;
        this.checkWritePermission(MetadataUtilities.valueIfDefined(this.metadataStandards));
        SimpleInternationalString simpleInternationalString = string != null ? new SimpleInternationalString(string) : null;
        ArrayList<Citation> arrayList = this.metadataStandards != null ? new ArrayList<Citation>(this.metadataStandards) : new ArrayList(1);
        DefaultCitation defaultCitation2 = defaultCitation = arrayList.isEmpty() ? null : DefaultCitation.castOrCopy((Citation)arrayList.get(0));
        if (defaultCitation == null) {
            defaultCitation = new DefaultCitation();
        }
        if (bl) {
            defaultCitation.setEdition(simpleInternationalString);
        } else {
            defaultCitation.setTitle(simpleInternationalString);
        }
        if (arrayList.isEmpty()) {
            arrayList.add(defaultCitation);
        } else {
            arrayList.set(0, defaultCitation);
        }
        this.setMetadataStandards(arrayList);
    }

    @Deprecated
    @Dependencies(value={"getMetadataStandards"})
    @XmlElement(name="metadataStandardName", namespace="http://www.isotc211.org/2005/gmd")
    public String getMetadataStandardName() {
        return this.getMetadataStandard(false);
    }

    @Deprecated
    public void setMetadataStandardName(String string) {
        this.setMetadataStandard(false, string);
    }

    @Deprecated
    @Dependencies(value={"getMetadataStandards"})
    @XmlElement(name="metadataStandardVersion", namespace="http://www.isotc211.org/2005/gmd")
    public String getMetadataStandardVersion() {
        return this.getMetadataStandard(true);
    }

    @Deprecated
    public void setMetadataStandardVersion(String string) {
        this.setMetadataStandard(true, string);
    }

    @UML(identifier="metadataLinkage", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<OnlineResource> getMetadataLinkages() {
        this.metadataLinkages = this.nonNullCollection(this.metadataLinkages, OnlineResource.class);
        return this.metadataLinkages;
    }

    public void setMetadataLinkages(Collection<? extends OnlineResource> collection) {
        this.metadataLinkages = this.writeCollection(collection, this.metadataLinkages, OnlineResource.class);
    }

    @Deprecated
    @Dependencies(value={"getIdentificationInfo"})
    @XmlElement(name="dataSetURI", namespace="http://www.isotc211.org/2005/gmd")
    public String getDataSetUri() {
        Collection<Identification> collection;
        String string = null;
        if (FilterByVersion.LEGACY_METADATA.accept() && (collection = this.getIdentificationInfo()) != null) {
            block0: for (Identification identification : collection) {
                Collection<OnlineResource> collection2;
                Citation citation = identification.getCitation();
                if (!(citation instanceof DefaultCitation) || (collection2 = ((DefaultCitation)citation).getOnlineResources()) == null) continue;
                for (OnlineResource onlineResource : collection2) {
                    URI uRI = onlineResource.getLinkage();
                    if (uRI == null) continue;
                    if (string == null) {
                        string = uRI.toString();
                        continue;
                    }
                    LegacyPropertyAdapter.warnIgnoredExtraneous(OnlineResource.class, DefaultMetadata.class, "getDataSetUri");
                    continue block0;
                }
            }
        }
        return string;
    }

    @Deprecated
    public void setDataSetUri(String string) throws URISyntaxException {
        Collection<OnlineResource> collection;
        DefaultOnlineResource defaultOnlineResource;
        DefaultCitation defaultCitation;
        URI uRI = string != null ? new URI(string) : null;
        Collection<Identification> collection2 = this.identificationInfo;
        this.checkWritePermission(MetadataUtilities.valueIfDefined(collection2));
        AbstractIdentification abstractIdentification = AbstractIdentification.castOrCopy(CollectionsExt.first(collection2));
        if (abstractIdentification == null) {
            if (uRI == null) {
                return;
            }
            abstractIdentification = new DefaultDataIdentification();
        }
        if ((defaultCitation = DefaultCitation.castOrCopy(abstractIdentification.getCitation())) == null) {
            if (uRI == null) {
                return;
            }
            defaultCitation = new DefaultCitation();
        }
        if ((defaultOnlineResource = DefaultOnlineResource.castOrCopy(CollectionsExt.first(collection = defaultCitation.getOnlineResources()))) == null) {
            if (uRI == null) {
                return;
            }
            defaultOnlineResource = new DefaultOnlineResource();
        }
        defaultOnlineResource.setLinkage(uRI);
        collection = MetadataUtilities.setFirst(collection, defaultOnlineResource);
        defaultCitation.setOnlineResources(collection);
        abstractIdentification.setCitation(defaultCitation);
        collection2 = MetadataUtilities.setFirst(collection2, abstractIdentification);
        this.setIdentificationInfo(collection2);
    }

    @XmlElement(name="spatialRepresentationInfo")
    public Collection<SpatialRepresentation> getSpatialRepresentationInfo() {
        this.spatialRepresentationInfo = this.nonNullCollection(this.spatialRepresentationInfo, SpatialRepresentation.class);
        return this.spatialRepresentationInfo;
    }

    public void setSpatialRepresentationInfo(Collection<? extends SpatialRepresentation> collection) {
        this.spatialRepresentationInfo = this.writeCollection(collection, this.spatialRepresentationInfo, SpatialRepresentation.class);
    }

    @XmlElement(name="referenceSystemInfo")
    public Collection<ReferenceSystem> getReferenceSystemInfo() {
        this.referenceSystemInfo = this.nonNullCollection(this.referenceSystemInfo, ReferenceSystem.class);
        return this.referenceSystemInfo;
    }

    public void setReferenceSystemInfo(Collection<? extends ReferenceSystem> collection) {
        this.referenceSystemInfo = this.writeCollection(collection, this.referenceSystemInfo, ReferenceSystem.class);
    }

    @XmlElement(name="metadataExtensionInfo")
    public Collection<MetadataExtensionInformation> getMetadataExtensionInfo() {
        this.metadataExtensionInfo = this.nonNullCollection(this.metadataExtensionInfo, MetadataExtensionInformation.class);
        return this.metadataExtensionInfo;
    }

    public void setMetadataExtensionInfo(Collection<? extends MetadataExtensionInformation> collection) {
        this.metadataExtensionInfo = this.writeCollection(collection, this.metadataExtensionInfo, MetadataExtensionInformation.class);
    }

    @XmlElement(name="identificationInfo", required=true)
    public Collection<Identification> getIdentificationInfo() {
        this.identificationInfo = this.nonNullCollection(this.identificationInfo, Identification.class);
        return this.identificationInfo;
    }

    public void setIdentificationInfo(Collection<? extends Identification> collection) {
        this.identificationInfo = this.writeCollection(collection, this.identificationInfo, Identification.class);
    }

    @XmlElement(name="contentInfo")
    public Collection<ContentInformation> getContentInfo() {
        this.contentInfo = this.nonNullCollection(this.contentInfo, ContentInformation.class);
        return this.contentInfo;
    }

    public void setContentInfo(Collection<? extends ContentInformation> collection) {
        this.contentInfo = this.writeCollection(collection, this.contentInfo, ContentInformation.class);
    }

    @XmlElement(name="distributionInfo")
    public Distribution getDistributionInfo() {
        return this.distributionInfo;
    }

    public void setDistributionInfo(Distribution distribution) {
        this.checkWritePermission(this.distributionInfo);
        this.distributionInfo = distribution;
    }

    @XmlElement(name="dataQualityInfo")
    public Collection<DataQuality> getDataQualityInfo() {
        this.dataQualityInfo = this.nonNullCollection(this.dataQualityInfo, DataQuality.class);
        return this.dataQualityInfo;
    }

    public void setDataQualityInfo(Collection<? extends DataQuality> collection) {
        this.dataQualityInfo = this.writeCollection(collection, this.dataQualityInfo, DataQuality.class);
    }

    @XmlElement(name="portrayalCatalogueInfo")
    public Collection<PortrayalCatalogueReference> getPortrayalCatalogueInfo() {
        this.portrayalCatalogueInfo = this.nonNullCollection(this.portrayalCatalogueInfo, PortrayalCatalogueReference.class);
        return this.portrayalCatalogueInfo;
    }

    public void setPortrayalCatalogueInfo(Collection<? extends PortrayalCatalogueReference> collection) {
        this.portrayalCatalogueInfo = this.writeCollection(collection, this.portrayalCatalogueInfo, PortrayalCatalogueReference.class);
    }

    @XmlElement(name="metadataConstraints")
    public Collection<Constraints> getMetadataConstraints() {
        this.metadataConstraints = this.nonNullCollection(this.metadataConstraints, Constraints.class);
        return this.metadataConstraints;
    }

    public void setMetadataConstraints(Collection<? extends Constraints> collection) {
        this.metadataConstraints = this.writeCollection(collection, this.metadataConstraints, Constraints.class);
    }

    @XmlElement(name="applicationSchemaInfo")
    public Collection<ApplicationSchemaInformation> getApplicationSchemaInfo() {
        this.applicationSchemaInfo = this.nonNullCollection(this.applicationSchemaInfo, ApplicationSchemaInformation.class);
        return this.applicationSchemaInfo;
    }

    public void setApplicationSchemaInfo(Collection<? extends ApplicationSchemaInformation> collection) {
        this.applicationSchemaInfo = this.writeCollection(collection, this.applicationSchemaInfo, ApplicationSchemaInformation.class);
    }

    @XmlElement(name="acquisitionInformation")
    public Collection<AcquisitionInformation> getAcquisitionInformation() {
        this.acquisitionInformation = this.nonNullCollection(this.acquisitionInformation, AcquisitionInformation.class);
        return this.acquisitionInformation;
    }

    public void setAcquisitionInformation(Collection<? extends AcquisitionInformation> collection) {
        this.acquisitionInformation = this.writeCollection(collection, this.acquisitionInformation, AcquisitionInformation.class);
    }

    @XmlElement(name="metadataMaintenance")
    public MaintenanceInformation getMetadataMaintenance() {
        return this.metadataMaintenance;
    }

    public void setMetadataMaintenance(MaintenanceInformation maintenanceInformation) {
        this.checkWritePermission(this.metadataMaintenance);
        this.metadataMaintenance = maintenanceInformation;
    }

    @UML(identifier="resourceLineage", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Lineage> getResourceLineages() {
        this.resourceLineages = this.nonNullCollection(this.resourceLineages, Lineage.class);
        return this.resourceLineages;
    }

    public void setResourceLineages(Collection<? extends Lineage> collection) {
        this.resourceLineages = this.writeCollection(collection, this.resourceLineages, Lineage.class);
    }

    private void beforeMarshal(Marshaller marshaller) {
        Context.push(CollectionsExt.first(LocaleAndCharset.getLanguages(this.getLocalesAndCharsets())));
    }

    private void afterMarshal(Marshaller marshaller) {
        Context.pull();
    }

    @XmlElement(name="defaultLocale")
    private PT_Locale getDefaultLocale() {
        return FilterByVersion.CURRENT_METADATA.accept() ? PT_Locale.first(this.getLocalesAndCharsets()) : null;
    }

    private void setDefaultLocale(PT_Locale pT_Locale) {
        this.setLocalesAndCharsets(OtherLocales.setFirst(this.locales, pT_Locale));
    }

    @XmlElement(name="otherLocale")
    private Collection<PT_Locale> getOtherLocales() {
        return FilterByVersion.CURRENT_METADATA.accept() ? OtherLocales.filter(this.getLocalesAndCharsets()) : null;
    }

    @XmlElement(name="characterSet", namespace="http://www.isotc211.org/2005/gmd")
    private Charset getCharset() {
        if (FilterByVersion.LEGACY_METADATA.accept()) {
            return LegacyPropertyAdapter.getSingleton(this.getCharacterSets(), Charset.class, null, DefaultMetadata.class, "getCharacterSet");
        }
        return null;
    }

    private void setCharset(Charset charset) {
        this.setCharacterSets(CollectionsExt.singletonOrEmpty(charset));
    }

    @XmlElement(name="dateInfo", required=true)
    private Collection<CitationDate> getDates() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getDateInfo() : null;
    }

    @XmlElement(name="metadataStandard")
    private Collection<Citation> getMetadataStandard() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getMetadataStandards() : null;
    }

    @XmlElement(name="metadataProfile")
    private Collection<Citation> getMetadataProfile() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getMetadataProfiles() : null;
    }

    @XmlElement(name="alternativeMetadataReference")
    private Collection<Citation> getAlternativeMetadataReference() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getAlternativeMetadataReferences() : null;
    }

    @XmlElement(name="metadataLinkage")
    private Collection<OnlineResource> getMetadataLinkage() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getMetadataLinkages() : null;
    }

    @XmlElement(name="resourceLineage")
    private Collection<Lineage> getResourceLineage() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getResourceLineages() : null;
    }

    @XmlElement(name="metadataScope")
    private Collection<DefaultMetadataScope> getMetadataScope() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getMetadataScopes() : null;
    }

    private static final class ToLocale
    extends SurjectiveConverter<PT_Locale, Locale> {
        static final ToLocale INSTANCE = new ToLocale();

        private ToLocale() {
        }

        @Override
        public Class<PT_Locale> getSourceClass() {
            return PT_Locale.class;
        }

        @Override
        public Class<Locale> getTargetClass() {
            return Locale.class;
        }

        @Override
        public Locale apply(PT_Locale pT_Locale) {
            return pT_Locale.getLocale();
        }

        @Override
        public ObjectConverter<Locale, PT_Locale> inverse() {
            return FromLocale.INSTANCE;
        }
    }

    private static final class FromLocale
    implements ObjectConverter<Locale, PT_Locale> {
        static final FromLocale INSTANCE = new FromLocale();

        private FromLocale() {
        }

        @Override
        public Set<FunctionProperty> properties() {
            return EnumSet.of(FunctionProperty.INJECTIVE);
        }

        @Override
        public Class<Locale> getSourceClass() {
            return Locale.class;
        }

        @Override
        public Class<PT_Locale> getTargetClass() {
            return PT_Locale.class;
        }

        @Override
        public PT_Locale apply(Locale locale) {
            return locale != null ? new PT_Locale(locale) : null;
        }

        @Override
        public ObjectConverter<PT_Locale, Locale> inverse() {
            return ToLocale.INSTANCE;
        }
    }
}

