/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf;

import java.awt.image.DataBuffer;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.util.List;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.BufferedGridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.ImageRenderer;
import org.apache.sis.internal.netcdf.Resources;

final class Raster
extends BufferedGridCoverage {
    private final int pixelStride;
    private final int[] bandOffsets;
    private final String label;

    Raster(GridGeometry gridGeometry, List<SampleDimension> list, DataBuffer dataBuffer, int n, int[] nArray, String string) {
        super(gridGeometry, list, dataBuffer);
        this.label = string;
        this.pixelStride = n;
        this.bandOffsets = nArray;
    }

    @Override
    public RenderedImage render(GridExtent gridExtent) {
        ImageRenderer imageRenderer = new ImageRenderer(this, gridExtent);
        try {
            imageRenderer.setData(this.data);
            if (this.bandOffsets != null) {
                imageRenderer.setInterleavedPixelOffsets(this.pixelStride, this.bandOffsets);
            }
            return imageRenderer.createImage();
        }
        catch (RasterFormatException | ArithmeticException | IllegalArgumentException runtimeException) {
            throw new RuntimeException(Resources.format((short)14, this.label, runtimeException), runtimeException);
        }
    }
}

