/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Arguments used to upgrade a Private Cloud Control Plane on embedded kubernetes and the associated Containerized Cluster.")
public class ApiUpgradeEmbeddedControlPlaneArgs {
    @SerializedName(value="remoteRepoUrl")
    private String remoteRepoUrl = null;
    @SerializedName(value="valuesYaml")
    private String valuesYaml = null;
    @SerializedName(value="experienceClusterName")
    private String experienceClusterName = null;
    @SerializedName(value="containerizedClusterName")
    private String containerizedClusterName = null;

    public ApiUpgradeEmbeddedControlPlaneArgs remoteRepoUrl(String remoteRepoUrl) {
        this.remoteRepoUrl = remoteRepoUrl;
        return this;
    }

    @Schema(description="The url of the remote repository where the private cloud artifacts to upgrade to are hosted")
    public String getRemoteRepoUrl() {
        return this.remoteRepoUrl;
    }

    public void setRemoteRepoUrl(String remoteRepoUrl) {
        this.remoteRepoUrl = remoteRepoUrl;
    }

    public ApiUpgradeEmbeddedControlPlaneArgs valuesYaml(String valuesYaml) {
        this.valuesYaml = valuesYaml;
        return this;
    }

    @Schema(description="A yaml file containing configuration parameters for the upgrade.")
    public String getValuesYaml() {
        return this.valuesYaml;
    }

    public void setValuesYaml(String valuesYaml) {
        this.valuesYaml = valuesYaml;
    }

    public ApiUpgradeEmbeddedControlPlaneArgs experienceClusterName(String experienceClusterName) {
        this.experienceClusterName = experienceClusterName;
        return this;
    }

    @Schema(description="Deprecated. Use containerizedClusterName instead.")
    public String getExperienceClusterName() {
        return this.experienceClusterName;
    }

    public void setExperienceClusterName(String experienceClusterName) {
        this.experienceClusterName = experienceClusterName;
    }

    public ApiUpgradeEmbeddedControlPlaneArgs containerizedClusterName(String containerizedClusterName) {
        this.containerizedClusterName = containerizedClusterName;
        return this;
    }

    @Schema(description="The name of the existing Containerized Cluster to upgrade.")
    public String getContainerizedClusterName() {
        return this.containerizedClusterName;
    }

    public void setContainerizedClusterName(String containerizedClusterName) {
        this.containerizedClusterName = containerizedClusterName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiUpgradeEmbeddedControlPlaneArgs apiUpgradeEmbeddedControlPlaneArgs = (ApiUpgradeEmbeddedControlPlaneArgs)o;
        return Objects.equals(this.remoteRepoUrl, apiUpgradeEmbeddedControlPlaneArgs.remoteRepoUrl) && Objects.equals(this.valuesYaml, apiUpgradeEmbeddedControlPlaneArgs.valuesYaml) && Objects.equals(this.experienceClusterName, apiUpgradeEmbeddedControlPlaneArgs.experienceClusterName) && Objects.equals(this.containerizedClusterName, apiUpgradeEmbeddedControlPlaneArgs.containerizedClusterName);
    }

    public int hashCode() {
        return Objects.hash(this.remoteRepoUrl, this.valuesYaml, this.experienceClusterName, this.containerizedClusterName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiUpgradeEmbeddedControlPlaneArgs {\n");
        sb.append("    remoteRepoUrl: ").append(this.toIndentedString(this.remoteRepoUrl)).append("\n");
        sb.append("    valuesYaml: ").append(this.toIndentedString(this.valuesYaml)).append("\n");
        sb.append("    experienceClusterName: ").append(this.toIndentedString(this.experienceClusterName)).append("\n");
        sb.append("    containerizedClusterName: ").append(this.toIndentedString(this.containerizedClusterName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

