/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import net.spy.memcached.MemcachedNode;

public class KetamaNodeKeyFormatter {
    private final Format format;
    private Map<MemcachedNode, String> nodeKeys = new HashMap<MemcachedNode, String>();

    public Format getFormat() {
        return this.format;
    }

    public KetamaNodeKeyFormatter() {
        this(Format.SPYMEMCACHED);
    }

    public KetamaNodeKeyFormatter(Format format) {
        this.format = format;
    }

    public String getKeyForNode(MemcachedNode node, int repetition) {
        String nodeKey = this.nodeKeys.get(node);
        if (nodeKey == null) {
            switch (this.format) {
                case LIBMEMCACHED: {
                    InetSocketAddress address = (InetSocketAddress)node.getSocketAddress();
                    nodeKey = address.getHostName();
                    if (address.getPort() == 11211) break;
                    nodeKey = nodeKey + ":" + address.getPort();
                    break;
                }
                case SPYMEMCACHED: {
                    nodeKey = String.valueOf(node.getSocketAddress());
                    if (!nodeKey.startsWith("/")) break;
                    nodeKey = nodeKey.substring(1);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            this.nodeKeys.put(node, nodeKey);
        }
        return nodeKey + "-" + repetition;
    }

    public static enum Format {
        SPYMEMCACHED,
        LIBMEMCACHED;

    }
}

