/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.util.Strings;

public final class DsaQualitySyntaxSyntaxChecker
extends SyntaxChecker {
    public static final DsaQualitySyntaxSyntaxChecker INSTANCE = new DsaQualitySyntaxSyntaxChecker("1.3.6.1.4.1.1466.115.121.1.19");

    private DsaQualitySyntaxSyntaxChecker(String oid) {
        super(oid);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isValidSyntax(Object value) {
        String remaining;
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_04488_SYNTAX_INVALID, "null"));
            }
            return false;
        }
        String strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() < 7) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_04488_SYNTAX_INVALID, value));
            }
            return false;
        }
        switch (strValue.charAt(0)) {
            case 'B': {
                if (!strValue.startsWith("BEST-EFFORT")) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(I18n.err(I18n.ERR_04488_SYNTAX_INVALID, value));
                    }
                    return false;
                }
                remaining = strValue.substring("BEST-EFFORT".length());
                break;
            }
            case 'D': {
                if (!strValue.startsWith("DEFUNCT")) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(I18n.err(I18n.ERR_04488_SYNTAX_INVALID, value));
                    }
                    return false;
                }
                remaining = strValue.substring("DEFUNCT".length());
                break;
            }
            case 'E': {
                if (!strValue.startsWith("EXPERIMENTAL")) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(I18n.err(I18n.ERR_04488_SYNTAX_INVALID, value));
                    }
                    return false;
                }
                remaining = strValue.substring("EXPERIMENTAL".length());
                break;
            }
            case 'F': {
                if (!strValue.startsWith("FULL-SERVICE")) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(I18n.err(I18n.ERR_04488_SYNTAX_INVALID, value));
                    }
                    return false;
                }
                remaining = strValue.substring("FULL-SERVICE".length());
                break;
            }
            case 'P': {
                if (!strValue.startsWith("PILOT-SERVICE")) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(I18n.err(I18n.ERR_04488_SYNTAX_INVALID, value));
                    }
                    return false;
                }
                remaining = strValue.substring("PILOT-SERVICE".length());
                break;
            }
            default: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.err(I18n.ERR_04488_SYNTAX_INVALID, value));
                }
                return false;
            }
        }
        if (remaining.length() == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg(I18n.MSG_04489_SYNTAX_VALID, value));
            }
            return true;
        }
        if (remaining.charAt(0) != '#') {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_04488_SYNTAX_INVALID, value));
            }
            return false;
        }
        boolean result = Strings.isPrintableString(remaining.substring(1));
        if (LOG.isDebugEnabled()) {
            if (result) {
                LOG.debug(I18n.msg(I18n.MSG_04489_SYNTAX_VALID, value));
            } else {
                LOG.debug(I18n.err(I18n.ERR_04488_SYNTAX_INVALID, value));
            }
        }
        return result;
    }

    public static final class Builder
    extends SyntaxChecker.SCBuilder<DsaQualitySyntaxSyntaxChecker> {
        private Builder() {
            super("1.3.6.1.4.1.1466.115.121.1.19");
        }

        @Override
        public DsaQualitySyntaxSyntaxChecker build() {
            return new DsaQualitySyntaxSyntaxChecker(this.oid);
        }
    }
}

