/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.ha.provider.impl;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.knox.gateway.ha.provider.impl.BaseZookeeperURLManager;

public class KafkaZookeeperURLManager
extends BaseZookeeperURLManager {
    private static final int PORT_NUMBER = 8082;
    private static final String BASE_PATH = "/brokers/ids";

    @Override
    protected List<String> lookupURLs() {
        List<String> hosts = this.retrieveHosts();
        List<String> validatedHosts = this.validateHosts(hosts, "/topics", "application/vnd.kafka.v2+json");
        if (!validatedHosts.isEmpty()) {
            Collections.shuffle(validatedHosts);
        }
        return validatedHosts;
    }

    @Override
    protected String getServiceName() {
        return "KAFKA";
    }

    private List<String> retrieveHosts() {
        ArrayList<String> serverHosts = new ArrayList<String>();
        try (CuratorFramework zooKeeperClient = CuratorFrameworkFactory.builder().connectString(this.getZookeeperEnsemble()).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(1000, 3)).build();){
            zooKeeperClient.start();
            zooKeeperClient.blockUntilConnected(10, TimeUnit.SECONDS);
            List brokers = (List)zooKeeperClient.getChildren().forPath(BASE_PATH);
            for (String broker : brokers) {
                String serverInfo = new String((byte[])zooKeeperClient.getData().forPath("/brokers/ids/" + broker), StandardCharsets.UTF_8);
                String serverURL = this.constructURL(serverInfo);
                serverHosts.add(serverURL);
            }
        }
        catch (Exception e) {
            LOG.failedToGetZookeeperUrls(e);
            throw new RuntimeException(e);
        }
        return serverHosts;
    }

    private String constructURL(String serverInfo) throws ParseException {
        String scheme = "http";
        StringBuffer buffer = new StringBuffer();
        buffer.append(scheme);
        buffer.append("://");
        JSONParser parser = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
        JSONObject obj = (JSONObject)parser.parse(serverInfo);
        buffer.append(obj.get((Object)"host"));
        buffer.append(":");
        buffer.append(8082);
        return buffer.toString();
    }
}

