/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.math.BigInteger;
import java.util.Iterator;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.util.ObjectHelper;

@Converter(generateLoader=true)
public final class ObjectConverter {
    private ObjectConverter() {
    }

    @Converter
    public static boolean toBool(Object value) {
        Boolean answer = ObjectConverter.toBoolean(value);
        if (answer == null) {
            throw new IllegalArgumentException("Cannot convert type: " + value.getClass().getName() + " to boolean");
        }
        return answer;
    }

    @Converter
    public static Boolean toBoolean(Object value) {
        return ObjectHelper.toBoolean((Object)value);
    }

    @Converter
    public static Iterator<?> iterator(Object value) {
        return org.apache.camel.support.ObjectHelper.createIterator((Object)value);
    }

    @Converter
    public static Iterable<?> iterable(Object value) {
        return org.apache.camel.support.ObjectHelper.createIterable((Object)value);
    }

    @Converter(allowNull=true)
    public static Byte toByte(Number value) {
        if (ObjectHelper.isNaN((Object)value)) {
            return null;
        }
        return value.byteValue();
    }

    @Converter
    public static Byte toByte(String value) {
        return Byte.valueOf(value);
    }

    @Converter
    public static char[] toCharArray(String value) {
        return value.toCharArray();
    }

    @Converter
    public static Character toCharacter(String value) {
        return Character.valueOf(ObjectConverter.toChar(value));
    }

    @Converter
    public static char toChar(String value) {
        if (value.length() != 1) {
            throw new IllegalArgumentException("String must have exactly a length of 1: " + value);
        }
        return value.charAt(0);
    }

    @Converter
    public static String fromCharArray(char[] value) {
        return new String(value);
    }

    @Converter
    public static Class<?> toClass(String value, Exchange exchange) {
        if (exchange != null) {
            return exchange.getContext().getClassResolver().resolveClass(value);
        }
        return ObjectHelper.loadClass((String)value);
    }

    @Converter(allowNull=true)
    public static Short toShort(Number value) {
        if (ObjectHelper.isNaN((Object)value)) {
            return null;
        }
        return value.shortValue();
    }

    @Converter
    public static Short toShort(String value) {
        return Short.valueOf(value);
    }

    @Converter(allowNull=true)
    public static Integer toInteger(Number value) {
        if (ObjectHelper.isNaN((Object)value)) {
            return null;
        }
        return value.intValue();
    }

    @Converter
    public static Integer toInteger(String value) {
        return Integer.valueOf(value);
    }

    @Converter(allowNull=true)
    public static Long toLong(Number value) {
        if (ObjectHelper.isNaN((Object)value)) {
            return null;
        }
        return value.longValue();
    }

    @Converter
    public static Long toLong(String value) {
        return Long.valueOf(value);
    }

    @Converter(allowNull=true)
    public static BigInteger toBigInteger(Object value) {
        if (ObjectHelper.isNaN((Object)value)) {
            return null;
        }
        if (value instanceof String) {
            return new BigInteger((String)value);
        }
        Long num = null;
        if (value instanceof Number) {
            Number number = (Number)value;
            num = number.longValue();
        }
        if (num != null) {
            return BigInteger.valueOf(num);
        }
        return null;
    }

    @Converter
    public static Float toFloat(Number value) {
        if (ObjectHelper.isNaN((Object)value)) {
            return Float.valueOf(Float.NaN);
        }
        return Float.valueOf(value.floatValue());
    }

    @Converter
    public static Float toFloat(String value) {
        return Float.valueOf(value);
    }

    @Converter
    public static Double toDouble(Number value) {
        if (ObjectHelper.isNaN((Object)value)) {
            return Double.NaN;
        }
        return value.doubleValue();
    }

    @Converter
    public static Double toDouble(String value) {
        return Double.valueOf(value);
    }

    @Converter
    public static String toString(Integer value) {
        return value.toString();
    }

    @Converter
    public static String toString(Long value) {
        return value.toString();
    }

    @Converter
    public static String toString(Boolean value) {
        return value.toString();
    }

    @Converter
    public static String toString(StringBuffer value) {
        return value.toString();
    }

    @Converter
    public static String toString(StringBuilder value) {
        return value.toString();
    }

    @Converter
    public static Boolean toBoolean(String value) {
        return ObjectHelper.toBoolean((Object)value);
    }
}

