/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene103;

import java.io.IOException;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.lucene103.Lucene103PostingsReader;
import org.apache.lucene.codecs.lucene103.Lucene103PostingsWriter;
import org.apache.lucene.codecs.lucene103.blocktree.Lucene103BlockTreeTermsReader;
import org.apache.lucene.codecs.lucene103.blocktree.Lucene103BlockTreeTermsWriter;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.TermState;
import org.apache.lucene.util.IOUtils;

public final class Lucene103PostingsFormat
extends PostingsFormat {
    public static final String META_EXTENSION = "psm";
    public static final String DOC_EXTENSION = "doc";
    public static final String POS_EXTENSION = "pos";
    public static final String PAY_EXTENSION = "pay";
    public static final int BLOCK_SIZE = 128;
    public static final int BLOCK_MASK = 127;
    public static final int LEVEL1_FACTOR = 32;
    public static final int LEVEL1_NUM_DOCS = 4096;
    public static final int LEVEL1_MASK = 4095;
    static final String TERMS_CODEC = "Lucene103PostingsWriterTerms";
    static final String META_CODEC = "Lucene103PostingsWriterMeta";
    static final String DOC_CODEC = "Lucene103PostingsWriterDoc";
    static final String POS_CODEC = "Lucene103PostingsWriterPos";
    static final String PAY_CODEC = "Lucene103PostingsWriterPay";
    static final int VERSION_START = 0;
    static final int VERSION_CURRENT = 0;
    private final int version;
    private final int minTermBlockSize;
    private final int maxTermBlockSize;

    public static Class<? extends ImpactsEnum> getImpactsEnumImpl() {
        return Lucene103PostingsReader.BlockPostingsEnum.class;
    }

    public Lucene103PostingsFormat() {
        this(25, 48);
    }

    public Lucene103PostingsFormat(int minTermBlockSize, int maxTermBlockSize) {
        this(minTermBlockSize, maxTermBlockSize, 0);
    }

    public Lucene103PostingsFormat(int minTermBlockSize, int maxTermBlockSize, int version2) {
        super("Lucene103");
        if (version2 < 0 || version2 > 0) {
            throw new IllegalArgumentException("Version out of range: " + version2);
        }
        this.version = version2;
        Lucene103BlockTreeTermsWriter.validateSettings(minTermBlockSize, maxTermBlockSize);
        this.minTermBlockSize = minTermBlockSize;
        this.maxTermBlockSize = maxTermBlockSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        Lucene103BlockTreeTermsWriter lucene103BlockTreeTermsWriter;
        block3: {
            Lucene103PostingsWriter postingsWriter = new Lucene103PostingsWriter(state, this.version);
            boolean success = false;
            try {
                Lucene103BlockTreeTermsWriter ret = new Lucene103BlockTreeTermsWriter(state, postingsWriter, this.minTermBlockSize, this.maxTermBlockSize);
                success = true;
                lucene103BlockTreeTermsWriter = ret;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(postingsWriter);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(postingsWriter);
        }
        return lucene103BlockTreeTermsWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        Lucene103BlockTreeTermsReader lucene103BlockTreeTermsReader;
        block3: {
            Lucene103PostingsReader postingsReader = new Lucene103PostingsReader(state);
            boolean success = false;
            try {
                Lucene103BlockTreeTermsReader ret = new Lucene103BlockTreeTermsReader(postingsReader, state);
                success = true;
                lucene103BlockTreeTermsReader = ret;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(postingsReader);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(postingsReader);
        }
        return lucene103BlockTreeTermsReader;
    }

    public static final class IntBlockTermState
    extends BlockTermState {
        public long docStartFP;
        public long posStartFP;
        public long payStartFP;
        public long lastPosBlockOffset = -1L;
        public int singletonDocID = -1;

        @Override
        public IntBlockTermState clone() {
            IntBlockTermState other = new IntBlockTermState();
            other.copyFrom(this);
            return other;
        }

        @Override
        public void copyFrom(TermState _other) {
            super.copyFrom(_other);
            IntBlockTermState other = (IntBlockTermState)_other;
            this.docStartFP = other.docStartFP;
            this.posStartFP = other.posStartFP;
            this.payStartFP = other.payStartFP;
            this.lastPosBlockOffset = other.lastPosBlockOffset;
            this.singletonDocID = other.singletonDocID;
        }

        @Override
        public String toString() {
            return super.toString() + " docStartFP=" + this.docStartFP + " posStartFP=" + this.posStartFP + " payStartFP=" + this.payStartFP + " lastPosBlockOffset=" + this.lastPosBlockOffset + " singletonDocID=" + this.singletonDocID;
        }
    }
}

