/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.jena.shacl.validation.ValidationListener;
import org.apache.jena.shacl.validation.event.EventUtil;
import org.apache.jena.shacl.validation.event.ValidationEvent;

public class HandlerBasedValidationListener
implements ValidationListener {
    private final Map<Class<? extends ValidationEvent>, List<Consumer<ValidationEvent>>> eventHandlers = new HashMap<Class<? extends ValidationEvent>, List<Consumer<ValidationEvent>>>();
    private final HandlerSelectionStrategy handlerSelectionStrategy;

    private HandlerBasedValidationListener(HandlerSelectionStrategy handlerSelectionStrategy) {
        this.handlerSelectionStrategy = handlerSelectionStrategy;
    }

    public static Builder builder(HandlerSelectionStrategy handlerSelectionStrategy) {
        return new Builder(handlerSelectionStrategy);
    }

    public static Builder builder() {
        return new Builder(new ClassHierarchyStrategy());
    }

    @Override
    public void onValidationEvent(ValidationEvent e) {
        Objects.requireNonNull(e);
        this.handlerSelectionStrategy.findHandlers(this.eventHandlers, e).forEach(handler -> handler.accept(e));
    }

    private <T extends ValidationEvent> void registerHandlerInternal(Class<T> eventType, Consumer<? super T> handler) {
        Objects.requireNonNull(eventType);
        Objects.requireNonNull(handler);
        this.eventHandlers.compute(eventType, (k, l) -> {
            List ret = Optional.ofNullable(l).orElse(new ArrayList());
            boolean b = ret.add(handler);
            return ret;
        });
        this.handlerSelectionStrategy.onNewHandlerRegistered(eventType);
    }

    public static interface HandlerSelectionStrategy {
        public Collection<Consumer<ValidationEvent>> findHandlers(Map<Class<? extends ValidationEvent>, List<Consumer<ValidationEvent>>> var1, ValidationEvent var2);

        public void onNewHandlerRegistered(Class<? extends ValidationEvent> var1);
    }

    public static class Builder {
        private HandlerBasedValidationListener listener;

        private Builder(HandlerSelectionStrategy handlerSelectionStrategy) {
            this.listener = new HandlerBasedValidationListener(handlerSelectionStrategy);
        }

        public <T extends ValidationEvent> HandlerAdder<T> forEventType(Class<T> eventType) {
            return new HandlerAdder(this, eventType);
        }

        @SafeVarargs
        public final HandlerAdder<ValidationEvent> forEventTypes(Class<? extends ValidationEvent> ... eventType) {
            return new HandlerAdder<ValidationEvent>(this, eventType);
        }

        public HandlerBasedValidationListener build() {
            HandlerBasedValidationListener ret = this.listener;
            this.listener = null;
            return ret;
        }

        private <T extends ValidationEvent> void registerHandlerInternal(Class<T> eventType, Consumer<? super T> handler) {
            this.listener.registerHandlerInternal(eventType, handler);
        }
    }

    private static class ClassHierarchyStrategy
    implements HandlerSelectionStrategy {
        private final Map<Class<? extends ValidationEvent>, List<Consumer<ValidationEvent>>> registeredHandlersCache = new HashMap<Class<? extends ValidationEvent>, List<Consumer<ValidationEvent>>>();

        @Override
        public void onNewHandlerRegistered(Class<? extends ValidationEvent> eventType) {
            this.registeredHandlersCache.clear();
        }

        @Override
        public Collection<Consumer<ValidationEvent>> findHandlers(Map<Class<? extends ValidationEvent>, List<Consumer<ValidationEvent>>> handlers, ValidationEvent event) {
            return this.registeredHandlersCache.computeIfAbsent(event.getClass(), e -> {
                List<Class<? extends ValidationEvent>> eventTypes = EventUtil.getSuperclassesAndInterfaces(event.getClass()).collect(Collectors.toUnmodifiableList());
                return this.getHandlers(handlers, eventTypes);
            });
        }

        private List<Consumer<ValidationEvent>> getHandlers(Map<Class<? extends ValidationEvent>, List<Consumer<ValidationEvent>>> handlers, List<Class<? extends ValidationEvent>> eventTypes) {
            return eventTypes.stream().flatMap(t -> handlers.getOrDefault(t, List.of()).stream()).toList();
        }
    }

    public static class HandlerBuilder<T extends ValidationEvent>
    implements HandlerCustomizer<T>,
    HandlerConditionCustomizer<T> {
        private Predicate<ValidationEvent> predicate = null;
        private Consumer<T> handler = null;

        @Override
        public HandlerBuilder<T> iff(Predicate<ValidationEvent> predicate) {
            this.predicate = predicate;
            return this;
        }

        @Override
        public void handle(Consumer<T> handler) {
            this.handler = handler;
        }

        public Consumer<T> build() {
            Objects.requireNonNull(this.handler);
            if (this.predicate == null) {
                return this.handler;
            }
            return new FilteredEventHandler(this.predicate, this.handler);
        }
    }

    public static interface HandlerConfigurer<T extends ValidationEvent> {
        public void configure(HandlerConditionCustomizer<T> var1);
    }

    public static interface HandlerCustomizer<T extends ValidationEvent> {
        public void handle(Consumer<T> var1);
    }

    public static interface HandlerConditionCustomizer<T extends ValidationEvent> {
        public HandlerCustomizer<T> iff(Predicate<ValidationEvent> var1);

        public void handle(Consumer<T> var1);
    }

    public static class HandlerAdder<T extends ValidationEvent> {
        private final Builder parent;
        private final Class<T>[] eventTypes;

        @SafeVarargs
        public HandlerAdder(Builder parent, Class<T> ... eventTypes) {
            this.eventTypes = eventTypes;
            this.parent = parent;
        }

        @SafeVarargs
        public final Builder addSimpleHandlers(Consumer<? super T> ... handlers) {
            for (Consumer<? super T> handler : handlers) {
                Builder builder = this.addSimpleHandler(handler);
            }
            return this.parent;
        }

        public Builder addSimpleHandler(Consumer<? super T> handler) {
            for (Class<T> eventType : this.eventTypes) {
                this.parent.registerHandlerInternal(eventType, handler);
            }
            return this.parent;
        }

        public Builder addHandler(HandlerConfigurer<T> handlerConfigurer) {
            HandlerBuilder hb = new HandlerBuilder();
            handlerConfigurer.configure(hb);
            for (Class<T> eventType : this.eventTypes) {
                this.parent.registerHandlerInternal(eventType, hb.build());
            }
            return this.parent;
        }
    }

    private static class FilteredEventHandler
    implements Consumer<ValidationEvent> {
        private final Predicate<ValidationEvent> filter;
        private final Consumer<ValidationEvent> handler;

        public FilteredEventHandler(Predicate<ValidationEvent> filter, Consumer<ValidationEvent> handler) {
            this.filter = filter;
            this.handler = handler;
        }

        @Override
        public void accept(ValidationEvent validationEvent) {
            if (this.filter.test(validationEvent)) {
                this.handler.accept(validationEvent);
            }
        }
    }
}

