/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.operation;

import java.util.Iterator;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.jcr2spi.hierarchy.PropertyEntry;
import org.apache.jackrabbit.jcr2spi.operation.AbstractOperation;
import org.apache.jackrabbit.jcr2spi.operation.OperationVisitor;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.jcr2spi.version.VersionManager;
import org.apache.jackrabbit.spi.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Checkpoint
extends AbstractOperation {
    private static Logger log = LoggerFactory.getLogger(Checkpoint.class);
    private final NodeState nodeState;
    private final VersionManager mgr;
    private final NodeId activityId;
    private final boolean supportsActivity;
    private NodeId newVersionId;

    private Checkpoint(NodeState nodeState, VersionManager mgr) {
        this.nodeState = nodeState;
        this.mgr = mgr;
        this.supportsActivity = false;
        this.activityId = null;
    }

    private Checkpoint(NodeState nodeState, NodeId activityId, VersionManager mgr) {
        this.nodeState = nodeState;
        this.activityId = activityId;
        this.mgr = mgr;
        this.supportsActivity = true;
    }

    @Override
    public void accept(OperationVisitor visitor) throws RepositoryException, ConstraintViolationException, AccessDeniedException, ItemExistsException, NoSuchNodeTypeException, UnsupportedRepositoryOperationException, VersionException {
        assert (this.status == 0);
        visitor.visit(this);
    }

    @Override
    public void persisted() {
        assert (this.status == 0);
        this.status = 1;
        try {
            NodeEntry vhe = this.mgr.getVersionHistoryEntry(this.nodeState);
            if (vhe != null) {
                vhe.invalidate(true);
            }
        }
        catch (RepositoryException e) {
            log.warn("Failed to access Version history entry -> skip invalidation.", e);
        }
        NodeEntry nodeEntry = (NodeEntry)this.nodeState.getHierarchyEntry();
        Iterator<PropertyEntry> entries = nodeEntry.getPropertyEntries();
        while (entries.hasNext()) {
            PropertyEntry pe = entries.next();
            pe.invalidate(false);
        }
        nodeEntry.invalidate(false);
    }

    public NodeId getNodeId() throws RepositoryException {
        return this.nodeState.getNodeEntry().getWorkspaceId();
    }

    public NodeId getActivityId() {
        return this.activityId;
    }

    public boolean supportsActivity() {
        return this.supportsActivity;
    }

    public void setNewVersionId(NodeId newVersionId) {
        this.newVersionId = newVersionId;
    }

    public NodeId getNewVersionId() {
        return this.newVersionId;
    }

    public static Checkpoint create(NodeState nodeState, VersionManager mgr) {
        return new Checkpoint(nodeState, mgr);
    }

    public static Checkpoint create(NodeState nodeState, NodeId activityId, VersionManager mgr) {
        return new Checkpoint(nodeState, activityId, mgr);
    }
}

