/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public final class DOMWalker {
    private static final DocumentBuilderFactory factory = DOMWalker.createFactory();
    private final Document document;
    private Element current;

    private static DocumentBuilderFactory createFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(false);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setXIncludeAware(false);
        factory.setExpandEntityReferences(false);
        String feature = null;
        try {
            feature = "http://javax.xml.XMLConstants/feature/secure-processing";
            factory.setFeature(feature, true);
            feature = "http://apache.org/xml/features/disallow-doctype-decl";
            factory.setFeature(feature, true);
            feature = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
            factory.setFeature(feature, false);
            feature = "http://xml.org/sax/features/external-general-entities";
            factory.setFeature(feature, false);
            feature = "http://xml.org/sax/features/external-parameter-entities";
            factory.setFeature(feature, false);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Secure processing feature '" + feature + "' not supported by the DocumentBuilderFactory: " + factory.getClass().getName(), ex);
        }
        return factory;
    }

    public DOMWalker(InputStream xml) throws IOException {
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            EntityResolver stopMe = (publicId, systemId) -> new InputSource(new StringReader("<preventing read of: " + publicId + " " + systemId + ">"));
            builder.setEntityResolver(stopMe);
            this.document = builder.parse(xml);
            this.current = this.document.getDocumentElement();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    public Properties getNamespaces() {
        Properties namespaces = new Properties();
        NamedNodeMap attributes = this.current.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            if (!attribute.getName().startsWith("xmlns:")) continue;
            namespaces.setProperty(attribute.getName().substring(6), attribute.getValue());
        }
        return namespaces;
    }

    public String getName() {
        return this.current.getNodeName();
    }

    public String getAttribute(String name) {
        Attr attribute = this.current.getAttributeNode(name);
        if (attribute != null) {
            return attribute.getValue();
        }
        return null;
    }

    public String getContent() {
        StringBuilder content = new StringBuilder();
        NodeList nodes = this.current.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 3) continue;
            content.append(((CharacterData)node).getData());
        }
        return content.toString();
    }

    public boolean enterElement(String name) {
        NodeList children = this.current.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !name.equals(child.getNodeName())) continue;
            this.current = (Element)child;
            return true;
        }
        return false;
    }

    public void leaveElement() {
        this.current = (Element)this.current.getParentNode();
    }

    public boolean iterateElements(String name) {
        Node parent;
        for (Node next = name.equals(this.current.getNodeName()) ? this.current.getNextSibling() : this.current.getFirstChild(); next != null; next = next.getNextSibling()) {
            if (next.getNodeType() != 1 || !name.equals(next.getNodeName())) continue;
            this.current = (Element)next;
            return true;
        }
        if (name.equals(this.current.getNodeName()) && (parent = this.current.getParentNode()) instanceof Element) {
            this.current = (Element)parent;
        }
        return false;
    }
}

