/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.message;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite3.internal.partition.replicator.network.replication.BinaryTupleMessage;
import org.apache.ignite3.internal.sql.engine.message.QueryBatchMessage;
import org.apache.ignite3.internal.sql.engine.message.QueryBatchMessageBuilder;
import org.apache.ignite3.internal.sql.engine.message.QueryBatchMessageSerializer;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;

public class QueryBatchMessageImpl
implements QueryBatchMessage,
Cloneable {
    public static final short GROUP_TYPE = 4;
    public static final short TYPE = 3;
    @IgniteToStringInclude
    private final int batchId;
    @IgniteToStringInclude
    private final long exchangeId;
    @IgniteToStringInclude
    private final int executionToken;
    @IgniteToStringInclude
    private final long fragmentId;
    @IgniteToStringInclude
    private final boolean last;
    @IgniteToStringInclude
    private final UUID queryId;
    @IgniteToStringInclude
    private final List<BinaryTupleMessage> rows;
    @IgniteToStringInclude
    private final HybridTimestamp timestamp;

    private QueryBatchMessageImpl(int batchId, long exchangeId, int executionToken, long fragmentId, boolean last, UUID queryId, List<BinaryTupleMessage> rows, HybridTimestamp timestamp) {
        this.batchId = batchId;
        this.exchangeId = exchangeId;
        this.executionToken = executionToken;
        this.fragmentId = fragmentId;
        this.last = last;
        this.queryId = queryId;
        this.rows = rows;
        this.timestamp = timestamp;
    }

    @Override
    public int batchId() {
        return this.batchId;
    }

    @Override
    public long exchangeId() {
        return this.exchangeId;
    }

    @Override
    public int executionToken() {
        return this.executionToken;
    }

    @Override
    public long fragmentId() {
        return this.fragmentId;
    }

    @Override
    public boolean last() {
        return this.last;
    }

    @Override
    public UUID queryId() {
        return this.queryId;
    }

    @Override
    public List<BinaryTupleMessage> rows() {
        return this.rows;
    }

    @Override
    public HybridTimestamp timestamp() {
        return this.timestamp;
    }

    public MessageSerializer serializer() {
        return QueryBatchMessageSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 4;
    }

    public String toString() {
        return S.toString(QueryBatchMessageImpl.class, this);
    }

    @Override
    public short messageType() {
        return 3;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        QueryBatchMessageImpl otherMessage = (QueryBatchMessageImpl)other;
        return Objects.equals(this.queryId, otherMessage.queryId) && Objects.equals(this.rows, otherMessage.rows) && Objects.equals(this.timestamp, otherMessage.timestamp) && this.batchId == otherMessage.batchId && this.exchangeId == otherMessage.exchangeId && this.executionToken == otherMessage.executionToken && this.fragmentId == otherMessage.fragmentId && this.last == otherMessage.last;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.batchId, this.exchangeId, this.executionToken, this.fragmentId, this.last, this.queryId, this.rows, this.timestamp);
        return result;
    }

    @Override
    public QueryBatchMessageImpl clone() {
        try {
            return (QueryBatchMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static QueryBatchMessageBuilder builder() {
        return new Builder();
    }

    @Override
    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.rows != null) {
            for (BinaryTupleMessage obj : this.rows) {
                if (obj == null) continue;
                obj.prepareMarshal(usedDescriptors, marshaller);
            }
        }
    }

    @Override
    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.rows != null) {
            for (BinaryTupleMessage obj : this.rows) {
                if (obj == null) continue;
                obj.unmarshal(marshaller, descriptorsObj);
            }
        }
    }

    private static class Builder
    implements QueryBatchMessageBuilder {
        private int batchId;
        private long exchangeId;
        private int executionToken;
        private long fragmentId;
        private boolean last;
        private UUID queryId;
        private List<BinaryTupleMessage> rows;
        private HybridTimestamp timestamp;

        private Builder() {
        }

        @Override
        public QueryBatchMessageBuilder batchId(int batchId) {
            this.batchId = batchId;
            return this;
        }

        @Override
        public QueryBatchMessageBuilder exchangeId(long exchangeId) {
            this.exchangeId = exchangeId;
            return this;
        }

        @Override
        public QueryBatchMessageBuilder executionToken(int executionToken) {
            this.executionToken = executionToken;
            return this;
        }

        @Override
        public QueryBatchMessageBuilder fragmentId(long fragmentId) {
            this.fragmentId = fragmentId;
            return this;
        }

        @Override
        public QueryBatchMessageBuilder last(boolean last) {
            this.last = last;
            return this;
        }

        @Override
        public QueryBatchMessageBuilder queryId(UUID queryId) {
            Objects.requireNonNull(queryId, "queryId is not marked @Nullable");
            this.queryId = queryId;
            return this;
        }

        @Override
        public QueryBatchMessageBuilder rows(List<BinaryTupleMessage> rows) {
            Objects.requireNonNull(rows, "rows is not marked @Nullable");
            this.rows = rows;
            return this;
        }

        @Override
        public QueryBatchMessageBuilder timestamp(HybridTimestamp timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public int batchId() {
            return this.batchId;
        }

        @Override
        public long exchangeId() {
            return this.exchangeId;
        }

        @Override
        public int executionToken() {
            return this.executionToken;
        }

        @Override
        public long fragmentId() {
            return this.fragmentId;
        }

        @Override
        public boolean last() {
            return this.last;
        }

        @Override
        public UUID queryId() {
            return this.queryId;
        }

        @Override
        public List<BinaryTupleMessage> rows() {
            return this.rows;
        }

        @Override
        public HybridTimestamp timestamp() {
            return this.timestamp;
        }

        @Override
        public QueryBatchMessage build() {
            return new QueryBatchMessageImpl(this.batchId, this.exchangeId, this.executionToken, this.fragmentId, this.last, Objects.requireNonNull(this.queryId, "queryId is not marked @Nullable"), Objects.requireNonNull(this.rows, "rows is not marked @Nullable"), this.timestamp);
        }
    }
}

