/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.SQLConnection;
import com.ibm.as400.vaccess.SQLMetaDataTableModel;
import com.ibm.as400.vaccess.SQLQueryGroupPane;
import com.ibm.as400.vaccess.SQLQueryHavingPane;
import com.ibm.as400.vaccess.SQLQueryJoinPane;
import com.ibm.as400.vaccess.SQLQueryOrderPane;
import com.ibm.as400.vaccess.SQLQuerySelectPane;
import com.ibm.as400.vaccess.SQLQuerySummaryPane;
import com.ibm.as400.vaccess.SQLQueryTablePane;
import com.ibm.as400.vaccess.SQLQueryWherePane;
import com.ibm.as400.vaccess.SerializationListener;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingCursorAdapter;
import com.ibm.as400.vaccess.WorkingEvent;
import java.awt.BorderLayout;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SQLQueryBuilderPane
extends JComponent
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private SQLConnection sqlconn_ = null;
    private String[] tables_;
    private String[] schemas_ = new String[0];
    private transient Connection connection_ = null;
    private boolean tablesUserDefined_ = true;
    private boolean schemasUserDefined_ = true;
    transient JTabbedPane notebook_;
    private transient SQLQueryTablePane tablePane_;
    private transient SQLQuerySelectPane selectPane_;
    private transient SQLQueryJoinPane joinPane_;
    private transient SQLQueryWherePane wherePane_;
    private transient SQLQueryGroupPane groupPane_;
    private transient SQLQueryHavingPane havingPane_;
    private transient SQLQueryOrderPane orderPane_;
    private transient SQLQuerySummaryPane summaryPane_;
    static final int TABLE_ = 0;
    static final int SELECT_ = 1;
    static final int JOIN_ = 2;
    static final int WHERE_ = 3;
    static final int GROUP_ = 4;
    static final int HAVING_ = 5;
    static final int ORDER_ = 6;
    static final int SUMMARY_ = 7;
    transient int currentPane_ = 0;
    private transient boolean[] panelInit = new boolean[8];
    transient SQLMetaDataTableModel fields_ = null;
    private transient PropertyChangeSupport fieldListeners_ = new PropertyChangeSupport(this);
    private boolean internalLoad_ = false;
    private transient boolean loadDone_ = false;
    private transient PropertyChangeSupport changeListeners_ = new PropertyChangeSupport(this);
    private transient VetoableChangeSupport vetoListeners_ = new VetoableChangeSupport(this);
    private transient ErrorEventSupport panelErrors_ = new ErrorEventSupport(this);
    transient WorkingCursorAdapter worker_ = new WorkingCursorAdapter(this);
    transient WorkingEvent workEvent_ = new WorkingEvent(this);

    public SQLQueryBuilderPane() {
        this.tables_ = new String[0];
        this.setupPane();
        this.addFocusListener(new SerializationListener(this));
    }

    public SQLQueryBuilderPane(SQLConnection connection) {
        this.sqlconn_ = connection;
        this.tables_ = new String[0];
        this.setupPane();
        this.addFocusListener(new SerializationListener(this));
    }

    public SQLQueryBuilderPane(SQLConnection connection, String[] tables) {
        if (tables == null) {
            throw new NullPointerException("tables");
        }
        this.sqlconn_ = connection;
        this.tables_ = tables;
        this.setupPane();
        this.addFocusListener(new SerializationListener(this));
    }

    public void addErrorListener(ErrorListener listener) {
        this.panelErrors_.addErrorListener(listener);
    }

    void addFieldListener(PropertyChangeListener listener) {
        this.fieldListeners_.addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeListeners_.addPropertyChangeListener(listener);
        super.addPropertyChangeListener(listener);
    }

    void addSelectListener(PropertyChangeListener listener) {
        this.selectPane_.addSelectListener(listener);
    }

    @Override
    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoListeners_.addVetoableChangeListener(listener);
        super.addVetoableChangeListener(listener);
    }

    synchronized void completePage() {
        Trace.log(1, "Completing page " + this.currentPane_);
        switch (this.currentPane_) {
            case 0: {
                this.tablePane_.complete();
                if (this.tablePane_.getSchemas() != this.schemas_) {
                    try {
                        this.setTableSchemas(this.tablePane_.getSchemas());
                    }
                    catch (PropertyVetoException ev) {
                        this.tablePane_.setSchemas(this.schemas_);
                    }
                }
                if (this.tablePane_.getTables() == this.tables_) break;
                try {
                    this.setTables(this.tablePane_.getTables());
                }
                catch (PropertyVetoException ev) {
                    this.tablePane_.setTables(this.tables_);
                }
                this.internalLoad_ = true;
                this.load();
                this.internalLoad_ = false;
                if (this.tables_.length == 0) {
                    this.notebook_.setEnabledAt(1, false);
                    this.notebook_.setEnabledAt(2, false);
                    this.notebook_.setEnabledAt(3, false);
                    this.notebook_.setEnabledAt(4, false);
                    this.notebook_.setEnabledAt(5, false);
                    this.notebook_.setEnabledAt(6, false);
                    break;
                }
                this.notebook_.setEnabledAt(1, true);
                this.notebook_.setEnabledAt(3, true);
                this.notebook_.setEnabledAt(4, true);
                this.notebook_.setEnabledAt(5, true);
                if (this.tables_.length == 1) {
                    this.notebook_.setEnabledAt(2, false);
                } else {
                    this.notebook_.setEnabledAt(2, true);
                }
                if (this.selectPane_.getSelectedItems().length > 0) {
                    this.notebook_.setEnabledAt(6, true);
                    break;
                }
                this.notebook_.setEnabledAt(6, false);
                break;
            }
            case 1: {
                this.selectPane_.complete();
                if (this.selectPane_.getSelectedItems().length > 0) {
                    this.notebook_.setEnabledAt(6, true);
                    break;
                }
                this.notebook_.setEnabledAt(6, false);
                break;
            }
            case 2: {
                this.joinPane_.complete();
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            default: {
                Trace.log(2, "Unknown page " + this.currentPane_);
            }
        }
    }

    public SQLConnection getConnection() {
        return this.sqlconn_;
    }

    public synchronized String getQuery() {
        String clause;
        this.completePage();
        if (this.tables_.length == 0) {
            return "";
        }
        this.worker_.startWorking(this.workEvent_);
        StringBuffer result = new StringBuffer("SELECT " + this.selectPane_.getClause());
        boolean whereProcessed = false;
        boolean fromAdded = false;
        if (this.tables_.length > 1) {
            if (this.joinPane_.getJoinType() == 1) {
                clause = this.joinPane_.getClause(0);
                if (clause != null && !clause.equals("")) {
                    result.append(" FROM ");
                    for (int i = 0; i < this.tables_.length; ++i) {
                        if (i > 0) {
                            result.append(", ");
                        }
                        result.append(this.tables_[i]);
                        result.append(" AS ");
                        result.append(this.tables_[i].substring(this.tables_[i].lastIndexOf(".") + 1));
                    }
                    fromAdded = true;
                    result.append(" WHERE ");
                    result.append(clause);
                    String where = this.wherePane_.getClause();
                    if (where != null && !where.equals("")) {
                        result.append(" AND ");
                        result.append(where);
                    }
                    whereProcessed = true;
                }
            } else {
                result.append(" FROM ");
                result.append(this.tables_[0]);
                result.append(" AS ");
                result.append(this.tables_[0].substring(this.tables_[0].lastIndexOf(".") + 1));
                int i = 0;
                while (i < this.tables_.length - 1) {
                    clause = this.joinPane_.getClause(i).trim();
                    if (clause.equals("")) {
                        result.append(", ");
                        result.append(this.tables_[++i]);
                        result.append(" AS ");
                        result.append(this.tables_[i].substring(this.tables_[i].lastIndexOf(".") + 1));
                        continue;
                    }
                    result.append(" LEFT JOIN ");
                    result.append(this.tables_[++i]);
                    result.append(" AS ");
                    result.append(this.tables_[i].substring(this.tables_[i].lastIndexOf(".") + 1));
                    result.append(" ON ");
                    result.append(clause);
                }
                fromAdded = true;
            }
        }
        if (!fromAdded) {
            result.append(" FROM ");
            for (int i = 0; i < this.tables_.length; ++i) {
                if (i > 0) {
                    result.append(", ");
                }
                result.append(this.tables_[i]);
                result.append(" AS ");
                result.append(this.tables_[i].substring(this.tables_[i].lastIndexOf(".") + 1));
            }
        }
        if (!whereProcessed && (clause = this.wherePane_.getClause()) != null && !clause.equals("")) {
            result.append(" WHERE ");
            result.append(clause);
        }
        if ((clause = this.groupPane_.getClause()) != null && !clause.equals("")) {
            result.append(" GROUP BY ");
            result.append(clause);
        }
        if ((clause = this.havingPane_.getClause()) != null && !clause.equals("")) {
            result.append(" HAVING ");
            result.append(clause);
        }
        if ((clause = this.orderPane_.getClause()) != null && !clause.equals("")) {
            result.append(" ORDER BY ");
            result.append(clause);
        }
        this.worker_.stopWorking(this.workEvent_);
        return result.toString();
    }

    synchronized String[] getSelectedFields() {
        this.worker_.startWorking(this.workEvent_);
        String[] result = this.selectPane_.getSelectedFields();
        this.worker_.stopWorking(this.workEvent_);
        return result;
    }

    synchronized String[] getSelectedItems() {
        this.worker_.startWorking(this.workEvent_);
        String[] result = this.selectPane_.getSelectedItems();
        this.worker_.stopWorking(this.workEvent_);
        return result;
    }

    public String[] getTables() {
        return this.tables_;
    }

    public String[] getTableSchemas() {
        return this.schemas_;
    }

    public boolean getUserSelectTables() {
        return this.tablesUserDefined_;
    }

    public boolean getUserSelectTableSchemas() {
        return this.schemasUserDefined_;
    }

    public synchronized void load() {
        Trace.log(1, "Doing query builder load");
        this.worker_.startWorking(this.workEvent_);
        if (this.currentPane_ != 0) {
            this.completePage();
        }
        if (!this.internalLoad_) {
            if (this.sqlconn_ == null) {
                this.sqlconn_ = new SQLConnection("jdbc:as400");
            }
            this.connection_ = null;
            try {
                this.connection_ = this.sqlconn_.getConnection();
            }
            catch (SQLException e) {
                this.panelErrors_.fireError(e);
                return;
            }
        }
        this.fields_.setConnection(this.connection_);
        this.fields_.setTables(this.tables_);
        this.fields_.load();
        this.fieldListeners_.firePropertyChange(null, null, null);
        if (!this.internalLoad_) {
            this.tablePane_.setConnection(this.connection_);
            this.tablePane_.setTables(this.tables_);
            this.tablePane_.load();
            if (this.tablesUserDefined_) {
                this.tablePane_.setEnabled(true);
            }
            this.updatePage();
        }
        this.worker_.stopWorking(this.workEvent_);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.addFocusListener(new SerializationListener(this));
        this.panelInit = new boolean[8];
        this.fieldListeners_ = new PropertyChangeSupport(this);
        this.changeListeners_ = new PropertyChangeSupport(this);
        this.vetoListeners_ = new VetoableChangeSupport(this);
        this.panelErrors_ = new ErrorEventSupport(this);
        this.fields_ = null;
        this.worker_ = new WorkingCursorAdapter(this);
        this.workEvent_ = new WorkingEvent(this);
        this.currentPane_ = 0;
        this.loadDone_ = false;
        this.setupPane();
    }

    public void removeErrorListener(ErrorListener listener) {
        this.panelErrors_.removeErrorListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeListeners_.removePropertyChangeListener(listener);
        super.removePropertyChangeListener(listener);
    }

    @Override
    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoListeners_.removeVetoableChangeListener(listener);
        super.removeVetoableChangeListener(listener);
    }

    public void setConnection(SQLConnection connection) throws PropertyVetoException {
        SQLConnection old = this.sqlconn_;
        this.vetoListeners_.fireVetoableChange("connection", old, connection);
        this.sqlconn_ = connection;
        this.changeListeners_.firePropertyChange("connection", old, connection);
    }

    public void setTables(String[] tables) throws PropertyVetoException {
        if (tables == null) {
            throw new NullPointerException("tables");
        }
        String[] old = this.tables_;
        this.vetoListeners_.fireVetoableChange("tables", old, tables);
        this.tables_ = tables;
        this.changeListeners_.firePropertyChange("tables", old, tables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTableSchemas(String[] tableSchemas) throws PropertyVetoException {
        if (tableSchemas == null) {
            throw new NullPointerException("tableSchemas");
        }
        String[] old = this.schemas_;
        this.vetoListeners_.fireVetoableChange("tableSchemas", old, tableSchemas);
        SQLQueryBuilderPane sQLQueryBuilderPane = this;
        synchronized (sQLQueryBuilderPane) {
            this.schemas_ = tableSchemas;
            this.tablePane_.setSchemas(tableSchemas);
        }
        this.changeListeners_.firePropertyChange("tableSchemas", old, tableSchemas);
    }

    public void setUserSelectTables(boolean flag) throws PropertyVetoException {
        Boolean old = this.tablesUserDefined_;
        this.vetoListeners_.fireVetoableChange("userSelectTables", old, (Object)flag);
        this.tablesUserDefined_ = flag;
        this.tablePane_.setEnabled(flag);
        this.changeListeners_.firePropertyChange("userSelectTables", old, (Object)flag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserSelectTableSchemas(boolean flag) throws PropertyVetoException {
        this.vetoListeners_.fireVetoableChange("userSelectTableSchemas", (Object)this.schemasUserDefined_, (Object)flag);
        boolean old = this.schemasUserDefined_;
        this.schemasUserDefined_ = flag;
        SQLQueryBuilderPane sQLQueryBuilderPane = this;
        synchronized (sQLQueryBuilderPane) {
            this.tablePane_.setUserSelectTableSchemas(flag);
        }
        this.changeListeners_.firePropertyChange("userSelectTableSchemas", (Object)old, (Object)flag);
    }

    private void setupPane() {
        this.fields_ = new SQLMetaDataTableModel(this.connection_, this.tables_);
        this.fields_.addErrorListener(this.panelErrors_);
        this.setLayout(new BorderLayout());
        this.notebook_ = new JTabbedPane();
        this.tablePane_ = new SQLQueryTablePane(this, this.connection_, this.tables_, this.schemas_, this.schemasUserDefined_);
        this.tablePane_.addErrorListener(this.panelErrors_);
        this.notebook_.addTab(ResourceLoader.getQueryText("DBQUERY_LABEL_TABLES"), null, this.tablePane_);
        this.selectPane_ = new SQLQuerySelectPane(this);
        this.notebook_.addTab("Select", null, this.selectPane_);
        this.joinPane_ = new SQLQueryJoinPane(this);
        this.notebook_.addTab("Join By", null, this.joinPane_);
        this.wherePane_ = new SQLQueryWherePane(this);
        this.notebook_.addTab("Where", null, this.wherePane_);
        this.groupPane_ = new SQLQueryGroupPane(this);
        this.notebook_.addTab("Group By", null, this.groupPane_);
        this.havingPane_ = new SQLQueryHavingPane(this);
        this.notebook_.addTab("Having", null, this.havingPane_);
        this.orderPane_ = new SQLQueryOrderPane(this);
        this.notebook_.addTab("Order By", null, this.orderPane_);
        this.summaryPane_ = new SQLQuerySummaryPane(this);
        this.notebook_.addTab(ResourceLoader.getQueryText("DBQUERY_LABEL_SUMMARY"), null, this.summaryPane_);
        this.notebook_.setSelectedIndex(0);
        this.tablePane_.init();
        this.tablePane_.setEnabled(this.tablesUserDefined_);
        if (this.tables_.length == 1) {
            this.notebook_.setEnabledAt(2, false);
        } else if (this.tables_.length == 0) {
            this.notebook_.setEnabledAt(1, false);
            this.notebook_.setEnabledAt(2, false);
            this.notebook_.setEnabledAt(3, false);
            this.notebook_.setEnabledAt(4, false);
            this.notebook_.setEnabledAt(5, false);
            this.notebook_.setEnabledAt(6, false);
        }
        this.notebook_.addChangeListener(new Listener_());
        this.add("Center", this.notebook_);
    }

    synchronized void updatePage() {
        Trace.log(1, "Updating page " + this.currentPane_);
        switch (this.currentPane_) {
            case 0: {
                this.tablePane_.update();
                break;
            }
            case 1: {
                if (!this.panelInit[1]) {
                    this.selectPane_.init();
                    this.panelInit[1] = true;
                    this.selectPane_.validate();
                    break;
                }
                this.selectPane_.update();
                break;
            }
            case 2: {
                if (!this.panelInit[2]) {
                    this.joinPane_.init();
                    this.panelInit[2] = true;
                    this.joinPane_.validate();
                    break;
                }
                this.joinPane_.update();
                break;
            }
            case 3: {
                if (!this.panelInit[3]) {
                    this.wherePane_.init();
                    this.panelInit[3] = true;
                    this.wherePane_.validate();
                    break;
                }
                this.wherePane_.update();
                break;
            }
            case 4: {
                if (!this.panelInit[4]) {
                    this.groupPane_.init();
                    this.panelInit[4] = true;
                    this.groupPane_.validate();
                    break;
                }
                this.groupPane_.update();
                break;
            }
            case 5: {
                if (!this.panelInit[5]) {
                    this.havingPane_.init();
                    this.panelInit[5] = true;
                    this.havingPane_.validate();
                    break;
                }
                this.havingPane_.update();
                break;
            }
            case 6: {
                if (!this.panelInit[6]) {
                    this.orderPane_.init();
                    this.panelInit[6] = true;
                    this.orderPane_.validate();
                    break;
                }
                this.orderPane_.update();
                break;
            }
            case 7: {
                if (!this.panelInit[7]) {
                    this.summaryPane_.init();
                    this.panelInit[7] = true;
                    this.summaryPane_.validate();
                    break;
                }
                this.summaryPane_.update();
                break;
            }
            default: {
                Trace.log(2, "Unknown page " + this.currentPane_);
            }
        }
    }

    private class Listener_
    implements ChangeListener {
        private Listener_() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            SQLQueryBuilderPane.this.worker_.startWorking(SQLQueryBuilderPane.this.workEvent_);
            SQLQueryBuilderPane.this.completePage();
            SQLQueryBuilderPane.this.currentPane_ = SQLQueryBuilderPane.this.notebook_.getSelectedIndex();
            SQLQueryBuilderPane.this.updatePage();
            SQLQueryBuilderPane.this.worker_.stopWorking(SQLQueryBuilderPane.this.workEvent_);
        }
    }
}

