/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.resource.Presentation;
import com.ibm.as400.resource.ResourceLevel;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ResourceMetaData
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static ResourceLevel defaultLevel_ = new ResourceLevel();
    private Object id_;
    private Object defaultValue_ = null;
    private ResourceLevel level_ = null;
    private boolean multipleAllowed_ = false;
    private Hashtable possibleValues_ = new Hashtable();
    private Hashtable possibleValuePresentations_ = new Hashtable();
    private Presentation presentation_;
    private boolean readOnly_;
    private Class type_;
    private boolean valueLimited_;

    public ResourceMetaData(Object id, Class type, Presentation presentation) {
        this(id, type, true, null, null, false, false, presentation, null);
    }

    public ResourceMetaData(Object id, Class type, boolean readOnly, Object[] possibleValues, Object defaultValue, boolean valueLimited, boolean multipleAllowed, Presentation presentation, Presentation[] possibleValuePresentations) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (presentation == null) {
            throw new NullPointerException("presentation");
        }
        this.id_ = id;
        this.defaultValue_ = defaultValue;
        this.level_ = defaultLevel_;
        this.type_ = type;
        this.readOnly_ = readOnly;
        this.valueLimited_ = valueLimited;
        this.multipleAllowed_ = multipleAllowed;
        this.presentation_ = presentation;
        if (possibleValues != null) {
            this.setPossibleValues(possibleValues, null);
        }
        if (defaultValue != null) {
            this.validateValue(defaultValue);
        }
        if (possibleValuePresentations != null) {
            if (possibleValues == null) {
                throw new NullPointerException("possibleValues");
            }
            if (possibleValuePresentations.length > possibleValues.length) {
                throw new ExtendedIllegalArgumentException("possibleValuePresentations", 2);
            }
            for (int i = 0; i < possibleValuePresentations.length; ++i) {
                this.possibleValuePresentations_.put(possibleValues[i], possibleValuePresentations[i]);
            }
        }
    }

    private static boolean arrayCompare(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public boolean areMultipleAllowed() {
        return this.multipleAllowed_;
    }

    public Object getID() {
        return this.id_;
    }

    public Object getDefaultValue() {
        return this.defaultValue_;
    }

    public ResourceLevel getLevel() {
        return this.level_;
    }

    public Presentation getPresentation() {
        return this.presentation_;
    }

    public Object[] getPossibleValues() {
        Object[] possibleValues = new Object[this.possibleValues_.size()];
        Enumeration values = this.possibleValues_.keys();
        int i = 0;
        while (values.hasMoreElements()) {
            possibleValues[i++] = values.nextElement();
        }
        return possibleValues;
    }

    Object[] getPossibleValues(String level) {
        if (level == null) {
            throw new NullPointerException("level");
        }
        Vector possibleValuesV = new Vector(this.possibleValues_.size());
        Enumeration values = this.possibleValues_.keys();
        while (values.hasMoreElements()) {
            Object possibleValue = values.nextElement();
            ResourceLevel possibleValueLevel = (ResourceLevel)this.possibleValues_.get(possibleValue);
            if (!possibleValueLevel.checkLevel(level)) continue;
            possibleValuesV.addElement(possibleValue);
        }
        Object[] possibleValues = new Object[possibleValuesV.size()];
        possibleValuesV.copyInto(possibleValues);
        return possibleValues;
    }

    public Presentation getPossibleValuePresentation(Object possibleValue) {
        if (possibleValue == null) {
            throw new NullPointerException("possibleValue");
        }
        this.validateValue(possibleValue);
        if (this.possibleValuePresentations_.containsKey(possibleValue)) {
            return (Presentation)this.possibleValuePresentations_.get(possibleValue);
        }
        return null;
    }

    public Presentation[] getPossibleValuePresentations() {
        Object[] possibleValues = this.getPossibleValues();
        Presentation[] possibleValuePresentations = new Presentation[possibleValues.length];
        for (int i = 0; i < possibleValues.length; ++i) {
            possibleValuePresentations[i] = this.getPossibleValuePresentation(possibleValues[i]);
        }
        return possibleValuePresentations;
    }

    Presentation[] getPossibleValuePresentations(String level) {
        if (level == null) {
            throw new NullPointerException("level");
        }
        Object[] possibleValues = this.getPossibleValues(level);
        Presentation[] possibleValuePresentations = new Presentation[possibleValues.length];
        for (int i = 0; i < possibleValues.length; ++i) {
            possibleValuePresentations[i] = this.getPossibleValuePresentation(possibleValues[i]);
        }
        return possibleValuePresentations;
    }

    public Class getType() {
        return this.type_;
    }

    public boolean isReadOnly() {
        return this.readOnly_;
    }

    public boolean isValueLimited() {
        return this.valueLimited_;
    }

    public void setLevel(ResourceLevel level) {
        this.level_ = level == null ? defaultLevel_ : level;
    }

    public void setPossibleValues(Object[] possibleValues, ResourceLevel level) {
        int i;
        if (possibleValues == null) {
            throw new NullPointerException("possibleValues");
        }
        Class<?> possibleValuesType = this.multipleAllowed_ && this.type_.isArray() ? this.type_.getComponentType() : this.type_;
        for (i = 0; i < possibleValues.length; ++i) {
            if (possibleValuesType.isAssignableFrom(possibleValues[i].getClass())) continue;
            throw new ExtendedIllegalArgumentException("possibleValues[" + i + "]", 2);
        }
        for (i = 0; i < possibleValues.length; ++i) {
            if (level == null) {
                this.possibleValues_.put(possibleValues[i], defaultLevel_);
                continue;
            }
            this.possibleValues_.put(possibleValues[i], level);
        }
    }

    public String toString() {
        return this.id_.toString();
    }

    private int validateValue(Object value, Object[] possibleValues) {
        int index = -1;
        for (int i = 0; i < possibleValues.length; ++i) {
            if (value.getClass().equals(byte[].class)) {
                if (!ResourceMetaData.arrayCompare((byte[])value, (byte[])possibleValues[i])) continue;
                index = i;
                break;
            }
            if (!value.equals(possibleValues[i])) continue;
            index = i;
            break;
        }
        if (this.valueLimited_ && index < 0) {
            throw new ExtendedIllegalArgumentException("value(" + value + ") for id(" + this.id_ + ")", 2);
        }
        return index;
    }

    Object validateValue(Object value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        Class<?> valueClass = value.getClass();
        if (this.multipleAllowed_) {
            if (valueClass.isArray()) {
                if (!this.type_.isAssignableFrom(valueClass.getComponentType())) {
                    throw new ExtendedIllegalArgumentException("value(" + value + ") type(" + valueClass + ") for id(" + this.id_ + ")", 2);
                }
                Object[] asArray = (Object[])value;
                for (int i = 0; i < asArray.length; ++i) {
                    if (this.validateValue(asArray[i], this.getPossibleValues()) >= 0) continue;
                    return value;
                }
                return value;
            }
            if (!this.type_.isAssignableFrom(valueClass)) {
                throw new ExtendedIllegalArgumentException("value(" + value + ") type(" + valueClass + ") for id(" + this.id_ + ")", 2);
            }
            this.validateValue(value, this.getPossibleValues());
            Object[] asArray = (Object[])Array.newInstance(this.type_, 1);
            asArray[0] = value;
            return asArray;
        }
        if (!this.type_.isAssignableFrom(valueClass)) {
            throw new ExtendedIllegalArgumentException("value(" + value + ") type(" + valueClass + ") for id(" + this.id_ + ")", 2);
        }
        this.validateValue(value, this.getPossibleValues());
        return value;
    }

    int validateValue(Object value, String level) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (level == null) {
            throw new NullPointerException("level");
        }
        if (!this.type_.isAssignableFrom(value.getClass())) {
            throw new ExtendedIllegalArgumentException("value(" + value + ") type(" + value.getClass() + ") for id(" + this.id_ + ")", 2);
        }
        return this.validateValue(value, this.getPossibleValues(level));
    }
}

