/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable.changestreams.action;

import com.google.cloud.bigtable.data.v2.models.ChangeStreamContinuationToken;
import com.google.cloud.bigtable.data.v2.models.ChangeStreamMutation;
import com.google.cloud.bigtable.data.v2.models.ChangeStreamRecord;
import com.google.cloud.bigtable.data.v2.models.CloseStream;
import com.google.cloud.bigtable.data.v2.models.Heartbeat;
import com.google.cloud.bigtable.data.v2.models.Range;
import com.google.protobuf.ByteString;
import java.util.Optional;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.ByteStringRangeHelper;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.ChangeStreamMetrics;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.TimestampConverter;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.estimator.BytesThroughputEstimator;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.model.PartitionRecord;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.restriction.StreamProgress;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.splittabledofn.ManualWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.values.KV;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class ChangeStreamAction {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(ChangeStreamAction.class);
    private final @UnknownKeyFor @NonNull @Initialized ChangeStreamMetrics metrics;

    public ChangeStreamAction(@UnknownKeyFor @NonNull @Initialized ChangeStreamMetrics metrics) {
        this.metrics = metrics;
    }

    public @UnknownKeyFor @NonNull @Initialized Optional<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DoFn.ProcessContinuation> run(@UnknownKeyFor @NonNull @Initialized PartitionRecord partitionRecord, @UnknownKeyFor @NonNull @Initialized ChangeStreamRecord record, @UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @NonNull @Initialized StreamProgress, @UnknownKeyFor @NonNull @Initialized StreamProgress> tracker, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized ChangeStreamRecord>> receiver, @UnknownKeyFor @NonNull @Initialized ManualWatermarkEstimator<@UnknownKeyFor @NonNull @Initialized Instant> watermarkEstimator, @UnknownKeyFor @NonNull @Initialized BytesThroughputEstimator<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized ChangeStreamRecord>> throughputEstimator) {
        if (record instanceof Heartbeat) {
            Heartbeat heartbeat = (Heartbeat)record;
            Instant watermark = TimestampConverter.toJodaTime(heartbeat.getEstimatedLowWatermark());
            ByteString heartbeatKey = Range.ByteStringRange.serializeToByteString((Range.ByteStringRange)partitionRecord.getPartition());
            KV outputRecord = KV.of((Object)heartbeatKey, (Object)heartbeat);
            throughputEstimator.update(Instant.now(), (KV<ByteString, ChangeStreamRecord>)outputRecord);
            StreamProgress streamProgress = new StreamProgress(heartbeat.getChangeStreamContinuationToken(), watermark, throughputEstimator.get(), Instant.now(), true);
            watermarkEstimator.setWatermark(watermark);
            if (!tracker.tryClaim((Object)streamProgress)) {
                return Optional.of(DoFn.ProcessContinuation.stop());
            }
            this.metrics.incHeartbeatCount();
            receiver.outputWithTimestamp((Object)outputRecord, Instant.EPOCH);
        } else {
            if (record instanceof CloseStream) {
                CloseStream closeStream = (CloseStream)record;
                StreamProgress streamProgress = new StreamProgress(closeStream);
                if (!tracker.tryClaim((Object)streamProgress)) {
                    return Optional.of(DoFn.ProcessContinuation.stop());
                }
                this.metrics.incClosestreamCount();
                return Optional.of(DoFn.ProcessContinuation.resume());
            }
            if (record instanceof ChangeStreamMutation) {
                ChangeStreamMutation changeStreamMutation = (ChangeStreamMutation)record;
                Instant watermark = TimestampConverter.toJodaTime(changeStreamMutation.getEstimatedLowWatermark());
                watermarkEstimator.setWatermark(watermark);
                ChangeStreamContinuationToken changeStreamContinuationToken = ChangeStreamContinuationToken.create((Range.ByteStringRange)Range.ByteStringRange.create((ByteString)((ByteString)partitionRecord.getPartition().getStart()), (ByteString)((ByteString)partitionRecord.getPartition().getEnd())), (String)changeStreamMutation.getToken());
                KV outputRecord = KV.of((Object)changeStreamMutation.getRowKey(), (Object)changeStreamMutation);
                throughputEstimator.update(Instant.now(), (KV<ByteString, ChangeStreamRecord>)outputRecord);
                StreamProgress streamProgress = new StreamProgress(changeStreamContinuationToken, watermark, throughputEstimator.get(), Instant.now(), false);
                if (!tracker.tryClaim((Object)streamProgress)) {
                    return Optional.of(DoFn.ProcessContinuation.stop());
                }
                if (changeStreamMutation.getType() == ChangeStreamMutation.MutationType.GARBAGE_COLLECTION) {
                    this.metrics.incChangeStreamMutationGcCounter();
                } else if (changeStreamMutation.getType() == ChangeStreamMutation.MutationType.USER) {
                    this.metrics.incChangeStreamMutationUserCounter();
                }
                Instant delay = TimestampConverter.toJodaTime(changeStreamMutation.getCommitTimestamp());
                this.metrics.updateProcessingDelayFromCommitTimestamp(Instant.now().getMillis() - delay.getMillis());
                receiver.outputWithTimestamp((Object)outputRecord, Instant.EPOCH);
            } else {
                LOG.warn("RCSP {}: Invalid response type", (Object)ByteStringRangeHelper.formatByteStringRange(partitionRecord.getPartition()));
            }
        }
        return Optional.empty();
    }
}

