/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.IExecutionConfiguration;
import org.apache.hop.core.Const;
import org.apache.hop.core.Result;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.IXml;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.workflow.WorkflowMeta;
import org.w3c.dom.Node;

public class WorkflowExecutionConfiguration
implements IExecutionConfiguration,
IXml {
    public static final String XML_TAG = "workflow_execution_configuration";
    private static final String CONST_VALUE = "value";
    private Map<String, String> parametersMap = new HashMap<String, String>();
    private Map<String, String> variablesMap = new HashMap<String, String>();
    private LogLevel logLevel;
    private boolean clearingLog = true;
    private Result previousResult;
    private String startActionName;
    private boolean gatheringMetrics;
    private boolean expandingRemoteWorkflow;
    private Map<String, String> extensionOptions = new HashMap<String, String>();
    private String runConfiguration;

    public WorkflowExecutionConfiguration() {
        this.logLevel = LogLevel.BASIC;
    }

    @Override
    public Object clone() {
        try {
            WorkflowExecutionConfiguration configuration = (WorkflowExecutionConfiguration)super.clone();
            configuration.parametersMap = new HashMap<String, String>();
            configuration.parametersMap.putAll(this.parametersMap);
            configuration.variablesMap = new HashMap<String, String>();
            configuration.variablesMap.putAll(this.variablesMap);
            if (this.previousResult != null) {
                configuration.previousResult = this.previousResult.clone();
            }
            return configuration;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public void setParametersMap(Map<String, String> parametersMap) {
        this.parametersMap = parametersMap;
    }

    @Override
    public Map<String, String> getParametersMap() {
        return this.parametersMap;
    }

    @Override
    public Map<String, String> getVariablesMap() {
        return this.variablesMap;
    }

    @Override
    public void setVariablesMap(Map<String, String> variablesMap) {
        this.variablesMap = variablesMap;
    }

    @Override
    public void setVariablesMap(IVariables variablesMap) {
        this.variablesMap = new HashMap<String, String>();
        for (String name : variablesMap.getVariableNames()) {
            String value = variablesMap.getVariable(name);
            this.variablesMap.put(name, value);
        }
    }

    public void getUsedVariables(WorkflowMeta workflowMeta, IVariables variables) {
        String[] keys;
        Properties properties = new Properties();
        for (String key : keys = variables.getVariableNames()) {
            if (!StringUtils.isNotEmpty((String)key)) continue;
            properties.put(key, Const.NVL((String)variables.getVariable(key), (String)""));
        }
        List<String> vars = workflowMeta.getUsedVariables();
        if (!Utils.isEmpty(vars)) {
            HashMap<String, String> newVariables = new HashMap<String, String>();
            for (String varname : vars) {
                if (varname.startsWith("Internal")) continue;
                newVariables.put(varname, Const.NVL((String)this.variablesMap.get(varname), (String)properties.getProperty(varname, "")));
            }
            this.variablesMap.putAll(newVariables);
        }
        for (String variableName : Const.INTERNAL_WORKFLOW_VARIABLES) {
            String value = variables.getVariable(variableName);
            if (Utils.isEmpty((CharSequence)value)) continue;
            this.variablesMap.put(variableName, value);
        }
    }

    @Override
    public String getRunConfiguration() {
        return this.runConfiguration;
    }

    @Override
    public void setRunConfiguration(String runConfiguration) {
        this.runConfiguration = runConfiguration;
    }

    @Override
    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    @Override
    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public String getXml(IVariables variables) {
        StringBuilder xml = new StringBuilder(160);
        xml.append("  <workflow_execution_configuration>").append(Const.CR);
        xml.append("    <parameters>").append(Const.CR);
        ArrayList<String> paramNames = new ArrayList<String>(this.parametersMap.keySet());
        Collections.sort(paramNames);
        for (String name : paramNames) {
            String value = this.parametersMap.get(name);
            xml.append("    <parameter>");
            xml.append(XmlHandler.addTagValue((String)"name", (String)name, (boolean)false, (String[])new String[0]));
            xml.append(XmlHandler.addTagValue((String)CONST_VALUE, (String)value, (boolean)false, (String[])new String[0]));
            xml.append("</parameter>").append(Const.CR);
        }
        xml.append("    </parameters>").append(Const.CR);
        xml.append("    <variables>").append(Const.CR);
        ArrayList<String> variableNames = new ArrayList<String>(this.variablesMap.keySet());
        Collections.sort(variableNames);
        for (String name : variableNames) {
            String value = this.variablesMap.get(name);
            xml.append("    <variable>");
            xml.append(XmlHandler.addTagValue((String)"name", (String)name, (boolean)false, (String[])new String[0]));
            xml.append(XmlHandler.addTagValue((String)CONST_VALUE, (String)value, (boolean)false, (String[])new String[0]));
            xml.append("</variable>").append(Const.CR);
        }
        xml.append("    </variables>").append(Const.CR);
        xml.append("    ").append(XmlHandler.addTagValue((String)"log_level", (String)this.logLevel.getCode()));
        xml.append("    ").append(XmlHandler.addTagValue((String)"clear_log", (boolean)this.clearingLog));
        xml.append("    ").append(XmlHandler.addTagValue((String)"start_copy_name", (String)this.startActionName));
        xml.append("    ").append(XmlHandler.addTagValue((String)"gather_metrics", (boolean)this.gatheringMetrics));
        xml.append("    ").append(XmlHandler.addTagValue((String)"expand_remote_workflow", (boolean)this.expandingRemoteWorkflow));
        xml.append("    ").append(XmlHandler.addTagValue((String)"run_configuration", (String)this.runConfiguration));
        if (this.previousResult != null) {
            xml.append(this.previousResult.getXml());
        }
        xml.append("</workflow_execution_configuration>").append(Const.CR);
        return xml.toString();
    }

    public WorkflowExecutionConfiguration(Node configNode) throws HopException {
        this();
        this.expandingRemoteWorkflow = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)configNode, (String)"expand_remote_workflow"));
        Node varsNode = XmlHandler.getSubNode((Node)configNode, (String)"variables");
        int nrVariables = XmlHandler.countNodes((Node)varsNode, (String)"variable");
        for (int i = 0; i < nrVariables; ++i) {
            Node argNode = XmlHandler.getSubNodeByNr((Node)varsNode, (String)"variable", (int)i);
            String name = XmlHandler.getTagValue((Node)argNode, (String)"name");
            String value = XmlHandler.getTagValue((Node)argNode, (String)CONST_VALUE);
            if (Utils.isEmpty((CharSequence)name) || Utils.isEmpty((CharSequence)value)) continue;
            this.variablesMap.put(name, value);
        }
        Node parmsNode = XmlHandler.getSubNode((Node)configNode, (String)"parameters");
        int nrParams = XmlHandler.countNodes((Node)parmsNode, (String)"parameter");
        for (int i = 0; i < nrParams; ++i) {
            Node parmNode = XmlHandler.getSubNodeByNr((Node)parmsNode, (String)"parameter", (int)i);
            String name = XmlHandler.getTagValue((Node)parmNode, (String)"name");
            String value = XmlHandler.getTagValue((Node)parmNode, (String)CONST_VALUE);
            if (Utils.isEmpty((CharSequence)name)) continue;
            this.parametersMap.put(name, value);
        }
        this.logLevel = LogLevel.lookupCode((String)XmlHandler.getTagValue((Node)configNode, (String)"log_level"));
        this.clearingLog = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)configNode, (String)"clear_log"));
        this.startActionName = XmlHandler.getTagValue((Node)configNode, (String)"start_copy_name");
        this.gatheringMetrics = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)configNode, (String)"gather_metrics"));
        this.runConfiguration = XmlHandler.getTagValue((Node)configNode, (String)"run_configuration");
        Node resultNode = XmlHandler.getSubNode((Node)configNode, (String)"result");
        if (resultNode != null) {
            try {
                this.previousResult = new Result(resultNode);
            }
            catch (HopException e) {
                throw new HopException("Unable to hydrate previous result", (Throwable)e);
            }
        }
    }

    @Override
    public Result getPreviousResult() {
        return this.previousResult;
    }

    @Override
    public void setPreviousResult(Result previousResult) {
        this.previousResult = previousResult;
    }

    @Override
    public boolean isClearingLog() {
        return this.clearingLog;
    }

    @Override
    public void setClearingLog(boolean clearingLog) {
        this.clearingLog = clearingLog;
    }

    public String getStartActionName() {
        return this.startActionName;
    }

    public void setStartActionName(String name) {
        this.startActionName = name;
    }

    public boolean isGatheringMetrics() {
        return this.gatheringMetrics;
    }

    public void setGatheringMetrics(boolean gatheringMetrics) {
        this.gatheringMetrics = gatheringMetrics;
    }

    public Map<String, String> getExtensionOptions() {
        return this.extensionOptions;
    }

    public void setExtensionOptions(Map<String, String> extensionOptions) {
        this.extensionOptions = extensionOptions;
    }

    public boolean isExpandingRemoteWorkflow() {
        return this.expandingRemoteWorkflow;
    }

    public void setExpandingRemoteWorkflow(boolean expandingRemoteWorkflow) {
        this.expandingRemoteWorkflow = expandingRemoteWorkflow;
    }
}

