/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

public final class MemberSelector {
    public static final MemberSelector OTHER = new MemberSelector().withTag(Tag.OTHER);
    private Tag _tag;
    private String dropboxIdValue;
    private String emailValue;

    private MemberSelector() {
    }

    private MemberSelector withTag(Tag _tag) {
        MemberSelector result = new MemberSelector();
        result._tag = _tag;
        return result;
    }

    private MemberSelector withTagAndDropboxId(Tag _tag, String dropboxIdValue) {
        MemberSelector result = new MemberSelector();
        result._tag = _tag;
        result.dropboxIdValue = dropboxIdValue;
        return result;
    }

    private MemberSelector withTagAndEmail(Tag _tag, String emailValue) {
        MemberSelector result = new MemberSelector();
        result._tag = _tag;
        result.emailValue = emailValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isDropboxId() {
        return this._tag == Tag.DROPBOX_ID;
    }

    public static MemberSelector dropboxId(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() < 1) {
            throw new IllegalArgumentException("String is shorter than 1");
        }
        return new MemberSelector().withTagAndDropboxId(Tag.DROPBOX_ID, value);
    }

    public String getDropboxIdValue() {
        if (this._tag != Tag.DROPBOX_ID) {
            throw new IllegalStateException("Invalid tag: required Tag.DROPBOX_ID, but was Tag." + this._tag.name());
        }
        return this.dropboxIdValue;
    }

    public boolean isEmail() {
        return this._tag == Tag.EMAIL;
    }

    public static MemberSelector email(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() > 255) {
            throw new IllegalArgumentException("String is longer than 255");
        }
        if (!Pattern.matches("^['#&A-Za-z0-9._%+-]+@[A-Za-z0-9-][A-Za-z0-9.-]*\\.[A-Za-z]{2,15}$", value)) {
            throw new IllegalArgumentException("String does not match pattern");
        }
        return new MemberSelector().withTagAndEmail(Tag.EMAIL, value);
    }

    public String getEmailValue() {
        if (this._tag != Tag.EMAIL) {
            throw new IllegalStateException("Invalid tag: required Tag.EMAIL, but was Tag." + this._tag.name());
        }
        return this.emailValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.dropboxIdValue, this.emailValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof MemberSelector) {
            MemberSelector other = (MemberSelector)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case DROPBOX_ID: {
                    return this.dropboxIdValue == other.dropboxIdValue || this.dropboxIdValue.equals(other.dropboxIdValue);
                }
                case EMAIL: {
                    return this.emailValue == other.emailValue || this.emailValue.equals(other.emailValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    public static class Serializer
    extends UnionSerializer<MemberSelector> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void serialize(MemberSelector value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case DROPBOX_ID: {
                    g.writeStartObject();
                    this.writeTag("dropbox_id", g);
                    g.writeFieldName("dropbox_id");
                    StoneSerializers.string().serialize(value.dropboxIdValue, g);
                    g.writeEndObject();
                    break;
                }
                case EMAIL: {
                    g.writeStartObject();
                    this.writeTag("email", g);
                    g.writeFieldName("email");
                    StoneSerializers.string().serialize(value.emailValue, g);
                    g.writeEndObject();
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public MemberSelector deserialize(JsonParser p) throws IOException, JsonParseException {
            MemberSelector value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("dropbox_id".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("dropbox_id", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = MemberSelector.dropboxId(fieldValue);
            } else if ("email".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("email", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = MemberSelector.email(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        DROPBOX_ID,
        EMAIL,
        OTHER;

    }
}

