/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.files.SearchMatch;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;

public class SearchResult {
    @Nonnull
    protected final List<SearchMatch> matches;
    protected final boolean more;
    protected final long start;

    public SearchResult(@Nonnull List<SearchMatch> matches, boolean more, long start) {
        if (matches == null) {
            throw new IllegalArgumentException("Required value for 'matches' is null");
        }
        for (SearchMatch x : matches) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list 'matches' is null");
        }
        this.matches = matches;
        this.more = more;
        this.start = start;
    }

    @Nonnull
    public List<SearchMatch> getMatches() {
        return this.matches;
    }

    public boolean getMore() {
        return this.more;
    }

    public long getStart() {
        return this.start;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.matches, this.more, this.start});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            SearchResult other = (SearchResult)obj;
            return (this.matches == other.matches || this.matches.equals(other.matches)) && this.more == other.more && this.start == other.start;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<SearchResult> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(SearchResult value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("matches");
            StoneSerializers.list(SearchMatch.Serializer.INSTANCE).serialize(value.matches, g);
            g.writeFieldName("more");
            StoneSerializers.boolean_().serialize((Boolean)value.more, g);
            g.writeFieldName("start");
            StoneSerializers.uInt64().serialize((Long)value.start, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public SearchResult deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Long f_start;
            Boolean f_more;
            List<SearchMatch> f_matches;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_matches = null;
                f_more = null;
                f_start = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("matches".equals(field)) {
                        f_matches = StoneSerializers.list(SearchMatch.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("more".equals(field)) {
                        f_more = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("start".equals(field)) {
                        f_start = StoneSerializers.uInt64().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_matches == null) {
                    throw new JsonParseException(p, "Required field \"matches\" missing.");
                }
                if (f_more == null) {
                    throw new JsonParseException(p, "Required field \"more\" missing.");
                }
                if (f_start == null) {
                    throw new JsonParseException(p, "Required field \"start\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            SearchResult value = new SearchResult(f_matches, f_more, f_start);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

